/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.model.ComputedColumnDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.recommendation.candidate.RawRecItem;
import org.apache.kylin.metadata.recommendation.ref.OptRecV2;
import org.apache.kylin.metadata.recommendation.ref.RecommendationRef;
import org.apache.kylin.metadata.recommendation.util.RawRecUtil;

public class FuzzyKeySearcher {
    private FuzzyKeySearcher() {
    }

    public static Set<String> searchComputedColumns(NDataModel model, String key) {
        return model.getComputedColumnDescs().stream().filter(cc -> StringUtils.containsIgnoreCase((CharSequence)cc.getFullName(), (CharSequence)key) || StringUtils.containsIgnoreCase((CharSequence)cc.getInnerExpression(), (CharSequence)key)).map(ComputedColumnDesc::getFullName).collect(Collectors.toSet());
    }

    public static Set<Integer> searchDimensions(NDataModel model, Set<String> ccNameSet, String key) {
        return model.getAllNamedColumns().stream().filter(NDataModel.NamedColumn::isExist).filter(c -> StringUtils.containsIgnoreCase((CharSequence)c.getAliasDotColumn(), (CharSequence)key) || StringUtils.containsIgnoreCase((CharSequence)c.getName(), (CharSequence)key) || ccNameSet.contains(c.getAliasDotColumn())).map(NDataModel.NamedColumn::getId).collect(Collectors.toSet());
    }

    public static Set<Integer> searchMeasures(NDataModel model, Set<String> ccNameSet, String key) {
        return model.getAllMeasures().stream().filter(m -> !m.isTomb()).filter(m -> StringUtils.containsIgnoreCase((CharSequence)m.getName(), (CharSequence)key) || m.getFunction().getParameters().stream().anyMatch(p -> p.getType().equals("column") && (StringUtils.containsIgnoreCase((CharSequence)p.getValue(), (CharSequence)key) || ccNameSet.contains(p.getValue())))).map(NDataModel.Measure::getId).collect(Collectors.toSet());
    }

    public static Set<Integer> searchColumnRefs(OptRecV2 recommendation, Set<String> ccFullNameSet, String key) {
        HashSet recIds = Sets.newHashSet();
        recommendation.getColumnRefs().forEach((id, colRef) -> {
            if (StringUtils.containsIgnoreCase((CharSequence)colRef.getName(), (CharSequence)key) || String.valueOf(colRef.getId()).equals(key) || ccFullNameSet.contains(colRef.getName())) {
                recIds.add(id);
            }
        });
        return recIds;
    }

    public static Set<Integer> searchCCRecRefs(OptRecV2 recommendation, String key) {
        HashSet recIds = Sets.newHashSet();
        recommendation.getCcRefs().forEach((id, ref) -> {
            RawRecItem rawRecItem = (RawRecItem)recommendation.getRawRecItemMap().get(-id.intValue());
            ComputedColumnDesc cc = RawRecUtil.getCC((RawRecItem)rawRecItem);
            if (StringUtils.containsIgnoreCase((CharSequence)cc.getFullName(), (CharSequence)key) || StringUtils.containsIgnoreCase((CharSequence)cc.getInnerExpression(), (CharSequence)key)) {
                recIds.add(id);
                return;
            }
            for (int dependID : rawRecItem.getDependIDs()) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)String.valueOf(dependID), (CharSequence)key)) continue;
                recIds.add(id);
                return;
            }
        });
        return recIds;
    }

    public static Set<Integer> searchDependRefIds(OptRecV2 recommendation, Set<Integer> dependRefIds, String key) {
        HashMap map = Maps.newHashMap();
        recommendation.getDimensionRefs().forEach(map::putIfAbsent);
        recommendation.getMeasureRefs().forEach(map::putIfAbsent);
        HashSet recIds = Sets.newHashSet();
        map.forEach((id, ref) -> {
            if (StringUtils.containsIgnoreCase((CharSequence)ref.getName(), (CharSequence)key) || ref.getId() >= 0 && String.valueOf(ref.getId()).equals(key)) {
                recIds.add(id);
                return;
            }
            for (RecommendationRef dependency : ref.getDependencies()) {
                if (!dependRefIds.contains(dependency.getId())) continue;
                recIds.add(id);
                return;
            }
        });
        return recIds;
    }
}

