/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.response;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.metadata.cube.model.IndexEntity;
import org.apache.kylin.rest.response.AggIndexCombResult;

public class AggIndexResponse
implements Serializable {
    private static AggIndexResponse EMPTY = new AggIndexResponse(Lists.newArrayList(), AggIndexCombResult.successResult(0), 0L);
    @JsonProperty(value="agg_index_counts")
    private List<AggIndexCombResult> aggIndexCounts;
    @JsonProperty(value="total_count")
    private AggIndexCombResult totalCount;
    @JsonProperty(value="max_combination_num")
    private Long aggrgroupMaxCombination;

    public static AggIndexResponse combine(AggIndexResponse batch, AggIndexResponse stream, List<IndexEntity.Range> aggGroupTypes) {
        if (batch.isEmpty()) {
            return stream;
        }
        if (stream.isEmpty()) {
            return batch;
        }
        AggIndexCombResult combineTotalCount = AggIndexCombResult.combine(batch.getTotalCount(), stream.getTotalCount());
        ArrayList aggIndexCounts = Lists.newArrayList();
        int batchIndex = 0;
        int streamIndex = 0;
        for (int n = 0; n < aggGroupTypes.size(); ++n) {
            if (aggGroupTypes.get(n) == IndexEntity.Range.BATCH) {
                aggIndexCounts.add(batch.getAggIndexCounts().get(batchIndex++));
                continue;
            }
            if (aggGroupTypes.get(n) == IndexEntity.Range.STREAMING) {
                aggIndexCounts.add(stream.getAggIndexCounts().get(streamIndex++));
                continue;
            }
            if (aggGroupTypes.get(n) != IndexEntity.Range.HYBRID) continue;
            aggIndexCounts.add(AggIndexCombResult.combine(batch.getAggIndexCounts().get(batchIndex++), stream.getAggIndexCounts().get(streamIndex++)));
        }
        AggIndexResponse combineResponse = new AggIndexResponse(aggIndexCounts, combineTotalCount, stream.getAggrgroupMaxCombination());
        return combineResponse;
    }

    private boolean isEmpty() {
        return EMPTY == this;
    }

    public static AggIndexResponse empty() {
        return EMPTY;
    }

    @Generated
    public List<AggIndexCombResult> getAggIndexCounts() {
        return this.aggIndexCounts;
    }

    @Generated
    public AggIndexCombResult getTotalCount() {
        return this.totalCount;
    }

    @Generated
    public Long getAggrgroupMaxCombination() {
        return this.aggrgroupMaxCombination;
    }

    @Generated
    public AggIndexResponse(List<AggIndexCombResult> aggIndexCounts, AggIndexCombResult totalCount, Long aggrgroupMaxCombination) {
        this.aggIndexCounts = aggIndexCounts;
        this.totalCount = totalCount;
        this.aggrgroupMaxCombination = aggrgroupMaxCombination;
    }
}

