/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.response;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.builder.HashCodeExclude;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.metadata.acl.NDataModelAclParams;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.cube.model.NIndexPlanManager;
import org.apache.kylin.metadata.model.ColExcludedChecker;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.ComputedColumnDesc;
import org.apache.kylin.metadata.model.JoinTableDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.PartitionDesc;
import org.apache.kylin.metadata.model.SegmentRange;
import org.apache.kylin.metadata.model.TableExtDesc;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.model.util.scd2.SimplifiedJoinTableDesc;
import org.apache.kylin.rest.constant.ModelStatusToDisplayEnum;
import org.apache.kylin.rest.response.NDataModelOldParams;
import org.apache.kylin.rest.response.NDataSegmentResponse;
import org.apache.kylin.rest.response.SimplifiedColumnResponse;
import org.apache.kylin.rest.response.SimplifiedMeasure;
import org.apache.kylin.rest.response.SimplifiedTableResponse;
import org.apache.kylin.rest.util.ModelUtils;
import org.apache.kylin.rest.util.SCD2SimplificationConvertUtil;

public class NDataModelResponse
extends NDataModel {
    @JsonProperty(value="status")
    private ModelStatusToDisplayEnum status;
    @JsonProperty(value="last_build_end")
    private String lastBuildEnd;
    @JsonProperty(value="storage")
    private long storage;
    @JsonProperty(value="source")
    private long source;
    @JsonProperty(value="expansion_rate")
    private String expansionrate;
    @JsonProperty(value="usage")
    private long usage;
    @JsonProperty(value="root_fact_table_deleted")
    private boolean rootFactTableDeleted = false;
    @JsonProperty(value="segments")
    private List<NDataSegmentResponse> segments = new ArrayList<NDataSegmentResponse>();
    @JsonProperty(value="available_indexes_count")
    private long availableIndexesCount;
    @JsonProperty(value="empty_indexes_count")
    private long emptyIndexesCount;
    @JsonProperty(value="segment_holes")
    private List<SegmentRange> segmentHoles;
    @JsonProperty(value="inconsistent_segment_count")
    private long inconsistentSegmentCount;
    @JsonProperty(value="total_indexes")
    private long totalIndexes;
    @JsonProperty(value="forbidden_online")
    private boolean forbiddenOnline = false;
    @JsonProperty(value="join_tables")
    private List<SimplifiedJoinTableDesc> simplifiedJoinTableDescs;
    @JsonProperty(value="last_build_time")
    private long lastBuildTime;
    @JsonProperty(value="has_base_table_index")
    private boolean hasBaseTableIndex;
    @JsonProperty(value="has_base_agg_index")
    private boolean hasBaseAggIndex;
    @JsonProperty(value="has_segments")
    private boolean hasSegments;
    @JsonProperty(value="model_update_enabled")
    private boolean modelUpdateEnabled = true;
    @JsonProperty(value="auto_index_plan_enable")
    private boolean autoIndexPlanEnable;
    @JsonProperty(value="instant_index_init_enable")
    private boolean instantInitIndexEnable;
    @JsonProperty(value="computed_columns")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected List<ComputedColumnDesc> computedColumns = Lists.newArrayList();
    private long lastModify;
    @JsonIgnore
    private List<SimplifiedNamedColumn> simplifiedDims;
    @JsonIgnore
    private final AtomicReference<Object> lazyModel = new AtomicReference();
    @JsonUnwrapped
    private NDataModelOldParams oldParams;
    @JsonUnwrapped
    private NDataModelAclParams aclParams;

    public NDataModelResponse() {
    }

    public NDataModelResponse(NDataModel dataModel) {
        super(dataModel);
        this.setConfig(dataModel.getConfig());
        this.setProject(dataModel.getProject());
        this.setMvcc(dataModel.getMvcc());
        this.setModelType(dataModel.getModelType());
        this.lastModify = this.lastModified;
        this.setSimplifiedJoinTableDescs(SCD2SimplificationConvertUtil.simplifiedJoinTablesConvert(dataModel.getJoinTables()));
        this.setComputedColumns(dataModel.getComputedColumnDescs());
        this.setAllMeasures(this.getAllMeasures().stream().filter(m -> m.getType() != NDataModel.MeasureType.INTERNAL).collect(Collectors.toList()));
    }

    @JsonProperty(value="empty_model")
    public boolean isEmptyModel() {
        List<SimplifiedMeasure> simplifiedMeasures = this.getSimplifiedMeasures();
        return this.getNamedColumns().isEmpty() && simplifiedMeasures.size() == 1 && "COUNT_ALL".equals(simplifiedMeasures.get(0).getName());
    }

    @JsonProperty(value="partition_column_in_dims")
    public boolean isPartitionColumnInDims() {
        PartitionDesc partitionDesc = this.getPartitionDesc();
        if (partitionDesc == null || partitionDesc.getPartitionDateColumn() == null) {
            return false;
        }
        String partitionColumn = partitionDesc.getPartitionDateColumn();
        return this.getNamedColumns().stream().anyMatch(dim -> dim.getAliasDotColumn().equalsIgnoreCase(partitionColumn));
    }

    @JsonProperty(value="simplified_dimensions")
    public List<SimplifiedNamedColumn> getNamedColumns() {
        if (this.simplifiedDims != null) {
            return this.simplifiedDims;
        }
        this.fillDimensions(true);
        return this.simplifiedDims;
    }

    public void enrichDerivedDimension() {
        this.fillDimensions(false);
    }

    private void fillDimensions(boolean onlyNormalDim) {
        NTableMetadataManager tableMetadata = null;
        if (!this.isBroken()) {
            tableMetadata = NTableMetadataManager.getInstance((KylinConfig)this.getConfig(), (String)this.getProject());
        }
        ColExcludedChecker excludedChecker = new ColExcludedChecker(this.getConfig(), this.getProject(), (NDataModel)this);
        ArrayList dimList = Lists.newArrayList();
        for (Object col : this.getAllNamedColumns()) {
            if (!col.isDimension()) continue;
            dimList.add(this.transColumnToDim(excludedChecker, (NDataModel.NamedColumn)col, tableMetadata));
        }
        if (!onlyNormalDim) {
            ArrayList allNameColCopy = Lists.newArrayList();
            for (NDataModel.NamedColumn col : this.getAllNamedColumns()) {
                allNameColCopy.add(NDataModel.NamedColumn.copy((NDataModel.NamedColumn)col));
            }
            Map<String, NDataModel.NamedColumn> columnMap = allNameColCopy.stream().filter(NDataModel.NamedColumn::isExist).collect(Collectors.toMap(NDataModel.NamedColumn::getAliasDotColumn, Function.identity()));
            for (JoinTableDesc joinTable : this.getJoinTables()) {
                if (joinTable.isFlattenable() || !this.isFkAllDim(joinTable.getJoin().getForeignKey(), columnMap)) continue;
                for (TblColRef col : joinTable.getTableRef().getColumns()) {
                    NDataModel.NamedColumn namedColumn = columnMap.get(col.getAliasDotName());
                    if (namedColumn.isDimension()) continue;
                    dimList.add(this.transColumnToDim(excludedChecker, namedColumn, tableMetadata));
                    namedColumn.setStatus(NDataModel.ColumnStatus.DIMENSION);
                }
            }
            this.setAllNamedColumns(allNameColCopy);
        }
        this.simplifiedDims = dimList;
    }

    private boolean isFkAllDim(String[] foreignKeys, Map<String, NDataModel.NamedColumn> columnMap) {
        if (foreignKeys == null) {
            return false;
        }
        for (String fkCol : foreignKeys) {
            if (columnMap.get(fkCol).isDimension()) continue;
            return false;
        }
        return true;
    }

    private NDataModel originModel() {
        return NDataModelManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)this.getProject()).getDataModelDesc(this.getUuid());
    }

    public SimplifiedNamedColumn transColumnToDim(ColExcludedChecker excludedChecker, NDataModel.NamedColumn col, NTableMetadataManager tableMetadata) {
        TableExtDesc tableExt;
        SimplifiedNamedColumn simplifiedDimension = new SimplifiedNamedColumn(col);
        simplifiedDimension.setStatus(NDataModel.ColumnStatus.DIMENSION);
        TblColRef colRef = this.findColumnByAlias(simplifiedDimension.getAliasDotColumn());
        if (colRef == null || tableMetadata == null) {
            return simplifiedDimension;
        }
        if (excludedChecker.isExcludedCol(colRef) && !colRef.getTableRef().getTableIdentity().equals(this.getLazyModel().getRootFactTableName())) {
            simplifiedDimension.setExcluded(true);
        }
        if ((tableExt = tableMetadata.getTableExtIfExists(colRef.getTableRef().getTableDesc())) != null) {
            TableExtDesc.ColumnStats columnStats = tableExt.getColumnStatsByName(colRef.getName());
            if (colRef.getColumnDesc().getComment() != null) {
                simplifiedDimension.setComment(colRef.getColumnDesc().getComment());
            }
            if (colRef.getColumnDesc().getType() != null) {
                simplifiedDimension.setType(colRef.getColumnDesc().getType().toString());
            }
            if (columnStats != null) {
                simplifiedDimension.setCardinality(columnStats.getCardinality());
                simplifiedDimension.setMaxValue(columnStats.getMaxValue());
                simplifiedDimension.setMinValue(columnStats.getMinValue());
                simplifiedDimension.setMaxLengthValue(columnStats.getMaxLengthValue());
                simplifiedDimension.setMinLengthValue(columnStats.getMinLengthValue());
                ArrayList simple = Lists.newArrayList();
                tableExt.getSampleRows().forEach(row -> simple.add(row[tableExt.getAllColumnStats().indexOf(columnStats)]));
                simplifiedDimension.setSimple(simple);
            }
        }
        return simplifiedDimension;
    }

    @JsonProperty(value="all_measures")
    public List<NDataModel.Measure> getMeasures() {
        return this.getAllMeasures().stream().filter(m -> !m.isTomb()).collect(Collectors.toList());
    }

    @JsonProperty(value="model_broken")
    public boolean isModelBroken() {
        return this.isBroken();
    }

    @JsonProperty(value="has_segment_overlap")
    public boolean isHasSegmentOverlap() {
        return NDataModel.BrokenReason.SEGMENT_OVERLAP == this.getBrokenReason();
    }

    @JsonProperty(value="simplified_tables")
    public List<SimplifiedTableResponse> getSimpleTables() {
        ArrayList<SimplifiedTableResponse> simpleTables = new ArrayList<SimplifiedTableResponse>();
        for (TableRef tableRef : this.getAllTables()) {
            SimplifiedTableResponse simpleTable = new SimplifiedTableResponse();
            simpleTable.setTable(tableRef.getTableIdentity());
            List<SimplifiedColumnResponse> columns = this.getSimplifiedColumns(tableRef);
            simpleTable.setColumns(columns);
            simpleTables.add(simpleTable);
        }
        return simpleTables;
    }

    @JsonProperty(value="simplified_measures")
    public List<SimplifiedMeasure> getSimplifiedMeasures() {
        List measures = this.getAllMeasures();
        ArrayList<SimplifiedMeasure> measureResponses = new ArrayList<SimplifiedMeasure>();
        for (NDataModel.Measure measure : measures) {
            if (measure.isTomb()) continue;
            measureResponses.add(SimplifiedMeasure.fromMeasure(measure));
        }
        return measureResponses;
    }

    private List<SimplifiedColumnResponse> getSimplifiedColumns(TableRef tableRef) {
        ArrayList<SimplifiedColumnResponse> columns = new ArrayList<SimplifiedColumnResponse>();
        NTableMetadataManager tableMetadataManager = NTableMetadataManager.getInstance((KylinConfig)this.getConfig(), (String)this.getProject());
        for (ColumnDesc columnDesc : tableRef.getTableDesc().getColumns()) {
            TableExtDesc tableExtDesc = tableMetadataManager.getOrCreateTableExt(tableRef.getTableDesc());
            SimplifiedColumnResponse simplifiedColumnResponse = new SimplifiedColumnResponse();
            simplifiedColumnResponse.setName(columnDesc.getName());
            simplifiedColumnResponse.setComment(columnDesc.getComment());
            simplifiedColumnResponse.setDataType(columnDesc.getDatatype());
            simplifiedColumnResponse.setComputedColumn(columnDesc.isComputedColumn());
            TableExtDesc.ColumnStats columnStats = tableExtDesc.getColumnStatsByName(columnDesc.getName());
            if (columnStats != null) {
                simplifiedColumnResponse.setCardinality(columnStats.getCardinality());
            }
            columns.add(simplifiedColumnResponse);
        }
        return columns;
    }

    @JsonGetter(value="selected_columns")
    public List<SimplifiedNamedColumn> getSelectedColumns() {
        ArrayList selectedColumns = Lists.newArrayList();
        NTableMetadataManager tableMetadata = null;
        KylinConfig config = this.getConfig();
        if (!this.isBroken()) {
            tableMetadata = NTableMetadataManager.getInstance((KylinConfig)config, (String)this.getProject());
        }
        ColExcludedChecker excludedChecker = new ColExcludedChecker(config, this.getProject(), (NDataModel)this);
        for (NDataModel.NamedColumn namedColumn : this.getAllSelectedColumns()) {
            SimplifiedNamedColumn simplifiedNamedColumn = new SimplifiedNamedColumn(namedColumn);
            TblColRef colRef = this.findColumnByAlias(simplifiedNamedColumn.getAliasDotColumn());
            if (colRef != null) {
                this.innerProcessSimplifiedNamedColumn(tableMetadata, excludedChecker, simplifiedNamedColumn, colRef);
            }
            selectedColumns.add(simplifiedNamedColumn);
        }
        return selectedColumns;
    }

    private void innerProcessSimplifiedNamedColumn(NTableMetadataManager tableMetadata, ColExcludedChecker excludedChecker, SimplifiedNamedColumn simplifiedNamedColumn, TblColRef colRef) {
        simplifiedNamedColumn.setType(colRef.getColumnDesc().getType().toString());
        if (simplifiedNamedColumn.getStatus() == NDataModel.ColumnStatus.DIMENSION && tableMetadata != null) {
            TableExtDesc tableExt;
            TableExtDesc.ColumnStats columnStats;
            if (excludedChecker.isExcludedCol(colRef) && !colRef.getTableRef().getTableIdentity().equals(this.getLazyModel().getRootFactTableName())) {
                simplifiedNamedColumn.setExcluded(true);
            }
            TableExtDesc.ColumnStats columnStats2 = columnStats = Objects.isNull(tableExt = tableMetadata.getTableExtIfExists(colRef.getTableRef().getTableDesc())) ? null : tableExt.getColumnStatsByName(colRef.getName());
            if (columnStats != null) {
                simplifiedNamedColumn.setCardinality(columnStats.getCardinality());
            }
        }
    }

    public void computedInfo(long inconsistentCount, ModelStatusToDisplayEnum status, boolean isScd2, NDataModel modelDesc, boolean onlyNormalDim) {
        if (!onlyNormalDim) {
            this.enrichDerivedDimension();
        }
        this.setForbiddenOnline(isScd2);
        this.setStatus(status);
        this.setInconsistentSegmentCount(inconsistentCount);
        this.computedDisplayInfo(modelDesc);
    }

    protected void computedDisplayInfo(NDataModel modelDesc) {
        NDataflowManager dfManager = NDataflowManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)this.getProject());
        NIndexPlanManager indexPlanManager = NIndexPlanManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)this.getProject());
        this.setLastBuildTime(dfManager.getDataflowLastBuildTime(modelDesc.getUuid()));
        this.setStorage(dfManager.getDataflowStorageSize(modelDesc.getUuid()));
        this.setSource(dfManager.getDataflowSourceSize(modelDesc.getUuid()));
        this.setSegmentHoles(dfManager.calculateSegHoles(modelDesc.getUuid()));
        this.setExpansionrate(ModelUtils.computeExpansionRate(this.getStorage(), this.getSource()));
        this.setUsage(dfManager.getDataflow(modelDesc.getUuid()).getQueryHitCount());
        if (!modelDesc.isBroken()) {
            IndexPlan indexPlan = indexPlanManager.getIndexPlan(modelDesc.getUuid());
            this.setAvailableIndexesCount(indexPlanManager.getAvailableIndexesCount(this.getProject(), modelDesc.getId()));
            this.setTotalIndexes(indexPlan.getAllLayoutsReadOnly().size());
            this.setEmptyIndexesCount(this.totalIndexes - this.availableIndexesCount);
            this.setHasBaseAggIndex(indexPlan.containBaseAggLayout());
            this.setHasBaseTableIndex(indexPlan.containBaseTableLayout());
        }
    }

    @Generated
    public void setStatus(ModelStatusToDisplayEnum status) {
        this.status = status;
    }

    @Generated
    public void setLastBuildEnd(String lastBuildEnd) {
        this.lastBuildEnd = lastBuildEnd;
    }

    @Generated
    public void setStorage(long storage) {
        this.storage = storage;
    }

    @Generated
    public void setSource(long source) {
        this.source = source;
    }

    @Generated
    public void setExpansionrate(String expansionrate) {
        this.expansionrate = expansionrate;
    }

    @Generated
    public void setUsage(long usage) {
        this.usage = usage;
    }

    @Generated
    public void setRootFactTableDeleted(boolean rootFactTableDeleted) {
        this.rootFactTableDeleted = rootFactTableDeleted;
    }

    @Generated
    public void setSegments(List<NDataSegmentResponse> segments) {
        this.segments = segments;
    }

    @Generated
    public void setAvailableIndexesCount(long availableIndexesCount) {
        this.availableIndexesCount = availableIndexesCount;
    }

    @Generated
    public void setEmptyIndexesCount(long emptyIndexesCount) {
        this.emptyIndexesCount = emptyIndexesCount;
    }

    @Generated
    public void setSegmentHoles(List<SegmentRange> segmentHoles) {
        this.segmentHoles = segmentHoles;
    }

    @Generated
    public void setInconsistentSegmentCount(long inconsistentSegmentCount) {
        this.inconsistentSegmentCount = inconsistentSegmentCount;
    }

    @Generated
    public void setTotalIndexes(long totalIndexes) {
        this.totalIndexes = totalIndexes;
    }

    @Generated
    public void setForbiddenOnline(boolean forbiddenOnline) {
        this.forbiddenOnline = forbiddenOnline;
    }

    @Generated
    public void setSimplifiedJoinTableDescs(List<SimplifiedJoinTableDesc> simplifiedJoinTableDescs) {
        this.simplifiedJoinTableDescs = simplifiedJoinTableDescs;
    }

    @Generated
    public void setLastBuildTime(long lastBuildTime) {
        this.lastBuildTime = lastBuildTime;
    }

    @Generated
    public void setHasBaseTableIndex(boolean hasBaseTableIndex) {
        this.hasBaseTableIndex = hasBaseTableIndex;
    }

    @Generated
    public void setHasBaseAggIndex(boolean hasBaseAggIndex) {
        this.hasBaseAggIndex = hasBaseAggIndex;
    }

    @Generated
    public void setHasSegments(boolean hasSegments) {
        this.hasSegments = hasSegments;
    }

    @Generated
    public void setModelUpdateEnabled(boolean modelUpdateEnabled) {
        this.modelUpdateEnabled = modelUpdateEnabled;
    }

    @Generated
    public void setAutoIndexPlanEnable(boolean autoIndexPlanEnable) {
        this.autoIndexPlanEnable = autoIndexPlanEnable;
    }

    @Generated
    public void setInstantInitIndexEnable(boolean instantInitIndexEnable) {
        this.instantInitIndexEnable = instantInitIndexEnable;
    }

    @Generated
    public void setComputedColumns(List<ComputedColumnDesc> computedColumns) {
        this.computedColumns = computedColumns;
    }

    @Generated
    public void setLastModify(long lastModify) {
        this.lastModify = lastModify;
    }

    @Generated
    public void setSimplifiedDims(List<SimplifiedNamedColumn> simplifiedDims) {
        this.simplifiedDims = simplifiedDims;
    }

    @Generated
    public ModelStatusToDisplayEnum getStatus() {
        return this.status;
    }

    @Generated
    public String getLastBuildEnd() {
        return this.lastBuildEnd;
    }

    @Generated
    public long getStorage() {
        return this.storage;
    }

    @Generated
    public long getSource() {
        return this.source;
    }

    @Generated
    public String getExpansionrate() {
        return this.expansionrate;
    }

    @Generated
    public long getUsage() {
        return this.usage;
    }

    @Generated
    public boolean isRootFactTableDeleted() {
        return this.rootFactTableDeleted;
    }

    @Generated
    public List<NDataSegmentResponse> getSegments() {
        return this.segments;
    }

    @Generated
    public long getAvailableIndexesCount() {
        return this.availableIndexesCount;
    }

    @Generated
    public long getEmptyIndexesCount() {
        return this.emptyIndexesCount;
    }

    @Generated
    public List<SegmentRange> getSegmentHoles() {
        return this.segmentHoles;
    }

    @Generated
    public long getInconsistentSegmentCount() {
        return this.inconsistentSegmentCount;
    }

    @Generated
    public long getTotalIndexes() {
        return this.totalIndexes;
    }

    @Generated
    public boolean isForbiddenOnline() {
        return this.forbiddenOnline;
    }

    @Generated
    public List<SimplifiedJoinTableDesc> getSimplifiedJoinTableDescs() {
        return this.simplifiedJoinTableDescs;
    }

    @Generated
    public long getLastBuildTime() {
        return this.lastBuildTime;
    }

    @Generated
    public boolean isHasBaseTableIndex() {
        return this.hasBaseTableIndex;
    }

    @Generated
    public boolean isHasBaseAggIndex() {
        return this.hasBaseAggIndex;
    }

    @Generated
    public boolean isHasSegments() {
        return this.hasSegments;
    }

    @Generated
    public boolean isModelUpdateEnabled() {
        return this.modelUpdateEnabled;
    }

    @Generated
    public boolean isAutoIndexPlanEnable() {
        return this.autoIndexPlanEnable;
    }

    @Generated
    public boolean isInstantInitIndexEnable() {
        return this.instantInitIndexEnable;
    }

    @Generated
    public List<ComputedColumnDesc> getComputedColumns() {
        return this.computedColumns;
    }

    @Generated
    public long getLastModify() {
        return this.lastModify;
    }

    @Generated
    public List<SimplifiedNamedColumn> getSimplifiedDims() {
        return this.simplifiedDims;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public NDataModel getLazyModel() {
        Object value = this.lazyModel.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.lazyModel;
            synchronized (atomicReference) {
                value = this.lazyModel.get();
                if (value == null) {
                    NDataModel actualValue = this.originModel();
                    value = actualValue == null ? this.lazyModel : actualValue;
                    this.lazyModel.set(value);
                }
            }
        }
        return (NDataModel)(value == this.lazyModel ? null : value);
    }

    @Generated
    public NDataModelOldParams getOldParams() {
        return this.oldParams;
    }

    @Generated
    public void setOldParams(NDataModelOldParams oldParams) {
        this.oldParams = oldParams;
    }

    @Generated
    public NDataModelAclParams getAclParams() {
        return this.aclParams;
    }

    @Generated
    public void setAclParams(NDataModelAclParams aclParams) {
        this.aclParams = aclParams;
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    public static class SimplifiedNamedColumn
    extends NDataModel.NamedColumn
    implements Serializable {
        @HashCodeExclude
        @JsonProperty(value="excluded")
        private boolean excluded;
        @JsonProperty(value="cardinality")
        private Long cardinality;
        @JsonProperty(value="min_value")
        private String minValue;
        @JsonProperty(value="max_value")
        private String maxValue;
        @JsonProperty(value="max_length_value")
        private String maxLengthValue;
        @JsonProperty(value="min_length_value")
        private String minLengthValue;
        @JsonProperty(value="null_count")
        private Long nullCount;
        @JsonProperty(value="comment")
        private String comment;
        @JsonProperty(value="type")
        private String type;
        @JsonProperty(value="simple")
        private ArrayList<String> simple;

        public SimplifiedNamedColumn(NDataModel.NamedColumn namedColumn) {
            this.id = namedColumn.getId();
            this.aliasDotColumn = namedColumn.getAliasDotColumn();
            this.status = namedColumn.getStatus();
            this.name = namedColumn.getName();
        }

        @Generated
        public boolean isExcluded() {
            return this.excluded;
        }

        @Generated
        public Long getCardinality() {
            return this.cardinality;
        }

        @Generated
        public String getMinValue() {
            return this.minValue;
        }

        @Generated
        public String getMaxValue() {
            return this.maxValue;
        }

        @Generated
        public String getMaxLengthValue() {
            return this.maxLengthValue;
        }

        @Generated
        public String getMinLengthValue() {
            return this.minLengthValue;
        }

        @Generated
        public Long getNullCount() {
            return this.nullCount;
        }

        @Generated
        public String getComment() {
            return this.comment;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public ArrayList<String> getSimple() {
            return this.simple;
        }

        @Generated
        public void setExcluded(boolean excluded) {
            this.excluded = excluded;
        }

        @Generated
        public void setCardinality(Long cardinality) {
            this.cardinality = cardinality;
        }

        @Generated
        public void setMinValue(String minValue) {
            this.minValue = minValue;
        }

        @Generated
        public void setMaxValue(String maxValue) {
            this.maxValue = maxValue;
        }

        @Generated
        public void setMaxLengthValue(String maxLengthValue) {
            this.maxLengthValue = maxLengthValue;
        }

        @Generated
        public void setMinLengthValue(String minLengthValue) {
            this.minLengthValue = minLengthValue;
        }

        @Generated
        public void setNullCount(Long nullCount) {
            this.nullCount = nullCount;
        }

        @Generated
        public void setComment(String comment) {
            this.comment = comment;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public void setSimple(ArrayList<String> simple) {
            this.simple = simple;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SimplifiedNamedColumn)) {
                return false;
            }
            SimplifiedNamedColumn other = (SimplifiedNamedColumn)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isExcluded() != other.isExcluded()) {
                return false;
            }
            Long this$cardinality = this.getCardinality();
            Long other$cardinality = other.getCardinality();
            if (this$cardinality == null ? other$cardinality != null : !((Object)this$cardinality).equals(other$cardinality)) {
                return false;
            }
            String this$minValue = this.getMinValue();
            String other$minValue = other.getMinValue();
            if (this$minValue == null ? other$minValue != null : !this$minValue.equals(other$minValue)) {
                return false;
            }
            String this$maxValue = this.getMaxValue();
            String other$maxValue = other.getMaxValue();
            if (this$maxValue == null ? other$maxValue != null : !this$maxValue.equals(other$maxValue)) {
                return false;
            }
            String this$maxLengthValue = this.getMaxLengthValue();
            String other$maxLengthValue = other.getMaxLengthValue();
            if (this$maxLengthValue == null ? other$maxLengthValue != null : !this$maxLengthValue.equals(other$maxLengthValue)) {
                return false;
            }
            String this$minLengthValue = this.getMinLengthValue();
            String other$minLengthValue = other.getMinLengthValue();
            if (this$minLengthValue == null ? other$minLengthValue != null : !this$minLengthValue.equals(other$minLengthValue)) {
                return false;
            }
            Long this$nullCount = this.getNullCount();
            Long other$nullCount = other.getNullCount();
            if (this$nullCount == null ? other$nullCount != null : !((Object)this$nullCount).equals(other$nullCount)) {
                return false;
            }
            String this$comment = this.getComment();
            String other$comment = other.getComment();
            if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            ArrayList<String> this$simple = this.getSimple();
            ArrayList<String> other$simple = other.getSimple();
            return !(this$simple == null ? other$simple != null : !((Object)this$simple).equals(other$simple));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SimplifiedNamedColumn;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isExcluded() ? 79 : 97);
            Long $cardinality = this.getCardinality();
            result = result * 59 + ($cardinality == null ? 43 : ((Object)$cardinality).hashCode());
            String $minValue = this.getMinValue();
            result = result * 59 + ($minValue == null ? 43 : $minValue.hashCode());
            String $maxValue = this.getMaxValue();
            result = result * 59 + ($maxValue == null ? 43 : $maxValue.hashCode());
            String $maxLengthValue = this.getMaxLengthValue();
            result = result * 59 + ($maxLengthValue == null ? 43 : $maxLengthValue.hashCode());
            String $minLengthValue = this.getMinLengthValue();
            result = result * 59 + ($minLengthValue == null ? 43 : $minLengthValue.hashCode());
            Long $nullCount = this.getNullCount();
            result = result * 59 + ($nullCount == null ? 43 : ((Object)$nullCount).hashCode());
            String $comment = this.getComment();
            result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            ArrayList<String> $simple = this.getSimple();
            result = result * 59 + ($simple == null ? 43 : ((Object)$simple).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "NDataModelResponse.SimplifiedNamedColumn(excluded=" + this.isExcluded() + ", cardinality=" + this.getCardinality() + ", minValue=" + this.getMinValue() + ", maxValue=" + this.getMaxValue() + ", maxLengthValue=" + this.getMaxLengthValue() + ", minLengthValue=" + this.getMinLengthValue() + ", nullCount=" + this.getNullCount() + ", comment=" + this.getComment() + ", type=" + this.getType() + ", simple=" + this.getSimple() + ")";
        }
    }
}

