/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.response;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.ParameterDesc;
import org.apache.kylin.rest.response.ParameterResponse;

public class SimplifiedMeasure
implements Serializable {
    @JsonProperty(value="id")
    private int id;
    @JsonProperty(value="expression")
    private String expression;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="return_type")
    private String returnType;
    @JsonProperty(value="parameter_value")
    private List<ParameterResponse> parameterValue;
    @JsonProperty(value="converted_columns")
    private List<ColumnDesc> convertedColumns = new ArrayList<ColumnDesc>();
    @JsonProperty(value="column")
    private String column;
    @JsonProperty(value="comment")
    private String comment;
    @JsonProperty(value="configuration")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Map<String, String> configuration = Maps.newHashMap();

    public static SimplifiedMeasure fromMeasure(NDataModel.Measure measure) {
        SimplifiedMeasure measureResponse = new SimplifiedMeasure();
        measureResponse.setId(measure.getId());
        measureResponse.setName(measure.getName());
        measureResponse.setExpression(measure.getFunction().getExpression());
        measureResponse.setReturnType(measure.getFunction().getReturnType());
        List<ParameterResponse> parameters = measure.getFunction().getParameters().stream().map(parameterDesc -> new ParameterResponse(parameterDesc.getType(), parameterDesc.getValue())).collect(Collectors.toList());
        measureResponse.setConfiguration(measure.getFunction().getConfiguration());
        measureResponse.setParameterValue(parameters);
        measureResponse.setColumn(measure.getColumn());
        measureResponse.setComment(measure.getComment());
        return measureResponse;
    }

    public NDataModel.Measure toMeasure() {
        NDataModel.Measure measure = new NDataModel.Measure();
        measure.setId(this.getId());
        measure.setName(this.getName());
        measure.setColumn(this.getColumn());
        measure.setComment(this.getComment());
        FunctionDesc functionDesc = new FunctionDesc();
        functionDesc.setReturnType(this.getReturnType());
        functionDesc.setExpression(this.getExpression());
        functionDesc.setConfiguration(this.configuration);
        List<ParameterResponse> parameterResponseList = this.getParameterValue();
        List parameterDescs = parameterResponseList.stream().map(parameterResponse -> {
            ParameterDesc parameterDesc = new ParameterDesc();
            parameterDesc.setType(parameterResponse.getType());
            parameterDesc.setValue(parameterResponse.getValue());
            return parameterDesc;
        }).collect(Collectors.toList());
        functionDesc.setParameters(parameterDescs);
        measure.setFunction(functionDesc);
        return measure;
    }

    public void changeTableAlias(String oldAlias, String newAlias) {
        for (ParameterResponse parameter : this.parameterValue) {
            String table = parameter.getValue().split("\\.")[0];
            if (!oldAlias.equalsIgnoreCase(table)) continue;
            String column = parameter.getValue().split("\\.")[1];
            parameter.setValue(newAlias + "." + column);
        }
    }

    @Generated
    public void setId(int id) {
        this.id = id;
    }

    @Generated
    public void setExpression(String expression) {
        this.expression = expression;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setReturnType(String returnType) {
        this.returnType = returnType;
    }

    @Generated
    public void setParameterValue(List<ParameterResponse> parameterValue) {
        this.parameterValue = parameterValue;
    }

    @Generated
    public void setConvertedColumns(List<ColumnDesc> convertedColumns) {
        this.convertedColumns = convertedColumns;
    }

    @Generated
    public void setColumn(String column) {
        this.column = column;
    }

    @Generated
    public void setComment(String comment) {
        this.comment = comment;
    }

    @Generated
    public void setConfiguration(Map<String, String> configuration) {
        this.configuration = configuration;
    }

    @Generated
    public int getId() {
        return this.id;
    }

    @Generated
    public String getExpression() {
        return this.expression;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getReturnType() {
        return this.returnType;
    }

    @Generated
    public List<ParameterResponse> getParameterValue() {
        return this.parameterValue;
    }

    @Generated
    public List<ColumnDesc> getConvertedColumns() {
        return this.convertedColumns;
    }

    @Generated
    public String getColumn() {
        return this.column;
    }

    @Generated
    public String getComment() {
        return this.comment;
    }

    @Generated
    public Map<String, String> getConfiguration() {
        return this.configuration;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimplifiedMeasure)) {
            return false;
        }
        SimplifiedMeasure other = (SimplifiedMeasure)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$expression = this.getExpression();
        String other$expression = other.getExpression();
        if (this$expression == null ? other$expression != null : !this$expression.equals(other$expression)) {
            return false;
        }
        String this$returnType = this.getReturnType();
        String other$returnType = other.getReturnType();
        if (this$returnType == null ? other$returnType != null : !this$returnType.equals(other$returnType)) {
            return false;
        }
        List<ParameterResponse> this$parameterValue = this.getParameterValue();
        List<ParameterResponse> other$parameterValue = other.getParameterValue();
        if (this$parameterValue == null ? other$parameterValue != null : !((Object)this$parameterValue).equals(other$parameterValue)) {
            return false;
        }
        Map<String, String> this$configuration = this.getConfiguration();
        Map<String, String> other$configuration = other.getConfiguration();
        return !(this$configuration == null ? other$configuration != null : !((Object)this$configuration).equals(other$configuration));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SimplifiedMeasure;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $expression = this.getExpression();
        result = result * 59 + ($expression == null ? 43 : $expression.hashCode());
        String $returnType = this.getReturnType();
        result = result * 59 + ($returnType == null ? 43 : $returnType.hashCode());
        List<ParameterResponse> $parameterValue = this.getParameterValue();
        result = result * 59 + ($parameterValue == null ? 43 : ((Object)$parameterValue).hashCode());
        Map<String, String> $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : ((Object)$configuration).hashCode());
        return result;
    }
}

