/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.metadata.jdbc.JdbcUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.session.SessionProperties;
import org.springframework.boot.autoconfigure.session.StoreType;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.datasource.init.DatabasePopulator;
import org.springframework.jdbc.datasource.init.DatabasePopulatorUtils;
import org.springframework.jdbc.datasource.init.ResourceDatabasePopulator;
import org.springframework.security.util.InMemoryResource;
import org.springframework.session.web.context.AbstractHttpSessionApplicationInitializer;

@Configuration
@ConditionalOnProperty(name={"spring.session.store-type"}, havingValue="JDBC")
public class SessionConfig
extends AbstractHttpSessionApplicationInitializer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SessionConfig.class);
    private static final String CREATE_SCHEMA_SESSION_TABLE = "create.schema-session.table";
    private static final String CREATE_SCHEMA_SESSION_ATTRIBUTES_TABLE = "create.schema-session-attributes.table";
    @Autowired
    @Qualifier
    DataSource dataSource;
    @Autowired
    SessionProperties sessionProperties;

    private void initSessionTable(String replaceName, String sessionScript) throws IOException {
        ResourceDatabasePopulator populator = new ResourceDatabasePopulator();
        sessionScript = sessionScript.replaceAll("SPRING_SESSION", replaceName);
        populator.addScript((Resource)new InMemoryResource(sessionScript));
        populator.setContinueOnError(false);
        DatabasePopulatorUtils.execute((DatabasePopulator)populator, (DataSource)this.dataSource);
    }

    @PostConstruct
    public void initSessionTables() throws SQLException, IOException {
        if (this.sessionProperties.getStoreType() != StoreType.JDBC) {
            return;
        }
        String tableName = KylinConfig.getInstanceFromEnv().getMetadataUrlPrefix() + "_session_v2";
        String attributesTableName = tableName + "_ATTRIBUTES";
        Properties properties = JdbcUtil.getProperties((BasicDataSource)((BasicDataSource)this.dataSource));
        if (!JdbcUtil.isTableExists((Connection)this.dataSource.getConnection(), (String)tableName)) {
            this.initSessionTable(tableName, properties.getProperty(CREATE_SCHEMA_SESSION_TABLE));
        }
        if (!JdbcUtil.isTableExists((Connection)this.dataSource.getConnection(), (String)attributesTableName)) {
            this.initSessionTable(tableName, properties.getProperty(CREATE_SCHEMA_SESSION_ATTRIBUTES_TABLE));
        }
    }
}

