/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.cache.memcached;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import net.spy.memcached.ArrayModNodeLocator;
import net.spy.memcached.ConnectionFactory;
import net.spy.memcached.ConnectionFactoryBuilder;
import net.spy.memcached.ConnectionObserver;
import net.spy.memcached.DefaultConnectionFactory;
import net.spy.memcached.FailureMode;
import net.spy.memcached.HashAlgorithm;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.NodeLocator;
import net.spy.memcached.OperationFactory;
import net.spy.memcached.RefinedKetamaNodeLocator;
import net.spy.memcached.auth.AuthDescriptor;
import net.spy.memcached.metrics.MetricCollector;
import net.spy.memcached.metrics.MetricType;
import net.spy.memcached.ops.Operation;
import net.spy.memcached.transcoders.Transcoder;

public class MemcachedConnectionFactoryBuilder
extends ConnectionFactoryBuilder {
    public ConnectionFactory build() {
        return new DefaultConnectionFactory(){

            public BlockingQueue<Operation> createOperationQueue() {
                return MemcachedConnectionFactoryBuilder.this.opQueueFactory == null ? super.createOperationQueue() : MemcachedConnectionFactoryBuilder.this.opQueueFactory.create();
            }

            public BlockingQueue<Operation> createReadOperationQueue() {
                return MemcachedConnectionFactoryBuilder.this.readQueueFactory == null ? super.createReadOperationQueue() : MemcachedConnectionFactoryBuilder.this.readQueueFactory.create();
            }

            public BlockingQueue<Operation> createWriteOperationQueue() {
                return MemcachedConnectionFactoryBuilder.this.writeQueueFactory == null ? super.createReadOperationQueue() : MemcachedConnectionFactoryBuilder.this.writeQueueFactory.create();
            }

            public NodeLocator createLocator(List<MemcachedNode> nodes) {
                switch (MemcachedConnectionFactoryBuilder.this.locator) {
                    case ARRAY_MOD: {
                        return new ArrayModNodeLocator(nodes, this.getHashAlg());
                    }
                    case CONSISTENT: {
                        return new RefinedKetamaNodeLocator(nodes, this.getHashAlg());
                    }
                }
                throw new IllegalStateException("Unhandled locator type: " + MemcachedConnectionFactoryBuilder.this.locator);
            }

            public Transcoder<Object> getDefaultTranscoder() {
                return MemcachedConnectionFactoryBuilder.this.transcoder == null ? super.getDefaultTranscoder() : MemcachedConnectionFactoryBuilder.this.transcoder;
            }

            public FailureMode getFailureMode() {
                return MemcachedConnectionFactoryBuilder.this.failureMode == null ? super.getFailureMode() : MemcachedConnectionFactoryBuilder.this.failureMode;
            }

            public HashAlgorithm getHashAlg() {
                return MemcachedConnectionFactoryBuilder.this.hashAlg == null ? super.getHashAlg() : MemcachedConnectionFactoryBuilder.this.hashAlg;
            }

            public Collection<ConnectionObserver> getInitialObservers() {
                return MemcachedConnectionFactoryBuilder.this.initialObservers;
            }

            public OperationFactory getOperationFactory() {
                return MemcachedConnectionFactoryBuilder.this.opFact == null ? super.getOperationFactory() : MemcachedConnectionFactoryBuilder.this.opFact;
            }

            public long getOperationTimeout() {
                return MemcachedConnectionFactoryBuilder.this.opTimeout == -1L ? super.getOperationTimeout() : MemcachedConnectionFactoryBuilder.this.opTimeout;
            }

            public int getReadBufSize() {
                return MemcachedConnectionFactoryBuilder.this.readBufSize == -1 ? super.getReadBufSize() : MemcachedConnectionFactoryBuilder.this.readBufSize;
            }

            public boolean isDaemon() {
                return MemcachedConnectionFactoryBuilder.this.isDaemon;
            }

            public boolean shouldOptimize() {
                return MemcachedConnectionFactoryBuilder.this.shouldOptimize;
            }

            public boolean useNagleAlgorithm() {
                return MemcachedConnectionFactoryBuilder.this.useNagle;
            }

            public long getMaxReconnectDelay() {
                return MemcachedConnectionFactoryBuilder.this.maxReconnectDelay;
            }

            public AuthDescriptor getAuthDescriptor() {
                return MemcachedConnectionFactoryBuilder.this.authDescriptor;
            }

            public long getOpQueueMaxBlockTime() {
                return MemcachedConnectionFactoryBuilder.this.opQueueMaxBlockTime > -1L ? MemcachedConnectionFactoryBuilder.this.opQueueMaxBlockTime : super.getOpQueueMaxBlockTime();
            }

            public int getTimeoutExceptionThreshold() {
                return MemcachedConnectionFactoryBuilder.this.timeoutExceptionThreshold;
            }

            public MetricType enableMetrics() {
                return MemcachedConnectionFactoryBuilder.this.metricType == null ? super.enableMetrics() : MemcachedConnectionFactoryBuilder.this.metricType;
            }

            public MetricCollector getMetricCollector() {
                return MemcachedConnectionFactoryBuilder.this.collector == null ? super.getMetricCollector() : MemcachedConnectionFactoryBuilder.this.collector;
            }

            public ExecutorService getListenerExecutorService() {
                return MemcachedConnectionFactoryBuilder.this.executorService == null ? super.getListenerExecutorService() : MemcachedConnectionFactoryBuilder.this.executorService;
            }

            public boolean isDefaultExecutorService() {
                return MemcachedConnectionFactoryBuilder.this.executorService == null;
            }

            public long getAuthWaitTime() {
                return MemcachedConnectionFactoryBuilder.this.authWaitTime;
            }
        };
    }
}

