/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.config.initialize;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.metrics.MetricsGroup;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.job.execution.ExecutableManager;
import org.apache.kylin.metadata.favorite.QueryHistoryIdOffsetManager;
import org.apache.kylin.metadata.query.RDBMSQueryHistoryDAO;
import org.apache.kylin.metadata.recommendation.candidate.RawRecManager;
import org.apache.kylin.rest.cluster.ClusterManager;
import org.apache.kylin.rest.config.initialize.MetricsRegistry;
import org.apache.kylin.streaming.manager.StreamingJobManager;
import org.apache.kylin.tool.restclient.RestClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;

public class ProjectDropListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProjectDropListener.class);

    public void onDelete(String project, ClusterManager clusterManager, HttpHeaders headers) {
        log.debug("delete project {}", (Object)project);
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        try {
            this.destroyAllProcess(project, clusterManager, headers);
            ExecutableManager.getInstance((KylinConfig)kylinConfig, (String)project).deleteAllJobsOfProject();
            StreamingJobManager.getInstance((KylinConfig)kylinConfig, (String)project).destroyAllProcess();
            RDBMSQueryHistoryDAO.getInstance().dropProjectMeasurement(project);
            QueryHistoryIdOffsetManager.getInstance((String)project).delete();
            RawRecManager.getInstance((String)project).deleteByProject(project);
            MetricsGroup.removeProjectMetrics((String)project);
            if (KylinConfig.getInstanceFromEnv().isPrometheusMetricsEnabled()) {
                MetricsRegistry.deletePrometheusProjectMetrics(project);
            }
            this.deleteStorage(kylinConfig, project.split("\\.")[0]);
        }
        catch (Exception e) {
            log.warn("error when delete " + project + " storage", (Throwable)e);
        }
    }

    private void destroyAllProcess(String project, ClusterManager clusterManager, HttpHeaders headers) throws IOException {
        if (null == clusterManager || null == headers) {
            return;
        }
        List serverInfoResponses = clusterManager.getJobServers();
        List jobNodeHosts = serverInfoResponses.stream().map(serverInfoResponse -> serverInfoResponse.getHost()).collect(Collectors.toList());
        for (String host : jobNodeHosts) {
            RestClient client = new RestClient(host);
            HashMap form = Maps.newHashMap();
            form.put("project", project);
            client.forwardPostWithUrlEncodedForm("/jobs/destroy_job_process", headers, (Map)form);
        }
    }

    private void deleteStorage(KylinConfig config, String project) throws IOException {
        String strPath = config.getHdfsWorkingDirectory(project);
        FileSystem fs = HadoopUtil.getWorkingFileSystem();
        if (fs.exists(new Path(strPath))) {
            fs.delete(new Path(strPath), true);
        }
    }
}

