/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.response;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.rest.util.PagingUtil;

public class DataResult<T extends Collection> {
    private T value;
    @JsonProperty(value="total_size")
    private int totalSize = 0;
    private int offset = 0;
    private int limit = 0;

    public DataResult(T data, int totalSize) {
        this.value = data;
        this.totalSize = totalSize;
    }

    public static <T extends Collection> DataResult<T> get(T data, int totalSize) {
        return new DataResult<T>(data, totalSize);
    }

    public static <T extends Collection> DataResult<T> get(T data, T allData) {
        return DataResult.get(data, allData, 0, 0);
    }

    public static <T extends Collection> DataResult<T> get(T data, T allData, int offset, int limit) {
        if (null == allData) {
            return new DataResult<T>(data, 0, offset, limit);
        }
        return new DataResult<T>(data, allData.size(), offset, limit);
    }

    public static <E> DataResult<List<E>> get(List<E> data, int offset, int limit) {
        return DataResult.get(PagingUtil.cutPage(data, (int)offset, (int)limit), data, offset, limit);
    }

    public static <E> DataResult<List<E>> getCustom(Pair<List<E>, Integer> objWithActualSize, int offset, int limit) {
        return new DataResult<List<E>>(PagingUtil.cutPage((List)((List)objWithActualSize.getFirst()), (int)offset, (int)limit), (Integer)objWithActualSize.getSecond(), offset, limit);
    }

    @Generated
    public T getValue() {
        return this.value;
    }

    @Generated
    public int getTotalSize() {
        return this.totalSize;
    }

    @Generated
    public int getOffset() {
        return this.offset;
    }

    @Generated
    public int getLimit() {
        return this.limit;
    }

    @Generated
    public void setValue(T value) {
        this.value = value;
    }

    @Generated
    public void setTotalSize(int totalSize) {
        this.totalSize = totalSize;
    }

    @Generated
    public void setOffset(int offset) {
        this.offset = offset;
    }

    @Generated
    public void setLimit(int limit) {
        this.limit = limit;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataResult)) {
            return false;
        }
        DataResult other = (DataResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        T this$value = this.getValue();
        T other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        if (this.getTotalSize() != other.getTotalSize()) {
            return false;
        }
        if (this.getOffset() != other.getOffset()) {
            return false;
        }
        return this.getLimit() == other.getLimit();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DataResult;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        T $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        result = result * 59 + this.getTotalSize();
        result = result * 59 + this.getOffset();
        result = result * 59 + this.getLimit();
        return result;
    }

    @Generated
    public String toString() {
        return "DataResult(value=" + this.getValue() + ", totalSize=" + this.getTotalSize() + ", offset=" + this.getOffset() + ", limit=" + this.getLimit() + ")";
    }

    @Generated
    public DataResult(T value, int totalSize, int offset, int limit) {
        this.value = value;
        this.totalSize = totalSize;
        this.offset = offset;
        this.limit = limit;
    }
}

