/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.response;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Set;
import lombok.Generated;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableExtDesc;
import org.apache.kylin.rest.constant.SnapshotStatus;

public class SnapshotInfoResponse
implements Comparable<SnapshotInfoResponse> {
    @JsonProperty(value="table")
    private String table;
    @JsonProperty(value="database")
    private String database;
    @JsonProperty(value="usage")
    private int usage;
    @JsonProperty(value="total_rows")
    private long totalRows;
    @JsonProperty(value="storage")
    private long storage;
    @JsonProperty(value="fact_table_count")
    private int factTableCount;
    @JsonProperty(value="lookup_table_count")
    private int lookupTableCount;
    @JsonProperty(value="last_modified_time")
    private long lastModifiedTime;
    @JsonProperty(value="status")
    private SnapshotStatus status;
    @JsonProperty(value="forbidden_colunms")
    private Set<String> columns;
    @JsonProperty(value="select_partition_col")
    private String selectPartitionCol;
    @JsonProperty(value="source_type")
    private int sourceType;

    public SnapshotInfoResponse() {
    }

    public SnapshotInfoResponse(TableDesc tableDesc, TableExtDesc tableExtDesc, long totalRows, int factTableCount, int lookupTableCount, SnapshotStatus status, Set<String> columns) {
        this.table = tableDesc.getName();
        this.database = tableDesc.getDatabase();
        this.usage = tableExtDesc.getSnapshotHitCount() + tableDesc.getSnapshotHitCount();
        this.totalRows = totalRows;
        this.storage = tableDesc.getLastSnapshotSize();
        this.factTableCount = factTableCount;
        this.lookupTableCount = lookupTableCount;
        this.lastModifiedTime = tableDesc.getSnapshotLastModified();
        this.status = status;
        this.columns = columns;
        this.selectPartitionCol = tableDesc.getSelectedSnapshotPartitionCol();
        this.sourceType = tableDesc.getSourceType();
    }

    @Override
    public int compareTo(SnapshotInfoResponse o) {
        if (this.lastModifiedTime == 0L) {
            return -1;
        }
        if (o.lastModifiedTime == 0L) {
            return 1;
        }
        int nonNegative = o.lastModifiedTime > this.lastModifiedTime ? 1 : 0;
        return o.lastModifiedTime < this.lastModifiedTime ? -1 : nonNegative;
    }

    @Generated
    public String getTable() {
        return this.table;
    }

    @Generated
    public String getDatabase() {
        return this.database;
    }

    @Generated
    public int getUsage() {
        return this.usage;
    }

    @Generated
    public long getTotalRows() {
        return this.totalRows;
    }

    @Generated
    public long getStorage() {
        return this.storage;
    }

    @Generated
    public int getFactTableCount() {
        return this.factTableCount;
    }

    @Generated
    public int getLookupTableCount() {
        return this.lookupTableCount;
    }

    @Generated
    public long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    @Generated
    public SnapshotStatus getStatus() {
        return this.status;
    }

    @Generated
    public Set<String> getColumns() {
        return this.columns;
    }

    @Generated
    public String getSelectPartitionCol() {
        return this.selectPartitionCol;
    }

    @Generated
    public int getSourceType() {
        return this.sourceType;
    }

    @Generated
    public void setTable(String table) {
        this.table = table;
    }

    @Generated
    public void setDatabase(String database) {
        this.database = database;
    }

    @Generated
    public void setUsage(int usage) {
        this.usage = usage;
    }

    @Generated
    public void setTotalRows(long totalRows) {
        this.totalRows = totalRows;
    }

    @Generated
    public void setStorage(long storage) {
        this.storage = storage;
    }

    @Generated
    public void setFactTableCount(int factTableCount) {
        this.factTableCount = factTableCount;
    }

    @Generated
    public void setLookupTableCount(int lookupTableCount) {
        this.lookupTableCount = lookupTableCount;
    }

    @Generated
    public void setLastModifiedTime(long lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    @Generated
    public void setStatus(SnapshotStatus status) {
        this.status = status;
    }

    @Generated
    public void setColumns(Set<String> columns) {
        this.columns = columns;
    }

    @Generated
    public void setSelectPartitionCol(String selectPartitionCol) {
        this.selectPartitionCol = selectPartitionCol;
    }

    @Generated
    public void setSourceType(int sourceType) {
        this.sourceType = sourceType;
    }
}

