/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service.task;

import lombok.Generated;
import org.apache.kylin.job.JobContext;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.DefaultExecutable;
import org.apache.kylin.job.execution.ExecuteResult;
import org.apache.kylin.job.factory.JobFactory;
import org.apache.kylin.rest.util.SpringContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.session.jdbc.JdbcIndexedSessionRepository;

public class SpringSessionCleanExpiredJob
extends AbstractExecutable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpringSessionCleanExpiredJob.class);

    public SpringSessionCleanExpiredJob() {
    }

    public SpringSessionCleanExpiredJob(Object notSetId) {
        super(notSetId);
    }

    public static DefaultExecutable create(JobFactory.JobBuildParams jobBuildParams) {
        DefaultExecutable job = new DefaultExecutable();
        SpringSessionCleanExpiredJob innerJob = new SpringSessionCleanExpiredJob();
        innerJob.setParam("parentId", job.getJobId());
        job.addTask((AbstractExecutable)innerJob);
        job.setJobType(jobBuildParams.getJobType());
        return job;
    }

    protected ExecuteResult doWork(JobContext context) {
        ApplicationContext applicationContext = SpringContext.getApplicationContext();
        ((JdbcIndexedSessionRepository)applicationContext.getBean(JdbcIndexedSessionRepository.class)).cleanUpExpiredSessions();
        log.debug("Clean up expired sessions successfully.");
        return ExecuteResult.createSucceed();
    }

    public static class Factory
    extends JobFactory {
        protected DefaultExecutable create(JobFactory.JobBuildParams jobBuildParams) {
            return SpringSessionCleanExpiredJob.create(jobBuildParams);
        }
    }
}

