/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.client.read;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.celeborn.client.ShuffleClient;
import org.apache.celeborn.client.read.PartitionReader;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.network.client.TransportClient;
import org.apache.celeborn.common.network.client.TransportClientFactory;
import org.apache.celeborn.common.network.protocol.Message;
import org.apache.celeborn.common.network.protocol.OpenStream;
import org.apache.celeborn.common.protocol.PartitionLocation;
import org.apache.celeborn.common.util.ShuffleBlockInfoUtils;
import org.apache.celeborn.common.util.Utils;
import org.apache.celeborn.shaded.io.netty.buffer.ByteBuf;
import org.apache.celeborn.shaded.io.netty.buffer.Unpooled;
import org.apache.celeborn.shaded.io.netty.util.ReferenceCounted;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DfsPartitionReader
implements PartitionReader {
    private static Logger logger = LoggerFactory.getLogger(DfsPartitionReader.class);
    PartitionLocation location;
    private final int shuffleChunkSize;
    private final int fetchMaxReqsInFlight;
    private final LinkedBlockingQueue<ByteBuf> results;
    private final AtomicReference<IOException> exception = new AtomicReference();
    private volatile boolean closed = false;
    private Thread fetchThread;
    private FSDataInputStream hdfsInputStream;
    private int numChunks = 0;
    private int returnedChunks = 0;
    private int currentChunkIndex = 0;

    public DfsPartitionReader(CelebornConf conf, String shuffleKey, PartitionLocation location, TransportClientFactory clientFactory, int startMapIndex, int endMapIndex) throws IOException {
        this.shuffleChunkSize = (int)conf.shuffleChunkSize();
        this.fetchMaxReqsInFlight = conf.clientFetchMaxReqsInFlight();
        this.results = new LinkedBlockingQueue();
        this.location = location;
        ArrayList<Long> chunkOffsets = new ArrayList<Long>();
        if (endMapIndex != Integer.MAX_VALUE) {
            long fetchTimeoutMs = conf.clientFetchTimeoutMs();
            try {
                TransportClient client = clientFactory.createClient(location.getHost(), location.getFetchPort());
                OpenStream openBlocks = new OpenStream(shuffleKey, location.getFileName(), startMapIndex, endMapIndex);
                ByteBuffer response = client.sendRpcSync(openBlocks.toByteBuffer(), fetchTimeoutMs);
                Message.decode(response);
            }
            catch (IOException | InterruptedException e) {
                throw new IOException("read shuffle file from HDFS failed, filePath: " + location.getStorageInfo().getFilePath(), e);
            }
            this.hdfsInputStream = ShuffleClient.getHdfsFs(conf).open(new Path(Utils.getSortedFilePath(location.getStorageInfo().getFilePath())));
            chunkOffsets.addAll(this.getChunkOffsetsFromSortedIndex(conf, location, startMapIndex, endMapIndex));
        } else {
            this.hdfsInputStream = ShuffleClient.getHdfsFs(conf).open(new Path(location.getStorageInfo().getFilePath()));
            chunkOffsets.addAll(this.getChunkOffsetsFromUnsortedIndex(conf, location));
        }
        logger.debug("DFS {} index count:{} offsets:{}", new Object[]{location.getStorageInfo().getFilePath(), chunkOffsets.size(), chunkOffsets});
        if (chunkOffsets.size() > 1) {
            this.numChunks = chunkOffsets.size() - 1;
            this.fetchThread = new Thread(() -> {
                try {
                    while (!this.closed && this.currentChunkIndex < this.numChunks) {
                        while (this.results.size() >= this.fetchMaxReqsInFlight) {
                            Thread.sleep(50L);
                        }
                        long offset = (Long)chunkOffsets.get(this.currentChunkIndex);
                        long length = (Long)chunkOffsets.get(this.currentChunkIndex + 1) - offset;
                        logger.debug("read {} offset {} length {}", new Object[]{this.currentChunkIndex, offset, length});
                        byte[] buffer = new byte[(int)length];
                        try {
                            this.hdfsInputStream.readFully(offset, buffer);
                        }
                        catch (IOException e) {
                            logger.warn("read HDFS {} failed will retry, error detail {}", (Object)location.getStorageInfo().getFilePath(), (Object)e);
                            try {
                                this.hdfsInputStream.close();
                                this.hdfsInputStream = ShuffleClient.getHdfsFs(conf).open(new Path(Utils.getSortedFilePath(location.getStorageInfo().getFilePath())));
                                this.hdfsInputStream.readFully(offset, buffer);
                            }
                            catch (IOException ex) {
                                logger.warn("retry read HDFS {} failed, error detail {} ", (Object)location.getStorageInfo().getFilePath(), (Object)e);
                                this.exception.set(ex);
                                break;
                            }
                        }
                        this.results.put(Unpooled.wrappedBuffer(buffer));
                        logger.debug("add index {} to results", (Object)this.currentChunkIndex++);
                    }
                }
                catch (Exception e) {
                    logger.warn("Fetch thread is cancelled.", (Throwable)e);
                }
                logger.debug("fetch {} is done.", (Object)location.getStorageInfo().getFilePath());
            }, "Dfs-fetch-thread" + location.getStorageInfo().getFilePath());
            this.fetchThread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                    logger.error("thread {} failed with exception {}", (Object)t, (Object)e);
                }
            });
            this.fetchThread.start();
            logger.debug("Start dfs read on location {}", (Object)location);
        }
    }

    private List<Long> getChunkOffsetsFromUnsortedIndex(CelebornConf conf, PartitionLocation location) throws IOException {
        FSDataInputStream indexInputStream = ShuffleClient.getHdfsFs(conf).open(new Path(Utils.getIndexFilePath(location.getStorageInfo().getFilePath())));
        ArrayList<Long> offsets = new ArrayList<Long>();
        int offsetCount = indexInputStream.readInt();
        for (int i = 0; i < offsetCount; ++i) {
            offsets.add(indexInputStream.readLong());
        }
        indexInputStream.close();
        return offsets;
    }

    private List<Long> getChunkOffsetsFromSortedIndex(CelebornConf conf, PartitionLocation location, int startMapIndex, int endMapIndex) throws IOException {
        String indexPath = Utils.getIndexFilePath(location.getStorageInfo().getFilePath());
        FSDataInputStream indexInputStream = ShuffleClient.getHdfsFs(conf).open(new Path(indexPath));
        logger.debug("read sorted index {}", (Object)indexPath);
        long indexSize = ShuffleClient.getHdfsFs(conf).getFileStatus(new Path(indexPath)).getLen();
        byte[] indexBuffer = new byte[(int)indexSize];
        indexInputStream.readFully(0L, indexBuffer);
        ArrayList<Long> offsets = new ArrayList<Long>(ShuffleBlockInfoUtils.getChunkOffsetsFromShuffleBlockInfos(startMapIndex, endMapIndex, this.shuffleChunkSize, ShuffleBlockInfoUtils.parseShuffleBlockInfosFromByteBuffer(indexBuffer)));
        indexInputStream.close();
        return offsets;
    }

    @Override
    public boolean hasNext() {
        logger.debug("check has next current index: {} chunks {}", (Object)this.returnedChunks, (Object)this.numChunks);
        return this.returnedChunks < this.numChunks;
    }

    @Override
    public ByteBuf next() throws IOException, InterruptedException {
        ByteBuf chunk = null;
        try {
            while (chunk == null) {
                this.checkException();
                chunk = this.results.poll(500L, TimeUnit.MILLISECONDS);
                logger.debug("poll result with result size: {}", (Object)this.results.size());
            }
        }
        catch (InterruptedException e) {
            logger.error("PartitionReader thread interrupted while fetching data.");
            throw e;
        }
        ++this.returnedChunks;
        return chunk;
    }

    private void checkException() throws IOException {
        IOException e = this.exception.get();
        if (e != null) {
            throw e;
        }
    }

    @Override
    public void close() {
        this.closed = true;
        if (this.fetchThread != null) {
            this.fetchThread.interrupt();
        }
        try {
            this.hdfsInputStream.close();
        }
        catch (IOException e) {
            logger.warn("close HDFS input stream failed.", (Throwable)e);
        }
        if (this.results.size() > 0) {
            this.results.forEach(ReferenceCounted::release);
        }
        this.results.clear();
    }

    @Override
    public PartitionLocation getLocation() {
        return this.location;
    }
}

