/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.shaded.influxdb.okhttp3.internal.http;

import java.io.IOException;
import java.net.ProtocolException;
import org.apache.kylin.shaded.influxdb.okhttp3.Protocol;
import org.apache.kylin.shaded.influxdb.okhttp3.Response;

public final class StatusLine {
    public static final int HTTP_TEMP_REDIRECT = 307;
    public static final int HTTP_PERM_REDIRECT = 308;
    public static final int HTTP_CONTINUE = 100;
    public final Protocol protocol;
    public final int code;
    public final String message;

    public StatusLine(Protocol protocol, int code, String message) {
        this.protocol = protocol;
        this.code = code;
        this.message = message;
    }

    public static StatusLine get(Response response) {
        return new StatusLine(response.protocol(), response.code(), response.message());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StatusLine parse(String statusLine) throws IOException {
        int code;
        Protocol protocol;
        int codeStart;
        if (statusLine.startsWith("HTTP/1.")) {
            if (statusLine.length() < 9 || statusLine.charAt(8) != ' ') {
                throw new ProtocolException("Unexpected status line: " + statusLine);
            }
            int httpMinorVersion = statusLine.charAt(7) - 48;
            codeStart = 9;
            if (httpMinorVersion == 0) {
                protocol = Protocol.HTTP_1_0;
            } else {
                if (httpMinorVersion != 1) throw new ProtocolException("Unexpected status line: " + statusLine);
                protocol = Protocol.HTTP_1_1;
            }
        } else {
            if (!statusLine.startsWith("ICY ")) throw new ProtocolException("Unexpected status line: " + statusLine);
            protocol = Protocol.HTTP_1_0;
            codeStart = 4;
        }
        if (statusLine.length() < codeStart + 3) {
            throw new ProtocolException("Unexpected status line: " + statusLine);
        }
        try {
            code = Integer.parseInt(statusLine.substring(codeStart, codeStart + 3));
        }
        catch (NumberFormatException e) {
            throw new ProtocolException("Unexpected status line: " + statusLine);
        }
        String message = "";
        if (statusLine.length() <= codeStart + 3) return new StatusLine(protocol, code, message);
        if (statusLine.charAt(codeStart + 3) != ' ') {
            throw new ProtocolException("Unexpected status line: " + statusLine);
        }
        message = statusLine.substring(codeStart + 4);
        return new StatusLine(protocol, code, message);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.protocol == Protocol.HTTP_1_0 ? "HTTP/1.0" : "HTTP/1.1");
        result.append(' ').append(this.code);
        if (this.message != null) {
            result.append(' ').append(this.message);
        }
        return result.toString();
    }
}

