/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.shaded.influxdb.org.influxdb.querybuilder;

import org.apache.kylin.shaded.influxdb.org.influxdb.dto.Query;
import org.apache.kylin.shaded.influxdb.org.influxdb.querybuilder.FunctionFactory;
import org.apache.kylin.shaded.influxdb.org.influxdb.querybuilder.Ordering;
import org.apache.kylin.shaded.influxdb.org.influxdb.querybuilder.QueryStringBuilder;
import org.apache.kylin.shaded.influxdb.org.influxdb.querybuilder.RawText;
import org.apache.kylin.shaded.influxdb.org.influxdb.querybuilder.SelectionCoreImpl;
import org.apache.kylin.shaded.influxdb.org.influxdb.querybuilder.SelectionQueryImpl;
import org.apache.kylin.shaded.influxdb.org.influxdb.querybuilder.clauses.AddRelativeTimeClause;
import org.apache.kylin.shaded.influxdb.org.influxdb.querybuilder.clauses.Clause;
import org.apache.kylin.shaded.influxdb.org.influxdb.querybuilder.clauses.ContainsClause;
import org.apache.kylin.shaded.influxdb.org.influxdb.querybuilder.clauses.NegativeRegexClause;
import org.apache.kylin.shaded.influxdb.org.influxdb.querybuilder.clauses.OperationClause;
import org.apache.kylin.shaded.influxdb.org.influxdb.querybuilder.clauses.RegexClause;
import org.apache.kylin.shaded.influxdb.org.influxdb.querybuilder.clauses.SimpleClause;
import org.apache.kylin.shaded.influxdb.org.influxdb.querybuilder.clauses.SubRelativeTimeClause;
import org.apache.kylin.shaded.influxdb.org.influxdb.querybuilder.time.TimeInterval;

public abstract class BuiltQuery
extends Query
implements QueryStringBuilder {
    public BuiltQuery(String database) {
        super(null, database);
    }

    public BuiltQuery(String database, boolean requiresPost) {
        super(null, database, requiresPost);
    }

    static StringBuilder addSemicolonIfMissing(StringBuilder stringBuilder) {
        int length = BuiltQuery.trimLast(stringBuilder);
        if (length == 0 || stringBuilder.charAt(length - 1) != ';') {
            stringBuilder.append(';');
        }
        return stringBuilder;
    }

    static int trimLast(StringBuilder stringBuilder) {
        int length;
        for (length = stringBuilder.length(); length > 0 && stringBuilder.charAt(length - 1) <= ' '; --length) {
        }
        if (length != stringBuilder.length()) {
            stringBuilder.setLength(length);
        }
        return length;
    }

    @Override
    public String getCommand() {
        StringBuilder sb = this.buildQueryString(new StringBuilder());
        BuiltQuery.addSemicolonIfMissing(sb);
        return sb.toString();
    }

    @Override
    public String getCommandWithUrlEncoded() {
        return BuiltQuery.encode(this.getCommand());
    }

    public static final class QueryBuilder {
        private QueryBuilder() {
        }

        public static SelectionQueryImpl select(String ... columns) {
            return QueryBuilder.select((Object[])columns);
        }

        public static SelectionQueryImpl select(Object ... columns) {
            return new SelectionQueryImpl(new SelectionCoreImpl(columns));
        }

        public static Clause eq(String name, Object value) {
            return new SimpleClause(name, "=", value);
        }

        public static Clause eq(Object arg1, Object arg2) {
            return new OperationClause(arg1, "=", arg2);
        }

        public static Clause ne(String name, Object value) {
            return new SimpleClause(name, "!=", value);
        }

        public static Clause neq(String name, Object value) {
            return new SimpleClause(name, "<>", value);
        }

        public static Clause neq(Object arg1, Object arg2) {
            return new OperationClause(arg1, "<>", arg2);
        }

        public static Clause ne(Object arg1, Object arg2) {
            return new OperationClause(arg1, "!=", arg2);
        }

        public static Clause contains(String name, String value) {
            return new ContainsClause(name, value);
        }

        public static Clause regex(String name, String value) {
            return new RegexClause(name, value);
        }

        public static Clause nregex(String name, String value) {
            return new NegativeRegexClause(name, value);
        }

        public static Clause lt(String name, Object value) {
            return new SimpleClause(name, "<", value);
        }

        public static Clause lt(Object arg1, Object arg2) {
            return new OperationClause(arg1, "<", arg2);
        }

        public static Clause lte(String name, Object value) {
            return new SimpleClause(name, "<=", value);
        }

        public static Clause lte(Object arg1, Object arg2) {
            return new OperationClause(arg1, "<=", arg2);
        }

        public static Clause gt(String name, Object value) {
            return new SimpleClause(name, ">", value);
        }

        public static Clause gt(Object arg1, Object arg2) {
            return new OperationClause(arg1, ">", arg2);
        }

        public static Clause gte(String name, Object value) {
            return new SimpleClause(name, ">=", value);
        }

        public static Clause gte(Object arg1, Object arg2) {
            return new OperationClause(arg1, ">=", arg2);
        }

        public static Clause addTime(long interval, String literal) {
            return new AddRelativeTimeClause(new TimeInterval(interval, literal));
        }

        public static Clause subTime(long interval, String literal) {
            return new SubRelativeTimeClause(new TimeInterval(interval, literal));
        }

        public static Ordering asc() {
            return new Ordering(false);
        }

        public static Ordering desc() {
            return new Ordering(true);
        }

        public static Object raw(String str) {
            return new RawText(str);
        }

        public static Object max(Object column) {
            return FunctionFactory.max(column);
        }

        public static Object min(Object column) {
            return FunctionFactory.min(column);
        }

        public static Object time(Long timeInterval, String durationLiteral) {
            return FunctionFactory.time(timeInterval, durationLiteral);
        }

        public static TimeInterval ti(Long timeInterval, String durationLiteral) {
            return new TimeInterval(timeInterval, durationLiteral);
        }

        public static SimpleClause cop(String column, String op, Object arg2) {
            return new SimpleClause(column, op, arg2);
        }

        public static OperationClause op(Object arg1, String op, Object arg2) {
            return new OperationClause(arg1, op, arg2);
        }

        public static Object time(Long timeInterval, String durationLiteral, Long offsetInterval, String offSetLiteral) {
            return FunctionFactory.time(timeInterval, durationLiteral, offsetInterval, offSetLiteral);
        }

        public static Object now() {
            return FunctionFactory.now();
        }
    }
}

