/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.parser;

import java.lang.reflect.Constructor;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.streaming.metadata.StreamingMessageRow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StreamingParser {
    public static final String PROPERTY_TS_COLUMN_NAME = "tsColName";
    public static final String PROPERTY_TS_PARSER = "tsParser";
    public static final String PROPERTY_TS_PATTERN = "tsPattern";
    public static final String PROPERTY_EMBEDDED_SEPARATOR = "separator";
    public static final String PROPERTY_STRICT_CHECK = "strictCheck";
    public static final String PROPERTY_TS_TIMEZONE = "tsTimezone";
    protected static final Map<String, String> defaultProperties = Maps.newHashMap();
    private static final Logger logger = LoggerFactory.getLogger(StreamingParser.class);
    protected List<TblColRef> allColumns = Lists.newArrayList();
    protected Map<String, String> columnMapping = Maps.newHashMap();

    public StreamingParser(List<TblColRef> allColumns, Map<String, String> properties) {
        if (allColumns != null) {
            this.initColumns(allColumns);
        }
    }

    public static StreamingParser getStreamingParser(String parserName, String parserProperties, List<TblColRef> columns) throws ReflectiveOperationException {
        if (!StringUtils.isEmpty((CharSequence)parserName)) {
            logger.info("Construct StreamingParse {} with properties {}", (Object)parserName, (Object)parserProperties);
            Class<?> clazz = Class.forName(parserName);
            Map<String, String> properties = StreamingParser.parseProperties(parserProperties);
            Constructor<?> constructor = clazz.getConstructor(List.class, Map.class);
            return (StreamingParser)constructor.newInstance(columns, properties);
        }
        throw new IllegalStateException("Invalid StreamingConfig, parserName " + parserName + ", parserProperties " + parserProperties + ".");
    }

    public static Map<String, String> parseProperties(String propertiesStr) {
        HashMap result = Maps.newHashMap(defaultProperties);
        if (!StringUtils.isEmpty((CharSequence)propertiesStr)) {
            String[] properties;
            for (String prop : properties = propertiesStr.split(";")) {
                String[] parts = prop.split("=");
                if (parts.length == 2) {
                    result.put(parts[0], parts[1]);
                    continue;
                }
                logger.warn("Ignored invalid property expression '{}'.", (Object)prop);
            }
        }
        return result;
    }

    private void initColumns(List<TblColRef> allColumns) {
        for (TblColRef col : allColumns) {
            if (col.getColumnDesc().isComputedColumn()) continue;
            this.allColumns.add(col);
        }
        logger.info("Streaming Parser columns: {}", this.allColumns);
    }

    public abstract Map<String, Object> flattenMessage(ByteBuffer var1);

    public abstract List<StreamingMessageRow> parse(ByteBuffer var1);

    public void setColumnMapping(Map<String, String> columnMapping) {
        this.columnMapping = columnMapping;
    }

    static {
        defaultProperties.put(PROPERTY_TS_COLUMN_NAME, "timestamp");
        defaultProperties.put(PROPERTY_TS_PARSER, "org.apache.kylin.parser.DefaultTimeParser");
        defaultProperties.put(PROPERTY_TS_PATTERN, "yyyy-MM-dd HH:mm:ss");
        defaultProperties.put(PROPERTY_EMBEDDED_SEPARATOR, "_");
        defaultProperties.put(PROPERTY_STRICT_CHECK, "false");
        defaultProperties.put(PROPERTY_TS_TIMEZONE, "GMT+0");
    }
}

