/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.streaming;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.base.Throwables;
import org.apache.kylin.parser.AbstractDataParser;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\u0005]b\u0001B\t\u0013\u0001mA\u0001B\u000e\u0001\u0003\u0002\u0003\u0006IA\t\u0005\to\u0001\u0011\t\u0011)A\u0005q!Aa\b\u0001B\u0001B\u0003%q\b\u0003\u0005H\u0001\t\u0005\t\u0015!\u0003I\u0011\u00151\u0006\u0001\"\u0001X\u0011\u001dq\u0006A1A\u0005\n}CaA\u001a\u0001!\u0002\u0013\u0001\u0007bB4\u0001\u0005\u0004%I\u0001\u001b\u0005\u0007S\u0002\u0001\u000b\u0011\u0002\u0018\t\u000f)\u0004!\u0019!C\u0005W\"1q\u000e\u0001Q\u0001\n1DQ\u0001\u001d\u0001\u0005\u0002EDQ!\u001e\u0001\u0005\u0002YDQa\u001e\u0001\u0005\u0002aDQa\u001f\u0001\u0005\u0002qDq!a\t\u0001\t\u0003\t)C\u0001\u000bQCJ$\u0018\u000e^5p]J{w/\u0013;fe\u0006$xN\u001d\u0006\u0003'Q\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005U1\u0012!B6zY&t'BA\f\u0019\u0003\u0019\t\u0007/Y2iK*\t\u0011$A\u0002pe\u001e\u001c\u0001aE\u0002\u00019\t\u0002\"!\b\u0011\u000e\u0003yQ\u0011aH\u0001\u0006g\u000e\fG.Y\u0005\u0003Cy\u0011a!\u00118z%\u00164\u0007cA\u0012,]9\u0011A%\u000b\b\u0003K!j\u0011A\n\u0006\u0003Oi\ta\u0001\u0010:p_Rt\u0014\"A\u0010\n\u0005)r\u0012a\u00029bG.\fw-Z\u0005\u0003Y5\u0012\u0001\"\u0013;fe\u0006$xN\u001d\u0006\u0003Uy\u0001\"a\f\u001b\u000e\u0003AR!!\r\u001a\u0002\u0007M\fHN\u0003\u00024-\u0005)1\u000f]1sW&\u0011Q\u0007\r\u0002\u0004%><\u0018\u0001B5uKJ\fA\u0002]1sg\u0016$7k\u00195f[\u0006\u0004\"!\u000f\u001f\u000e\u0003iR!a\u000f\u0019\u0002\u000bQL\b/Z:\n\u0005uR$AC*ueV\u001cG\u000fV=qK\u0006y\u0001/\u0019:uSRLwN\\\"pYVlg\u000e\u0005\u0002A\t:\u0011\u0011I\u0011\t\u0003KyI!a\u0011\u0010\u0002\rA\u0013X\rZ3g\u0013\t)eI\u0001\u0004TiJLgn\u001a\u0006\u0003\u0007z\t!\u0002Z1uKB\u000b'o]3s!\rIEJT\u0007\u0002\u0015*\u00111\nF\u0001\u0007a\u0006\u00148/\u001a:\n\u00055S%AE!cgR\u0014\u0018m\u0019;ECR\f\u0007+\u0019:tKJ\u0004\"a\u0014+\u000e\u0003AS!!\u0015*\u0002\u00079LwNC\u0001T\u0003\u0011Q\u0017M^1\n\u0005U\u0003&A\u0003\"zi\u0016\u0014UO\u001a4fe\u00061A(\u001b8jiz\"R\u0001\u0017.\\9v\u0003\"!\u0017\u0001\u000e\u0003IAQAN\u0003A\u0002\tBQaN\u0003A\u0002aBQAP\u0003A\u0002}BQaR\u0003A\u0002!\u000ba\u0001\\8hO\u0016\u0014X#\u00011\u0011\u0005\u0005$W\"\u00012\u000b\u0005\rD\u0012!B:mMRR\u0017BA3c\u0005\u0019aunZ4fe\u00069An\\4hKJ\u0004\u0013!C#N!RKvLU(X+\u0005q\u0013AC#N!RKvLU(XA\u0005aA)\u0011+F?B\u000bE\u000bV#S\u001dV\tA\u000eE\u0002\u001e[~J!A\u001c\u0010\u0003\u000b\u0005\u0013(/Y=\u0002\u001b\u0011\u000bE+R0Q\u0003R#VI\u0015(!\u0003\u001dA\u0017m\u001d(fqR,\u0012A\u001d\t\u0003;ML!\u0001\u001e\u0010\u0003\u000f\t{w\u000e\\3b]\u0006!a.\u001a=u)\u0005q\u0013A\u00039beN,Gk\u001c*poR\u0011a&\u001f\u0005\u0006u:\u0001\raP\u0001\u0006S:\u0004X\u000f^\u0001\u000ba\u0006\u00148/\u001a,bYV,GcB?\u0002\u0002\u0005U\u0011\u0011\u0004\t\u0003;yL!a \u0010\u0003\u0007\u0005s\u0017\u0010C\u0004\u0002\u0004=\u0001\r!!\u0002\u0002\u000f)\u001cxN\\'baB1\u0011qAA\t\u007fqi!!!\u0003\u000b\t\u0005-\u0011QB\u0001\b[V$\u0018M\u00197f\u0015\r\tyAH\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\n\u0003\u0013\u00111!T1q\u0011\u0019\t9b\u0004a\u0001\u007f\u000591m\u001c7OC6,\u0007bBA\u000e\u001f\u0001\u0007\u0011QD\u0001\u0006S:$W\r\u001f\t\u0004;\u0005}\u0011bAA\u0011=\t\u0019\u0011J\u001c;\u0002!A\u0014xnY3tgRKW.Z:uC6\u0004HCBA\u0014\u0003c\t\u0019\u0004\u0005\u0003\u0002*\u00055RBAA\u0016\u0015\t\t$+\u0003\u0003\u00020\u0005-\"!\u0003+j[\u0016\u001cH/Y7q\u0011\u0019\t9\u0002\u0005a\u0001\u007f!1\u0011Q\u0007\tA\u0002}\nQA^1mk\u0016\u0004")
public class PartitionRowIterator
implements Iterator<Row> {
    private final Iterator<Row> iter;
    private final StructType parsedSchema;
    private final String partitionColumn;
    private final AbstractDataParser<ByteBuffer> dateParser;
    private final Logger logger;
    private final Row EMPTY_ROW;
    private final String[] DATE_PATTERN;

    public Iterator<Row> seq() {
        return Iterator.seq$((Iterator)this);
    }

    public boolean isEmpty() {
        return Iterator.isEmpty$((Iterator)this);
    }

    public boolean isTraversableAgain() {
        return Iterator.isTraversableAgain$((Iterator)this);
    }

    public boolean hasDefiniteSize() {
        return Iterator.hasDefiniteSize$((Iterator)this);
    }

    public Iterator<Row> take(int n) {
        return Iterator.take$((Iterator)this, (int)n);
    }

    public Iterator<Row> drop(int n) {
        return Iterator.drop$((Iterator)this, (int)n);
    }

    public Iterator<Row> slice(int from, int until) {
        return Iterator.slice$((Iterator)this, (int)from, (int)until);
    }

    public Iterator<Row> sliceIterator(int from, int until) {
        return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
    }

    public <B> Iterator<B> map(Function1<Row, B> f) {
        return Iterator.map$((Iterator)this, f);
    }

    public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
        return Iterator.$plus$plus$((Iterator)this, that);
    }

    public <B> Iterator<B> flatMap(Function1<Row, GenTraversableOnce<B>> f) {
        return Iterator.flatMap$((Iterator)this, f);
    }

    public Iterator<Row> filter(Function1<Row, Object> p) {
        return Iterator.filter$((Iterator)this, p);
    }

    public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<Row, B, Object> p) {
        return Iterator.corresponds$((Iterator)this, that, p);
    }

    public Iterator<Row> withFilter(Function1<Row, Object> p) {
        return Iterator.withFilter$((Iterator)this, p);
    }

    public Iterator<Row> filterNot(Function1<Row, Object> p) {
        return Iterator.filterNot$((Iterator)this, p);
    }

    public <B> Iterator<B> collect(PartialFunction<Row, B> pf) {
        return Iterator.collect$((Iterator)this, pf);
    }

    public <B> Iterator<B> scanLeft(B z, Function2<B, Row, B> op) {
        return Iterator.scanLeft$((Iterator)this, z, op);
    }

    public <B> Iterator<B> scanRight(B z, Function2<Row, B, B> op) {
        return Iterator.scanRight$((Iterator)this, z, op);
    }

    public Iterator<Row> takeWhile(Function1<Row, Object> p) {
        return Iterator.takeWhile$((Iterator)this, p);
    }

    public Tuple2<Iterator<Row>, Iterator<Row>> partition(Function1<Row, Object> p) {
        return Iterator.partition$((Iterator)this, p);
    }

    public Tuple2<Iterator<Row>, Iterator<Row>> span(Function1<Row, Object> p) {
        return Iterator.span$((Iterator)this, p);
    }

    public Iterator<Row> dropWhile(Function1<Row, Object> p) {
        return Iterator.dropWhile$((Iterator)this, p);
    }

    public <B> Iterator<Tuple2<Row, B>> zip(Iterator<B> that) {
        return Iterator.zip$((Iterator)this, that);
    }

    public <A1> Iterator<A1> padTo(int len, A1 elem) {
        return Iterator.padTo$((Iterator)this, (int)len, elem);
    }

    public Iterator<Tuple2<Row, Object>> zipWithIndex() {
        return Iterator.zipWithIndex$((Iterator)this);
    }

    public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
        return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
    }

    public <U> void foreach(Function1<Row, U> f) {
        Iterator.foreach$((Iterator)this, f);
    }

    public boolean forall(Function1<Row, Object> p) {
        return Iterator.forall$((Iterator)this, p);
    }

    public boolean exists(Function1<Row, Object> p) {
        return Iterator.exists$((Iterator)this, p);
    }

    public boolean contains(Object elem) {
        return Iterator.contains$((Iterator)this, (Object)elem);
    }

    public Option<Row> find(Function1<Row, Object> p) {
        return Iterator.find$((Iterator)this, p);
    }

    public int indexWhere(Function1<Row, Object> p) {
        return Iterator.indexWhere$((Iterator)this, p);
    }

    public int indexWhere(Function1<Row, Object> p, int from) {
        return Iterator.indexWhere$((Iterator)this, p, (int)from);
    }

    public <B> int indexOf(B elem) {
        return Iterator.indexOf$((Iterator)this, elem);
    }

    public <B> int indexOf(B elem, int from) {
        return Iterator.indexOf$((Iterator)this, elem, (int)from);
    }

    public BufferedIterator<Row> buffered() {
        return Iterator.buffered$((Iterator)this);
    }

    public <B> Iterator.GroupedIterator<B> grouped(int size) {
        return Iterator.grouped$((Iterator)this, (int)size);
    }

    public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
        return Iterator.sliding$((Iterator)this, (int)size, (int)step);
    }

    public <B> int sliding$default$2() {
        return Iterator.sliding$default$2$((Iterator)this);
    }

    public int length() {
        return Iterator.length$((Iterator)this);
    }

    public Tuple2<Iterator<Row>, Iterator<Row>> duplicate() {
        return Iterator.duplicate$((Iterator)this);
    }

    public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
        return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
    }

    public <B> void copyToArray(Object xs, int start, int len) {
        Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
    }

    public boolean sameElements(Iterator<?> that) {
        return Iterator.sameElements$((Iterator)this, that);
    }

    public Traversable<Row> toTraversable() {
        return Iterator.toTraversable$((Iterator)this);
    }

    public Iterator<Row> toIterator() {
        return Iterator.toIterator$((Iterator)this);
    }

    public Stream<Row> toStream() {
        return Iterator.toStream$((Iterator)this);
    }

    public String toString() {
        return Iterator.toString$((Iterator)this);
    }

    public List<Row> reversed() {
        return TraversableOnce.reversed$((TraversableOnce)this);
    }

    public int size() {
        return TraversableOnce.size$((TraversableOnce)this);
    }

    public boolean nonEmpty() {
        return TraversableOnce.nonEmpty$((TraversableOnce)this);
    }

    public int count(Function1<Row, Object> p) {
        return TraversableOnce.count$((TraversableOnce)this, p);
    }

    public <B> Option<B> collectFirst(PartialFunction<Row, B> pf) {
        return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
    }

    public <B> B $div$colon(B z, Function2<B, Row, B> op) {
        return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
    }

    public <B> B $colon$bslash(B z, Function2<Row, B, B> op) {
        return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
    }

    public <B> B foldLeft(B z, Function2<B, Row, B> op) {
        return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
    }

    public <B> B foldRight(B z, Function2<Row, B, B> op) {
        return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
    }

    public <B> B reduceLeft(Function2<B, Row, B> op) {
        return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
    }

    public <B> B reduceRight(Function2<Row, B, B> op) {
        return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
    }

    public <B> Option<B> reduceLeftOption(Function2<B, Row, B> op) {
        return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
    }

    public <B> Option<B> reduceRightOption(Function2<Row, B, B> op) {
        return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
    }

    public <A1> A1 reduce(Function2<A1, A1, A1> op) {
        return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
    }

    public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
        return TraversableOnce.reduceOption$((TraversableOnce)this, op);
    }

    public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
        return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
    }

    public <B> B aggregate(Function0<B> z, Function2<B, Row, B> seqop, Function2<B, B, B> combop) {
        return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
    }

    public <B> B sum(Numeric<B> num) {
        return (B)TraversableOnce.sum$((TraversableOnce)this, num);
    }

    public <B> B product(Numeric<B> num) {
        return (B)TraversableOnce.product$((TraversableOnce)this, num);
    }

    public Object min(Ordering cmp) {
        return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
    }

    public Object max(Ordering cmp) {
        return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
    }

    public Object maxBy(Function1 f, Ordering cmp) {
        return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
    }

    public Object minBy(Function1 f, Ordering cmp) {
        return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
    }

    public <B> void copyToBuffer(Buffer<B> dest) {
        TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
    }

    public <B> void copyToArray(Object xs, int start) {
        TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
    }

    public <B> void copyToArray(Object xs) {
        TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
    }

    public <B> Object toArray(ClassTag<B> evidence$1) {
        return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
    }

    public List<Row> toList() {
        return TraversableOnce.toList$((TraversableOnce)this);
    }

    public Iterable<Row> toIterable() {
        return TraversableOnce.toIterable$((TraversableOnce)this);
    }

    public Seq<Row> toSeq() {
        return TraversableOnce.toSeq$((TraversableOnce)this);
    }

    public IndexedSeq<Row> toIndexedSeq() {
        return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
    }

    public <B> Buffer<B> toBuffer() {
        return TraversableOnce.toBuffer$((TraversableOnce)this);
    }

    public <B> Set<B> toSet() {
        return TraversableOnce.toSet$((TraversableOnce)this);
    }

    public Vector<Row> toVector() {
        return TraversableOnce.toVector$((TraversableOnce)this);
    }

    public <Col> Col to(CanBuildFrom<Nothing$, Row, Col> cbf) {
        return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
    }

    public <T, U> Map<T, U> toMap(Predef$.less.colon.less<Row, Tuple2<T, U>> ev) {
        return TraversableOnce.toMap$((TraversableOnce)this, ev);
    }

    public String mkString(String start, String sep, String end) {
        return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
    }

    public String mkString(String sep) {
        return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
    }

    public String mkString() {
        return TraversableOnce.mkString$((TraversableOnce)this);
    }

    public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
        return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
    }

    public StringBuilder addString(StringBuilder b, String sep) {
        return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
    }

    public StringBuilder addString(StringBuilder b) {
        return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
    }

    public int sizeHintIfCheap() {
        return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
    }

    private Logger logger() {
        return this.logger;
    }

    private Row EMPTY_ROW() {
        return this.EMPTY_ROW;
    }

    private String[] DATE_PATTERN() {
        return this.DATE_PATTERN;
    }

    public boolean hasNext() {
        return this.iter.hasNext();
    }

    public Row next() {
        Row row;
        Object input = ((Row)this.iter.next()).get(0);
        if (Objects.isNull(input) || StringUtils.isEmpty((CharSequence)input.toString())) {
            this.logger().error(new java.lang.StringBuilder(66).append("input data is null or length is 0, returning empty row. line is '").append(input).append("'").toString());
            return this.EMPTY_ROW();
        }
        try {
            row = this.parseToRow(input.toString());
        }
        catch (Exception e) {
            this.logger().error(new java.lang.StringBuilder(30).append("parse data failed, line is: '").append(input).append("'").toString(), Throwables.getRootCause((Throwable)e));
            row = this.EMPTY_ROW();
        }
        return row;
    }

    public Row parseToRow(String input) {
        scala.collection.mutable.Map jsonMap = (scala.collection.mutable.Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.dateParser.process((Object)StandardCharsets.UTF_8.encode(input))).asScala()).map((Function1 & Serializable & scala.Serializable)pair -> new Tuple2((Object)((String)pair._1()).toLowerCase(Locale.ROOT), pair._2()), Map$.MODULE$.canBuildFrom());
        return Row$.MODULE$.apply((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.parsedSchema.fields())).indices().map((Function1 & Serializable & scala.Serializable)index -> PartitionRowIterator.$anonfun$parseToRow$2(this, jsonMap, BoxesRunTime.unboxToInt((Object)index)), IndexedSeq$.MODULE$.canBuildFrom()));
    }

    public Object parseValue(scala.collection.mutable.Map<String, Object> jsonMap, String colName, int index) {
        Object object;
        DataType dataType;
        if (!jsonMap.contains((Object)colName)) {
            return null;
        }
        Object value = jsonMap.getOrElse((Object)colName, (Function0 & Serializable & scala.Serializable)() -> null);
        DataType dataType2 = dataType = this.parsedSchema.fields()[index].dataType();
        StringType$ stringType$ = StringType$.MODULE$;
        if (!(dataType2 != null ? !dataType2.equals(stringType$) : stringType$ != null)) {
            object = value;
        } else if (ObjectUtils.isEmpty((Object)value)) {
            object = null;
        } else {
            String strValue = value.toString();
            DataType dataType3 = dataType;
            Object object2 = ShortType$.MODULE$.equals(dataType3) ? BoxesRunTime.boxToShort((short)Short.parseShort(strValue)) : (IntegerType$.MODULE$.equals(dataType3) ? BoxesRunTime.boxToInteger((int)Integer.parseInt(strValue)) : (LongType$.MODULE$.equals(dataType3) ? BoxesRunTime.boxToLong((long)Long.parseLong(strValue)) : (DoubleType$.MODULE$.equals(dataType3) ? BoxesRunTime.boxToDouble((double)Double.parseDouble(strValue)) : (FloatType$.MODULE$.equals(dataType3) ? BoxesRunTime.boxToFloat((float)Float.parseFloat(strValue)) : (BooleanType$.MODULE$.equals(dataType3) ? BoxesRunTime.boxToBoolean((boolean)Boolean.parseBoolean(strValue)) : (TimestampType$.MODULE$.equals(dataType3) ? this.processTimestamp(colName, strValue) : (DateType$.MODULE$.equals(dataType3) ? new Date(DateUtils.parseDate((String)strValue, (String[])this.DATE_PATTERN()).getTime()) : (DecimalType$.MODULE$.unapply(dataType3) ? package$.MODULE$.BigDecimal().apply(strValue) : value))))))));
            object = object2;
        }
        return object;
    }

    public Timestamp processTimestamp(String colName, String value) {
        long timestamp = DateUtils.parseDate((String)value, (String[])this.DATE_PATTERN()).getTime();
        if (colName.equalsIgnoreCase(this.partitionColumn)) {
            Preconditions.checkArgument((timestamp >= 0L ? 1 : 0) != 0, (String)"invalid value %s", (Object[])new Object[]{value});
        }
        return new Timestamp(timestamp);
    }

    public static final /* synthetic */ Object $anonfun$parseToRow$2(PartitionRowIterator $this, scala.collection.mutable.Map jsonMap$1, int index) {
        String colName = $this.parsedSchema.fields()[index].name().toLowerCase(Locale.ROOT);
        return $this.parseValue((scala.collection.mutable.Map<String, Object>)jsonMap$1, colName, index);
    }

    public PartitionRowIterator(Iterator<Row> iter, StructType parsedSchema, String partitionColumn, AbstractDataParser<ByteBuffer> dateParser) {
        this.iter = iter;
        this.parsedSchema = parsedSchema;
        this.partitionColumn = partitionColumn;
        this.dateParser = dateParser;
        GenTraversableOnce.$init$((GenTraversableOnce)this);
        TraversableOnce.$init$((TraversableOnce)this);
        Iterator.$init$((Iterator)this);
        this.logger = LoggerFactory.getLogger(PartitionRowIterator.class);
        this.EMPTY_ROW = Row$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.DATE_PATTERN = (String[])((Object[])new String[]{"yyyyMMdd", "yyyy-MM-dd", "yyyy/MM/dd", "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm:ss.SSS"});
    }
}

