/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.streaming.jobs.thread;

import lombok.Generated;
import org.apache.kylin.job.execution.JobTypeEnum;
import org.apache.kylin.metadata.cube.utils.StreamingUtils;
import org.apache.kylin.streaming.jobs.impl.StreamingJobLauncher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamingJobRunner
implements Runnable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StreamingJobRunner.class);
    private String project;
    private String modelId;
    private JobTypeEnum jobType;
    private StreamingJobLauncher jobLauncher;

    public StreamingJobRunner(String project, String modelId, JobTypeEnum jobType) {
        this.project = project;
        this.modelId = modelId;
        this.jobType = jobType;
        this.jobLauncher = new StreamingJobLauncher();
    }

    @Override
    public void run() {
        this.launchJob();
    }

    public void stop() {
        this.stopJob();
    }

    public void init() {
        this.jobLauncher.init(this.project, this.modelId, this.jobType);
    }

    private void launchJob() {
        this.jobLauncher.init(this.project, this.modelId, this.jobType);
        this.jobLauncher.launch();
    }

    private void stopJob() {
        if (!this.jobLauncher.isInitialized()) {
            log.warn("Streaming job launcher {} not exists...", (Object)StreamingUtils.getJobId((String)this.modelId, (String)this.jobType.name()));
            return;
        }
        this.jobLauncher.stop();
    }
}

