/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.enumerable;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.adapter.enumerable.EnumUtils;
import org.apache.calcite.adapter.enumerable.JavaRowFormat;
import org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.BlockStatement;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.FunctionExpression;
import org.apache.calcite.linq4j.tree.MemberDeclaration;
import org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.calcite.linq4j.tree.Node;
import org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.calcite.linq4j.tree.Primitive;
import org.apache.calcite.linq4j.tree.Statement;
import org.apache.calcite.linq4j.tree.Types;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.runtime.Utilities;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PhysTypeImpl
implements PhysType {
    private final JavaTypeFactory typeFactory;
    private final RelDataType rowType;
    private final Type javaRowClass;
    private final List<Class> fieldClasses = new ArrayList<Class>();
    final JavaRowFormat format;

    PhysTypeImpl(JavaTypeFactory typeFactory, RelDataType rowType, Type javaRowClass, JavaRowFormat format) {
        this.typeFactory = typeFactory;
        this.rowType = rowType;
        this.javaRowClass = javaRowClass;
        this.format = format;
        for (RelDataTypeField field : rowType.getFieldList()) {
            Type fieldType = typeFactory.getJavaClass(field.getType());
            this.fieldClasses.add(fieldType instanceof Class ? (Class)fieldType : Object[].class);
        }
    }

    public static PhysType of(JavaTypeFactory typeFactory, RelDataType rowType, JavaRowFormat format) {
        return PhysTypeImpl.of(typeFactory, rowType, format, true);
    }

    public static PhysType of(JavaTypeFactory typeFactory, RelDataType rowType, JavaRowFormat format, boolean optimize) {
        if (optimize) {
            format = format.optimize(rowType);
        }
        Type javaRowClass = format.javaRowClass(typeFactory, rowType);
        return new PhysTypeImpl(typeFactory, rowType, javaRowClass, format);
    }

    static PhysType of(JavaTypeFactory typeFactory, Type javaRowClass) {
        RelDataTypeFactory.FieldInfoBuilder builder = typeFactory.builder();
        if (javaRowClass instanceof Types.RecordType) {
            Types.RecordType recordType = (Types.RecordType)javaRowClass;
            for (Types.RecordField field : recordType.getRecordFields()) {
                ((RelDataTypeFactory.Builder)builder).add(field.getName(), typeFactory.createType(field.getType()));
            }
        }
        RelDataType rowType = builder.build();
        return new PhysTypeImpl(typeFactory, rowType, javaRowClass, JavaRowFormat.CUSTOM);
    }

    @Override
    public JavaRowFormat getFormat() {
        return this.format;
    }

    @Override
    public PhysType project(List<Integer> integers, JavaRowFormat format) {
        return this.project(integers, false, format);
    }

    @Override
    public PhysType project(List<Integer> integers, boolean indicator, JavaRowFormat format) {
        RelDataTypeFactory.FieldInfoBuilder builder = this.typeFactory.builder();
        for (int index : integers) {
            ((RelDataTypeFactory.Builder)builder).add(this.rowType.getFieldList().get(index));
        }
        if (indicator) {
            RelDataType booleanType = this.typeFactory.createTypeWithNullability(this.typeFactory.createSqlType(SqlTypeName.BOOLEAN), false);
            for (int index : integers) {
                ((RelDataTypeFactory.Builder)builder).add("i$" + this.rowType.getFieldList().get(index).getName(), booleanType);
            }
        }
        RelDataType projectedRowType = builder.build();
        return PhysTypeImpl.of(this.typeFactory, projectedRowType, format.optimize(projectedRowType));
    }

    @Override
    public Expression generateSelector(ParameterExpression parameter, List<Integer> fields) {
        return this.generateSelector(parameter, fields, this.format);
    }

    @Override
    public Expression generateSelector(ParameterExpression parameter, List<Integer> fields, JavaRowFormat targetFormat) {
        switch (fields.size()) {
            case 0: {
                targetFormat = JavaRowFormat.LIST;
                break;
            }
            case 1: {
                targetFormat = JavaRowFormat.SCALAR;
                break;
            }
        }
        PhysType targetPhysType = this.project(fields, targetFormat);
        switch (this.format) {
            case SCALAR: {
                return Expressions.call((Method)BuiltInMethod.IDENTITY_SELECTOR.method, (Expression[])new Expression[0]);
            }
        }
        return Expressions.lambda(Function1.class, (Expression)targetPhysType.record(this.fieldReferences((Expression)parameter, fields)), (ParameterExpression[])new ParameterExpression[]{parameter});
    }

    @Override
    public Expression generateSelector(ParameterExpression parameter, List<Integer> fields, List<Integer> usedFields, JavaRowFormat targetFormat) {
        PhysType targetPhysType = this.project(fields, true, targetFormat);
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        for (Ord ord : Ord.zip(fields)) {
            Integer field = (Integer)ord.e;
            if (usedFields.contains(field)) {
                expressions.add(this.fieldReference((Expression)parameter, field));
                continue;
            }
            Primitive primitive = Primitive.of((Type)targetPhysType.fieldClass(ord.i));
            expressions.add((Expression)Expressions.constant((Object)(primitive != null ? primitive.defaultValue : null)));
        }
        for (Integer field : fields) {
            expressions.add((Expression)Expressions.constant((Object)(!usedFields.contains(field) ? 1 : 0)));
        }
        return Expressions.lambda(Function1.class, (Expression)targetPhysType.record(expressions), (ParameterExpression[])new ParameterExpression[]{parameter});
    }

    @Override
    public Pair<Type, List<Expression>> selector(ParameterExpression parameter, List<Integer> fields, JavaRowFormat targetFormat) {
        switch (fields.size()) {
            case 0: {
                targetFormat = JavaRowFormat.LIST;
                break;
            }
            case 1: {
                targetFormat = JavaRowFormat.SCALAR;
                break;
            }
        }
        PhysType targetPhysType = this.project(fields, targetFormat);
        switch (this.format) {
            case SCALAR: {
                return Pair.of(parameter.getType(), ImmutableList.of((Object)parameter));
            }
        }
        return Pair.of(targetPhysType.getJavaRowType(), this.fieldReferences((Expression)parameter, fields));
    }

    @Override
    public List<Expression> accessors(Expression v1, List<Integer> argList) {
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        for (int field : argList) {
            expressions.add(EnumUtils.convert(this.fieldReference(v1, field), this.fieldClass(field)));
        }
        return expressions;
    }

    @Override
    public PhysType makeNullable(boolean nullable) {
        if (!nullable) {
            return this;
        }
        return new PhysTypeImpl(this.typeFactory, this.typeFactory.createTypeWithNullability(this.rowType, true), Primitive.box((Type)this.javaRowClass), this.format);
    }

    @Override
    public Expression convertTo(Expression exp, PhysType targetPhysType) {
        return this.convertTo(exp, targetPhysType.getFormat());
    }

    @Override
    public Expression convertTo(Expression exp, JavaRowFormat targetFormat) {
        if (this.format == targetFormat) {
            return exp;
        }
        ParameterExpression o_ = Expressions.parameter((Type)this.javaRowClass, (String)"o");
        int fieldCount = this.rowType.getFieldCount();
        PhysType targetPhysType = PhysTypeImpl.of(this.typeFactory, this.rowType, targetFormat, false);
        FunctionExpression selector = Expressions.lambda(Function1.class, (Expression)targetPhysType.record(this.fieldReferences((Expression)o_, Util.range(fieldCount))), (ParameterExpression[])new ParameterExpression[]{o_});
        return Expressions.call((Expression)exp, (Method)BuiltInMethod.SELECT.method, (Expression[])new Expression[]{selector});
    }

    @Override
    public Pair<Expression, Expression> generateCollationKey(List<RelFieldCollation> collations) {
        if (collations.size() == 1) {
            RelFieldCollation collation = collations.get(0);
            RelDataType fieldType = this.rowType.getFieldList() == null || this.rowType.getFieldList().isEmpty() ? this.rowType : this.rowType.getFieldList().get(collation.getFieldIndex()).getType();
            Expression fieldComparator = EnumUtils.generateCollatorExpression(fieldType.getCollation());
            ParameterExpression parameter = Expressions.parameter((Type)this.javaRowClass, (String)"v");
            FunctionExpression selector = Expressions.lambda(Function1.class, (Expression)this.fieldReference((Expression)parameter, collation.getFieldIndex()), (ParameterExpression[])new ParameterExpression[]{parameter});
            return Pair.of(selector, Expressions.call((Method)(fieldComparator == null ? BuiltInMethod.NULLS_COMPARATOR.method : BuiltInMethod.NULLS_COMPARATOR2.method), (Iterable)Expressions.list((Object[])new Expression[]{Expressions.constant((Object)(collation.nullDirection == RelFieldCollation.NullDirection.FIRST ? 1 : 0)), Expressions.constant((Object)(collation.direction == RelFieldCollation.Direction.DESCENDING ? 1 : 0))}).appendIfNotNull((Object)fieldComparator)));
        }
        MethodCallExpression selector = Expressions.call((Method)BuiltInMethod.IDENTITY_SELECTOR.method, (Expression[])new Expression[0]);
        BlockBuilder body = new BlockBuilder();
        ParameterExpression parameterV0 = Expressions.parameter((Type)this.javaRowClass, (String)"v0");
        ParameterExpression parameterV1 = Expressions.parameter((Type)this.javaRowClass, (String)"v1");
        ParameterExpression parameterC = Expressions.parameter(Integer.TYPE, (String)"c");
        int mod = collations.size() == 1 ? 16 : 0;
        body.add((Statement)Expressions.declare((int)mod, (ParameterExpression)parameterC, null));
        for (RelFieldCollation collation : collations) {
            boolean descending;
            int index = collation.getFieldIndex();
            RelDataType fieldType = this.rowType.getFieldList().get(index).getType();
            Expression fieldComparator = EnumUtils.generateCollatorExpression(fieldType.getCollation());
            Expression arg0 = this.fieldReference((Expression)parameterV0, index);
            Expression arg1 = this.fieldReference((Expression)parameterV1, index);
            switch (Primitive.flavor((Type)this.fieldClass(index))) {
                case OBJECT: {
                    arg0 = EnumUtils.convert(arg0, Comparable.class);
                    arg1 = EnumUtils.convert(arg1, Comparable.class);
                    break;
                }
            }
            boolean nullsFirst = collation.nullDirection == RelFieldCollation.NullDirection.FIRST;
            boolean bl = descending = collation.getDirection() == RelFieldCollation.Direction.DESCENDING;
            body.add(Expressions.statement((Expression)Expressions.assign((Expression)parameterC, (Expression)Expressions.call(Utilities.class, (String)(this.fieldNullable(index) ? (nullsFirst != descending ? "compareNullsFirst" : "compareNullsLast") : "compare"), (Iterable)Expressions.list((Object[])new Expression[]{arg0, arg1}).appendIfNotNull((Object)fieldComparator)))));
            body.add((Statement)Expressions.ifThen((Expression)Expressions.notEqual((Expression)parameterC, (Expression)Expressions.constant((Object)0)), (Node)Expressions.return_(null, (Expression)(descending ? Expressions.negate((Expression)parameterC) : parameterC))));
        }
        body.add((Statement)Expressions.return_(null, (Expression)Expressions.constant((Object)0)));
        Expressions.FluentList memberDeclarations = Expressions.list((Object[])new MemberDeclaration[]{Expressions.methodDecl((int)1, Integer.TYPE, (String)"compare", (Iterable)ImmutableList.of((Object)parameterV0, (Object)parameterV1), (BlockStatement)body.toBlock())});
        ParameterExpression parameterO0 = Expressions.parameter(Object.class, (String)"o0");
        ParameterExpression parameterO1 = Expressions.parameter(Object.class, (String)"o1");
        BlockBuilder bridgeBody = new BlockBuilder();
        bridgeBody.add((Statement)Expressions.return_(null, (Expression)Expressions.call((Expression)Expressions.parameter(Comparable.class, (String)"this"), (Method)BuiltInMethod.COMPARATOR_COMPARE.method, (Expression[])new Expression[]{Expressions.convert_((Expression)parameterO0, (Type)this.javaRowClass), Expressions.convert_((Expression)parameterO1, (Type)this.javaRowClass)})));
        memberDeclarations.add(EnumUtils.overridingMethodDecl(BuiltInMethod.COMPARATOR_COMPARE.method, (Iterable<ParameterExpression>)ImmutableList.of((Object)parameterO0, (Object)parameterO1), bridgeBody.toBlock()));
        return Pair.of(selector, Expressions.new_(Comparator.class, (Iterable)ImmutableList.of(), (Iterable)memberDeclarations));
    }

    @Override
    public Expression generateComparator(RelCollation collation) {
        BlockBuilder body = new BlockBuilder();
        Type javaRowClass = Primitive.box((Type)this.javaRowClass);
        ParameterExpression parameterV0 = Expressions.parameter((Type)javaRowClass, (String)"v0");
        ParameterExpression parameterV1 = Expressions.parameter((Type)javaRowClass, (String)"v1");
        ParameterExpression parameterC = Expressions.parameter(Integer.TYPE, (String)"c");
        int mod = collation.getFieldCollations().size() == 1 ? 16 : 0;
        body.add((Statement)Expressions.declare((int)mod, (ParameterExpression)parameterC, null));
        for (RelFieldCollation fieldCollation : collation.getFieldCollations()) {
            boolean descending;
            int index = fieldCollation.getFieldIndex();
            RelDataType fieldType = this.rowType.getFieldList().get(index).getType();
            Expression fieldComparator = EnumUtils.generateCollatorExpression(fieldType.getCollation());
            Expression arg0 = this.fieldReference((Expression)parameterV0, index);
            Expression arg1 = this.fieldReference((Expression)parameterV1, index);
            switch (Primitive.flavor((Type)this.fieldClass(index))) {
                case OBJECT: {
                    arg0 = EnumUtils.convert(arg0, Comparable.class);
                    arg1 = EnumUtils.convert(arg1, Comparable.class);
                    break;
                }
            }
            boolean nullsFirst = fieldCollation.nullDirection == RelFieldCollation.NullDirection.FIRST;
            boolean bl = descending = fieldCollation.getDirection() == RelFieldCollation.Direction.DESCENDING;
            body.add(Expressions.statement((Expression)Expressions.assign((Expression)parameterC, (Expression)Expressions.call(Utilities.class, (String)(this.fieldNullable(index) ? (nullsFirst != descending ? "compareNullsFirst" : "compareNullsLast") : "compare"), (Iterable)Expressions.list((Object[])new Expression[]{arg0, arg1}).appendIfNotNull((Object)fieldComparator)))));
            body.add((Statement)Expressions.ifThen((Expression)Expressions.notEqual((Expression)parameterC, (Expression)Expressions.constant((Object)0)), (Node)Expressions.return_(null, (Expression)(descending ? Expressions.negate((Expression)parameterC) : parameterC))));
        }
        body.add((Statement)Expressions.return_(null, (Expression)Expressions.constant((Object)0)));
        Expressions.FluentList memberDeclarations = Expressions.list((Object[])new MemberDeclaration[]{Expressions.methodDecl((int)1, Integer.TYPE, (String)"compare", (Iterable)ImmutableList.of((Object)parameterV0, (Object)parameterV1), (BlockStatement)body.toBlock())});
        ParameterExpression parameterO0 = Expressions.parameter(Object.class, (String)"o0");
        ParameterExpression parameterO1 = Expressions.parameter(Object.class, (String)"o1");
        BlockBuilder bridgeBody = new BlockBuilder();
        bridgeBody.add((Statement)Expressions.return_(null, (Expression)Expressions.call((Expression)Expressions.parameter(Comparable.class, (String)"this"), (Method)BuiltInMethod.COMPARATOR_COMPARE.method, (Expression[])new Expression[]{Expressions.convert_((Expression)parameterO0, (Type)javaRowClass), Expressions.convert_((Expression)parameterO1, (Type)javaRowClass)})));
        memberDeclarations.add(EnumUtils.overridingMethodDecl(BuiltInMethod.COMPARATOR_COMPARE.method, (Iterable<ParameterExpression>)ImmutableList.of((Object)parameterO0, (Object)parameterO1), bridgeBody.toBlock()));
        return Expressions.new_(Comparator.class, (Iterable)ImmutableList.of(), (Iterable)memberDeclarations);
    }

    @Override
    public RelDataType getRowType() {
        return this.rowType;
    }

    @Override
    public Expression record(List<Expression> expressions) {
        return this.format.record(this.javaRowClass, expressions);
    }

    @Override
    public Type getJavaRowType() {
        return this.javaRowClass;
    }

    @Override
    public Type getJavaFieldType(int index) {
        return this.format.javaFieldClass(this.typeFactory, this.rowType, index);
    }

    @Override
    public PhysType component(int fieldOrdinal) {
        RelDataTypeField field = this.rowType.getFieldList().get(fieldOrdinal);
        RelDataType componentType = Objects.requireNonNull(field.getType().getComponentType(), () -> "field.getType().getComponentType() for " + field);
        return PhysTypeImpl.of(this.typeFactory, this.toStruct(componentType), this.format, false);
    }

    @Override
    public PhysType field(int ordinal) {
        RelDataTypeField field = this.rowType.getFieldList().get(ordinal);
        RelDataType type = field.getType();
        return PhysTypeImpl.of(this.typeFactory, this.toStruct(type), this.format, false);
    }

    private RelDataType toStruct(RelDataType type) {
        if (type.isStruct()) {
            return type;
        }
        return this.typeFactory.builder().add(SqlUtil.deriveAliasFromOrdinal(0), type).build();
    }

    @Override
    public @Nullable Expression comparer() {
        return this.format.comparer();
    }

    private List<Expression> fieldReferences(final Expression parameter, final List<Integer> fields) {
        return new AbstractList<Expression>(){

            @Override
            public Expression get(int index) {
                return PhysTypeImpl.this.fieldReference(parameter, (Integer)fields.get(index));
            }

            @Override
            public int size() {
                return fields.size();
            }
        };
    }

    @Override
    public Class fieldClass(int field) {
        return this.fieldClasses.get(field);
    }

    @Override
    public boolean fieldNullable(int field) {
        return this.rowType.getFieldList().get(field).getType().isNullable();
    }

    @Override
    public Expression generateAccessor(List<Integer> fields) {
        ParameterExpression v1 = Expressions.parameter((Type)this.javaRowClass, (String)"v1");
        switch (fields.size()) {
            case 0: {
                return Expressions.lambda(Function1.class, (Expression)Expressions.field(null, (Field)BuiltInMethod.COMPARABLE_EMPTY_LIST.field), (ParameterExpression[])new ParameterExpression[]{v1});
            }
            case 1: {
                int field0 = fields.get(0);
                Class returnType = this.fieldClasses.get(field0);
                Expression fieldReference = EnumUtils.convert(this.fieldReference((Expression)v1, field0), returnType);
                return Expressions.lambda(Function1.class, (Expression)fieldReference, (ParameterExpression[])new ParameterExpression[]{v1});
            }
        }
        Expressions.FluentList list = Expressions.list();
        for (int field : fields) {
            list.add((Object)this.fieldReference((Expression)v1, field));
        }
        switch (list.size()) {
            case 2: {
                return Expressions.lambda(Function1.class, (Expression)Expressions.call(List.class, null, (Method)BuiltInMethod.LIST2.method, (Iterable)list), (ParameterExpression[])new ParameterExpression[]{v1});
            }
            case 3: {
                return Expressions.lambda(Function1.class, (Expression)Expressions.call(List.class, null, (Method)BuiltInMethod.LIST3.method, (Iterable)list), (ParameterExpression[])new ParameterExpression[]{v1});
            }
            case 4: {
                return Expressions.lambda(Function1.class, (Expression)Expressions.call(List.class, null, (Method)BuiltInMethod.LIST4.method, (Iterable)list), (ParameterExpression[])new ParameterExpression[]{v1});
            }
            case 5: {
                return Expressions.lambda(Function1.class, (Expression)Expressions.call(List.class, null, (Method)BuiltInMethod.LIST5.method, (Iterable)list), (ParameterExpression[])new ParameterExpression[]{v1});
            }
            case 6: {
                return Expressions.lambda(Function1.class, (Expression)Expressions.call(List.class, null, (Method)BuiltInMethod.LIST6.method, (Iterable)list), (ParameterExpression[])new ParameterExpression[]{v1});
            }
        }
        return Expressions.lambda(Function1.class, (Expression)Expressions.call(List.class, null, (Method)BuiltInMethod.LIST_N.method, (Expression[])new Expression[]{Expressions.newArrayInit(Comparable.class, (Iterable)list)}), (ParameterExpression[])new ParameterExpression[]{v1});
    }

    @Override
    public Expression fieldReference(Expression expression, int field) {
        return this.fieldReference(expression, field, null);
    }

    @Override
    public Expression fieldReference(Expression expression, int field, @Nullable Type storageType) {
        Class fieldType;
        if (storageType == null) {
            storageType = this.fieldClass(field);
            fieldType = null;
        } else {
            fieldType = this.fieldClass(field);
            if (fieldType != Date.class && fieldType != Time.class && fieldType != Timestamp.class) {
                fieldType = null;
            }
        }
        return this.format.field(expression, field, fieldType, storageType);
    }
}

