/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.metadata;

import java.util.List;
import org.apache.calcite.adapter.enumerable.EnumerableInterpreter;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.Union;
import org.apache.calcite.rel.metadata.BuiltInMetadata;
import org.apache.calcite.rel.metadata.ChainedRelMetadataProvider;
import org.apache.calcite.rel.metadata.MetadataDef;
import org.apache.calcite.rel.metadata.MetadataHandler;
import org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.PolyNull;

public class RelMdPercentageOriginalRows {
    public static final RelMetadataProvider SOURCE = ChainedRelMetadataProvider.of((List<RelMetadataProvider>)ImmutableList.of((Object)ReflectiveRelMetadataProvider.reflectiveSource(new RelMdPercentageOriginalRowsHandler(), BuiltInMetadata.PercentageOriginalRows.Handler.class), (Object)ReflectiveRelMetadataProvider.reflectiveSource(new RelMdCumulativeCost(), BuiltInMetadata.CumulativeCost.Handler.class), (Object)ReflectiveRelMetadataProvider.reflectiveSource(new RelMdNonCumulativeCost(), BuiltInMetadata.NonCumulativeCost.Handler.class)));

    private RelMdPercentageOriginalRows() {
    }

    public @Nullable Double getPercentageOriginalRows(Aggregate rel, RelMetadataQuery mq) {
        return mq.getPercentageOriginalRows(rel.getInput());
    }

    public Double getPercentageOriginalRows(Union rel, RelMetadataQuery mq) {
        double numerator = 0.0;
        double denominator = 0.0;
        for (RelNode input : rel.getInputs()) {
            Double percentage;
            Double rowCount = mq.getRowCount(input);
            if (rowCount == null || (percentage = mq.getPercentageOriginalRows(input)) == null || percentage == 0.0) continue;
            denominator += rowCount / percentage;
            numerator += rowCount.doubleValue();
        }
        return RelMdPercentageOriginalRows.quotientForPercentage(numerator, denominator);
    }

    public @Nullable Double getPercentageOriginalRows(Join rel, RelMetadataQuery mq) {
        Double left = mq.getPercentageOriginalRows(rel.getLeft());
        if (left == null) {
            return null;
        }
        Double right = mq.getPercentageOriginalRows(rel.getRight());
        if (right == null) {
            return null;
        }
        return left * right;
    }

    public @Nullable Double getPercentageOriginalRows(RelNode rel, RelMetadataQuery mq) {
        if (rel.getInputs().size() > 1) {
            return null;
        }
        if (rel.getInputs().size() == 0) {
            return 1.0;
        }
        RelNode child = rel.getInputs().get(0);
        Double childPercentage = mq.getPercentageOriginalRows(child);
        if (childPercentage == null) {
            return null;
        }
        Double relPercentage = RelMdPercentageOriginalRows.quotientForPercentage(mq.getRowCount(rel), mq.getRowCount(child));
        if (relPercentage == null) {
            return null;
        }
        double percent = relPercentage * childPercentage;
        if (percent < 0.0 || percent > 1.0) {
            return null;
        }
        return relPercentage * childPercentage;
    }

    public @Nullable RelOptCost getCumulativeCost(RelNode rel, RelMetadataQuery mq) {
        RelOptCost cost = mq.getNonCumulativeCost(rel);
        if (cost == null) {
            return null;
        }
        List<RelNode> inputs = rel.getInputs();
        for (RelNode input : inputs) {
            RelOptCost inputCost = mq.getCumulativeCost(input);
            if (inputCost == null) {
                return null;
            }
            cost = cost.plus(inputCost);
        }
        return cost;
    }

    public @Nullable RelOptCost getCumulativeCost(EnumerableInterpreter rel, RelMetadataQuery mq) {
        return mq.getNonCumulativeCost(rel);
    }

    public @Nullable RelOptCost getNonCumulativeCost(RelNode rel, RelMetadataQuery mq) {
        return rel.computeSelfCost(rel.getCluster().getPlanner(), mq);
    }

    private static @PolyNull Double quotientForPercentage(@PolyNull Double numerator, @PolyNull Double denominator) {
        if (numerator == null || denominator == null) {
            return null;
        }
        if (denominator == 0.0) {
            return 1.0;
        }
        return numerator / denominator;
    }

    private static final class RelMdPercentageOriginalRowsHandler
    extends RelMdPercentageOriginalRows
    implements MetadataHandler<BuiltInMetadata.PercentageOriginalRows> {
        private RelMdPercentageOriginalRowsHandler() {
        }

        @Override
        @Deprecated
        public MetadataDef<BuiltInMetadata.PercentageOriginalRows> getDef() {
            return BuiltInMetadata.PercentageOriginalRows.DEF;
        }
    }

    private static final class RelMdNonCumulativeCost
    extends RelMdPercentageOriginalRows
    implements MetadataHandler<BuiltInMetadata.NonCumulativeCost> {
        private RelMdNonCumulativeCost() {
        }

        @Override
        @Deprecated
        public MetadataDef<BuiltInMetadata.NonCumulativeCost> getDef() {
            return BuiltInMetadata.NonCumulativeCost.DEF;
        }
    }

    private static final class RelMdCumulativeCost
    extends RelMdPercentageOriginalRows
    implements MetadataHandler<BuiltInMetadata.CumulativeCost> {
        private RelMdCumulativeCost() {
        }

        @Override
        @Deprecated
        public MetadataDef<BuiltInMetadata.CumulativeCost> getDef() {
            return BuiltInMetadata.CumulativeCost.DEF;
        }
    }
}

