/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.metadata;

import java.util.List;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.Exchange;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.TableModify;
import org.apache.calcite.rel.core.Union;
import org.apache.calcite.rel.core.Values;
import org.apache.calcite.rel.metadata.BuiltInMetadata;
import org.apache.calcite.rel.metadata.MetadataDef;
import org.apache.calcite.rel.metadata.MetadataHandler;
import org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMdUtil;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.util.ImmutableBitSet;
import org.checkerframework.checker.nullness.qual.Nullable;

public class RelMdPopulationSize
implements MetadataHandler<BuiltInMetadata.PopulationSize> {
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource(new RelMdPopulationSize(), BuiltInMetadata.PopulationSize.Handler.class);

    private RelMdPopulationSize() {
    }

    @Override
    public MetadataDef<BuiltInMetadata.PopulationSize> getDef() {
        return BuiltInMetadata.PopulationSize.DEF;
    }

    public @Nullable Double getPopulationSize(Filter rel, RelMetadataQuery mq, ImmutableBitSet groupKey) {
        return mq.getPopulationSize(rel.getInput(), groupKey);
    }

    public @Nullable Double getPopulationSize(Sort rel, RelMetadataQuery mq, ImmutableBitSet groupKey) {
        return mq.getPopulationSize(rel.getInput(), groupKey);
    }

    public @Nullable Double getPopulationSize(Exchange rel, RelMetadataQuery mq, ImmutableBitSet groupKey) {
        return mq.getPopulationSize(rel.getInput(), groupKey);
    }

    public @Nullable Double getPopulationSize(TableModify rel, RelMetadataQuery mq, ImmutableBitSet groupKey) {
        return mq.getPopulationSize(rel.getInput(), groupKey);
    }

    public @Nullable Double getPopulationSize(Union rel, RelMetadataQuery mq, ImmutableBitSet groupKey) {
        double population = 0.0;
        for (RelNode input : rel.getInputs()) {
            Double subPop = mq.getPopulationSize(input, groupKey);
            if (subPop == null) {
                return null;
            }
            population += subPop.doubleValue();
        }
        return population;
    }

    public @Nullable Double getPopulationSize(Join rel, RelMetadataQuery mq, ImmutableBitSet groupKey) {
        return RelMdUtil.getJoinPopulationSize(mq, rel, groupKey);
    }

    public @Nullable Double getPopulationSize(Aggregate rel, RelMetadataQuery mq, ImmutableBitSet groupKey) {
        ImmutableBitSet.Builder childKey = ImmutableBitSet.builder();
        RelMdUtil.setAggChildKeys(groupKey, rel, childKey);
        return mq.getPopulationSize(rel.getInput(), childKey.build());
    }

    public Double getPopulationSize(Values rel, RelMetadataQuery mq, ImmutableBitSet groupKey) {
        return rel.estimateRowCount(mq) / 2.0;
    }

    public @Nullable Double getPopulationSize(Project rel, RelMetadataQuery mq, ImmutableBitSet groupKey) {
        ImmutableBitSet nonConstCols = RexUtil.getNonConstColumns(groupKey, rel.getProjects());
        if (nonConstCols.cardinality() == 0) {
            return 1.0;
        }
        if (nonConstCols.cardinality() < groupKey.cardinality()) {
            return this.getPopulationSize(rel, mq, nonConstCols);
        }
        ImmutableBitSet.Builder baseCols = ImmutableBitSet.builder();
        ImmutableBitSet.Builder projCols = ImmutableBitSet.builder();
        List<RexNode> projExprs = rel.getProjects();
        RelMdUtil.splitCols(projExprs, groupKey, baseCols, projCols);
        Double population = mq.getPopulationSize(rel.getInput(), baseCols.build());
        if (population == null) {
            return null;
        }
        if (projCols.cardinality() == 0) {
            return population;
        }
        for (int bit : projCols.build()) {
            Double subRowCount = RelMdUtil.cardOfProjExpr(mq, rel, projExprs.get(bit));
            if (subRowCount == null) {
                return null;
            }
            population = population * subRowCount;
        }
        return RelMdUtil.numDistinctVals(population, mq.getRowCount(rel));
    }

    public @Nullable Double getPopulationSize(RelNode rel, RelMetadataQuery mq, ImmutableBitSet groupKey) {
        boolean uniq = RelMdUtil.areColumnsDefinitelyUnique(mq, rel, groupKey);
        if (uniq) {
            return mq.getRowCount(rel);
        }
        return null;
    }
}

