/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.Window;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.logical.LogicalWindow;
import org.apache.calcite.rel.rules.ImmutableProjectWindowTransposeRule;
import org.apache.calcite.rel.rules.ProjectRemoveRule;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.BitSets;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;
import org.immutables.value.Value;

@Value.Enclosing
public class ProjectWindowTransposeRule
extends RelRule<Config>
implements TransformationRule {
    protected ProjectWindowTransposeRule(Config config) {
        super(config);
    }

    @Deprecated
    public ProjectWindowTransposeRule(RelBuilderFactory relBuilderFactory) {
        this(Config.DEFAULT.withRelBuilderFactory(relBuilderFactory).as(Config.class));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Project project = (Project)call.rel(0);
        Window window = (Window)call.rel(1);
        RelOptCluster cluster = window.getCluster();
        List<RelDataTypeField> rowTypeWindowInput = window.getInput().getRowType().getFieldList();
        final int windowInputColumn = rowTypeWindowInput.size();
        final ImmutableBitSet beReferred = ProjectWindowTransposeRule.findReference(project, window);
        if (beReferred.cardinality() == windowInputColumn) {
            return;
        }
        ArrayList<RexInputRef> exps = new ArrayList<RexInputRef>();
        RelDataTypeFactory.FieldInfoBuilder builder = cluster.getTypeFactory().builder();
        for (int index : BitSets.toIter(beReferred)) {
            RelDataTypeField relDataTypeField = rowTypeWindowInput.get(index);
            exps.add(new RexInputRef(index, relDataTypeField.getType()));
            ((RelDataTypeFactory.Builder)builder).add(relDataTypeField);
        }
        LogicalProject projectBelowWindow = new LogicalProject(cluster, window.getTraitSet(), (List<RelHint>)ImmutableList.of(), window.getInput(), exps, builder.build());
        ArrayList<Window.Group> groups = new ArrayList<Window.Group>();
        RexShuttle indexAdjustment = new RexShuttle(){

            @Override
            public RexNode visitInputRef(RexInputRef inputRef) {
                int newIndex = ProjectWindowTransposeRule.getAdjustedIndex(inputRef.getIndex(), beReferred, windowInputColumn);
                return new RexInputRef(newIndex, inputRef.getType());
            }

            @Override
            public RexNode visitCall(RexCall call) {
                if (call instanceof Window.RexWinAggCall) {
                    Window.RexWinAggCall aggCall = (Window.RexWinAggCall)call;
                    boolean[] update = new boolean[]{false};
                    List<RexNode> clonedOperands = this.visitList((List<? extends RexNode>)call.operands, update);
                    if (update[0]) {
                        return new Window.RexWinAggCall((SqlAggFunction)call.getOperator(), call.getType(), clonedOperands, aggCall.ordinal, aggCall.distinct, aggCall.ignoreNulls);
                    }
                    return call;
                }
                return super.visitCall(call);
            }
        };
        int aggCallIndex = windowInputColumn;
        RelDataTypeFactory.FieldInfoBuilder outputBuilder = cluster.getTypeFactory().builder();
        ((RelDataTypeFactory.Builder)outputBuilder).addAll(projectBelowWindow.getRowType().getFieldList());
        for (Window.Group group : window.groups) {
            ImmutableBitSet.Builder keys = ImmutableBitSet.builder();
            ArrayList<RelFieldCollation> orderKeys = new ArrayList<RelFieldCollation>();
            ArrayList<Window.RexWinAggCall> aggCalls = new ArrayList<Window.RexWinAggCall>();
            Iterator<Object> iterator = group.keys.iterator();
            while (iterator.hasNext()) {
                int index = iterator.next();
                keys.set(ProjectWindowTransposeRule.getAdjustedIndex(index, beReferred, windowInputColumn));
            }
            for (RelFieldCollation relFieldCollation : group.orderKeys.getFieldCollations()) {
                int index = relFieldCollation.getFieldIndex();
                orderKeys.add(relFieldCollation.withFieldIndex(ProjectWindowTransposeRule.getAdjustedIndex(index, beReferred, windowInputColumn)));
            }
            for (Window.RexWinAggCall rexWinAggCall : group.aggCalls) {
                aggCalls.add((Window.RexWinAggCall)rexWinAggCall.accept(indexAdjustment));
                RelDataTypeField relDataTypeField = window.getRowType().getFieldList().get(aggCallIndex);
                ((RelDataTypeFactory.Builder)outputBuilder).add(relDataTypeField);
                ++aggCallIndex;
            }
            groups.add(new Window.Group(keys.build(), group.isRows, group.lowerBound, group.upperBound, RelCollations.of(orderKeys), aggCalls));
        }
        LogicalWindow newLogicalWindow = LogicalWindow.create(window.getTraitSet(), projectBelowWindow, window.constants, outputBuilder.build(), groups);
        List<RexNode> topProjExps = indexAdjustment.visitList(project.getProjects());
        Project newTopProj = project.copy(newLogicalWindow.getTraitSet(), newLogicalWindow, topProjExps, project.getRowType());
        if (ProjectRemoveRule.isTrivial(newTopProj)) {
            call.transformTo(newLogicalWindow);
        } else {
            call.transformTo(newTopProj);
        }
    }

    private static ImmutableBitSet findReference(Project project, Window window) {
        final int windowInputColumn = window.getInput().getRowType().getFieldCount();
        final ImmutableBitSet.Builder beReferred = ImmutableBitSet.builder();
        RexShuttle referenceFinder = new RexShuttle(){

            @Override
            public RexNode visitInputRef(RexInputRef inputRef) {
                int index = inputRef.getIndex();
                if (index < windowInputColumn) {
                    beReferred.set(index);
                }
                return inputRef;
            }
        };
        referenceFinder.visitEach(project.getProjects());
        for (Window.Group group : window.groups) {
            Iterator<Object> iterator = group.keys.iterator();
            while (iterator.hasNext()) {
                int index = iterator.next();
                if (index >= windowInputColumn) continue;
                beReferred.set(index);
            }
            for (RelFieldCollation relFieldCollation : group.orderKeys.getFieldCollations()) {
                if (relFieldCollation.getFieldIndex() >= windowInputColumn) continue;
                beReferred.set(relFieldCollation.getFieldIndex());
            }
            referenceFinder.visitEach((Iterable<? extends RexNode>)group.aggCalls);
        }
        return beReferred.build();
    }

    private static int getAdjustedIndex(int initIndex, ImmutableBitSet beReferred, int windowInputColumn) {
        if (initIndex >= windowInputColumn) {
            return beReferred.cardinality() + (initIndex - windowInputColumn);
        }
        return beReferred.get(0, initIndex).cardinality();
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableProjectWindowTransposeRule.Config.of().withOperandFor(LogicalProject.class, LogicalWindow.class);

        @Override
        default public ProjectWindowTransposeRule toRule() {
            return new ProjectWindowTransposeRule(this);
        }

        default public Config withOperandFor(Class<? extends Project> projectClass, Class<? extends Window> windowClass) {
            return this.withOperandSupplier(b0 -> b0.operand(projectClass).oneInput(b1 -> b1.operand(windowClass).anyInputs())).as(Config.class);
        }
    }
}

