/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.metrics.service;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.Singletons;
import org.apache.kylin.common.metrics.service.InfluxDBInstance;
import org.apache.kylin.common.metrics.service.JobStatusMonitorMetric;
import org.apache.kylin.common.metrics.service.MonitorMetric;
import org.apache.kylin.common.metrics.service.QueryMonitorMetric;
import org.apache.kylin.guava30.shaded.common.annotations.VisibleForTesting;
import org.apache.kylin.shaded.influxdb.org.influxdb.dto.QueryResult;
import org.apache.kylin.shaded.influxdb.org.influxdb.impl.InfluxDBResultMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorDao {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MonitorDao.class);
    private final InfluxDBInstance influxDBInstance;
    public static final String QUERY_METRICS_BY_TIME_SQL_FORMAT = "SELECT * FROM %s WHERE create_time >= %d AND create_time < %d";

    private MonitorDao() {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        String database = MonitorDao.generateDatabase(kylinConfig);
        String rp = MonitorDao.generateRetentionPolicy(kylinConfig);
        String retentionDuration = KapConfig.wrap((KylinConfig)kylinConfig).getMonitorRetentionDuration();
        String shardDuration = KapConfig.wrap((KylinConfig)kylinConfig).getMonitorShardDuration();
        Integer replicationFactor = KapConfig.wrap((KylinConfig)kylinConfig).getMonitorReplicationFactor();
        boolean useDefault = KapConfig.wrap((KylinConfig)kylinConfig).isMonitorUserDefault();
        this.influxDBInstance = new InfluxDBInstance(database, rp, retentionDuration, shardDuration, replicationFactor, useDefault);
    }

    @VisibleForTesting
    public MonitorDao(InfluxDBInstance influxDBInstance) {
        this.influxDBInstance = influxDBInstance;
    }

    public static MonitorDao getInstance() {
        return (MonitorDao)Singletons.getInstance(MonitorDao.class, monitorDaoClass -> {
            MonitorDao dao = new MonitorDao();
            dao.influxDBInstance.init();
            return dao;
        });
    }

    public static String generateDatabase(KylinConfig kylinConfig) {
        return kylinConfig.getMetadataUrlPrefix() + "_" + KapConfig.wrap((KylinConfig)kylinConfig).getMonitorDatabase();
    }

    public static String generateRetentionPolicy(KylinConfig kylinConfig) {
        return kylinConfig.getMetadataUrlPrefix() + "_" + KapConfig.wrap((KylinConfig)kylinConfig).getMonitorRetentionPolicy();
    }

    public InfluxDBWriteRequest convert2InfluxDBWriteRequest(MonitorMetric monitorMetric) {
        return new InfluxDBWriteRequest(this.influxDBInstance.getDatabase(), monitorMetric.getTable(), monitorMetric.getTags(), monitorMetric.getFields(), monitorMetric.getCreateTime());
    }

    public boolean write2InfluxDB(InfluxDBWriteRequest writeRequest) {
        return this.influxDBInstance.write(writeRequest.getMeasurement(), writeRequest.getTags(), writeRequest.getFields(), writeRequest.getTimeStamp());
    }

    public List<QueryMonitorMetric> readQueryMonitorMetricFromInfluxDB(Long startTime, Long endTime) {
        QueryResult queryResult = this.readFromInfluxDBByTime(new InfluxDBReadRequest(this.influxDBInstance.getDatabase(), "tb_query", startTime, endTime));
        InfluxDBResultMapper resultMapper = new InfluxDBResultMapper();
        return resultMapper.toPOJO(queryResult, QueryMonitorMetric.class, "tb_query");
    }

    public List<JobStatusMonitorMetric> readJobStatusMonitorMetricFromInfluxDB(Long startTime, Long endTime) {
        QueryResult queryResult = this.readFromInfluxDBByTime(new InfluxDBReadRequest(this.influxDBInstance.getDatabase(), "tb_job_status", startTime, endTime));
        InfluxDBResultMapper resultMapper = new InfluxDBResultMapper();
        return resultMapper.toPOJO(queryResult, JobStatusMonitorMetric.class, "tb_job_status");
    }

    private QueryResult readFromInfluxDBByTime(InfluxDBReadRequest readRequest) {
        String influxDBSql = String.format(Locale.ROOT, QUERY_METRICS_BY_TIME_SQL_FORMAT, readRequest.getMeasurement(), readRequest.getStartTime(), readRequest.getEndTime());
        return this.influxDBInstance.read(influxDBSql);
    }

    public class InfluxDBReadRequest {
        private String database;
        private String measurement;
        private Long startTime;
        private Long endTime;

        @Generated
        public String getDatabase() {
            return this.database;
        }

        @Generated
        public String getMeasurement() {
            return this.measurement;
        }

        @Generated
        public Long getStartTime() {
            return this.startTime;
        }

        @Generated
        public Long getEndTime() {
            return this.endTime;
        }

        @Generated
        public void setDatabase(String database) {
            this.database = database;
        }

        @Generated
        public void setMeasurement(String measurement) {
            this.measurement = measurement;
        }

        @Generated
        public void setStartTime(Long startTime) {
            this.startTime = startTime;
        }

        @Generated
        public void setEndTime(Long endTime) {
            this.endTime = endTime;
        }

        @Generated
        public InfluxDBReadRequest(String database, String measurement, Long startTime, Long endTime) {
            this.database = database;
            this.measurement = measurement;
            this.startTime = startTime;
            this.endTime = endTime;
        }
    }

    public class InfluxDBWriteRequest {
        private String database;
        private String measurement;
        private Map<String, String> tags;
        private Map<String, Object> fields;
        private Long timeStamp;

        @Generated
        public String getDatabase() {
            return this.database;
        }

        @Generated
        public String getMeasurement() {
            return this.measurement;
        }

        @Generated
        public Map<String, String> getTags() {
            return this.tags;
        }

        @Generated
        public Map<String, Object> getFields() {
            return this.fields;
        }

        @Generated
        public Long getTimeStamp() {
            return this.timeStamp;
        }

        @Generated
        public void setDatabase(String database) {
            this.database = database;
        }

        @Generated
        public void setMeasurement(String measurement) {
            this.measurement = measurement;
        }

        @Generated
        public void setTags(Map<String, String> tags) {
            this.tags = tags;
        }

        @Generated
        public void setFields(Map<String, Object> fields) {
            this.fields = fields;
        }

        @Generated
        public void setTimeStamp(Long timeStamp) {
            this.timeStamp = timeStamp;
        }

        @Generated
        public InfluxDBWriteRequest(String database, String measurement, Map<String, String> tags, Map<String, Object> fields, Long timeStamp) {
            this.database = database;
            this.measurement = measurement;
            this.tags = tags;
            this.fields = fields;
            this.timeStamp = timeStamp;
        }
    }
}

