/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.substrait.expression;

import com.google.protobuf.ByteString;
import io.substrait.proto.Expression;
import java.math.BigDecimal;
import org.apache.gluten.substrait.expression.ExpressionBuilder;
import org.apache.gluten.substrait.expression.LiteralNodeWithValue;
import org.apache.gluten.substrait.type.TypeBuilder;
import org.apache.gluten.substrait.type.TypeNode;
import org.apache.spark.sql.types.Decimal;

public class DecimalLiteralNode
extends LiteralNodeWithValue<Decimal> {
    private final ByteString valueBytes;
    private static final long[] POWER_OF_10 = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L};
    private static final byte zero = 0;
    private static final byte minus_one = -1;

    public DecimalLiteralNode(Decimal value, TypeNode typeNode) {
        super(value, typeNode);
        ExpressionBuilder.checkDecimalScale(value.scale());
        this.valueBytes = ByteString.copyFrom((byte[])DecimalLiteralNode.encodeDecimalIntoBytes(value.toJavaBigDecimal(), value.scale(), 16));
    }

    public DecimalLiteralNode(Decimal value) {
        this(value, TypeBuilder.makeDecimal(true, value.precision(), value.scale()));
    }

    private static BigDecimal powerOfTen(int scale) {
        if (scale < POWER_OF_10.length) {
            return new BigDecimal(POWER_OF_10[scale]);
        }
        int length = POWER_OF_10.length;
        BigDecimal bd = new BigDecimal(POWER_OF_10[length - 1]);
        for (int i = length - 1; i < scale; ++i) {
            bd = bd.multiply(new BigDecimal(10));
        }
        return bd;
    }

    @Override
    protected void updateLiteralBuilder(Expression.Literal.Builder literalBuilder, Decimal value) {
        Expression.Literal.Decimal.Builder decimalBuilder = Expression.Literal.Decimal.newBuilder();
        decimalBuilder.setPrecision(value.precision());
        decimalBuilder.setScale(value.scale());
        decimalBuilder.setValue(this.valueBytes);
        literalBuilder.setDecimal(decimalBuilder.build());
    }

    public static byte[] encodeDecimalIntoBytes(BigDecimal decimal, int scale, int byteWidth) {
        BigDecimal scaledDecimal = decimal.multiply(DecimalLiteralNode.powerOfTen(scale));
        byte[] bytes = scaledDecimal.toBigInteger().toByteArray();
        if (bytes.length > byteWidth) {
            throw new UnsupportedOperationException("Decimal size greater than " + byteWidth + " bytes: " + bytes.length);
        }
        byte[] encodedBytes = new byte[byteWidth];
        int padByte = bytes[0] < 0 ? -1 : 0;
        byte[] bytesLE = new byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            bytesLE[i] = bytes[bytes.length - 1 - i];
        }
        int destIndex = 0;
        for (int i = 0; i < bytes.length; ++i) {
            encodedBytes[destIndex++] = bytesLE[i];
        }
        for (int j = bytes.length; j < byteWidth; ++j) {
            encodedBytes[destIndex++] = padByte;
        }
        return encodedBytes;
    }
}

