/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.substrait.rel;

import io.substrait.proto.ProjectRel;
import io.substrait.proto.Rel;
import io.substrait.proto.RelCommon;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.gluten.substrait.expression.ExpressionNode;
import org.apache.gluten.substrait.extensions.AdvancedExtensionNode;
import org.apache.gluten.substrait.rel.RelNode;

public class ProjectRelNode
implements RelNode,
Serializable {
    private final RelNode input;
    private final List<ExpressionNode> expressionNodes = new ArrayList<ExpressionNode>();
    private final AdvancedExtensionNode extensionNode;
    private final int emitStartIndex;

    ProjectRelNode(RelNode input, List<ExpressionNode> expressionNodes, int emitStartIndex) {
        this.input = input;
        this.expressionNodes.addAll(expressionNodes);
        this.extensionNode = null;
        this.emitStartIndex = emitStartIndex;
    }

    ProjectRelNode(RelNode input, List<ExpressionNode> expressionNodes, AdvancedExtensionNode extensionNode, int emitStartIndex) {
        this.input = input;
        this.expressionNodes.addAll(expressionNodes);
        this.extensionNode = extensionNode;
        this.emitStartIndex = emitStartIndex;
    }

    @Override
    public Rel toProtobuf() {
        RelCommon.Builder relCommonBuilder = RelCommon.newBuilder();
        if (this.emitStartIndex < 0) {
            relCommonBuilder.setDirect(RelCommon.Direct.newBuilder());
        } else {
            RelCommon.Emit.Builder emitBuilder = RelCommon.Emit.newBuilder();
            for (int i = 0; i < this.expressionNodes.size(); ++i) {
                emitBuilder.addOutputMapping(i + this.emitStartIndex);
            }
            relCommonBuilder.setEmit(emitBuilder.build());
        }
        ProjectRel.Builder projectBuilder = ProjectRel.newBuilder();
        projectBuilder.setCommon(relCommonBuilder.build());
        if (this.input != null) {
            projectBuilder.setInput(this.input.toProtobuf());
        }
        for (ExpressionNode expressionNode : this.expressionNodes) {
            projectBuilder.addExpressions(expressionNode.toProtobuf());
        }
        if (this.extensionNode != null) {
            projectBuilder.setAdvancedExtension(this.extensionNode.toProtobuf());
        }
        Rel.Builder builder = Rel.newBuilder();
        builder.setProject(projectBuilder.build());
        return builder.build();
    }
}

