/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.substrait.rel;

import io.substrait.proto.NamedObjectWrite;
import io.substrait.proto.NamedStruct;
import io.substrait.proto.Rel;
import io.substrait.proto.WriteRel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.gluten.substrait.extensions.AdvancedExtensionNode;
import org.apache.gluten.substrait.rel.RelNode;
import org.apache.gluten.substrait.type.ColumnTypeNode;
import org.apache.gluten.substrait.type.TypeNode;
import org.apache.gluten.utils.SubstraitUtil;

public class WriteRelNode
implements RelNode,
Serializable {
    private final RelNode input;
    private final List<TypeNode> types = new ArrayList<TypeNode>();
    private final List<String> names = new ArrayList<String>();
    private final List<ColumnTypeNode> columnTypeNodes = new ArrayList<ColumnTypeNode>();
    private final AdvancedExtensionNode extensionNode;
    private final WriteRel.BucketSpec bucketSpec;

    WriteRelNode(RelNode input, List<TypeNode> types, List<String> names, List<ColumnTypeNode> partitionColumnTypeNodes, AdvancedExtensionNode extensionNode, WriteRel.BucketSpec bucketSpec) {
        this.input = input;
        this.types.addAll(types);
        this.names.addAll(names);
        this.columnTypeNodes.addAll(partitionColumnTypeNodes);
        this.extensionNode = extensionNode;
        this.bucketSpec = bucketSpec;
    }

    @Override
    public Rel toProtobuf() {
        WriteRel.Builder writeBuilder = WriteRel.newBuilder();
        NamedStruct.Builder nStructBuilder = SubstraitUtil.createNameStructBuilder(this.types, this.names, this.columnTypeNodes);
        writeBuilder.setTableSchema(nStructBuilder);
        NamedObjectWrite.Builder nameObjectWriter = NamedObjectWrite.newBuilder();
        if (this.extensionNode != null) {
            nameObjectWriter.setAdvancedExtension(this.extensionNode.toProtobuf());
        }
        if (this.bucketSpec != null) {
            writeBuilder.setBucketSpec(this.bucketSpec);
        }
        writeBuilder.setNamedTable(nameObjectWriter);
        if (this.input != null) {
            writeBuilder.setInput(this.input.toProtobuf());
        }
        Rel.Builder builder = Rel.newBuilder();
        builder.setWrite(writeBuilder.build());
        return builder.build();
    }
}

