/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.routing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexSimplify;
import org.apache.calcite.rex.RexUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.KylinRuntimeException;
import org.apache.kylin.common.exception.KylinTimeoutException;
import org.apache.kylin.common.util.DateFormat;
import org.apache.kylin.guava30.shaded.common.collect.BiMap;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.metadata.cube.cuboid.NLayoutCandidate;
import org.apache.kylin.metadata.cube.model.DimensionRangeInfo;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.ISegment;
import org.apache.kylin.metadata.model.ParameterDesc;
import org.apache.kylin.metadata.model.PartitionDesc;
import org.apache.kylin.metadata.model.Segments;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.realization.CapabilityResult;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.metadata.realization.IRealizationCandidate;
import org.apache.kylin.query.exception.UserStopQueryException;
import org.apache.kylin.query.relnode.OlapContext;
import org.apache.kylin.query.routing.Candidate;
import org.apache.kylin.query.routing.PruningRule;
import org.apache.kylin.query.util.QueryInterruptChecker;
import org.apache.kylin.query.util.RexUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentPruningRule
extends PruningRule {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SegmentPruningRule.class);

    @Override
    public void apply(Candidate candidate) {
        if (!this.isStorageMatch(candidate)) {
            return;
        }
        List realizations = candidate.getRealization().getRealizations();
        for (IRealization realization : realizations) {
            NDataflow df = (NDataflow)realization;
            Segments<NDataSegment> prunedSegments = this.pruneSegments(df, candidate.getCtx());
            candidate.setPrunedSegments(prunedSegments, df);
        }
        if (CollectionUtils.isEmpty((Collection)candidate.getQueryableSeg().getBatchSegments()) && CollectionUtils.isEmpty((Collection)candidate.getQueryableSeg().getStreamingSegments())) {
            log.info("{}({}/{}): there is no queryable segments to answer this query.", new Object[]{this.getClass().getName(), candidate.getRealization().getProject(), candidate.getRealization().getCanonicalName()});
            CapabilityResult capability = new CapabilityResult();
            capability.setCapable(true);
            capability.setSelectedCandidate((IRealizationCandidate)NLayoutCandidate.ofEmptyCandidate());
            capability.setSelectedStreamCandidate((IRealizationCandidate)NLayoutCandidate.ofEmptyCandidate());
            candidate.setCapability(capability);
        }
    }

    @Override
    public boolean isStorageMatch(Candidate candidate) {
        return candidate.getRealization().getModel().getStorageType().isV1Storage();
    }

    public Segments<NDataSegment> pruneSegments(NDataflow dataflow, OlapContext olapContext) {
        Segments allReadySegments = dataflow.getQueryableSegments();
        KylinConfig projectConfig = NProjectManager.getProjectConfig((String)dataflow.getProject());
        if (!projectConfig.isHeterogeneousSegmentEnabled()) {
            return allReadySegments;
        }
        PartitionDesc partitionCol = this.getPartitionDesc(dataflow, olapContext);
        if (this.isFullBuildModel(partitionCol)) {
            log.info("No partition column or partition column format is null.");
            return allReadySegments;
        }
        RelOptCluster relOptCluster = olapContext.getFirstTableScan().getCluster();
        RexSimplify rexSimplify = new RexSimplify(relOptCluster.getRexBuilder(), RelOptPredicateList.EMPTY, true, relOptCluster.getPlanner().getExecutor());
        RexNode simplifiedFilter = rexSimplify.simplifyAnds(olapContext.getExpandedFilterConditions());
        if (simplifiedFilter.isAlwaysFalse()) {
            log.info("SQL filter condition is always false, pruning all ready segments");
            olapContext.getStorageContext().setFilterCondAlwaysFalse(true);
            return Segments.empty();
        }
        TblColRef partition = partitionCol.getPartitionDateColumnRef();
        if (this.canPruneSegmentsForMaxMeasure(dataflow, olapContext, partition)) {
            return this.selectSegmentsForMaxMeasure(dataflow);
        }
        if (simplifiedFilter.isAlwaysTrue()) {
            log.info("SQL filter condition is always true, pruning no segment");
            return allReadySegments;
        }
        ArrayList dimColRefs = Lists.newArrayList();
        if (projectConfig.isQueryDimensionRangeFilterEnabled()) {
            BiMap effectiveDims = dataflow.getIndexPlan().getEffectiveDimCols();
            List collect = olapContext.getFilterColumns().stream().filter(tblColRef -> !tblColRef.equals((Object)partition) && effectiveDims.containsValue(tblColRef)).collect(Collectors.toList());
            dimColRefs.addAll(collect);
        }
        return this.prune(dataflow, olapContext, rexSimplify, partition, dimColRefs, simplifiedFilter);
    }

    private Segments<NDataSegment> prune(NDataflow dataflow, OlapContext olapContext, RexSimplify rexSimplify, TblColRef partitionColRef, List<TblColRef> dimTblColRefs, RexNode simplifiedFilter) {
        if (CollectionUtils.isEmpty(olapContext.getExpandedFilterConditions()) || CollectionUtils.isEmpty(olapContext.getFilterColumns())) {
            log.info("There is no filter for pruning segments.");
            return dataflow.getQueryableSegments();
        }
        if (RelOptUtil.conjunctions((RexNode)RexUtil.toCnf((RexBuilder)rexSimplify.rexBuilder, (int)100, (RexNode)simplifiedFilter)).size() > dataflow.getConfig().getMaxFilterConditionCnt()) {
            return dataflow.getQueryableSegments();
        }
        Segments selectedSegments = new Segments();
        RexInputRef partitionColInputRef = olapContext.getFilterColumns().contains(partitionColRef) ? RexUtils.transformColumn2RexInputRef(partitionColRef, olapContext.getAllTableScans()) : null;
        String partitionDateFormat = this.getPartitionDesc(dataflow, olapContext).getPartitionDateFormat();
        Map<TblColRef, RexInputRef> dimTblInputRefMap = dimTblColRefs.stream().collect(Collectors.toMap(tcr -> tcr, tcr -> RexUtils.transformColumn2RexInputRef(tcr, olapContext.getAllTableScans())));
        for (NDataSegment segment : dataflow.getQueryableSegments()) {
            try {
                QueryInterruptChecker.checkQueryCanceledOrThreadInterrupted((String)"Interrupted during pruning segments by filter!", (String)"pruning segments by filter");
                ArrayList allPredicates = Lists.newArrayList();
                allPredicates.addAll(this.collectPartitionPredicates(rexSimplify.rexBuilder, segment, partitionColInputRef, partitionDateFormat, partitionColRef.getType()));
                allPredicates.addAll(this.collectDimensionPredicates(rexSimplify.rexBuilder, segment, dimTblInputRefMap));
                RelOptPredicateList predicateList = RelOptPredicateList.of((RexBuilder)rexSimplify.rexBuilder, (Iterable)allPredicates);
                RexNode simplifiedWithPredicates = rexSimplify.withPredicates(predicateList).simplify(simplifiedFilter);
                if (simplifiedWithPredicates.isAlwaysFalse()) continue;
                selectedSegments.add((Object)segment);
            }
            catch (InterruptedException ie) {
                log.error(String.format(Locale.ROOT, "Interrupted on pruning segments from %s!", segment.toString()), (Throwable)ie);
                Thread.currentThread().interrupt();
                throw new KylinRuntimeException((Throwable)ie);
            }
            catch (KylinTimeoutException | UserStopQueryException e) {
                log.error(String.format(Locale.ROOT, "Stop pruning segments from %s!", segment.toString()), e);
                throw e;
            }
            catch (Exception ex) {
                log.warn(String.format(Locale.ROOT, "To skip the exception on pruning segment %s!", segment.toString()), (Throwable)ex);
                selectedSegments.add((Object)segment);
            }
        }
        log.info("Scan segments {}/{} after time partition and dimension range pruning by[{}]", new Object[]{selectedSegments.size(), dataflow.getQueryableSegments().size(), simplifiedFilter});
        return selectedSegments;
    }

    private Segments<NDataSegment> selectSegmentsForMaxMeasure(NDataflow dataflow) {
        Segments selectedSegments = new Segments();
        long days = dataflow.getConfig().getMaxMeasureSegmentPrunerBeforeDays();
        Segments allReadySegments = dataflow.getQueryableSegments();
        long maxDt = ((NDataSegment)allReadySegments.getLatestReadySegment()).getTSRange().getEnd();
        long minDt = maxDt - 86400000L * days;
        for (int i = allReadySegments.size() - 1; i >= 0 && ((NDataSegment)allReadySegments.get(i)).getTSRange().getEnd() > minDt; --i) {
            selectedSegments.add(allReadySegments.get(i));
        }
        log.info("Scan segment size: {} after max measure segment pruner. The before days: {}. Passed on segment: {}", new Object[]{selectedSegments.size(), days, selectedSegments.stream().map(ISegment::getName).collect(Collectors.joining(","))});
        return selectedSegments;
    }

    private boolean canPruneSegmentsForMaxMeasure(NDataflow dataflow, OlapContext olapContext, TblColRef partitionColRef) {
        if (dataflow.getConfig().getMaxMeasureSegmentPrunerBeforeDays() < 0L) {
            return false;
        }
        if (CollectionUtils.isNotEmpty(olapContext.getGroupByColumns())) {
            if (!olapContext.getGroupByColumns().stream().allMatch(arg_0 -> ((TblColRef)partitionColRef).equals(arg_0))) {
                return false;
            }
        }
        if (CollectionUtils.isEmpty(olapContext.getAggregations())) {
            return false;
        }
        for (FunctionDesc agg : olapContext.getAggregations()) {
            if ("MAX".equalsIgnoreCase(agg.getExpression()) && !partitionColRef.equals((Object)((ParameterDesc)agg.getParameters().get(0)).getColRef())) {
                return false;
            }
            if ("MAX".equalsIgnoreCase(agg.getExpression()) || !CollectionUtils.isNotEmpty((Collection)agg.getParameters())) continue;
            return false;
        }
        return true;
    }

    private List<RexNode> collectDimensionPredicates(RexBuilder rexBuilder, NDataSegment dataSegment, Map<TblColRef, RexInputRef> dimTblInputRefMap) {
        Map dimRangeInfoMap = dataSegment.getDimensionRangeInfoMap();
        if (dimRangeInfoMap.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList allPredicts = Lists.newArrayList();
        BiMap inverse = dataSegment.getDataflow().getIndexPlan().getEffectiveDimCols().inverse();
        dimTblInputRefMap.forEach((tblColRef, inputRef) -> {
            int index = (Integer)inverse.get(tblColRef);
            DimensionRangeInfo dimRangeInfo = (DimensionRangeInfo)dimRangeInfoMap.get(String.valueOf(index));
            if (Objects.isNull(dimRangeInfo)) {
                log.warn("There is no values for the column[{}] in this segment.", (Object)tblColRef.getName());
                return;
            }
            List<RexNode> rexNodes = this.transformValue2RexCall(rexBuilder, (RexInputRef)inputRef, tblColRef.getType(), dimRangeInfo.getMin(), dimRangeInfo.getMax(), true);
            allPredicts.addAll(rexNodes);
        });
        return allPredicts;
    }

    private List<RexNode> collectPartitionPredicates(RexBuilder rexBuilder, NDataSegment segment, RexInputRef partitionColInputRef, String dateFormat, DataType partitionColType) {
        String end;
        String start;
        if (partitionColInputRef == null) {
            return Collections.emptyList();
        }
        ArrayList allPredicts = Lists.newArrayList();
        if (segment.isOffsetCube()) {
            start = DateFormat.formatToDateStr((long)segment.getKSRange().getStart(), (String)dateFormat);
            end = DateFormat.formatToDateStr((long)segment.getKSRange().getEnd(), (String)dateFormat);
        } else {
            long segmentStartTs = segment.getTSRange().getStart();
            long segmentEndTs = segment.getTSRange().getEnd();
            String formattedStart = DateFormat.formatToDateStr((long)segmentStartTs, (String)dateFormat);
            String formattedEnd = DateFormat.formatToDateStr((long)segmentEndTs, (String)dateFormat);
            start = SegmentPruningRule.checkAndReformatDateType(formattedStart, segmentStartTs, partitionColType);
            end = SegmentPruningRule.checkAndReformatDateType(formattedEnd, segmentEndTs, partitionColType);
        }
        List<RexNode> rexNodes = this.transformValue2RexCall(rexBuilder, partitionColInputRef, partitionColType, start, end, segment.getDataflow().isStreaming());
        allPredicts.addAll(rexNodes);
        return allPredicts;
    }
}

