/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.routing;

import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.metadata.cube.cuboid.AggIndexMatcher;
import org.apache.kylin.metadata.cube.cuboid.ChooserContext;
import org.apache.kylin.metadata.cube.cuboid.IndexMatcher;
import org.apache.kylin.metadata.cube.cuboid.NLayoutCandidate;
import org.apache.kylin.metadata.cube.cuboid.TableIndexMatcher;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.model.AntiFlatChecker;
import org.apache.kylin.metadata.model.ColExcludedChecker;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.realization.CapabilityResult;
import org.apache.kylin.metadata.realization.HybridRealization;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.metadata.realization.IRealizationCandidate;
import org.apache.kylin.metadata.realization.SQLDigest;
import org.apache.kylin.query.routing.Candidate;
import org.apache.kylin.query.routing.PruningRule;
import org.apache.kylin.query.util.QueryInterruptChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VacantIndexPruningRule
extends PruningRule {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VacantIndexPruningRule.class);

    @Override
    public void apply(Candidate candidate) {
        if (!this.isStorageMatch(candidate)) {
            return;
        }
        if (this.nonBatchRealizationSkipEmptySegments(candidate)) {
            log.info("{}({}/{}): only batch model support this feature, but the type of this model is {}", new Object[]{this.getClass().getName(), candidate.getRealization().getProject(), candidate.getRealization().getCanonicalName(), candidate.getRealization().getModel().getModelType()});
            return;
        }
        if (candidate.getCapability() == null || candidate.getCapability().isCapable()) {
            log.debug("skip the rule of {}.", (Object)this.getClass().getName());
            return;
        }
        List realizations = candidate.getRealization().getRealizations();
        if (CollectionUtils.isEmpty((Collection)realizations)) {
            log.warn("It seems that unlikely things happened when matching indexes haven't built. Expected size of realizations(models) is 1.");
            return;
        }
        NDataflow dataflow = (NDataflow)realizations.get(0);
        CapabilityResult capabilityResult = this.match(dataflow, candidate.getCtx().getSQLDigest());
        candidate.setCapability(capabilityResult);
    }

    private CapabilityResult match(NDataflow dataflow, SQLDigest digest) {
        CapabilityResult result = new CapabilityResult();
        log.info("Try matching no built indexes from model.");
        NLayoutCandidate layoutCandidate = this.selectLayoutCandidate(dataflow, digest);
        if (layoutCandidate != null) {
            result.influences.addAll(layoutCandidate.getCapabilityResult().influences);
            result.setLayoutUnmatchedColsSize(layoutCandidate.getCapabilityResult().getLayoutUnmatchedColsSize());
            result.setSelectedCandidate((IRealizationCandidate)layoutCandidate);
            log.info("Matched layout {} snapshot in dataflow {} ", (Object)layoutCandidate, (Object)dataflow);
            result.setCapable(true);
            result.setVacant(true);
        } else {
            result.setCapable(false);
        }
        return result;
    }

    @Override
    public boolean isStorageMatch(Candidate candidate) {
        return true;
    }

    private NLayoutCandidate selectLayoutCandidate(NDataflow dataflow, SQLDigest sqlDigest) {
        String project = dataflow.getProject();
        NDataModel model = dataflow.getModel();
        KylinConfig projectConfig = NProjectManager.getProjectConfig((String)project);
        ChooserContext chooserContext = new ChooserContext(sqlDigest, dataflow);
        ColExcludedChecker excludedChecker = new ColExcludedChecker(projectConfig, project, model);
        AntiFlatChecker antiFlatChecker = new AntiFlatChecker(model.getJoinTables(), model);
        AggIndexMatcher aggIndexMatcher = new AggIndexMatcher(sqlDigest, chooserContext, dataflow, excludedChecker, antiFlatChecker);
        TableIndexMatcher tableIndexMatcher = new TableIndexMatcher(sqlDigest, chooserContext, dataflow, excludedChecker, antiFlatChecker);
        if (chooserContext.isIndexMatchersInvalid()) {
            return null;
        }
        NLayoutCandidate candidate = VacantIndexPruningRule.findCandidate(dataflow, aggIndexMatcher, tableIndexMatcher);
        QueryInterruptChecker.checkThreadInterrupted((String)"Interrupted exception occurs.", (String)"Current step were matching indexes haven't built ");
        return candidate;
    }

    private static NLayoutCandidate findCandidate(NDataflow dataflow, AggIndexMatcher aggIndexMatcher, TableIndexMatcher tableIndexMatcher) {
        List allLayouts = dataflow.getIndexPlan().getAllLayouts();
        for (LayoutEntity layout : allLayouts) {
            NLayoutCandidate candidate = new NLayoutCandidate(layout);
            IndexMatcher.MatchResult matchResult = tableIndexMatcher.match(layout);
            if (!matchResult.isMatched()) {
                matchResult = aggIndexMatcher.match(layout);
            }
            if (!matchResult.isMatched()) continue;
            CapabilityResult tempResult = new CapabilityResult();
            tempResult.setSelectedCandidate((IRealizationCandidate)candidate);
            candidate.setCapabilityResult(tempResult);
            return candidate;
        }
        return null;
    }

    private boolean nonBatchRealizationSkipEmptySegments(Candidate candidate) {
        IRealization realization = candidate.getRealization();
        return realization instanceof HybridRealization || realization.isStreaming();
    }
}

