/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.monitor;

import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import lombok.Generated;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.Singletons;
import org.apache.kylin.common.metrics.MetricsCategory;
import org.apache.kylin.common.metrics.MetricsGroup;
import org.apache.kylin.common.metrics.MetricsName;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparderEnv;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkContextCanary {
    private static final Logger logger = LoggerFactory.getLogger(SparkContextCanary.class);
    private static final int THRESHOLD_TO_RESTART_SPARK = KapConfig.getInstanceFromEnv().getThresholdToRestartSpark();
    private static final int PERIOD_MINUTES = KapConfig.getInstanceFromEnv().getSparkCanaryPeriodMinutes();
    private static final String WORKING_DIR = KapConfig.getInstanceFromEnv().getWriteHdfsWorkingDirectory();
    private static final String CHECK_TYPE = KapConfig.getInstanceFromEnv().getSparkCanaryType();
    private volatile int errorAccumulated = 0;
    private volatile long lastResponseTime = -1L;
    private volatile boolean sparkRestarting = false;

    private SparkContextCanary() {
    }

    public static SparkContextCanary getInstance() {
        return (SparkContextCanary)Singletons.getInstance(SparkContextCanary.class, v -> new SparkContextCanary());
    }

    public void init(ScheduledExecutorService executorService) {
        logger.info("Start monitoring Spark");
        executorService.scheduleWithFixedDelay(this::monitor, PERIOD_MINUTES, PERIOD_MINUTES, TimeUnit.MINUTES);
    }

    public boolean isError() {
        return this.errorAccumulated >= THRESHOLD_TO_RESTART_SPARK;
    }

    void monitor() {
        block11: {
            try {
                long startTime = System.currentTimeMillis();
                if (!SparderEnv.isSparkAvailable()) {
                    logger.info("Spark is unavailable, need to restart immediately.");
                    this.errorAccumulated = Math.max(this.errorAccumulated + 1, THRESHOLD_TO_RESTART_SPARK);
                } else {
                    Future<Boolean> handler = this.check();
                    try {
                        long t = System.currentTimeMillis();
                        handler.get(KapConfig.getInstanceFromEnv().getSparkCanaryErrorResponseMs(), TimeUnit.MILLISECONDS);
                        logger.info("SparkContextCanary checkWriteFile returned successfully, takes {} ms.", (Object)(System.currentTimeMillis() - t));
                        this.errorAccumulated = 0;
                    }
                    catch (TimeoutException te) {
                        ++this.errorAccumulated;
                        handler.cancel(true);
                        logger.error("SparkContextCanary write file timeout.", (Throwable)te);
                    }
                    catch (InterruptedException e) {
                        ++this.errorAccumulated;
                        logger.error("Thread is interrupted.", (Throwable)e);
                        Thread.currentThread().interrupt();
                    }
                    catch (ExecutionException e) {
                        this.errorAccumulated = Math.max(this.errorAccumulated + 1, THRESHOLD_TO_RESTART_SPARK);
                        logger.error("SparkContextCanary numberCount occurs exception, need to restart immediately.", (Throwable)e);
                    }
                    catch (Exception e) {
                        ++this.errorAccumulated;
                        logger.error("SparkContextCanary write file occurs exception.", (Throwable)e);
                    }
                }
                this.lastResponseTime = System.currentTimeMillis() - startTime;
                logger.debug("Spark context errorAccumulated:{}", (Object)this.errorAccumulated);
                if (!this.isError()) break block11;
                this.sparkRestarting = true;
                try {
                    logger.warn("Repairing spark context");
                    SparderEnv.restartSpark();
                    MetricsGroup.hostTagCounterInc((MetricsName)MetricsName.SPARDER_RESTART, (MetricsCategory)MetricsCategory.GLOBAL, (String)"global");
                }
                catch (Throwable th) {
                    logger.error("Restart spark context failed.", th);
                }
                this.sparkRestarting = false;
            }
            catch (Throwable th) {
                logger.error("Error when monitoring Spark.", th);
                Thread.currentThread().interrupt();
            }
        }
    }

    private Future<Boolean> check() {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        return executor.submit(() -> {
            SparkSession ss = SparderEnv.getSparkSession();
            JavaSparkContext jsc = JavaSparkContext.fromSparkContext((SparkContext)SparderEnv.getSparkSession().sparkContext());
            jsc.setLocalProperty("spark.scheduler.pool", "vip_tasks");
            jsc.setJobDescription("Canary check by " + CHECK_TYPE);
            switch (CHECK_TYPE) {
                case "file": {
                    ArrayList<Row> rowList = new ArrayList<Row>();
                    for (int i = 0; i < 100; ++i) {
                        rowList.add(RowFactory.create((Object[])new Object[]{i}));
                    }
                    StructType schema = new StructType(new StructField[]{DataTypes.createStructField((String)"col", (DataType)DataTypes.IntegerType, (boolean)true)});
                    Dataset df = ss.createDataFrame(jsc.parallelize(rowList), schema);
                    String appId = ss.sparkContext().applicationId();
                    df.write().mode(SaveMode.Overwrite).parquet(WORKING_DIR + "/_health/" + appId);
                    break;
                }
                case "count": {
                    ArrayList<Integer> countList = new ArrayList<Integer>();
                    for (int i = 0; i < 100; ++i) {
                        countList.add(i);
                    }
                    jsc.parallelize(countList).count();
                    break;
                }
            }
            jsc.setJobDescription(null);
            return true;
        });
    }

    @Generated
    public int getErrorAccumulated() {
        return this.errorAccumulated;
    }

    @Generated
    public long getLastResponseTime() {
        return this.lastResponseTime;
    }

    @Generated
    public boolean isSparkRestarting() {
        return this.sparkRestarting;
    }
}

