/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.cluster.ClusterManagerFactory;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.metrics.service.JobStatusMonitorMetric;
import org.apache.kylin.common.metrics.service.MonitorDao;
import org.apache.kylin.common.metrics.service.MonitorMetric;
import org.apache.kylin.common.metrics.service.QueryMonitorMetric;
import org.apache.kylin.common.util.ClusterConstant;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.guava30.shaded.common.annotations.VisibleForTesting;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.job.dao.ExecutablePO;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.DefaultExecutable;
import org.apache.kylin.job.execution.ExecutableManager;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.state.QueryShareStateManager;
import org.apache.kylin.rest.cluster.ClusterManager;
import org.apache.kylin.rest.config.initialize.AfterMetadataReadyEvent;
import org.apache.kylin.rest.monitor.AbstractMonitorCollectTask;
import org.apache.kylin.rest.monitor.MonitorReporter;
import org.apache.kylin.rest.monitor.SparkContextCanary;
import org.apache.kylin.rest.request.AlertMessageRequest;
import org.apache.kylin.rest.response.ClusterStatisticStatusResponse;
import org.apache.kylin.rest.response.ClusterStatusResponse;
import org.apache.kylin.rest.response.ProjectConfigResponse;
import org.apache.kylin.rest.response.ServerInfoResponse;
import org.apache.kylin.rest.service.BasicService;
import org.apache.kylin.rest.service.ProjectService;
import org.apache.spark.metrics.SparkPrometheusMetrics;
import org.apache.spark.sql.SparderEnv;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="monitorService")
public class MonitorService
extends BasicService
implements ApplicationListener<AfterMetadataReadyEvent> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MonitorService.class);
    private static final Logger logger = LoggerFactory.getLogger(MonitorService.class);
    @Autowired
    private ProjectService projectService;
    @Autowired
    private ClusterManager clusterManager;

    @VisibleForTesting
    public List<ProjectInstance> getReadableProjects() {
        return ((NProjectManager)this.projectService.getManager(NProjectManager.class)).listAllProjects();
    }

    @VisibleForTesting
    public Set<String> getAllYarnQueues() {
        return this.getReadableProjects().stream().map(ProjectInstance::getName).map(arg_0 -> ((ProjectService)this.projectService).getProjectConfig0(arg_0)).map(ProjectConfigResponse::getYarnQueue).collect(Collectors.toSet());
    }

    public void onApplicationEvent(AfterMetadataReadyEvent event) {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        KapConfig kapConfig = KapConfig.wrap((KylinConfig)kylinConfig);
        boolean monitorEnabled = kapConfig.isMonitorEnabled();
        final MonitorReporter monitorReporter = MonitorReporter.getInstance();
        if (!monitorEnabled) {
            logger.warn("Monitor reporter is not enabled!");
            return;
        }
        try {
            monitorReporter.startReporter();
        }
        catch (Exception e) {
            log.error("Failed to start monitor reporter!", (Throwable)e);
        }
        monitorReporter.submit(new AbstractMonitorCollectTask(Lists.newArrayList((Object[])new String[]{ClusterConstant.ALL, ClusterConstant.QUERY, ClusterConstant.JOB})){

            protected MonitorMetric collect() {
                QueryMonitorMetric queryMonitorMetric = monitorReporter.createQueryMonitorMetric();
                queryMonitorMetric.setLastResponseTime(Long.valueOf(SparkContextCanary.getInstance().getLastResponseTime()));
                queryMonitorMetric.setErrorAccumulated(Integer.valueOf(SparkContextCanary.getInstance().getErrorAccumulated()));
                queryMonitorMetric.setSparkRestarting(Boolean.valueOf(SparkContextCanary.getInstance().isSparkRestarting()));
                return queryMonitorMetric;
            }
        });
        if (!kylinConfig.isJobNode() && !kylinConfig.isDataLoadingNode()) {
            return;
        }
        monitorReporter.submit(new AbstractMonitorCollectTask(Lists.newArrayList((Object[])new String[]{ClusterConstant.ALL, ClusterConstant.JOB})){

            protected MonitorMetric collect() {
                return MonitorService.this.collectJobMetric();
            }
        });
    }

    private JobStatusMonitorMetric collectJobMetric() {
        ArrayList<AbstractExecutable> finishedJobs = new ArrayList<AbstractExecutable>();
        ArrayList<AbstractExecutable> runningJobs = new ArrayList<AbstractExecutable>();
        ArrayList<AbstractExecutable> pendingJobs = new ArrayList<AbstractExecutable>();
        ArrayList<AbstractExecutable> errorJobs = new ArrayList<AbstractExecutable>();
        for (ProjectInstance project : this.getReadableProjects()) {
            ExecutableManager executableManager = (ExecutableManager)this.getManager(ExecutableManager.class, project.getName());
            for (ExecutablePO executablePO : executableManager.getAllJobs()) {
                AbstractExecutable executable = executableManager.fromPO(executablePO);
                if (executable.getStatusInMem().isFinalState()) {
                    finishedJobs.add(executable);
                    continue;
                }
                if (ExecutableState.RUNNING == executable.getStatusInMem()) {
                    runningJobs.add(executable);
                    continue;
                }
                if (ExecutableState.READY == executable.getStatusInMem() || ExecutableState.PAUSED == executable.getStatusInMem() || ExecutableState.PENDING == executable.getStatusInMem()) {
                    pendingJobs.add(executable);
                    continue;
                }
                if (ExecutableState.ERROR != executable.getStatusInMem()) continue;
                errorJobs.add(executable);
            }
        }
        List runningOnYarnJobs = ClusterManagerFactory.create((KylinConfig)this.getConfig()).getRunningJobs(this.getAllYarnQueues());
        long pendingOnYarnJobs = runningJobs.stream().filter(job -> this.pendingOnYarn(Sets.newHashSet((Iterable)runningOnYarnJobs), (AbstractExecutable)job)).count();
        JobStatusMonitorMetric metric = MonitorReporter.getInstance().createJobStatusMonitorMetric();
        metric.setErrorJobs(Long.valueOf(errorJobs.size()));
        metric.setFinishedJobs(Long.valueOf(finishedJobs.size()));
        metric.setPendingJobs(Long.valueOf((long)pendingJobs.size() + pendingOnYarnJobs));
        metric.setRunningJobs(Long.valueOf((long)runningJobs.size() - pendingOnYarnJobs));
        return metric;
    }

    private long floorTime(long time) {
        return MonitorService.floorTime(time, KapConfig.wrap((KylinConfig)this.getConfig()).getMonitorInterval());
    }

    private static long floorTime(long time, long interval) {
        return time - time % interval;
    }

    public ClusterStatusResponse currentClusterStatus() {
        return this.timeClusterStatus(this.floorTime(System.currentTimeMillis()));
    }

    public MonitorDao getMonitorDao() {
        return MonitorDao.getInstance();
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#project, 'ADMINISTRATION') or hasPermission(#project, 'MANAGEMENT') or hasPermission(#project, 'OPERATION')")
    public ClusterStatusResponse timeClusterStatus(long time) {
        List queryServers = this.clusterManager.getQueryServers().stream().map(ServerInfoResponse::getHost).collect(Collectors.toList());
        List jobServers = this.clusterManager.getJobServers().stream().map(ServerInfoResponse::getHost).collect(Collectors.toList());
        long jobInterval = KapConfig.wrap((KylinConfig)this.getConfig()).getJobStatisticInterval();
        long interval = KapConfig.wrap((KylinConfig)this.getConfig()).getMonitorInterval();
        long startTime = time - interval;
        Map jobMetrics = this.transferToMap(this.getMonitorDao().readJobStatusMonitorMetricFromInfluxDB(Long.valueOf(startTime), Long.valueOf(time)));
        long beforeStartTime1 = startTime - jobInterval;
        Map beforeJobMetrics = this.transferToMap(this.getMonitorDao().readJobStatusMonitorMetricFromInfluxDB(Long.valueOf(beforeStartTime1), Long.valueOf(beforeStartTime1 + interval)));
        HashMap jobStatus = Maps.newHashMap();
        jobMetrics.entrySet().forEach(entry -> {
            ClusterStatusResponse.NodeState nodeState = this.calculateNodeState(beforeJobMetrics.getOrDefault(entry.getKey(), null), (JobStatusMonitorMetric)entry.getValue());
            jobStatus.put(((JobStatusMonitorMetric)entry.getValue()).getInstanceName(), nodeState);
            jobStatus.put(((JobStatusMonitorMetric)entry.getValue()).getIpPort(), nodeState);
        });
        Map<String, ClusterStatusResponse.NodeState> jobServerResponse = jobServers.stream().collect(Collectors.toMap(s -> s, s -> jobStatus.getOrDefault(s, ClusterStatusResponse.NodeState.CRASH)));
        Map queryMetrics = this.transferToMap(this.getMonitorDao().readQueryMonitorMetricFromInfluxDB(Long.valueOf(startTime), Long.valueOf(time)));
        HashMap queryStatus = Maps.newHashMap();
        queryMetrics.values().forEach(monitorMetric -> {
            ClusterStatusResponse.NodeState nodeState = this.calculateNodeState((QueryMonitorMetric)monitorMetric);
            queryStatus.put(monitorMetric.getInstanceName(), nodeState);
            queryStatus.put(monitorMetric.getIpPort(), nodeState);
        });
        Map<String, ClusterStatusResponse.NodeState> queryServerResponse = queryServers.stream().collect(Collectors.toMap(s -> s, s -> queryStatus.getOrDefault(s, ClusterStatusResponse.NodeState.CRASH)));
        return this.clusterStatus(jobServerResponse, queryServerResponse);
    }

    public String fetchAndMergeSparkMetrics() {
        if (!SparderEnv.isSparkAvailable()) {
            return "";
        }
        String executorMetricsInfo = "";
        if (KylinConfig.getInstanceFromEnv().isSpark3ExecutorPrometheusEnabled()) {
            executorMetricsInfo = SparkPrometheusMetrics.fetchExecutorMetricsInfo((String)SparderEnv.getSparkSession().sparkContext().applicationId());
        }
        String driverMetricsInfo = "";
        if ("org.apache.spark.metrics.sink.PrometheusServlet".equals(KylinConfig.getInstanceFromEnv().getSpark3DriverPrometheusServletClass()) && "/metrics/prometheus".equals(KylinConfig.getInstanceFromEnv().getSpark3DriverPrometheusServletPath())) {
            driverMetricsInfo = SparkPrometheusMetrics.fetchDriverMetricsInfo((String)SparderEnv.getSparkSession().sparkContext().applicationId());
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)driverMetricsInfo)) {
            stringBuilder.append(driverMetricsInfo).append("\n");
        }
        if (StringUtils.isNotBlank((CharSequence)executorMetricsInfo)) {
            stringBuilder.append(executorMetricsInfo).append("\n");
        }
        return stringBuilder.toString();
    }

    public void handleAlertMessage(AlertMessageRequest request) {
        log.info("handle alert message : {}", (Object)request);
        List relatedQueryLimitAlerts = request.getAlerts().stream().filter(e -> "Spark Utilization Is Too High".equalsIgnoreCase(e.getLabels().getAlertname())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(relatedQueryLimitAlerts)) {
            return;
        }
        List needOpenLimitInstanceList = relatedQueryLimitAlerts.stream().filter(e -> !"resolved".equals(e.getStatus())).map(e -> e.getLabels().getInstance()).distinct().collect(Collectors.toList());
        List needCloseLimitInstanceList = relatedQueryLimitAlerts.stream().filter(e -> "resolved".equals(e.getStatus())).map(e -> e.getLabels().getInstance()).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(needOpenLimitInstanceList)) {
            QueryShareStateManager.getInstance().setState(needOpenLimitInstanceList, "QueryLimit", "true");
        }
        if (CollectionUtils.isNotEmpty(needCloseLimitInstanceList)) {
            QueryShareStateManager.getInstance().setState(needCloseLimitInstanceList, "QueryLimit", "false");
        }
    }

    private ClusterStatusResponse clusterStatus(Map<String, ClusterStatusResponse.NodeState> jobStatus, Map<String, ClusterStatusResponse.NodeState> queryStatus) {
        long goodJobs = jobStatus.values().stream().filter(s -> s == ClusterStatusResponse.NodeState.GOOD).count();
        long crashJobs = jobStatus.values().stream().filter(s -> s == ClusterStatusResponse.NodeState.CRASH).count();
        long goodQueries = queryStatus.values().stream().filter(s -> s == ClusterStatusResponse.NodeState.GOOD).count();
        long crashQueries = queryStatus.values().stream().filter(s -> s == ClusterStatusResponse.NodeState.CRASH).count();
        ClusterStatusResponse response = new ClusterStatusResponse();
        this.setTotalState(goodJobs, crashJobs, jobStatus.size(), arg_0 -> ((ClusterStatusResponse)response).setJobStatus(arg_0));
        this.setTotalState(goodQueries, crashQueries, queryStatus.size(), arg_0 -> ((ClusterStatusResponse)response).setQueryStatus(arg_0));
        response.setActiveInstances(jobStatus.size() + queryStatus.size() - Sets.intersection(jobStatus.keySet(), queryStatus.keySet()).size());
        response.setJob(this.transferToNodeStateResponse(jobStatus));
        response.setQuery(this.transferToNodeStateResponse(queryStatus));
        return response;
    }

    private List<ClusterStatusResponse.NodeStateResponse> transferToNodeStateResponse(Map<String, ClusterStatusResponse.NodeState> states) {
        return states.entrySet().stream().map(e -> new ClusterStatusResponse.NodeStateResponse((String)e.getKey(), (ClusterStatusResponse.NodeState)e.getValue())).collect(Collectors.toList());
    }

    private void setTotalState(long goods, long crashes, long total, Consumer<ClusterStatusResponse.NodeState> consumer) {
        if (goods == total) {
            consumer.accept(ClusterStatusResponse.NodeState.GOOD);
        } else if ((double)crashes / (double)total >= KapConfig.wrap((KylinConfig)this.getConfig()).getClusterCrashThreshhold()) {
            consumer.accept(ClusterStatusResponse.NodeState.CRASH);
        } else {
            consumer.accept(ClusterStatusResponse.NodeState.WARNING);
        }
    }

    private <T extends MonitorMetric> Map<String, T> transferToMap(List<T> metrics) {
        return metrics.stream().collect(Collectors.groupingBy(MonitorMetric::getInstanceName)).values().stream().map(ts -> {
            ts.sort(Comparator.comparing(MonitorMetric::getCreateTime).reversed());
            return (MonitorMetric)ts.iterator().next();
        }).collect(Collectors.toMap(MonitorMetric::getInstanceName, m -> m));
    }

    private boolean pendingOnYarn(Set<String> runningOnYarnJobs, AbstractExecutable executable) {
        DefaultExecutable parent = (DefaultExecutable)executable;
        AbstractExecutable runningJob = parent.getTasks().stream().filter(e -> e.getStatusInMem() == ExecutableState.RUNNING).findFirst().orElse(null);
        if (runningJob == null) {
            return false;
        }
        return !runningOnYarnJobs.contains("job_step_" + runningJob.getId());
    }

    private ClusterStatusResponse.NodeState calculateWhenNoFinished(long dP, long dE, long dNF, long dNFMax, long pendingJobs, long errorJobs) {
        if (dP < 0L) {
            if (dE > 0L) {
                return ClusterStatusResponse.NodeState.WARNING;
            }
        } else if (dP > 0L) {
            if (dNF >= dNFMax) {
                return ClusterStatusResponse.NodeState.CRASH;
            }
            if (dNF > 0L) {
                return ClusterStatusResponse.NodeState.WARNING;
            }
        } else {
            if (dE > 0L) {
                return ClusterStatusResponse.NodeState.CRASH;
            }
            if (dE < 0L) {
                return ClusterStatusResponse.NodeState.GOOD;
            }
            if (pendingJobs + errorJobs >= dNFMax / 2L) {
                return ClusterStatusResponse.NodeState.WARNING;
            }
        }
        return ClusterStatusResponse.NodeState.GOOD;
    }

    private ClusterStatusResponse.NodeState calculatedWhenFinishedError(long dNF, long dNFMax, long pendingJobs, long errorJobs) {
        if (dNF > 0L && dNF < dNFMax) {
            return ClusterStatusResponse.NodeState.WARNING;
        }
        if (dNF >= dNFMax) {
            return ClusterStatusResponse.NodeState.CRASH;
        }
        if (dNF == 0L && pendingJobs + errorJobs >= dNFMax / 2L) {
            return ClusterStatusResponse.NodeState.WARNING;
        }
        return ClusterStatusResponse.NodeState.GOOD;
    }

    private ClusterStatusResponse.NodeState calculateNodeState(JobStatusMonitorMetric m1, JobStatusMonitorMetric m2) {
        if (m2 == null) {
            return ClusterStatusResponse.NodeState.CRASH;
        }
        if (m1 == null) {
            return ClusterStatusResponse.NodeState.GOOD;
        }
        long dF = m2.getFinishedJobs() - m1.getFinishedJobs();
        long dE = m2.getErrorJobs() - m1.getErrorJobs();
        long dP = m2.getPendingJobs() - m1.getPendingJobs();
        long dNF = dP + dE;
        long dNFMax = KapConfig.wrap((KylinConfig)this.getConfig()).getMaxPendingErrorJobs();
        double dNFMaxRation = KapConfig.wrap((KylinConfig)this.getConfig()).getMaxPendingErrorJobsRation();
        if (dF > 0L) {
            if (dE + dP > 0L && (double)dF / (double)(dE + dP) <= dNFMaxRation) {
                return ClusterStatusResponse.NodeState.WARNING;
            }
            return ClusterStatusResponse.NodeState.GOOD;
        }
        if (dF == 0L) {
            return this.calculateWhenNoFinished(dP, dE, dNF, dNFMax, m2.getPendingJobs(), m2.getErrorJobs());
        }
        return this.calculatedWhenFinishedError(dNF, dNFMax, m2.getPendingJobs(), m2.getErrorJobs());
    }

    private ClusterStatusResponse.NodeState calculateNodeState(QueryMonitorMetric metric) {
        if (metric == null) {
            return ClusterStatusResponse.NodeState.CRASH;
        }
        if (metric.getErrorAccumulated() == 0) {
            return ClusterStatusResponse.NodeState.GOOD;
        }
        if (metric.getErrorAccumulated() >= KapConfig.wrap((KylinConfig)this.getConfig()).getThresholdToRestartSpark()) {
            return ClusterStatusResponse.NodeState.CRASH;
        }
        return ClusterStatusResponse.NodeState.WARNING;
    }

    public ClusterStatisticStatusResponse statisticClusterByFloorTime(long start, long end) {
        return this.statisticCluster(this.floorTime(start), this.floorTime(end));
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#project, 'ADMINISTRATION') or hasPermission(#project, 'MANAGEMENT') or hasPermission(#project, 'OPERATION')")
    public ClusterStatisticStatusResponse statisticCluster(long start, long end) {
        List jobs = this.clusterManager.getJobServers().stream().map(ServerInfoResponse::getHost).collect(Collectors.toList());
        List queries = this.clusterManager.getQueryServers().stream().map(ServerInfoResponse::getHost).collect(Collectors.toList());
        long interval = KapConfig.wrap((KylinConfig)this.getConfig()).getMonitorInterval();
        long jobInterval = KapConfig.wrap((KylinConfig)this.getConfig()).getJobStatisticInterval();
        ClusterStatisticStatusResponse response = new ClusterStatisticStatusResponse();
        Map jobMetrics = this.groupByInstance(this.getMonitorDao().readJobStatusMonitorMetricFromInfluxDB(Long.valueOf(start - jobInterval), Long.valueOf(end)));
        HashMap jobStatistics = Maps.newHashMap();
        jobMetrics.entrySet().forEach(entry -> {
            ClusterStatisticStatusResponse.NodeStatisticStatusResponse value = this.toResponse(new JobNodeStatistic((String)entry.getKey(), (List)entry.getValue(), start - jobInterval, end, interval, start, end, jobInterval));
            jobStatistics.put(((JobStatusMonitorMetric)((List)entry.getValue()).get(0)).getInstanceName(), value);
            jobStatistics.put(((JobStatusMonitorMetric)((List)entry.getValue()).get(0)).getIpPort(), value);
        });
        response.setJob(jobs.stream().map(s -> jobStatistics.getOrDefault(s, this.fullCrashed((String)s, start, end, interval))).collect(Collectors.toList()));
        Map queryMetrics = this.groupByInstance(this.getMonitorDao().readQueryMonitorMetricFromInfluxDB(Long.valueOf(start), Long.valueOf(end)));
        HashMap queryStatistics = Maps.newHashMap();
        queryMetrics.entrySet().forEach(entry -> {
            ClusterStatisticStatusResponse.NodeStatisticStatusResponse value = this.toResponse(new QueryNodeStatistic((String)entry.getKey(), (List)entry.getValue(), start, end, interval));
            queryStatistics.put(((QueryMonitorMetric)((List)entry.getValue()).get(0)).getInstanceName(), value);
            queryStatistics.put(((QueryMonitorMetric)((List)entry.getValue()).get(0)).getIpPort(), value);
        });
        response.setQuery(queries.stream().map(s -> queryStatistics.getOrDefault(s, this.fullCrashed((String)s, start, end, interval))).collect(Collectors.toList()));
        response.setStart(start);
        response.setEnd(end);
        response.setInterval(interval);
        return response;
    }

    private ClusterStatisticStatusResponse.NodeStatisticStatusResponse fullCrashed(String instance, long start, long end, long interval) {
        ClusterStatisticStatusResponse.NodeStatisticStatusResponse response = new ClusterStatisticStatusResponse.NodeStatisticStatusResponse();
        response.setInstance(instance);
        int size = (int)((end - start) / interval);
        ArrayList<ClusterStatisticStatusResponse.NodeTimeState> crashedStates = new ArrayList<ClusterStatisticStatusResponse.NodeTimeState>(size);
        for (int i = 0; i < size; ++i) {
            crashedStates.add(new ClusterStatisticStatusResponse.NodeTimeState(start + (long)i * interval, ClusterStatusResponse.NodeState.CRASH));
        }
        response.setDetails(crashedStates);
        response.setUnavailableCount(size);
        response.setUnavailableTime((long)size * interval);
        return response;
    }

    private <T extends MonitorMetric> ClusterStatisticStatusResponse.NodeStatisticStatusResponse toResponse(NodeStatistic<T> statistic) {
        ClusterStatisticStatusResponse.NodeStatisticStatusResponse response = new ClusterStatisticStatusResponse.NodeStatisticStatusResponse();
        response.setInstance(statistic.getName());
        response.setDetails(statistic.getStates().stream().map(p -> new ClusterStatisticStatusResponse.NodeTimeState(((Long)p.getKey()).longValue(), (ClusterStatusResponse.NodeState)p.getValue())).collect(Collectors.toList()));
        response.setUnavailableCount(statistic.getUnavailableCount());
        response.setUnavailableTime(statistic.getUnavailableTime());
        return response;
    }

    private <T extends MonitorMetric> Map<String, List<T>> groupByInstance(List<T> metrics) {
        return metrics.stream().sorted(Comparator.comparingLong(MonitorMetric::getCreateTime)).collect(Collectors.groupingBy(MonitorMetric::getInstanceName, Collectors.toList()));
    }

    @Generated
    public void setProjectService(ProjectService projectService) {
        this.projectService = projectService;
    }

    @Generated
    public void setClusterManager(ClusterManager clusterManager) {
        this.clusterManager = clusterManager;
    }

    class QueryNodeStatistic
    extends NodeStatistic<QueryMonitorMetric> {
        QueryNodeStatistic(String name, List<QueryMonitorMetric> metrics, long start, long end, long interval) {
            super(name, metrics, start, end, interval);
        }

        protected QueryMonitorMetric[] createMetricArray() {
            return new QueryMonitorMetric[this.size];
        }

        protected ClusterStatusResponse.NodeState[] calculate(QueryMonitorMetric[] fullMetrics) {
            ClusterStatusResponse.NodeState[] states = new ClusterStatusResponse.NodeState[this.size];
            for (int i = 0; i < fullMetrics.length; ++i) {
                states[i] = MonitorService.this.calculateNodeState(fullMetrics[i]);
            }
            return states;
        }
    }

    class JobNodeStatistic
    extends NodeStatistic<JobStatusMonitorMetric> {
        long calInterval;

        JobNodeStatistic(String name, List<JobStatusMonitorMetric> metrics, long start, long end, long interval, long realStart, long realEnd, long calInterval) {
            super(name, metrics, start, end, interval, realStart, realEnd);
            this.calInterval = calInterval;
        }

        protected JobStatusMonitorMetric[] createMetricArray() {
            return new JobStatusMonitorMetric[this.size];
        }

        protected ClusterStatusResponse.NodeState[] calculate(JobStatusMonitorMetric[] fullMetrics) {
            ClusterStatusResponse.NodeState[] states = new ClusterStatusResponse.NodeState[this.size];
            for (int i = 0; i < fullMetrics.length; ++i) {
                states[i] = i == 0 ? (fullMetrics[i] == null ? ClusterStatusResponse.NodeState.CRASH : ClusterStatusResponse.NodeState.GOOD) : MonitorService.this.calculateNodeState(this.findMetricBefore(fullMetrics, i), fullMetrics[i]);
            }
            return states;
        }

        private JobStatusMonitorMetric findMetricBefore(JobStatusMonitorMetric[] metrics, int i) {
            int pos = i - (int)(this.calInterval / this.interval);
            if (pos < 0) {
                return null;
            }
            return metrics[pos];
        }
    }

    static abstract class NodeStatistic<T extends MonitorMetric> {
        String name;
        List<T> metrics;
        int size;
        long start;
        long end;
        long interval;
        long realStart;
        long realEnd;
        private final AtomicReference<Object> states = new AtomicReference();

        NodeStatistic(String name, List<T> metrics, long start, long end, long interval) {
            this(name, metrics, start, end, interval, start, end);
        }

        NodeStatistic(String name, List<T> metrics, long start, long end, long interval, long realStart, long readEnd) {
            this.name = name;
            this.metrics = metrics;
            this.interval = interval;
            this.size = (int)((MonitorService.floorTime(end, interval) - MonitorService.floorTime(start, interval)) / interval);
            this.start = start;
            this.end = end;
            this.realStart = realStart;
            this.realEnd = readEnd;
        }

        protected abstract T[] createMetricArray();

        protected abstract ClusterStatusResponse.NodeState[] calculate(T[] var1);

        protected List<Pair<Long, ClusterStatusResponse.NodeState>> statistic() {
            long range = 7776000000L / this.interval;
            if ((long)this.size > range) {
                throw new IllegalArgumentException("Out of data range, only can calculate 90 days monitor data!");
            }
            MonitorMetric[] fullMetrics = this.createMetricArray();
            long firstTime = MonitorService.floorTime(this.start, this.interval);
            for (MonitorMetric metric : this.metrics) {
                int length = (int)((MonitorService.floorTime(metric.getCreateTime(), this.interval) - firstTime) / this.interval);
                if (length >= fullMetrics.length || null != fullMetrics[length]) {
                    if (length >= fullMetrics.length) {
                        logger.warn("Monitor metric create_time error, time: {}, end: {}", (Object)metric.getCreateTime(), (Object)this.end);
                        continue;
                    }
                    logger.debug("Found multi monitor metric in same interval, time: {}", (Object)metric.getCreateTime());
                    continue;
                }
                fullMetrics[length] = metric;
            }
            ClusterStatusResponse.NodeState[] calculatedStates = this.calculate(fullMetrics);
            ArrayList<Pair> res = new ArrayList<Pair>(calculatedStates.length);
            for (int i = 0; i < calculatedStates.length; ++i) {
                res.add(new Pair((Object)(fullMetrics[i] == null ? this.start + (long)i * this.interval : fullMetrics[i].getCreateTime()), (Object)calculatedStates[i]));
            }
            return res.stream().filter(p -> (Long)p.getKey() >= this.realStart && (Long)p.getKey() < this.realEnd).collect(Collectors.toList());
        }

        public int getUnavailableCount() {
            return (int)this.getStates().stream().filter(e -> e.getValue() == ClusterStatusResponse.NodeState.CRASH).count();
        }

        public long getUnavailableTime() {
            return (long)this.getUnavailableCount() * this.interval;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Generated
        public List<Pair<Long, ClusterStatusResponse.NodeState>> getStates() {
            Object value = this.states.get();
            if (value == null) {
                AtomicReference<Object> atomicReference = this.states;
                synchronized (atomicReference) {
                    value = this.states.get();
                    if (value == null) {
                        List<Pair<Long, ClusterStatusResponse.NodeState>> actualValue = this.statistic();
                        value = actualValue == null ? this.states : actualValue;
                        this.states.set(value);
                    }
                }
            }
            return (List)(value == this.states ? null : value);
        }
    }
}

