/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.util;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.QueryErrorCode;
import org.apache.kylin.common.msg.MsgPicker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncQueryRequestLimits
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(AsyncQueryRequestLimits.class);
    private static volatile AtomicInteger asyncQueryCount = new AtomicInteger(0);
    private static final int MAX_COUNT = KylinConfig.getInstanceFromEnv().getAsyncQueryMaxConcurrentJobs();

    private static synchronized void openAsyncQueryRequest() {
        if (MAX_COUNT <= 0) {
            return;
        }
        AsyncQueryRequestLimits.checkCount();
        asyncQueryCount.incrementAndGet();
        logger.debug("current async query job count is {}.", (Object)asyncQueryCount.get());
    }

    public static void checkCount() {
        if (MAX_COUNT <= 0) {
            return;
        }
        if (asyncQueryCount.get() >= MAX_COUNT) {
            throw new KylinException((ErrorCodeSupplier)QueryErrorCode.TOO_MANY_ASYNC_QUERY, MsgPicker.getMsg().getAsyncQueryTooManyRunning());
        }
    }

    private static void closeAsyncQueryRequest() {
        if (MAX_COUNT <= 0) {
            return;
        }
        asyncQueryCount.decrementAndGet();
    }

    public AsyncQueryRequestLimits() {
        AsyncQueryRequestLimits.openAsyncQueryRequest();
    }

    @Override
    public void close() {
        AsyncQueryRequestLimits.closeAsyncQueryRequest();
    }
}

