/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence;

import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.dbcp2.BasicDataSourceFactory;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.StorageURL;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.RawResourceTool;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.persistence.StringEntity;
import org.apache.kylin.common.persistence.UnitMessages;
import org.apache.kylin.common.persistence.event.ResourceCreateOrUpdateEvent;
import org.apache.kylin.common.persistence.metadata.JdbcAuditLogStore;
import org.apache.kylin.common.persistence.metadata.MetadataStore;
import org.apache.kylin.common.persistence.metadata.jdbc.JdbcUtil;
import org.apache.kylin.common.persistence.transaction.AbstractAuditLogReplayWorker;
import org.apache.kylin.common.persistence.transaction.UnitOfWork;
import org.apache.kylin.common.scheduler.EventBusFactory;
import org.apache.kylin.common.util.RandomUtil;
import org.apache.kylin.guava30.shaded.common.base.Joiner;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.eventbus.Subscribe;
import org.apache.kylin.junit.annotation.MetadataInfo;
import org.apache.kylin.junit.annotation.OverwriteProp;
import org.awaitility.Awaitility;
import org.junit.Assert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

@MetadataInfo(onlyProps=true)
public class JdbcAuditLogRecoveryTest {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JdbcAuditLogRecoveryTest.class);
    static final String META_TABLE_KEY = "META_TABLE_KEY";
    static final String META_TABLE_CONTENT = "META_TABLE_CONTENT";
    static final String META_TABLE_TS = "META_TABLE_TS";
    static final String META_TABLE_MVCC = "META_TABLE_MVCC";
    static final String INSERT_SQL = "insert into %s (" + Joiner.on((String)",").join((Object)"META_TABLE_KEY", (Object)"META_TABLE_CONTENT", new Object[]{"META_TABLE_TS", "META_TABLE_MVCC"}) + ") values (?, ?, ?, ?)";
    static final String UPDATE_SQL = "update %s set META_TABLE_CONTENT=?, META_TABLE_MVCC=?, META_TABLE_TS=? where META_TABLE_KEY=?";
    static final String AUDIT_LOG_TABLE_KEY = "meta_key";
    static final String AUDIT_LOG_TABLE_CONTENT = "meta_content";
    static final String AUDIT_LOG_TABLE_TS = "meta_ts";
    static final String AUDIT_LOG_TABLE_MVCC = "meta_mvcc";
    static final String AUDIT_LOG_TABLE_UNIT = "unit_id";
    static final String AUDIT_LOG_TABLE_OPERATOR = "operator";
    static final String AUDIT_LOG_TABLE_INSTANCE = "instance";
    static final String INSERT_AUDIT_LOG_SQL = "insert into %s (" + Joiner.on((String)",").join((Object)"meta_key", (Object)"meta_content", new Object[]{"meta_ts", "meta_mvcc", "unit_id", "operator", "instance"}) + ") values (?, ?, ?, ?, ?, ?, ?)";
    private final Charset charset = Charset.defaultCharset();

    @AfterEach
    public void destroy() throws Exception {
        JdbcTemplate jdbcTemplate = this.getJdbcTemplate();
        jdbcTemplate.batchUpdate(new String[]{"SHUTDOWN;"});
    }

    @Test
    @OverwriteProp.OverwriteProps(value={@OverwriteProp(key="kylin.metadata.url", value="test@jdbc,driverClassName=org.h2.Driver,url=jdbc:h2:mem:db_default;DB_CLOSE_DELAY=-1;MODE=MYSQL,username=sa,password=")})
    public void testAuditLogOutOfOrder() throws Exception {
        StatusListener listener = new StatusListener();
        EventBusFactory.getInstance().register((Object)listener, true);
        ResourceStore systemStore = ResourceStore.getKylinMetaStore((KylinConfig)this.getTestConfig());
        JdbcAuditLogStore auditLogStore = (JdbcAuditLogStore)systemStore.getAuditLogStore();
        UnitOfWork.doInTransactionWithRetry(() -> {
            ResourceStore store = ResourceStore.getKylinMetaStore((KylinConfig)KylinConfig.getInstanceFromEnv());
            UnitOfWork.get().getCopyForWriteItems().add("PROJECT/a");
            store.checkAndPutResource("PROJECT/a", (RootPersistentEntity)new StringEntity("a", RandomUtil.randomUUIDStr()), StringEntity.serializer);
            return null;
        }, (String)"a");
        UnitOfWork.doInTransactionWithRetry(() -> {
            ResourceStore store = ResourceStore.getKylinMetaStore((KylinConfig)KylinConfig.getInstanceFromEnv());
            UnitOfWork.get().getCopyForWriteItems().add("PROJECT/b");
            store.checkAndPutResource("PROJECT/b", (RootPersistentEntity)new StringEntity("b", RandomUtil.randomUUIDStr()), StringEntity.serializer);
            return null;
        }, (String)"b");
        Assert.assertEquals((long)2L, (long)systemStore.listResourcesRecursively(MetadataType.ALL.name()).size());
        Thread t = new Thread(() -> {
            Thread t1 = new Thread(() -> {
                UnitOfWork.doInTransactionWithRetry(() -> {
                    Thread.sleep(500L);
                    ResourceStore store = ResourceStore.getKylinMetaStore((KylinConfig)KylinConfig.getInstanceFromEnv());
                    String path = "PROJECT/a-" + System.currentTimeMillis();
                    UnitOfWork.get().getCopyForWriteItems().add(path);
                    RawResource originAbc = store.getResource(path, true);
                    store.checkAndPutResource(path, RawResourceTool.createByteSourceByPath(path), System.currentTimeMillis(), originAbc == null ? -1L : originAbc.getMvcc());
                    return 0;
                }, (String)"a");
                try {
                    auditLogStore.catchupWithTimeout();
                }
                catch (Exception e) {
                    log.error("catchup 1st phase failed", (Throwable)e);
                }
            });
            t1.start();
            HashMap versions = Maps.newHashMap();
            int size = 200;
            MetadataStore metadataStore = systemStore.getMetadataStore();
            IntStream.range(1000, 1000 + size).forEach(id -> {
                long newMvcc;
                String metaKey = "b-" + id;
                String path = "PROJECT/b-" + id;
                RawResource result = systemStore.getResource(path, true);
                long l = newMvcc = result == null ? 0L : result.getMvcc() + 1L;
                if (newMvcc == 0L) {
                    metadataStore.save(MetadataType.PROJECT, (RawResource)RawResourceTool.createProjectRawResource(metaKey, newMvcc));
                } else {
                    metadataStore.save(MetadataType.PROJECT, (RawResource)RawResourceTool.createProjectRawResource(metaKey, newMvcc));
                    List<ResourceCreateOrUpdateEvent> events = Collections.singletonList(new ResourceCreateOrUpdateEvent(path, new RawResource(metaKey, RawResourceTool.createByteSource(metaKey), System.currentTimeMillis(), newMvcc)));
                    UnitMessages unitMessages = new UnitMessages(events);
                    metadataStore.getAuditLogStore().save(unitMessages);
                    versions.put(path, newMvcc);
                }
            });
            try {
                t1.join();
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                log.debug("wait for thread join failed", (Throwable)e);
            }
            try {
                auditLogStore.catchupWithTimeout();
            }
            catch (Exception e) {
                log.error("catchup 2nd phase failed", (Throwable)e);
            }
            try {
                UnitOfWork.doInTransactionWithRetry(() -> {
                    ResourceStore store = ResourceStore.getKylinMetaStore((KylinConfig)KylinConfig.getInstanceFromEnv());
                    IntStream.range(1000, 1000 + size).forEach(id -> {
                        String path = "PROJECT/b-" + id;
                        UnitOfWork.get().getCopyForWriteItems().add(path);
                        RawResource originAbc = store.getResource(path, true);
                        store.checkAndPutResource(path, RawResourceTool.createByteSourceByPath(path + "-version2"), System.currentTimeMillis(), originAbc == null ? -1L : originAbc.getMvcc());
                    });
                    return 0;
                }, (String)"b");
                auditLogStore.catchupWithTimeout();
            }
            catch (Exception e) {
                log.error("catchup 3rd phase failed", (Throwable)e);
            }
        });
        t.start();
        Awaitility.await().atMost(200L, TimeUnit.SECONDS).until(() -> listener.status == -1);
        Assert.assertEquals((long)203L, (long)systemStore.listResourcesRecursively(MetadataType.ALL.name()).size());
        t.join();
    }

    JdbcTemplate getJdbcTemplate() throws Exception {
        StorageURL url = this.getTestConfig().getMetadataUrl();
        Properties props = JdbcUtil.datasourceParameters((StorageURL)url);
        BasicDataSource dataSource = BasicDataSourceFactory.createDataSource((Properties)props);
        return new JdbcTemplate((DataSource)dataSource);
    }

    KylinConfig getTestConfig() {
        return KylinConfig.getInstanceFromEnv();
    }

    static class StatusListener {
        int status = 0;

        StatusListener() {
        }

        @Subscribe
        public void onStart(AbstractAuditLogReplayWorker.StartReloadEvent start) {
            this.status = 1;
        }

        @Subscribe
        public void onEnd(AbstractAuditLogReplayWorker.EndReloadEvent end) {
            this.status = -1;
        }
    }
}

