/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.scheduler;

import java.util.LinkedList;
import java.util.Set;
import org.apache.kylin.common.scheduler.EventBusFactory;
import org.apache.kylin.common.scheduler.ProjectControlledNotifier;
import org.apache.kylin.common.scheduler.ProjectEscapedNotifier;
import org.apache.kylin.common.scheduler.ProjectSerialEventBus;
import org.apache.kylin.common.scheduler.SchedulerEventNotifier;
import org.apache.kylin.junit.annotation.MetadataInfo;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.test.util.ReflectionTestUtils;

@MetadataInfo
public class ProjectSerialEventBusTest {
    private ProjectSerialEventBus projectSerialEventBus;
    private EventBusFactory eventBusFactory;

    @BeforeEach
    public void setUp() throws Exception {
        this.projectSerialEventBus = (ProjectSerialEventBus)Mockito.spy((Object)ProjectSerialEventBus.getInstance());
        this.eventBusFactory = (EventBusFactory)Mockito.mock(EventBusFactory.class);
        ReflectionTestUtils.setField((Object)this.projectSerialEventBus, (String)"eventBus", (Object)this.eventBusFactory);
    }

    @Test
    void testInnerQueueStatus() throws Exception {
        LinkedList innerEventsQueue = (LinkedList)ReflectionTestUtils.getField((Object)this.projectSerialEventBus, (String)"eventsQueue");
        Set runningProjects = (Set)ReflectionTestUtils.getField((Object)this.projectSerialEventBus, (String)"runningProjects");
        this.projectSerialEventBus.postAsync((SchedulerEventNotifier)new ProjectEscapedNotifier("project1"));
        Assertions.assertEquals((int)1, (int)runningProjects.size());
        this.projectSerialEventBus.postAsync((SchedulerEventNotifier)new ProjectControlledNotifier("project1"));
        Assertions.assertEquals((int)1, (int)runningProjects.size());
        this.projectSerialEventBus.postAsync((SchedulerEventNotifier)new ProjectEscapedNotifier("project2"));
        Assertions.assertEquals((int)2, (int)runningProjects.size());
        this.projectSerialEventBus.postAsync((SchedulerEventNotifier)new ProjectControlledNotifier("project2"));
        Assertions.assertEquals((int)2, (int)runningProjects.size());
        ((ProjectSerialEventBus)Mockito.verify((Object)this.projectSerialEventBus, (VerificationMode)Mockito.times((int)2))).dispatch();
        Assertions.assertEquals((int)2, (int)innerEventsQueue.size());
        Assertions.assertEquals((Object)"project1", (Object)((SchedulerEventNotifier)innerEventsQueue.get(0)).getProject());
        Assertions.assertTrue((boolean)(innerEventsQueue.get(0) instanceof ProjectControlledNotifier));
        Assertions.assertEquals((Object)"project2", (Object)((SchedulerEventNotifier)innerEventsQueue.get(1)).getProject());
        Assertions.assertTrue((boolean)(innerEventsQueue.get(1) instanceof ProjectControlledNotifier));
        this.projectSerialEventBus.finishProjectAndDispatch("project1");
        Assertions.assertEquals((int)2, (int)runningProjects.size());
        this.projectSerialEventBus.finishProjectAndDispatch("project2");
        Assertions.assertEquals((int)2, (int)runningProjects.size());
        Assertions.assertEquals((int)0, (int)innerEventsQueue.size());
        this.projectSerialEventBus.finishProjectAndDispatch("project1");
        Assertions.assertEquals((int)1, (int)runningProjects.size());
        this.projectSerialEventBus.finishProjectAndDispatch("project2");
        Assertions.assertEquals((int)0, (int)runningProjects.size());
    }

    @Test
    void testTimingDispatcherRun() {
        LinkedList innerEventsQueue = (LinkedList)ReflectionTestUtils.getField((Object)this.projectSerialEventBus, (String)"eventsQueue");
        Set runningProjects = (Set)ReflectionTestUtils.getField((Object)this.projectSerialEventBus, (String)"runningProjects");
        innerEventsQueue.add(new ProjectEscapedNotifier("project1"));
        Assertions.assertEquals((int)1, (int)innerEventsQueue.size());
        Assertions.assertEquals((int)0, (int)runningProjects.size());
        new ProjectSerialEventBus.TimingDispatcher().run();
        Assertions.assertEquals((int)0, (int)innerEventsQueue.size());
        Assertions.assertEquals((int)1, (int)runningProjects.size());
    }

    @Test
    void testRunningProjectExpired() {
        ProjectSerialEventBus.RunningProject rp = ProjectSerialEventBus.RunningProject.newInstance((String)"project1");
        long DURATION_31_MINUTES_MILLIS = 1860000L;
        ReflectionTestUtils.setField((Object)rp, (String)"beginTime", (Object)(System.currentTimeMillis() - 1860000L));
        Assertions.assertTrue((boolean)rp.isExpired());
    }
}

