/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage;

import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.ImplementationSwitch;
import org.apache.kylin.metadata.model.IStorageAware;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.storage.IStorage;
import org.apache.kylin.storage.IStorageQuery;

public class StorageFactory {
    private static ThreadLocal<ImplementationSwitch<IStorage>> storages = new ThreadLocal();

    public static IStorage storage(IStorageAware aware) {
        ImplementationSwitch current = storages.get();
        if (storages.get() == null) {
            current = new ImplementationSwitch(KylinConfig.getInstanceFromEnv().getStorageEngines(), IStorage.class);
            storages.set((ImplementationSwitch<IStorage>)current);
        }
        return (IStorage)current.get(aware.getStorageType());
    }

    public static IStorageQuery createQuery(IRealization realization) {
        return StorageFactory.storage((IStorageAware)realization).createQuery(realization);
    }

    public static <T> T createEngineAdapter(IStorageAware aware, Class<T> engineInterface) {
        return StorageFactory.storage(aware).adaptToBuildEngine(engineInterface);
    }
}

