/*
 * Decompiled with CFR 0.152.
 */
package io.delta.storage;

import io.delta.storage.HadoopFileSystemLogStore;
import io.delta.storage.internal.LogStoreErrors;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HDFSLogStore
extends HadoopFileSystemLogStore {
    private static final Logger LOG = LoggerFactory.getLogger(HDFSLogStore.class);
    public static final String NO_ABSTRACT_FILE_SYSTEM_EXCEPTION_MESSAGE = "No AbstractFileSystem";

    public HDFSLogStore(Configuration configuration) {
        super(configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(Path path, Iterator<String> iterator, Boolean bl, Configuration configuration) throws IOException {
        boolean bl2 = path.getFileSystem(configuration) instanceof RawLocalFileSystem;
        if (bl2) {
            HDFSLogStore hDFSLogStore = this;
            synchronized (hDFSLogStore) {
                this.writeInternal(path, iterator, bl, configuration);
            }
        } else {
            this.writeInternal(path, iterator, bl, configuration);
        }
    }

    @Override
    public Boolean isPartialWriteVisible(Path path, Configuration configuration) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeInternal(Path path, Iterator<String> iterator, Boolean bl, Configuration configuration) throws IOException {
        FileContext fileContext;
        try {
            fileContext = FileContext.getFileContext((URI)path.toUri(), (Configuration)configuration);
        }
        catch (IOException iOException) {
            if (iOException.getMessage().contains(NO_ABSTRACT_FILE_SYSTEM_EXCEPTION_MESSAGE)) {
                IOException iOException2 = LogStoreErrors.incorrectLogStoreImplementationException(iOException);
                LOG.error(iOException2.getMessage(), iOException2.getCause());
                throw iOException2;
            }
            throw iOException;
        }
        if (!bl.booleanValue() && fileContext.util().exists(path)) {
            throw new java.nio.file.FileAlreadyExistsException(path.toString());
        }
        Path path2 = this.createTempPath(path);
        boolean bl2 = false;
        boolean bl3 = false;
        FSDataOutputStream fSDataOutputStream = fileContext.create(path2, EnumSet.of(CreateFlag.CREATE), new Options.CreateOpts[]{Options.CreateOpts.checksumParam((Options.ChecksumOpt)Options.ChecksumOpt.createDisabled())});
        try {
            while (iterator.hasNext()) {
                fSDataOutputStream.write((iterator.next() + "\n").getBytes(StandardCharsets.UTF_8));
            }
            fSDataOutputStream.close();
            bl2 = true;
            try {
                Options.Rename rename = bl != false ? Options.Rename.OVERWRITE : Options.Rename.NONE;
                fileContext.rename(path2, path, new Options.Rename[]{rename});
                bl3 = true;
                this.tryRemoveCrcFile(fileContext, path2);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                throw new java.nio.file.FileAlreadyExistsException(path.toString());
            }
        }
        finally {
            if (!bl2) {
                fSDataOutputStream.close();
            }
            if (!bl3) {
                fileContext.delete(path2, false);
            }
        }
        this.msyncIfSupported(path, configuration);
    }

    private void msyncIfSupported(Path path, Configuration configuration) throws IOException {
        block3: {
            try {
                FileSystem fileSystem = path.getFileSystem(configuration);
                Method method = fileSystem.getClass().getMethod("msync", new Class[0]);
                method.invoke((Object)fileSystem, new Object[0]);
            }
            catch (InterruptedIOException interruptedIOException) {
                throw interruptedIOException;
            }
            catch (Throwable throwable) {
                if (!(throwable instanceof InterruptedException)) break block3;
                Thread.currentThread().interrupt();
            }
        }
    }

    private void tryRemoveCrcFile(FileContext fileContext, Path path) throws IOException {
        block3: {
            try {
                Path path2 = new Path(path.getParent(), String.format(".%s.crc", path.getName()));
                if (fileContext.util().exists(path2)) {
                    fileContext.delete(path2, true);
                }
            }
            catch (Throwable throwable) {
                if (LogStoreErrors.isNonFatal(throwable)) break block3;
                throw throwable;
            }
        }
    }
}

