/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.lock.jdbc;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.util.Locale;
import java.util.Properties;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.ibatis.jdbc.ScriptRunner;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.StorageURL;
import org.apache.kylin.common.logging.LogOutputStream;
import org.apache.kylin.common.persistence.metadata.JdbcDataSource;
import org.apache.kylin.common.persistence.metadata.jdbc.JdbcUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcDistributedLockUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JdbcDistributedLockUtil.class);
    private static final Charset DEFAULT_CHARSET = Charset.defaultCharset();
    public static final String CREATE_TABLE_TEMPLATE = "create.jdbc.distributed.lock.table";

    private JdbcDistributedLockUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static void createDistributedLockTableIfNotExist() throws Exception {
        Throwable throwable;
        Connection connection;
        String prefix = JdbcDistributedLockUtil.getGlobalDictLockTablePrefix();
        String lockTableName = prefix + "LOCK";
        DataSource dataSource = JdbcDistributedLockUtil.getDataSource();
        try {
            connection = dataSource.getConnection();
            throwable = null;
            try {
                if (JdbcUtil.isTableExists((Connection)connection, (String)lockTableName)) {
                    return;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (connection != null) {
                    if (throwable != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        connection.close();
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("Fail to know if table {} exists", (Object)lockTableName, (Object)e);
            return;
        }
        try {
            connection = dataSource.getConnection();
            throwable = null;
            try {
                Properties properties = JdbcUtil.getProperties((BasicDataSource)((BasicDataSource)dataSource));
                String sql = String.format(Locale.ROOT, properties.getProperty(CREATE_TABLE_TEMPLATE), prefix, prefix);
                ScriptRunner sr = new ScriptRunner(connection);
                sr.setLogWriter(new PrintWriter(new OutputStreamWriter((OutputStream)new LogOutputStream(log), DEFAULT_CHARSET)));
                sr.runScript((Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(sql.getBytes(DEFAULT_CHARSET)), DEFAULT_CHARSET));
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (connection != null) {
                    if (throwable != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        connection.close();
                    }
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public static String getGlobalDictLockTablePrefix() {
        StorageURL url = KylinConfig.getInstanceFromEnv().getJDBCDistributedLockURL();
        return StorageURL.replaceUrl((StorageURL)url) + "_";
    }

    public static DataSource getDataSource() throws Exception {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        StorageURL url = config.getJDBCDistributedLockURL();
        Properties props = JdbcUtil.datasourceParameters((StorageURL)url);
        return JdbcDataSource.getDataSource((Properties)props);
    }
}

