/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.jni;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Vector;
import org.apache.gluten.exception.GlutenException;
import org.apache.spark.util.SparkShutdownManagerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.runtime.BoxedUnit;

public class JniLibLoader {
    private static final Logger LOG = LoggerFactory.getLogger(JniLibLoader.class);
    private static final Set<String> LOADED_LIBRARY_PATHS = Collections.synchronizedSet(new HashSet());
    private static final Set<String> REQUIRE_UNLOAD_LIBRARY_PATHS = Collections.synchronizedSet(new LinkedHashSet());
    private final String workDir;
    private final Set<String> loadedLibraries = Collections.synchronizedSet(new HashSet());

    JniLibLoader(String workDir) {
        this.workDir = workDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void forceUnloadAll() {
        ArrayList<String> loaded;
        Set<String> set = REQUIRE_UNLOAD_LIBRARY_PATHS;
        synchronized (set) {
            loaded = new ArrayList<String>(REQUIRE_UNLOAD_LIBRARY_PATHS);
        }
        Collections.reverse(loaded);
        loaded.forEach(JniLibLoader::unloadFromPath);
    }

    private static String toRealPath(String libPath) {
        String realPath = libPath;
        try {
            while (Files.isSymbolicLink(Paths.get(realPath, new String[0]))) {
                realPath = Files.readSymbolicLink(Paths.get(realPath, new String[0])).toString();
            }
            LOG.info("Read real path {} for libPath {}", (Object)realPath, (Object)libPath);
            return realPath;
        }
        catch (Throwable th) {
            throw new GlutenException("Error to read real path for libPath: " + libPath, th);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadFromPath0(String libPath, boolean requireUnload) {
        libPath = JniLibLoader.toRealPath(libPath);
        Set<String> set = LOADED_LIBRARY_PATHS;
        synchronized (set) {
            if (LOADED_LIBRARY_PATHS.contains(libPath)) {
                LOG.debug("Library in path {} has already been loaded, skipping", (Object)libPath);
            } else {
                System.load(libPath);
                LOADED_LIBRARY_PATHS.add(libPath);
                LOG.info("Library {} has been loaded using path-loading method", (Object)libPath);
            }
        }
        if (requireUnload) {
            set = REQUIRE_UNLOAD_LIBRARY_PATHS;
            synchronized (set) {
                REQUIRE_UNLOAD_LIBRARY_PATHS.add(libPath);
            }
        }
    }

    public static synchronized void loadFromPath(String libPath, boolean requireUnload) {
        File file = new File(libPath);
        if (!file.isFile() || !file.exists()) {
            throw new GlutenException("library at path: " + libPath + " is not a file or does not exist");
        }
        JniLibLoader.loadFromPath0(file.getAbsolutePath(), requireUnload);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unloadFromPath(String libPath) {
        Set<String> set = LOADED_LIBRARY_PATHS;
        synchronized (set) {
            if (!LOADED_LIBRARY_PATHS.remove(libPath)) {
                LOG.warn("Library {} was not loaded or already unloaded:", (Object)libPath);
                return;
            }
        }
        LOG.info("Starting unload library path: {} ", (Object)libPath);
        set = REQUIRE_UNLOAD_LIBRARY_PATHS;
        synchronized (set) {
            REQUIRE_UNLOAD_LIBRARY_PATHS.remove(libPath);
        }
        try {
            Vector libs;
            ClassLoader classLoader = JniLibLoader.class.getClassLoader();
            Field field = ClassLoader.class.getDeclaredField("nativeLibraries");
            field.setAccessible(true);
            Vector vector = libs = (Vector)field.get(classLoader);
            synchronized (vector) {
                for (Object object : libs) {
                    Field[] fs = object.getClass().getDeclaredFields();
                    for (int k = 0; k < fs.length; ++k) {
                        if (!fs[k].getName().equals("name")) continue;
                        fs[k].setAccessible(true);
                        String verbosePath = fs[k].get(object).toString();
                        File verboseFile = new File(verbosePath);
                        String verboseFileName = verboseFile.getName();
                        File libFile = new File(libPath);
                        String libFileName = libFile.getName();
                        if (!verboseFileName.equals(libFileName)) continue;
                        LOG.info("Finalizing library file: {}", (Object)libFileName);
                        Method finalize = object.getClass().getDeclaredMethod("finalize", new Class[0]);
                        finalize.setAccessible(true);
                        finalize.invoke(object, new Object[0]);
                    }
                }
            }
        }
        catch (Throwable th) {
            LOG.error("Unload native library error: ", th);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String libPath, boolean requireUnload) {
        Set<String> set = this.loadedLibraries;
        synchronized (set) {
            try {
                if (this.loadedLibraries.contains(libPath)) {
                    LOG.debug("Library {} has already been loaded, skipping", (Object)libPath);
                    return;
                }
                File file = this.moveToWorkDir(this.workDir, libPath);
                this.loadWithLink(file.getAbsolutePath(), null, requireUnload);
                this.loadedLibraries.add(libPath);
                LOG.info("Successfully loaded library {}", (Object)libPath);
            }
            catch (IOException e) {
                throw new GlutenException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAndCreateLink(String libPath, String linkName, boolean requireUnload) {
        Set<String> set = this.loadedLibraries;
        synchronized (set) {
            try {
                if (this.loadedLibraries.contains(libPath)) {
                    LOG.debug("Library {} has already been loaded, skipping", (Object)libPath);
                }
                File file = this.moveToWorkDir(this.workDir, libPath);
                this.loadWithLink(file.getAbsolutePath(), linkName, requireUnload);
                this.loadedLibraries.add(libPath);
                LOG.info("Successfully loaded library {}", (Object)libPath);
            }
            catch (IOException e) {
                throw new GlutenException(e);
            }
        }
    }

    private File moveToWorkDir(String workDir, String libraryToLoad) throws IOException {
        File temp;
        Path libPath = Paths.get(workDir + "/" + libraryToLoad, new String[0]);
        if (Files.exists(libPath, new LinkOption[0])) {
            Files.delete(libPath);
        }
        if (!(temp = new File(workDir + "/" + libraryToLoad)).getParentFile().exists()) {
            temp.getParentFile().mkdirs();
        }
        try (InputStream is = JniLibLoader.class.getClassLoader().getResourceAsStream(libraryToLoad);){
            if (is == null) {
                throw new FileNotFoundException(libraryToLoad);
            }
            try {
                Files.copy(is, temp.toPath(), new CopyOption[0]);
            }
            catch (Exception e) {
                throw new GlutenException(e);
            }
        }
        return temp;
    }

    private void loadWithLink(String libPath, String linkName, boolean requireUnload) throws IOException {
        JniLibLoader.loadFromPath0(libPath, requireUnload);
        LOG.info("Library {} has been loaded", (Object)libPath);
        if (linkName != null) {
            Path target = Paths.get(libPath, new String[0]);
            Path link = Paths.get(this.workDir, linkName);
            if (Files.exists(link, new LinkOption[0])) {
                LOG.info("Symbolic link already exists for library {}, deleting", (Object)libPath);
                Files.delete(link);
            }
            Files.createSymbolicLink(link, target, new FileAttribute[0]);
            LOG.info("Symbolic link {} created for library {}", (Object)link, (Object)libPath);
        }
    }

    static {
        SparkShutdownManagerUtil.addHookForLibUnloading((Function0<BoxedUnit>)((Function0)() -> {
            JniLibLoader.forceUnloadAll();
            return BoxedUnit.UNIT;
        }));
    }
}

