/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cache.fs;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import lombok.Generated;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.cache.kylin.KylinCacheFileSystem;
import org.apache.kylin.guava30.shaded.common.cache.CacheBuilder;
import org.apache.kylin.guava30.shaded.common.cache.CacheLoader;
import org.apache.kylin.guava30.shaded.common.cache.LoadingCache;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;
import org.apache.kylin.guava30.shaded.common.util.concurrent.UncheckedExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagerOfCacheFileStatus {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ManagerOfCacheFileStatus.class);
    private final LoadingCache<Path, FileStatusEntry> statusCache;
    private final LoadingCache<Path, FileStatusEntry> childrenCache;
    private int countOfEvict;

    public ManagerOfCacheFileStatus(long ttlSec, long maxSize, final Function<Path, FileStatus> statusLoader, final Function<Path, LocatedFileStatus[]> statusListLoader) {
        this.statusCache = CacheBuilder.newBuilder().maximumSize(maxSize).expireAfterAccess(ttlSec, TimeUnit.SECONDS).recordStats().build((CacheLoader)new CacheLoader<Path, FileStatusEntry>(){

            public FileStatusEntry load(Path p) {
                StopWatch w = StopWatch.createStarted();
                long cacheTime = KylinCacheFileSystem.getAcceptCacheTimeLocally();
                FileStatus status = (FileStatus)statusLoader.apply(p);
                log.debug("Slow fs operation took {} ms, now cached at {}: {}({})", new Object[]{w.getTime(), cacheTime, "getFileStatus", p});
                return new FileStatusEntry(p, status, null, cacheTime);
            }
        });
        this.childrenCache = CacheBuilder.newBuilder().maximumSize(maxSize).expireAfterAccess(ttlSec, TimeUnit.SECONDS).recordStats().build((CacheLoader)new CacheLoader<Path, FileStatusEntry>(){

            public FileStatusEntry load(Path p) {
                LocatedFileStatus[] children;
                StopWatch w = StopWatch.createStarted();
                long cacheTime = KylinCacheFileSystem.getAcceptCacheTimeLocally();
                for (LocatedFileStatus child : children = (LocatedFileStatus[])statusListLoader.apply(p)) {
                    ManagerOfCacheFileStatus.this.statusCache.put((Object)child.getPath(), (Object)new FileStatusEntry(child.getPath(), (FileStatus)child, null, cacheTime));
                }
                log.debug("Slow fs operation took {} ms, now cached at {}: got {} files from {}({})", new Object[]{w.getTime(), cacheTime, children.length, "listFileStatus", p});
                return new FileStatusEntry(p, null, children, cacheTime);
            }
        });
    }

    public void ensureCacheCreateTime(Path p, long requiredCacheTime) {
        if (requiredCacheTime <= 0L) {
            return;
        }
        ImmutableList caches = ImmutableList.of(this.statusCache, this.childrenCache);
        for (LoadingCache c : caches) {
            FileStatusEntry entry = (FileStatusEntry)c.asMap().get(p);
            if (entry == null || entry.cacheCreateTime >= requiredCacheTime) continue;
            log.debug("(accept-cache-time:{}) Evict file status cache for {}", (Object)requiredCacheTime, (Object)p);
            c.asMap().remove(p);
            ++this.countOfEvict;
        }
    }

    public FileStatus getFileStatus(Path p) throws IOException {
        try {
            return ((FileStatusEntry)this.statusCache.get((Object)p)).status;
        }
        catch (Exception e) {
            throw ManagerOfCacheFileStatus.makeIOException(e);
        }
    }

    public LocatedFileStatus[] listChildren(Path p) throws IOException {
        try {
            FileStatusEntry entry = (FileStatusEntry)this.childrenCache.get((Object)p);
            log.trace("Return cached at {}: got {} files from {}({})", new Object[]{entry.cacheCreateTime, entry.children.length, "listFileStatus", p});
            return entry.children;
        }
        catch (Exception e) {
            throw ManagerOfCacheFileStatus.makeIOException(e);
        }
    }

    protected static IOException makeIOException(Throwable e) {
        if (e instanceof UncheckedExecutionException || e instanceof ExecutionException) {
            e = e.getCause();
        }
        if (e instanceof IOException) {
            return (IOException)e;
        }
        if (e.getCause() instanceof IOException) {
            return (IOException)e.getCause();
        }
        return new IOException(e);
    }

    public long size() {
        return this.statusCache.size() + this.childrenCache.size();
    }

    public int countEvictions() {
        return this.countOfEvict;
    }

    private static class FileStatusEntry {
        final Path p;
        final FileStatus status;
        final LocatedFileStatus[] children;
        final long cacheCreateTime;

        @Generated
        public FileStatusEntry(Path p, FileStatus status, LocatedFileStatus[] children, long cacheCreateTime) {
            this.p = p;
            this.status = status;
            this.children = children;
            this.cacheCreateTime = cacheCreateTime;
        }
    }
}

