/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.fileseg;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Sets;
import org.apache.curator.shaded.com.google.common.base.Objects;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.KylinRuntimeException;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableMap;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.model.FilePartitionDesc;
import org.apache.kylin.metadata.model.ISegment;
import org.apache.kylin.metadata.model.MultiPartitionDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.PartitionDesc;
import org.apache.kylin.metadata.model.SegmentRange;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableExtDesc;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.spark.SparkContext;
import org.apache.spark.TaskContext;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSegments {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileSegments.class);
    public static String SOURCE_FILTER_KEY = "spark.kylin.fileseg.filter";
    public static String FILE_HASH_SEP = ":";

    public static void setFileSegFilterLocally(NDataSegment seg, FileSegRange segRange) {
        Preconditions.checkState((boolean)SparkSession.getDefaultSession().isDefined());
        SparkContext sparkContext = ((SparkSession)SparkSession.getDefaultSession().get()).sparkContext();
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        String sourceFileDir = FileSegments.getSegSourceFileDir(seg, config);
        String sourceFileHash = String.join((CharSequence)FILE_HASH_SEP, segRange.getFileHash());
        sparkContext.setLocalProperty(FileSegments.pathFilterKey(sourceFileDir), sourceFileHash);
    }

    private static String noEndingSlash(String p) {
        return p.endsWith("/") ? p.substring(0, p.length() - 1) : p;
    }

    private static String pathFilterKey(String path) {
        return SOURCE_FILTER_KEY + "." + FileSegments.noEndingSlash(path);
    }

    public static Optional<SourceFilePredicate> getFileSegFilterLocally(String srcDirPath) {
        String srcFileHash = FileSegments.getSparkLocalProperty(FileSegments.pathFilterKey(srcDirPath), null);
        if (srcFileHash == null) {
            return Optional.empty();
        }
        return Optional.of(new SourceFilePredicate(srcDirPath, Sets.newHashSet((Object[])srcFileHash.split(FILE_HASH_SEP))));
    }

    private static String getSparkLocalProperty(String key, String dft) {
        SparkContext ctx;
        String prop;
        if (TaskContext.get() != null) {
            String prop2 = TaskContext.get().getLocalProperty(key);
            if (prop2 != null) {
                return prop2;
            }
        } else if (SparkSession.getDefaultSession().isDefined() && (prop = (ctx = ((SparkSession)SparkSession.getDefaultSession().get()).sparkContext()).getLocalProperty(key)) != null) {
            return prop;
        }
        return dft;
    }

    public static void clearFileSegFilterLocally() {
        if (SparkSession.getDefaultSession().isDefined()) {
            SparkContext sparkContext = ((SparkSession)SparkSession.getDefaultSession().get()).sparkContext();
            List keys = sparkContext.getLocalProperties().keySet().stream().map(Object::toString).collect(Collectors.toList());
            for (String key : keys) {
                if (!key.startsWith(SOURCE_FILTER_KEY)) continue;
                sparkContext.setLocalProperty(key, null);
            }
        }
    }

    private static String getSegSourceFileDir(NDataSegment seg, KylinConfig config) {
        NTableMetadataManager tableManager = NTableMetadataManager.getInstance((KylinConfig)config, (String)seg.getProject());
        TableDesc rootFactTable = seg.getDataflow().getModel().getRootFactTable().getTableDesc();
        TableExtDesc tableExt = tableManager.getTableExtIfExists(rootFactTable);
        Preconditions.checkNotNull((Object)tableExt);
        String ret = (String)tableExt.getDataSourceProps().get("location");
        Preconditions.checkNotNull((Object)ret);
        return ret;
    }

    public static String computeFileHash(FileStatus file) {
        return file.getPath().getName() + "/" + Long.toString(file.getLen(), 36) + "/" + Long.toString(file.getModificationTime(), 36);
    }

    public static String hashToName(String fileHash) {
        int cut = fileHash.indexOf(47);
        if (cut < 0) {
            throw new IllegalArgumentException("Invalid file hash: " + fileHash);
        }
        return fileHash.substring(0, cut);
    }

    public static boolean isFileSegment(NDataSegment seg) {
        return seg.getSegRange() instanceof FileSegRange;
    }

    public static void forceFileSegments(String project, String modelId, String storageLocation, Optional<List<String>> fileHashOpt, Function<FileSegRange, NDataSegment> segCreator, Function<String, Boolean> segDeleter) {
        List<String> fileHashs;
        KylinConfig config = NProjectManager.getProjectConfig((String)project);
        NDataModelManager modelManager = (NDataModelManager)config.getManager(project, NDataModelManager.class);
        NDataModel model = modelManager.getDataModelDesc(modelId);
        if (model.isBroken()) {
            return;
        }
        if (!model.isFilePartitioned()) {
            FilePartitionDesc newPart = new FilePartitionDesc();
            newPart.setCubePartitionType(PartitionDesc.PartitionType.FILE);
            newPart.setFileStorageLocation(FileSegments.noEndingSlash(storageLocation));
            newPart.setPartitionConditionBuilderClz(FileSegmentConditionBuilder.class.getName());
            newPart.setPartitionDateColumn("");
            newPart.setPartitionDateFormat("yyyy-MM-dd");
            modelManager.updateDataModel(modelId, modelCopy -> modelCopy.setPartitionDesc((PartitionDesc)newPart));
        }
        if (CollectionUtils.isEmpty(fileHashs = FileSegments.filterFileHashs(fileHashOpt, project + "/" + model.getAlias(), config))) {
            return;
        }
        NDataflowManager dfManager = (NDataflowManager)config.getManager(project, NDataflowManager.class);
        NDataflow df = dfManager.getDataflow(modelId);
        if (df.isBroken()) {
            return;
        }
        dfManager.updateDataflow(df.getId(), copy -> copy.setLastDataRefreshTime(System.currentTimeMillis()));
        ImmutableList origSegments = ImmutableList.copyOf((Collection)df.getSegments());
        HashSet<String> latestHashs = new HashSet<String>(fileHashs);
        LinkedHashSet<String> toCreateHashs = new LinkedHashSet<String>(fileHashs);
        ArrayList<String> toDelSegIds = new ArrayList<String>();
        for (NDataSegment nDataSegment : origSegments) {
            if (!FileSegments.isFileSegment(nDataSegment)) {
                toDelSegIds.add(nDataSegment.getId());
                continue;
            }
            List<String> origHash = ((FileSegRange)nDataSegment.getSegRange()).getFileHash();
            if (latestHashs.containsAll(origHash)) {
                toCreateHashs.removeAll(origHash);
                continue;
            }
            toDelSegIds.add(nDataSegment.getId());
        }
        for (String string : toDelSegIds) {
            try {
                segDeleter.apply(string);
            }
            catch (Exception ex) {
                log.error("delete segment failed {}/{}", new Object[]{df.getId(), string, ex});
            }
        }
        FileRangeGenerator gen = new FileRangeGenerator(origSegments.stream().filter(seg -> !toDelSegIds.contains(seg.getId())).collect(Collectors.toList()));
        for (String toCreateHash : toCreateHashs) {
            try {
                segCreator.apply(gen.nextFileSegRange(toCreateHash));
            }
            catch (Exception ex) {
                log.error("create segment failed {}/{}", new Object[]{df.getId(), toCreateHash, ex});
            }
        }
        ModelFileSegments modelFileSegments = FileSegments.getModelFileSegments(project, modelId);
        log.info("Sync file segments for {}/{}, {} created, {} deleted, results {}/{}/{}/{}", new Object[]{project, modelFileSegments.model, toCreateHashs.size(), toDelSegIds.size(), modelFileSegments.summary.get((Object)FileSegStatusEnum.LOADED), modelFileSegments.summary.get((Object)FileSegStatusEnum.LOADING), modelFileSegments.summary.get((Object)FileSegStatusEnum.EXIST), modelFileSegments.summary.get((Object)FileSegStatusEnum.WARNING)});
    }

    private static List<String> filterFileHashs(Optional<List<String>> fileHashOpt, String modelForLog, KylinConfig config) {
        if (!fileHashOpt.isPresent()) {
            return Collections.emptyList();
        }
        List<String> hashList = fileHashOpt.get();
        String successFile = config.getFileSegmentSuccessFile();
        boolean hasSuccessFile = false;
        ArrayList<String> ret = new ArrayList<String>(hashList.size());
        for (String hash : hashList) {
            String fname = FileSegments.hashToName(hash);
            if (fname.equals(successFile)) {
                hasSuccessFile = true;
                continue;
            }
            if (fname.startsWith(".") || fname.startsWith("_")) continue;
            ret.add(hash);
        }
        if (successFile != null && !hasSuccessFile) {
            log.debug("Model {} ignored forceFileSegments() due to missing success file {} from {} detected files", new Object[]{modelForLog, successFile, hashList.size()});
            return Collections.emptyList();
        }
        return ret;
    }

    public static ModelFileSegments getModelFileSegments(String project, String modelId) {
        return FileSegments.getModelFileSegments(project, modelId, false);
    }

    public static ModelFileSegments getModelFileSegments(String project, String modelId, boolean returnDetails) {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        NDataflowManager dfManager = (NDataflowManager)config.getManager(project, NDataflowManager.class);
        NDataflow df = dfManager.getDataflow(modelId);
        Preconditions.checkState((boolean)df.getModel().isFilePartitioned());
        LinkedHashMap<String, Set> fileToSegs = new LinkedHashMap<String, Set>();
        for (NDataSegment seg : df.getSegments()) {
            SegmentRange range = seg.getSegRange();
            if (!(range instanceof FileSegRange)) continue;
            FileSegRange fileRange = (FileSegRange)range;
            for (Object fileHash : fileRange.fileHash) {
                fileToSegs.compute((String)fileHash, (hash, set) -> {
                    if (set == null) {
                        set = new HashSet<NDataSegment>();
                    }
                    set.add(seg);
                    return set;
                });
            }
        }
        ArrayList segStatuses = Lists.newArrayList();
        int loading = 0;
        int loaded = 0;
        int warning = 0;
        int exist = 0;
        for (Map.Entry entry : fileToSegs.entrySet()) {
            FileSegStatusEnum status;
            String fileHash = (String)entry.getKey();
            Set segs = (Set)entry.getValue();
            if (FileSegments.containsSegLike(segs, SegmentStatusEnum.NEW)) {
                status = FileSegStatusEnum.LOADING;
                ++loading;
            } else if (FileSegments.containsSegWithIndex(segs)) {
                status = FileSegStatusEnum.LOADED;
                ++loaded;
            } else if (FileSegments.containsSegLike(segs, SegmentStatusEnum.WARNING)) {
                status = FileSegStatusEnum.WARNING;
                ++warning;
            } else {
                status = FileSegStatusEnum.EXIST;
                ++exist;
            }
            if (!returnDetails) continue;
            segStatuses.add(new FileSegStatus(fileHash, status, 0));
        }
        ImmutableMap summary = ImmutableMap.of((Object)((Object)FileSegStatusEnum.LOADED), (Object)loaded, (Object)((Object)FileSegStatusEnum.LOADING), (Object)loading, (Object)((Object)FileSegStatusEnum.EXIST), (Object)exist, (Object)((Object)FileSegStatusEnum.WARNING), (Object)warning);
        boolean isBuildingIndex = FileSegments.guessIsBuildingIndex(df);
        return new ModelFileSegments(project, df.getModelAlias(), df.getLastDataRefreshTime(), df.getIndexPlan().getLastModified(), loading > 0, isBuildingIndex, false, (Map<FileSegStatusEnum, Integer>)summary, segStatuses);
    }

    public static boolean guessIsBuildingIndex(NDataflow df) {
        Set plannedLayouts = df.getIndexPlan().getAllLayouts().stream().map(LayoutEntity::getId).collect(Collectors.toSet());
        for (NDataSegment seg : df.getSegments()) {
            if (seg.getStatus() == SegmentStatusEnum.NEW) continue;
            if ("FULL_BUILD".equals(seg.getName())) break;
            Map layouts = seg.getLayoutsMap();
            if (layouts != null && layouts.keySet().containsAll(plannedLayouts)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsSegWithIndex(Set<NDataSegment> segs) {
        return segs.stream().anyMatch(seg -> seg.getLayoutSize() > 0);
    }

    private static boolean containsSegLike(Set<NDataSegment> segs, SegmentStatusEnum status) {
        return segs.stream().anyMatch(seg -> seg.getStatus() == status);
    }

    public static String makeSyncFileSegSql(String selectSql) {
        return "select count(*) _SYNC_FILE_SEGMENTS_ from ( " + selectSql + " )";
    }

    public static String makeSyncFileSegSql(List<NDataModel> models) {
        List factTables = models.stream().map(NDataModel::getRootFactTableName).distinct().collect(Collectors.toList());
        return factTables.stream().map(tbl -> "select count(*) _SYNC_FILE_SEGMENTS_ from " + tbl).collect(Collectors.joining(" union all "));
    }

    public static boolean isSyncFileSegSql(String sql) {
        return sql.contains("_SYNC_FILE_SEGMENTS_");
    }

    public static List<NDataModel> findModelsOfFileSeg(String project, List<String> modelAliasOrFactTables) {
        if (modelAliasOrFactTables == null || modelAliasOrFactTables.isEmpty()) {
            return ImmutableList.of();
        }
        List<NDataModel> models = FileSegments.listModelsOfFileSeg(project);
        return models.stream().filter(m -> modelAliasOrFactTables.stream().anyMatch(inp -> m.getAlias().equalsIgnoreCase((String)inp) || m.getRootFactTableName().equalsIgnoreCase((String)inp))).collect(Collectors.toList());
    }

    public static List<NDataModel> listModelsOfFileSeg(String project) {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        NDataflowManager dfManager = (NDataflowManager)config.getManager(project, NDataflowManager.class);
        List models = dfManager.listUnderliningDataModels();
        return models.stream().filter(m -> m.isFilePartitioned() && ((FilePartitionDesc)m.getPartitionDesc()).getFileStorageLocation() != null).collect(Collectors.toList());
    }

    public static class FileSegRange
    extends SegmentRange.TimePartitionedSegmentRange {
        @JsonProperty(value="file_hash")
        private List<String> fileHash;

        protected void checkSameType(SegmentRange<Long> o) {
            Preconditions.checkNotNull(o);
        }

        public SegmentRange<Long> coverWith(SegmentRange<Long> other) {
            FileSegRange o = (FileSegRange)other;
            FileSegRange ret = new FileSegRange();
            ret.start = Long.valueOf(Math.min((Long)this.start, (Long)o.start));
            ret.end = Long.valueOf(Math.max((Long)this.end, (Long)o.end));
            ret.fileHash = new ArrayList<String>();
            ret.fileHash.addAll((Collection)Objects.firstNonNull(this.fileHash, Collections.emptyList()));
            ret.fileHash.addAll((Collection)Objects.firstNonNull(o.fileHash, Collections.emptyList()));
            return ret;
        }

        public String proposeSegmentName() {
            if (this.fileHash == null || this.fileHash.isEmpty()) {
                return null;
            }
            return String.join((CharSequence)"|", this.fileHash);
        }

        @Generated
        public List<String> getFileHash() {
            return this.fileHash;
        }

        @Generated
        public void setFileHash(List<String> fileHash) {
            this.fileHash = fileHash;
        }
    }

    public static class FileSegmentConditionBuilder
    implements PartitionDesc.IPartitionConditionBuilder,
    Serializable {
        public String buildDateRangeCondition(PartitionDesc partDesc, ISegment seg, SegmentRange segRange) {
            FileSegments.setFileSegFilterLocally((NDataSegment)seg, (FileSegRange)segRange);
            return "1=1";
        }

        public String buildMultiPartitionCondition(PartitionDesc partDesc, MultiPartitionDesc multiPartDesc, LinkedList<Long> partitionIds, ISegment seg, SegmentRange segRange) {
            return "1=1";
        }
    }

    public static class SourceFilePredicate {
        final String srcDir;
        final Set<String> srcFileHash;

        public boolean checkFile(LocatedFileStatus f) {
            if (f.isDirectory()) {
                return true;
            }
            String thisFile = FileSegments.computeFileHash((FileStatus)f);
            boolean ok = this.srcFileHash.contains(thisFile);
            if (!ok) {
                log.trace("filtered out file {}, the filter is {}", (Object)thisFile, this.srcFileHash);
            }
            return ok;
        }

        @Generated
        public SourceFilePredicate(String srcDir, Set<String> srcFileHash) {
            this.srcDir = srcDir;
            this.srcFileHash = srcFileHash;
        }
    }

    private static class FileRangeGenerator {
        final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault(Locale.Category.FORMAT));
        int nextStartYear = 2000;

        FileRangeGenerator(List<NDataSegment> origSegments) {
            this.dateFormat.setTimeZone(TimeZone.getDefault());
            Optional<Long> maxEnd = origSegments.stream().map(seg -> (Long)seg.getSegRange().getEnd()).reduce(Math::max);
            maxEnd.ifPresent(millis -> {
                this.nextStartYear = this.yearOf((long)millis);
            });
            if (this.nextStartYear > 22000) {
                this.nextStartYear = 1970;
                log.error("File segments time range running out?? SegIds: " + origSegments.stream().map(seg -> seg.getId()).collect(Collectors.joining(",")));
            }
        }

        private int yearOf(long millis) {
            String format = this.dateFormat.format(new Date(millis));
            int cut = format.indexOf(45);
            return Integer.parseInt(format.substring(0, cut));
        }

        private long millisOf(int year) {
            try {
                return this.dateFormat.parse(year + "-01-01").getTime();
            }
            catch (ParseException e) {
                throw new KylinRuntimeException((Throwable)e);
            }
        }

        public FileSegRange nextFileSegRange(String toCreateHash) {
            FileSegRange ret = new FileSegRange();
            ret.setStart(this.millisOf(this.nextStartYear++));
            ret.setEnd(this.millisOf(this.nextStartYear));
            ret.setFileHash((List<String>)ImmutableList.of((Object)toCreateHash));
            return ret;
        }
    }

    public static class FileSegStatus {
        @JsonProperty(value="file_hash")
        private String fileHash;
        @JsonProperty(value="status")
        private FileSegStatusEnum status;
        @JsonProperty(value="progress_bar")
        private Integer progressBar;

        @Generated
        public String getFileHash() {
            return this.fileHash;
        }

        @Generated
        public FileSegStatusEnum getStatus() {
            return this.status;
        }

        @Generated
        public Integer getProgressBar() {
            return this.progressBar;
        }

        @Generated
        public void setFileHash(String fileHash) {
            this.fileHash = fileHash;
        }

        @Generated
        public void setStatus(FileSegStatusEnum status) {
            this.status = status;
        }

        @Generated
        public void setProgressBar(Integer progressBar) {
            this.progressBar = progressBar;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FileSegStatus)) {
                return false;
            }
            FileSegStatus other = (FileSegStatus)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$fileHash = this.getFileHash();
            String other$fileHash = other.getFileHash();
            if (this$fileHash == null ? other$fileHash != null : !this$fileHash.equals(other$fileHash)) {
                return false;
            }
            FileSegStatusEnum this$status = this.getStatus();
            FileSegStatusEnum other$status = other.getStatus();
            if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
                return false;
            }
            Integer this$progressBar = this.getProgressBar();
            Integer other$progressBar = other.getProgressBar();
            return !(this$progressBar == null ? other$progressBar != null : !((Object)this$progressBar).equals(other$progressBar));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof FileSegStatus;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $fileHash = this.getFileHash();
            result = result * 59 + ($fileHash == null ? 43 : $fileHash.hashCode());
            FileSegStatusEnum $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
            Integer $progressBar = this.getProgressBar();
            result = result * 59 + ($progressBar == null ? 43 : ((Object)$progressBar).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FileSegments.FileSegStatus(fileHash=" + this.getFileHash() + ", status=" + (Object)((Object)this.getStatus()) + ", progressBar=" + this.getProgressBar() + ")";
        }

        @Generated
        public FileSegStatus() {
        }

        @Generated
        public FileSegStatus(String fileHash, FileSegStatusEnum status, Integer progressBar) {
            this.fileHash = fileHash;
            this.status = status;
            this.progressBar = progressBar;
        }
    }

    public static class ModelFileSegments {
        @JsonProperty(value="project")
        private String project;
        @JsonProperty(value="model")
        private String model;
        @JsonProperty(value="last_data_refresh_time")
        private long lastDataRefreshTime;
        @JsonProperty(value="last_index_refresh_time")
        private long lastIndexRefreshTime;
        @JsonProperty(value="is_loading_data")
        private boolean isLoadingData;
        @JsonProperty(value="is_building_index")
        private boolean isBuildingIndex;
        @JsonProperty(value="is_broken")
        private boolean isBroken;
        @JsonProperty(value="summary")
        private Map<FileSegStatusEnum, Integer> summary;
        @JsonProperty(value="segments")
        private List<FileSegStatus> segments;

        public static ModelFileSegments broken(String project, String modelAlias) {
            ModelFileSegments ret = new ModelFileSegments();
            ret.setProject(project);
            ret.setModel(modelAlias);
            ret.setBroken(true);
            return ret;
        }

        @Generated
        public String getProject() {
            return this.project;
        }

        @Generated
        public String getModel() {
            return this.model;
        }

        @Generated
        public long getLastDataRefreshTime() {
            return this.lastDataRefreshTime;
        }

        @Generated
        public long getLastIndexRefreshTime() {
            return this.lastIndexRefreshTime;
        }

        @Generated
        public boolean isLoadingData() {
            return this.isLoadingData;
        }

        @Generated
        public boolean isBuildingIndex() {
            return this.isBuildingIndex;
        }

        @Generated
        public boolean isBroken() {
            return this.isBroken;
        }

        @Generated
        public Map<FileSegStatusEnum, Integer> getSummary() {
            return this.summary;
        }

        @Generated
        public List<FileSegStatus> getSegments() {
            return this.segments;
        }

        @Generated
        public void setProject(String project) {
            this.project = project;
        }

        @Generated
        public void setModel(String model) {
            this.model = model;
        }

        @Generated
        public void setLastDataRefreshTime(long lastDataRefreshTime) {
            this.lastDataRefreshTime = lastDataRefreshTime;
        }

        @Generated
        public void setLastIndexRefreshTime(long lastIndexRefreshTime) {
            this.lastIndexRefreshTime = lastIndexRefreshTime;
        }

        @Generated
        public void setLoadingData(boolean isLoadingData) {
            this.isLoadingData = isLoadingData;
        }

        @Generated
        public void setBuildingIndex(boolean isBuildingIndex) {
            this.isBuildingIndex = isBuildingIndex;
        }

        @Generated
        public void setBroken(boolean isBroken) {
            this.isBroken = isBroken;
        }

        @Generated
        public void setSummary(Map<FileSegStatusEnum, Integer> summary) {
            this.summary = summary;
        }

        @Generated
        public void setSegments(List<FileSegStatus> segments) {
            this.segments = segments;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ModelFileSegments)) {
                return false;
            }
            ModelFileSegments other = (ModelFileSegments)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$project = this.getProject();
            String other$project = other.getProject();
            if (this$project == null ? other$project != null : !this$project.equals(other$project)) {
                return false;
            }
            String this$model = this.getModel();
            String other$model = other.getModel();
            if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
                return false;
            }
            if (this.getLastDataRefreshTime() != other.getLastDataRefreshTime()) {
                return false;
            }
            if (this.getLastIndexRefreshTime() != other.getLastIndexRefreshTime()) {
                return false;
            }
            if (this.isLoadingData() != other.isLoadingData()) {
                return false;
            }
            if (this.isBuildingIndex() != other.isBuildingIndex()) {
                return false;
            }
            if (this.isBroken() != other.isBroken()) {
                return false;
            }
            Map<FileSegStatusEnum, Integer> this$summary = this.getSummary();
            Map<FileSegStatusEnum, Integer> other$summary = other.getSummary();
            if (this$summary == null ? other$summary != null : !((Object)this$summary).equals(other$summary)) {
                return false;
            }
            List<FileSegStatus> this$segments = this.getSegments();
            List<FileSegStatus> other$segments = other.getSegments();
            return !(this$segments == null ? other$segments != null : !((Object)this$segments).equals(other$segments));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ModelFileSegments;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $project = this.getProject();
            result = result * 59 + ($project == null ? 43 : $project.hashCode());
            String $model = this.getModel();
            result = result * 59 + ($model == null ? 43 : $model.hashCode());
            long $lastDataRefreshTime = this.getLastDataRefreshTime();
            result = result * 59 + (int)($lastDataRefreshTime >>> 32 ^ $lastDataRefreshTime);
            long $lastIndexRefreshTime = this.getLastIndexRefreshTime();
            result = result * 59 + (int)($lastIndexRefreshTime >>> 32 ^ $lastIndexRefreshTime);
            result = result * 59 + (this.isLoadingData() ? 79 : 97);
            result = result * 59 + (this.isBuildingIndex() ? 79 : 97);
            result = result * 59 + (this.isBroken() ? 79 : 97);
            Map<FileSegStatusEnum, Integer> $summary = this.getSummary();
            result = result * 59 + ($summary == null ? 43 : ((Object)$summary).hashCode());
            List<FileSegStatus> $segments = this.getSegments();
            result = result * 59 + ($segments == null ? 43 : ((Object)$segments).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FileSegments.ModelFileSegments(project=" + this.getProject() + ", model=" + this.getModel() + ", lastDataRefreshTime=" + this.getLastDataRefreshTime() + ", lastIndexRefreshTime=" + this.getLastIndexRefreshTime() + ", isLoadingData=" + this.isLoadingData() + ", isBuildingIndex=" + this.isBuildingIndex() + ", isBroken=" + this.isBroken() + ", summary=" + this.getSummary() + ", segments=" + this.getSegments() + ")";
        }

        @Generated
        public ModelFileSegments() {
        }

        @Generated
        public ModelFileSegments(String project, String model, long lastDataRefreshTime, long lastIndexRefreshTime, boolean isLoadingData, boolean isBuildingIndex, boolean isBroken, Map<FileSegStatusEnum, Integer> summary, List<FileSegStatus> segments) {
            this.project = project;
            this.model = model;
            this.lastDataRefreshTime = lastDataRefreshTime;
            this.lastIndexRefreshTime = lastIndexRefreshTime;
            this.isLoadingData = isLoadingData;
            this.isBuildingIndex = isBuildingIndex;
            this.isBroken = isBroken;
            this.summary = summary;
            this.segments = segments;
        }
    }

    public static enum FileSegStatusEnum {
        LOADED,
        LOADING,
        EXIST,
        WARNING;

    }
}

