/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.cache.refresh;

import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.apache.linkis.manager.engineplugin.common.loader.entity.EngineConnPluginInfo;
import org.apache.linkis.manager.engineplugin.common.loader.entity.EngineConnPluginInstance;

public class RefreshPluginCacheOperation
implements Delayed {
    private AtomicLong triggerTime = new AtomicLong(0L);
    private TimeUnit timeUnit = TimeUnit.SECONDS;
    private long duration = 0L;
    private EngineConnPluginInfo pluginInfo;
    private Function<EngineConnPluginInfo, EngineConnPluginInstance> operation;

    public RefreshPluginCacheOperation(Function<EngineConnPluginInfo, EngineConnPluginInstance> operation) {
        this.operation = operation;
        this.triggerTime.set(System.currentTimeMillis());
    }

    void setDuration(long duration) {
        this.duration = duration;
    }

    void setTimeUnit(TimeUnit timeUnit) {
        if (null != timeUnit) {
            this.timeUnit = timeUnit;
        }
    }

    String cacheStringKey() {
        return this.pluginInfo != null ? this.pluginInfo.toString() : null;
    }

    EngineConnPluginInfo pluginInfo() {
        return this.pluginInfo;
    }

    void setPluginInfo(EngineConnPluginInfo pluginInfo) {
        this.pluginInfo = pluginInfo;
    }

    public Function<EngineConnPluginInfo, EngineConnPluginInstance> getOperation() {
        return this.operation;
    }

    public void nextTime() {
        this.triggerTime.addAndGet(TimeUnit.MILLISECONDS.convert(this.duration, this.timeUnit));
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(this.triggerTime.get() - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public int compareTo(Delayed o) {
        if (o instanceof RefreshPluginCacheOperation) {
            return (int)(this.triggerTime.get() - ((RefreshPluginCacheOperation)o).triggerTime.get());
        }
        return -1;
    }
}

