/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.spark.datacalc.sink;

import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.engineplugin.spark.datacalc.api.DataCalcPlugin;
import org.apache.linkis.engineplugin.spark.datacalc.api.DataCalcSink;
import org.apache.linkis.engineplugin.spark.datacalc.exception.ElasticsearchSinkException;
import org.apache.linkis.engineplugin.spark.datacalc.model.SinkConfig;
import org.apache.linkis.engineplugin.spark.datacalc.sink.ElasticsearchSinkConfig;
import org.apache.linkis.engineplugin.spark.errorcode.SparkErrorCodeSummary;
import org.apache.spark.sql.DataFrameWriter;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u00113Aa\u0001\u0003\u0001'!)A\u0006\u0001C\u0001[!)q\u0006\u0001C\u0001a\t\tR\t\\1ti&\u001c7/Z1sG\"\u001c\u0016N\\6\u000b\u0005\u00151\u0011\u0001B:j].T!a\u0002\u0005\u0002\u0011\u0011\fG/Y2bY\u000eT!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011\u0001D3oO&tW\r\u001d7vO&t'BA\u0007\u000f\u0003\u0019a\u0017N\\6jg*\u0011q\u0002E\u0001\u0007CB\f7\r[3\u000b\u0003E\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\u000b\u001bIA\u0011Q\u0003G\u0007\u0002-)\tq#A\u0003tG\u0006d\u0017-\u0003\u0002\u001a-\t1\u0011I\\=SK\u001a\u00042a\u0007\u0010!\u001b\u0005a\"BA\u000f\u0007\u0003\r\t\u0007/[\u0005\u0003?q\u0011A\u0002R1uC\u000e\u000bGnY*j].\u0004\"!\t\u0012\u000e\u0003\u0011I!a\t\u0003\u0003/\u0015c\u0017m\u001d;jGN,\u0017M]2i'&t7nQ8oM&<\u0007CA\u0013+\u001b\u00051#BA\u0014)\u0003\u0015)H/\u001b7t\u0015\tIC\"\u0001\u0004d_6lwN\\\u0005\u0003W\u0019\u0012q\u0001T8hO&tw-\u0001\u0004=S:LGO\u0010\u000b\u0002]A\u0011\u0011\u0005A\u0001\u0007_V$\b/\u001e;\u0015\u0007E\"D\b\u0005\u0002\u0016e%\u00111G\u0006\u0002\u0005+:LG\u000fC\u0003\n\u0005\u0001\u0007Q\u0007\u0005\u00027u5\tqG\u0003\u00029s\u0005\u00191/\u001d7\u000b\u0005%q\u0011BA\u001e8\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0011\u0015i$\u00011\u0001?\u0003\t!7\u000fE\u00027\u007f\u0005K!\u0001Q\u001c\u0003\u000f\u0011\u000bG/Y:fiB\u0011aGQ\u0005\u0003\u0007^\u00121AU8x\u0001")
public class ElasticsearchSink
implements DataCalcSink<ElasticsearchSinkConfig>,
Logging {
    private Logger logger;
    private ElasticsearchSinkConfig config;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    @Override
    public Object getConfig() {
        return DataCalcPlugin.getConfig$(this);
    }

    @Override
    public void setConfig(Object config) {
        DataCalcPlugin.setConfig$(this, config);
    }

    @Override
    public void prepare(SparkSession spark) {
        DataCalcPlugin.prepare$(this, spark);
    }

    private Logger logger$lzycompute() {
        ElasticsearchSink elasticsearchSink = this;
        synchronized (elasticsearchSink) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public ElasticsearchSinkConfig config() {
        return this.config;
    }

    @Override
    public void config_$eq(ElasticsearchSinkConfig x$1) {
        this.config = x$1;
    }

    @Override
    public void output(SparkSession spark, Dataset<Row> ds) {
        scala.collection.immutable.Map options = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"es.index.auto.create"), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"es.nodes.wan.only"), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"es.nodes"), (Object)((ElasticsearchSinkConfig)this.config()).getNode()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"es.port"), (Object)((ElasticsearchSinkConfig)this.config()).getPort()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"es.net.http.auth.user"), (Object)((ElasticsearchSinkConfig)this.config()).getUser()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"es.net.http.auth.pass"), (Object)((ElasticsearchSinkConfig)this.config()).getPassword())}));
        if (((SinkConfig)this.config()).getOptions() != null && !((SinkConfig)this.config()).getOptions().isEmpty()) {
            options = ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(((SinkConfig)this.config()).getOptions()).asScala()).toMap(Predef$.MODULE$.$conforms()).$plus$plus((GenTraversableOnce)options);
        }
        if (((ElasticsearchSinkConfig)this.config()).getSaveMode().equalsIgnoreCase("upsert")) {
            if (StringUtils.isBlank((CharSequence)((ElasticsearchSinkConfig)this.config()).getPrimaryKey())) {
                throw new ElasticsearchSinkException(SparkErrorCodeSummary.DATA_CALC_VARIABLE_NOT_EXIST.getErrorCode(), "saveMode is upsert, please set elasticsearch mapping [primaryKey] in variables");
            }
            options = options.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"es.write.operation"), (Object)"upsert"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"es.mapping.id"), (Object)((ElasticsearchSinkConfig)this.config()).getPrimaryKey())})));
            ((ElasticsearchSinkConfig)this.config()).setSaveMode("append");
        }
        DataFrameWriter writer = ds.write().format("org.elasticsearch.spark.sql");
        Object object = StringUtils.isNotBlank((CharSequence)((ElasticsearchSinkConfig)this.config()).getSaveMode()) ? writer.mode(((ElasticsearchSinkConfig)this.config()).getSaveMode()) : BoxedUnit.UNIT;
        this.logger().info(new StringBuilder(51).append("Load data to elasticsearch nodes: ").append(((ElasticsearchSinkConfig)this.config()).getNode()).append(", port: ").append(((ElasticsearchSinkConfig)this.config()).getPort()).append(", index: ").append(((ElasticsearchSinkConfig)this.config()).getIndex()).toString());
        writer.options((Map)options).save(new StringBuilder(1).append(((ElasticsearchSinkConfig)this.config()).getIndex()).append("/").append(((ElasticsearchSinkConfig)this.config()).getType()).toString());
    }

    public ElasticsearchSink() {
        DataCalcPlugin.$init$(this);
        Logging.$init$((Logging)this);
    }
}

