/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.implementation.models;

import com.azure.core.util.CoreUtils;
import com.azure.storage.blob.implementation.models.BlobItemInternal;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class BlobFlatListSegment
implements XmlSerializable<BlobFlatListSegment> {
    private List<BlobItemInternal> blobItems = new ArrayList<BlobItemInternal>();

    public List<BlobItemInternal> getBlobItems() {
        return this.blobItems;
    }

    public BlobFlatListSegment setBlobItems(List<BlobItemInternal> blobItems) {
        this.blobItems = blobItems;
        return this;
    }

    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "Blobs" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        if (this.blobItems != null) {
            for (BlobItemInternal element : this.blobItems) {
                xmlWriter.writeXml((XmlSerializable)element, "Blob");
            }
        }
        return xmlWriter.writeEndElement();
    }

    public static BlobFlatListSegment fromXml(XmlReader xmlReader) throws XMLStreamException {
        return BlobFlatListSegment.fromXml(xmlReader, null);
    }

    public static BlobFlatListSegment fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "Blobs" : rootElementName;
        return (BlobFlatListSegment)xmlReader.readObject(finalRootElementName, reader -> {
            BlobFlatListSegment deserializedBlobFlatListSegment = new BlobFlatListSegment();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("Blob".equals(elementName.getLocalPart())) {
                    if (deserializedBlobFlatListSegment.blobItems == null) {
                        deserializedBlobFlatListSegment.blobItems = new ArrayList<BlobItemInternal>();
                    }
                    deserializedBlobFlatListSegment.blobItems.add(BlobItemInternal.fromXml(reader, "Blob"));
                    continue;
                }
                reader.skipElement();
            }
            return deserializedBlobFlatListSegment;
        });
    }
}

