/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.rpc.message.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.linkis.DataWorkCloudApplication;
import org.apache.linkis.rpc.message.method.MethodExecuteWrapper;
import org.apache.linkis.rpc.message.parser.ServiceMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;

public class MessageUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageUtils.class);

    public static <T> T getBean(Class<T> tClass) {
        Object t = null;
        ApplicationContext applicationContext = DataWorkCloudApplication.getApplicationContext();
        if (applicationContext != null) {
            try {
                t = applicationContext.getBean(tClass);
            }
            catch (NoSuchBeanDefinitionException e) {
                LOGGER.warn(String.format("can not get bean from spring ioc:%s", tClass.getName()));
            }
        }
        return (T)t;
    }

    public static boolean isAssignableFrom(String supperClassName, String className) {
        try {
            return Class.forName(supperClassName).isAssignableFrom(Class.forName(className));
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("class not found", (Throwable)e);
            return false;
        }
    }

    public static List<MethodExecuteWrapper> getMinOrders(List<MethodExecuteWrapper> methodExecuteWrappers) {
        if (methodExecuteWrappers == null || methodExecuteWrappers.isEmpty()) {
            return Collections.emptyList();
        }
        MethodExecuteWrapper minOrderMethodExecute = methodExecuteWrappers.get(0);
        for (MethodExecuteWrapper tmp : methodExecuteWrappers) {
            if (tmp.getOrder() >= minOrderMethodExecute.getOrder()) continue;
            minOrderMethodExecute = tmp;
        }
        ArrayList<MethodExecuteWrapper> result = new ArrayList<MethodExecuteWrapper>();
        for (MethodExecuteWrapper tmp : methodExecuteWrappers) {
            if (tmp.getOrder() != minOrderMethodExecute.getOrder()) continue;
            result.add(tmp);
        }
        return result;
    }

    public static boolean orderIsLast(int order, List<ServiceMethod> serviceMethods) {
        if (order == Integer.MAX_VALUE) {
            return true;
        }
        for (ServiceMethod serviceMethod : serviceMethods) {
            if (serviceMethod.getOrder() <= order) continue;
            return false;
        }
        return true;
    }

    public static Integer repeatOrder(List<ServiceMethod> serviceMethods) {
        HashSet<Integer> tmp = new HashSet<Integer>();
        for (ServiceMethod serviceMethod : serviceMethods) {
            int order = serviceMethod.getOrder();
            if (tmp.contains(order)) {
                return order;
            }
            tmp.add(order);
        }
        return null;
    }
}

