/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.metrics;

import com.codahale.metrics.Timer;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hive.metastore.metrics.Metrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerfLogger {
    protected final Map<String, Long> startTimes = new HashMap<String, Long>();
    protected final Map<String, Long> endTimes = new HashMap<String, Long>();
    private static final Logger LOG = LoggerFactory.getLogger((String)PerfLogger.class.getName());
    protected static final ThreadLocal<PerfLogger> perfLogger = new ThreadLocal();
    protected transient Map<String, Timer.Context> timerContexts = new HashMap<String, Timer.Context>();

    private PerfLogger() {
    }

    public static PerfLogger getPerfLogger(boolean resetPerfLogger) {
        PerfLogger result = perfLogger.get();
        if (resetPerfLogger || result == null) {
            result = new PerfLogger();
            perfLogger.set(result);
        }
        return result;
    }

    public static void setPerfLogger(PerfLogger resetPerfLogger) {
        perfLogger.set(resetPerfLogger);
    }

    public void PerfLogBegin(String callerName, String method) {
        long startTime = System.currentTimeMillis();
        this.startTimes.put(method, new Long(startTime));
        if (LOG.isDebugEnabled()) {
            LOG.debug("<PERFLOG method=" + method + " from=" + callerName + ">");
        }
        this.beginMetrics(method);
    }

    public long PerfLogEnd(String callerName, String method) {
        return this.PerfLogEnd(callerName, method, null);
    }

    public long PerfLogEnd(String callerName, String method, String additionalInfo) {
        long duration;
        Long startTime = this.startTimes.get(method);
        long endTime = System.currentTimeMillis();
        this.endTimes.put(method, new Long(endTime));
        long l = duration = startTime == null ? -1L : endTime - startTime;
        if (LOG.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder("</PERFLOG method=").append(method);
            if (startTime != null) {
                sb.append(" start=").append(startTime);
            }
            sb.append(" end=").append(endTime);
            if (startTime != null) {
                sb.append(" duration=").append(duration);
            }
            sb.append(" from=").append(callerName);
            if (additionalInfo != null) {
                sb.append(" ").append(additionalInfo);
            }
            sb.append(">");
            LOG.debug(sb.toString());
        }
        this.endMetrics(method);
        return duration;
    }

    public Long getStartTime(String method) {
        long startTime = 0L;
        if (this.startTimes.containsKey(method)) {
            startTime = this.startTimes.get(method);
        }
        return startTime;
    }

    public Long getEndTime(String method) {
        long endTime = 0L;
        if (this.endTimes.containsKey(method)) {
            endTime = this.endTimes.get(method);
        }
        return endTime;
    }

    public boolean startTimeHasMethod(String method) {
        return this.startTimes.containsKey(method);
    }

    public boolean endTimeHasMethod(String method) {
        return this.endTimes.containsKey(method);
    }

    public Long getDuration(String method) {
        long duration = 0L;
        if (this.startTimes.containsKey(method) && this.endTimes.containsKey(method)) {
            duration = this.endTimes.get(method) - this.startTimes.get(method);
        }
        return duration;
    }

    public ImmutableMap<String, Long> getStartTimes() {
        return ImmutableMap.copyOf(this.startTimes);
    }

    public ImmutableMap<String, Long> getEndTimes() {
        return ImmutableMap.copyOf(this.endTimes);
    }

    private void beginMetrics(String method) {
        Timer timer = Metrics.getOrCreateTimer("api_" + method);
        if (timer != null) {
            this.timerContexts.put(method, timer.time());
        }
    }

    private void endMetrics(String method) {
        Timer.Context context = this.timerContexts.remove(method);
        if (context != null) {
            context.close();
        }
    }

    public void cleanupPerfLogMetrics() {
        for (Timer.Context context : this.timerContexts.values()) {
            context.close();
        }
        this.timerContexts.clear();
    }
}

