/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.monitor.jobhistory.jobtime;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.monitor.config.MonitorConfig;
import org.apache.linkis.monitor.core.ob.Event;
import org.apache.linkis.monitor.core.ob.Observer;
import org.apache.linkis.monitor.jobhistory.entity.JobHistory;
import org.apache.linkis.monitor.jobhistory.exception.AnomalyScannerException;
import org.apache.linkis.monitor.jobhistory.jobtime.JobTimeExceedHitEvent;
import org.apache.linkis.monitor.utils.alert.AlertDesc;
import org.apache.linkis.monitor.utils.alert.ims.ImsAlertDesc;
import org.apache.linkis.monitor.utils.alert.ims.PooledImsAlertUtils$;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.LongRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r4AAB\u0004\u0001)!A1\u0006\u0001B\u0001B\u0003%A\u0006C\u0003G\u0001\u0011\u0005q\tC\u0004L\u0001\t\u0007I\u0011\u0002'\t\rM\u0003\u0001\u0015!\u0003N\u0011\u0015!\u0006\u0001\"\u0011V\u0005aQuN\u0019+j[\u0016,\u0005pY3fI\u0006cWM\u001d;TK:$WM\u001d\u0006\u0003\u0011%\tqA[8ci&lWM\u0003\u0002\u000b\u0017\u0005Q!n\u001c2iSN$xN]=\u000b\u00051i\u0011aB7p]&$xN\u001d\u0006\u0003\u001d=\ta\u0001\\5oW&\u001c(B\u0001\t\u0012\u0003\u0019\t\u0007/Y2iK*\t!#A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001+m\u0019\u0003C\u0001\f\u001a\u001b\u00059\"\"\u0001\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005i9\"AB!osJ+g\r\u0005\u0002\u001dC5\tQD\u0003\u0002\u001f?\u0005\u0011qN\u0019\u0006\u0003A-\tAaY8sK&\u0011!%\b\u0002\t\u001f\n\u001cXM\u001d<feB\u0011A%K\u0007\u0002K)\u0011aeJ\u0001\u0006kRLGn\u001d\u0006\u0003Q5\taaY8n[>t\u0017B\u0001\u0016&\u0005\u001daunZ4j]\u001e\fa!\u00197feR\u001c\b\u0003B\u00173i}j\u0011A\f\u0006\u0003_A\nA!\u001e;jY*\t\u0011'\u0001\u0003kCZ\f\u0017BA\u001a/\u0005\ri\u0015\r\u001d\t\u0003kqr!A\u000e\u001e\u0011\u0005]:R\"\u0001\u001d\u000b\u0005e\u001a\u0012A\u0002\u001fs_>$h(\u0003\u0002</\u00051\u0001K]3eK\u001aL!!\u0010 \u0003\rM#(/\u001b8h\u0015\tYt\u0003\u0005\u0002A\t6\t\u0011I\u0003\u0002C\u0007\u0006)\u0011\r\\3si*\u0011aeC\u0005\u0003\u000b\u0006\u0013\u0011\"\u00117feR$Um]2\u0002\rqJg.\u001b;?)\tA%\n\u0005\u0002J\u00015\tq\u0001C\u0003,\u0005\u0001\u0007A&A\tpe\u0012,'/\u001a3UQJ,7\u000f[8mIN,\u0012!\u0014\t\u0004-9\u0003\u0016BA(\u0018\u0005\u0015\t%O]1z!\t1\u0012+\u0003\u0002S/\t!Aj\u001c8h\u0003Iy'\u000fZ3sK\u0012$\u0006N]3tQ>dGm\u001d\u0011\u0002\rU\u0004H-\u0019;f)\r1\u0016L\u0018\t\u0003-]K!\u0001W\f\u0003\tUs\u0017\u000e\u001e\u0005\u00065\u0016\u0001\raW\u0001\u0002KB\u0011A\u0004X\u0005\u0003;v\u0011Q!\u0012<f]RDQaX\u0003A\u0002\u0001\faB[8c\u0011&\u001cHo\u001c:z\u0019&\u001cH\u000f\u0005\u0002\u0017C&\u0011!m\u0006\u0002\u0004\u0003:L\b")
public class JobTimeExceedAlertSender
implements Observer,
Logging {
    private final Map<String, AlertDesc> alerts;
    private final long[] orderedThresholds;
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        JobTimeExceedAlertSender jobTimeExceedAlertSender = this;
        synchronized (jobTimeExceedAlertSender) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private long[] orderedThresholds() {
        return this.orderedThresholds;
    }

    @Override
    public void update(Event e, Object jobHistoryList) {
        if (!(e instanceof JobTimeExceedHitEvent)) {
            throw new AnomalyScannerException(21304, new StringBuilder(68).append("Wrong event that triggers JobTimeExceedAlertSender. Input DataType: ").append(e.getClass().getCanonicalName()).toString());
        }
        if (jobHistoryList == null || !(jobHistoryList instanceof List)) {
            throw new AnomalyScannerException(21304, new StringBuilder(58).append("Wrong input for JobTimeExceedAlertSender. Input DataType: ").append(jobHistoryList.getClass().getCanonicalName()).toString());
        }
        if (this.orderedThresholds().length == 0) {
            this.logger().warn(new StringBuilder(53).append("Found none legal threshold, will not send any alert: ").append(this).toString());
            return;
        }
        HashMap toSend = new HashMap();
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)jobHistoryList).asScala()).foreach((Function1 & Serializable & scala.Serializable)a -> {
            JobTimeExceedAlertSender.$anonfun$update$1(this, toSend, a);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$orderedThresholds$3(JobTimeExceedAlertSender $this, String k$1, Throwable t) {
        $this.logger().warn(new StringBuilder(27).append("Ignored illegal threshold: ").append(k$1).toString(), t);
    }

    public static final /* synthetic */ void $anonfun$update$1(JobTimeExceedAlertSender $this, HashMap toSend$1, Object a) {
        if (a == null) {
            $this.logger().warn("Ignore null input data");
            return;
        }
        if (!(a instanceof JobHistory)) {
            $this.logger().warn(new StringBuilder(31).append("Ignore wrong input data Type : ").append(a.getClass().getCanonicalName()).toString());
            return;
        }
        JobHistory jobHistory = (JobHistory)a;
        long elapse = System.currentTimeMillis() - jobHistory.getCreatedTime().getTime();
        LongRef ts = LongRef.create((long)0L);
        new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps($this.orderedThresholds())).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)t -> {
            if (elapse >= t) {
                ts$1.elem = t;
                return;
            }
        });
        String name = Long.toString(ts.elem);
        ImsAlertDesc alert = !toSend$1.containsKey(name) ? (ImsAlertDesc)$this.alerts.get(name) : (ImsAlertDesc)toSend$1.get(name);
        String newInfo = MessageFormat.format((String)MonitorConfig.TASK_RUNTIME_TIMEOUT_DESC.getValue(), jobHistory.getId(), Long.toString(elapse / 1000L / 60L / 60L), jobHistory.getInstances(), MonitorConfig.SOLUTION_URL.getValue());
        int newNumHit = alert.numHit() + 1;
        HashSet<String> receiver = new HashSet<String>();
        receiver.add(jobHistory.getSubmitUser());
        receiver.add(jobHistory.getExecuteUser());
        String x$1 = newInfo;
        HashSet<String> x$2 = receiver;
        int x$3 = newNumHit;
        String x$4 = alert.copy$default$1();
        String x$5 = alert.copy$default$2();
        String x$6 = alert.copy$default$3();
        Enumeration.Value x$7 = alert.copy$default$5();
        String x$8 = alert.copy$default$6();
        int x$9 = alert.copy$default$7();
        Set<Enumeration.Value> x$10 = alert.copy$default$8();
        Set<String> x$11 = alert.copy$default$10();
        long x$12 = alert.copy$default$12();
        ImsAlertDesc ImsAlertDesc2 = alert.copy(x$4, x$5, x$6, x$1, x$7, x$8, x$9, x$10, x$2, x$11, x$3, x$12);
        PooledImsAlertUtils$.MODULE$.addAlert(ImsAlertDesc2);
    }

    public JobTimeExceedAlertSender(Map<String, AlertDesc> alerts) {
        this.alerts = alerts;
        Logging.$init$((Logging)this);
        ArrayBuffer ret = new ArrayBuffer();
        if (alerts != null) {
            ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(alerts.keySet()).asScala()).foreach((Function1 & Serializable & scala.Serializable)k -> {
                Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ret.append((Seq)Predef$.MODULE$.wrapLongArray(new long[]{new StringOps(Predef$.MODULE$.augmentString(k)).toLong()})), (Function1 & Serializable & scala.Serializable)t -> {
                    JobTimeExceedAlertSender.$anonfun$orderedThresholds$3($this, k, t);
                    return BoxedUnit.UNIT;
                });
                return BoxedUnit.UNIT;
            });
        }
        this.orderedThresholds = (long[])ret.toArray(ClassTag$.MODULE$.Long());
    }
}

