/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineconn.computation.executor.utlis;

import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessControlContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;

public class JarLoader
extends URLClassLoader {
    private AccessControlContext acc;

    public JarLoader(String[] paths) {
        this(paths, false);
    }

    public JarLoader(String[] paths, boolean recursive) {
        this(paths, recursive, JarLoader.class.getClassLoader());
    }

    public JarLoader(String[] paths, boolean recursive, ClassLoader parent) {
        super(JarLoader.getURLs(paths, recursive), parent);
    }

    private static URL[] getURLs(String[] paths, boolean recursive) {
        ArrayList<URL> urls = new ArrayList<URL>();
        if (recursive) {
            ArrayList<String> dirs = new ArrayList<String>();
            for (String path : paths) {
                dirs.add(path);
                JarLoader.collectDirs(path, dirs);
            }
            for (String path : dirs) {
                urls.addAll(JarLoader.doGetURLs(path));
            }
        } else {
            urls.addAll(Arrays.stream(paths).map(File::new).filter(File::exists).map(f -> {
                try {
                    return f.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    return null;
                }
            }).collect(Collectors.toList()));
        }
        return urls.toArray(new URL[0]);
    }

    public void addJarURL(String path) {
        File singleJar = new File(path);
        if (singleJar.exists() && singleJar.isFile()) {
            try {
                this.addURL(singleJar.toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }

    private static void collectDirs(String path, List<String> collector) {
        File current = new File(path);
        if (!current.exists() || !current.isDirectory()) {
            return;
        }
        if (null != current.listFiles()) {
            for (File child : Objects.requireNonNull(current.listFiles())) {
                if (!child.isDirectory()) continue;
                collector.add(child.getAbsolutePath());
                JarLoader.collectDirs(child.getAbsolutePath(), collector);
            }
        }
    }

    private static List<URL> doGetURLs(String path) {
        File jarPath = new File(path);
        Validate.isTrue((jarPath.exists() && jarPath.isDirectory() ? 1 : 0) != 0, (String)"jar\u5305\u8def\u5f84\u5fc5\u987b\u5b58\u5728\u4e14\u4e3a\u76ee\u5f55.", (Object[])new Object[0]);
        FileFilter jarFilter = pathname -> pathname.getName().endsWith(".jar");
        File[] allJars = new File(path).listFiles(jarFilter);
        assert (allJars != null);
        ArrayList<URL> jarURLs = new ArrayList<URL>(allJars.length);
        for (File allJar : allJars) {
            try {
                jarURLs.add(allJar.toURI().toURL());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return jarURLs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> c = this.findLoadedClass(name);
            if (c == null) {
                long t0 = System.nanoTime();
                try {
                    c = this.findClass(name);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (c == null) {
                    return super.loadClass(name, resolve);
                }
            }
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }
    }
}

