/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.test;

import java.util.Objects;
import java.util.function.Supplier;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class SystemPropertyTestRule
implements TestRule {
    private final String name;
    private final Supplier<String> valueSupplier;
    private String value;

    public static SystemPropertyTestRule create(String name, String value) {
        return new SystemPropertyTestRule(name, value);
    }

    protected SystemPropertyTestRule(String name, String value) {
        this(name, () -> value);
    }

    protected SystemPropertyTestRule(String name, Supplier<String> value) {
        this.name = Objects.requireNonNull(name, "name");
        this.valueSupplier = value;
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                String oldValue = System.getProperty(SystemPropertyTestRule.this.name);
                try {
                    SystemPropertyTestRule.this.value = (String)SystemPropertyTestRule.this.valueSupplier.get();
                    System.setProperty(SystemPropertyTestRule.this.name, SystemPropertyTestRule.this.value);
                    base.evaluate();
                }
                finally {
                    if (oldValue != null) {
                        System.setProperty(SystemPropertyTestRule.this.name, oldValue);
                    }
                }
            }
        };
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public Supplier<String> getValueSupplier() {
        return this.valueSupplier;
    }

    public String toString() {
        return "SystemPropertyTestRule [name=" + this.name + "]";
    }
}

