/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.core.interfaces;

import org.apache.manifoldcf.core.interfaces.Configuration;
import org.apache.manifoldcf.core.interfaces.ConfigurationNode;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.junit.Assert;
import org.junit.Test;

public class ConfigurationTest {
    private static final String testData = "{\"job\":{\"_children_\":[{\"_type_\":\"expiration_interval\",\"_value_\":\"infinite\"},{\"_type_\":\"hopcount_mode\",\"_value_\":\"accurate\"},{\"_type_\":\"document_specification\",\"_children_\":[{\"_type_\":\"security\",\"_value_\":\"\",\"_attribute_value\":\"off\"},{\"_type_\":\"parentfoldersecurity\",\"_value_\":\"\",\"_attribute_value\":\"off\"},{\"_type_\":\"startpoint\",\"include\":[{\"_attribute_filespec\":\"*\",\"_value_\":\"\",\"_attribute_type\":\"directory\"},{\"_attribute_filespec\":\"*.msg\",\"_value_\":\"\",\"_attribute_type\":\"file\"}],\"_attribute_path\":\"attribute path one\",\"_value_\":\"\"},{\"_type_\":\"startpoint\",\"include\":[{\"_attribute_filespec\":\"*\",\"_value_\":\"\",\"_attribute_type\":\"directory\"},{\"_attribute_filespec\":\"*.msg\",\"_value_\":\"\",\"_attribute_type\":\"file\"}],\"_attribute_path\":\"attribute path two\",\"_value_\":\"\"},{\"_type_\":\"sharesecurity\",\"_value_\":\"\",\"_attribute_value\":\"off\"}]},{\"_type_\":\"description\",\"_value_\":\"unit test: job\"},{\"_type_\":\"priority\",\"_value_\":\"5\"},{\"_type_\":\"schedule\",\"_children_\":[{\"_type_\":\"requestminimum\",\"_value_\":\"false\"},{\"_type_\":\"dayofmonth\",\"value\":[\"1\",\"15\"]}]},{\"_type_\":\"recrawl_interval\",\"_value_\":\"infinite\"},{\"_type_\":\"run_mode\",\"_value_\":\"scan once\"},{\"_type_\":\"reseed_interval\",\"_value_\":\"infinite\"},{\"_type_\":\"start_mode\",\"_value_\":\"manual\"},{\"_type_\":\"id\",\"_value_\":\"1505233221607\"},{\"_type_\":\"repository_connection\",\"_value_\":\"unit test: Repository connection\"},{\"_type_\":\"pipelinestage\",\"_children_\":[{\"_type_\":\"stage_isoutput\",\"_value_\":\"true\"},{\"_type_\":\"stage_id\",\"_value_\":\"0\"},{\"_type_\":\"stage_specification\"},{\"_type_\":\"stage_connectionname\",\"_value_\":\"unit test: Output connection\"}]},{\"_type_\":\"pipelinestage\",\"_children_\":[{\"_type_\":\"stage_isoutput\",\"_value_\":\"true\"},{\"_type_\":\"stage_id\",\"_value_\":\"1\"},{\"_type_\":\"stage_specification\"},{\"_type_\":\"stage_connectionname\",\"_value_\":\"unit test: Output connection\"},{\"_type_\":\"stage_prerequisite\",\"_value_\":\"0\"}]}]}}";

    @Test
    public void testNakedValue() throws ManifoldCFException {
        Configuration object2 = new Configuration();
        object2.fromJSON(testData);
        String jsonResult = object2.toJSON();
        Assert.assertEquals((long)jsonResult.length(), (long)testData.length());
    }

    @Test
    public void testBackAndForth() throws ManifoldCFException {
        ConfigurationNode connectionObject = new ConfigurationNode("repositoryconnection");
        ConfigurationNode child = new ConfigurationNode("name");
        child.setValue("File Connection");
        connectionObject.addChild(connectionObject.getChildCount(), child);
        child = new ConfigurationNode("class_name");
        child.setValue("org.apache.manifoldcf.crawler.connectors.filesystem.FileConnector");
        connectionObject.addChild(connectionObject.getChildCount(), child);
        child = new ConfigurationNode("description");
        child.setValue("File Connection");
        connectionObject.addChild(connectionObject.getChildCount(), child);
        child = new ConfigurationNode("max_connections");
        child.setValue("100");
        connectionObject.addChild(connectionObject.getChildCount(), child);
        Configuration requestObject = new Configuration();
        requestObject.addChild(0, connectionObject);
        String jsonResult = requestObject.toJSON();
        String validation = "{\"repositoryconnection\":{\"_children_\":[{\"_type_\":\"name\",\"_value_\":\"File Connection\"},{\"_type_\":\"class_name\",\"_value_\":\"org.apache.manifoldcf.crawler.connectors.filesystem.FileConnector\"},{\"_type_\":\"description\",\"_value_\":\"File Connection\"},{\"_type_\":\"max_connections\",\"_value_\":\"100\"}]}}";
        Assert.assertEquals((long)"{\"repositoryconnection\":{\"_children_\":[{\"_type_\":\"name\",\"_value_\":\"File Connection\"},{\"_type_\":\"class_name\",\"_value_\":\"org.apache.manifoldcf.crawler.connectors.filesystem.FileConnector\"},{\"_type_\":\"description\",\"_value_\":\"File Connection\"},{\"_type_\":\"max_connections\",\"_value_\":\"100\"}]}}".length(), (long)jsonResult.length());
        Configuration object2 = new Configuration();
        object2.fromJSON(jsonResult);
        String newResult = object2.toJSON();
        Assert.assertEquals((long)jsonResult.length(), (long)newResult.length());
    }
}

