/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.command.impl;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.List;
import org.apache.ftpserver.command.AbstractCommand;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.impl.FtpIoSession;
import org.apache.ftpserver.impl.FtpServerContext;
import org.apache.ftpserver.impl.LocalizedFtpReply;
import org.apache.ftpserver.ssl.ClientAuth;
import org.apache.ftpserver.ssl.SslConfiguration;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.filter.ssl.SslFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AUTH
extends AbstractCommand {
    private static final String SSL_SESSION_FILTER_NAME = "sslSessionFilter";
    private final Logger LOG = LoggerFactory.getLogger(AUTH.class);
    private static final List<String> VALID_AUTH_TYPES = Arrays.asList("SSL", "TLS", "TLS-C", "TLS-P");

    @Override
    public void execute(FtpIoSession session, FtpServerContext context, FtpRequest request) throws IOException, FtpException {
        session.resetState();
        if (!request.hasArgument()) {
            session.write((Object)LocalizedFtpReply.translate(session, request, context, 501, "AUTH", null));
            return;
        }
        if (session.getListener().getSslConfiguration() == null) {
            session.write((Object)LocalizedFtpReply.translate(session, request, context, 431, "AUTH", null));
            return;
        }
        if (session.getFilterChain().contains(SslFilter.class)) {
            session.write((Object)LocalizedFtpReply.translate(session, request, context, 534, "AUTH", null));
            return;
        }
        String authType = request.getArgument().toUpperCase();
        if (VALID_AUTH_TYPES.contains(authType)) {
            if (authType.equals("TLS-C")) {
                authType = "TLS";
            } else if (authType.equals("TLS-P")) {
                authType = "SSL";
            }
            try {
                this.secureSession(session, authType);
                session.write((Object)LocalizedFtpReply.translate(session, request, context, 234, "AUTH." + authType, null));
            }
            catch (FtpException ex) {
                throw ex;
            }
            catch (Exception ex) {
                this.LOG.warn("AUTH.execute()", (Throwable)ex);
                throw new FtpException("AUTH.execute()", (Throwable)ex);
            }
        } else {
            session.write((Object)LocalizedFtpReply.translate(session, request, context, 502, "AUTH", null));
        }
    }

    private void secureSession(FtpIoSession session, String type) throws GeneralSecurityException, FtpException {
        SslConfiguration ssl = session.getListener().getSslConfiguration();
        if (ssl != null) {
            session.setAttribute(SslFilter.DISABLE_ENCRYPTION_ONCE);
            SslFilter sslFilter = new SslFilter(ssl.getSSLContext());
            if (ssl.getClientAuth() == ClientAuth.NEED) {
                sslFilter.setNeedClientAuth(true);
            } else if (ssl.getClientAuth() == ClientAuth.WANT) {
                sslFilter.setWantClientAuth(true);
            }
            if (ssl.getEnabledCipherSuites() != null) {
                sslFilter.setEnabledCipherSuites(ssl.getEnabledCipherSuites());
            }
            if (ssl.getEnabledProtocol() != null) {
                sslFilter.setEnabledProtocols(new String[]{ssl.getEnabledProtocol()});
            }
            session.getFilterChain().addFirst(SSL_SESSION_FILTER_NAME, (IoFilter)sslFilter);
            if ("SSL".equals(type)) {
                session.getDataConnection().setSecure(true);
            }
        } else {
            throw new FtpException("Socket factory SSL not configured");
        }
    }
}

