/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.extension.websockets;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.vysper.mina.codec.StanzaBuilderFactory;
import org.apache.vysper.xml.decoder.XMLElementBuilderFactory;
import org.apache.vysper.xml.decoder.XMPPContentHandler;
import org.apache.vysper.xml.fragment.Renderer;
import org.apache.vysper.xml.fragment.XMLElement;
import org.apache.vysper.xml.sax.NonBlockingXMLReader;
import org.apache.vysper.xml.sax.impl.DefaultNonBlockingXMLReader;
import org.apache.vysper.xmpp.protocol.SessionStateHolder;
import org.apache.vysper.xmpp.protocol.StreamErrorCondition;
import org.apache.vysper.xmpp.server.AbstractSessionContext;
import org.apache.vysper.xmpp.server.ServerRuntimeContext;
import org.apache.vysper.xmpp.server.SessionContext;
import org.apache.vysper.xmpp.server.SessionState;
import org.apache.vysper.xmpp.server.response.ServerErrorResponses;
import org.apache.vysper.xmpp.stanza.Stanza;
import org.apache.vysper.xmpp.writer.StanzaWriter;
import org.eclipse.jetty.websocket.WebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class WebSocketBackedSessionContext
extends AbstractSessionContext
implements WebSocket,
XMPPContentHandler.StanzaListener,
StanzaWriter {
    private static final Charset CHARSET = Charset.forName("UTF-8");
    private static final CharsetDecoder CHARSET_DECODER = CHARSET.newDecoder();
    private static final Logger LOG = LoggerFactory.getLogger(WebSocketBackedSessionContext.class);
    private WebSocket.Outbound outbound;
    private NonBlockingXMLReader xmlReader = new DefaultNonBlockingXMLReader();

    public WebSocketBackedSessionContext(ServerRuntimeContext serverRuntimeContext) {
        super(serverRuntimeContext, new SessionStateHolder());
        XMPPContentHandler contentHandler = new XMPPContentHandler((XMLElementBuilderFactory)new StanzaBuilderFactory());
        contentHandler.setListener((XMPPContentHandler.StanzaListener)this);
        try {
            this.xmlReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            this.xmlReader.setFeature("http://mina.apache.org/vysper/features/restart-allowed", true);
            this.xmlReader.setProperty("http://mina.apache.org/vysper/properties/restart-qname", (Object)"stream:stream");
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        this.xmlReader.setContentHandler((ContentHandler)contentHandler);
    }

    public StanzaWriter getResponseWriter() {
        return this;
    }

    public void switchToTLS(boolean delayed, boolean clientTls) {
    }

    public void setIsReopeningXMLStream() {
    }

    public void onConnect(WebSocket.Outbound outbound) {
        LOG.info("WebSocket client connected");
        this.outbound = outbound;
        this.sessionStateHolder.setState(SessionState.ENCRYPTED);
    }

    public void onMessage(byte frame, String data) {
        LOG.info("< " + data);
        try {
            this.xmlReader.parse(IoBuffer.wrap((byte[])data.getBytes(CHARSET.name())), CHARSET_DECODER);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            Stanza errorStanza = ServerErrorResponses.getStreamError((StreamErrorCondition)StreamErrorCondition.XML_NOT_WELL_FORMED, (String)this.getXMLLang(), (String)"Stanza not well-formed", null);
            this.write(errorStanza);
            this.endSession(SessionContext.SessionTerminationCause.STREAM_ERROR);
        }
    }

    public void onDisconnect() {
        LOG.info("WebSocket client disconnected");
        this.endSession(SessionContext.SessionTerminationCause.CONNECTION_ABORT);
    }

    public void stanza(XMLElement element) {
        this.serverRuntimeContext.getStanzaProcessor().processStanza(this.serverRuntimeContext, (SessionContext)this, (Stanza)element, this.sessionStateHolder);
    }

    public void write(Stanza stanza) {
        Renderer renderer = new Renderer((XMLElement)stanza);
        if ("stream".equals(stanza.getName()) && "http://etherx.jabber.org/streams".equals(stanza.getNamespaceURI())) {
            this.send(renderer.getOpeningElement());
            this.send(renderer.getElementContent());
        } else {
            this.send(renderer.getComplete());
        }
    }

    private void send(String xml) {
        try {
            LOG.info("> " + xml);
            this.outbound.sendMessage(xml);
        }
        catch (IOException e) {
            this.endSession(SessionContext.SessionTerminationCause.CONNECTION_ABORT);
        }
    }

    public void close() {
    }

    public void onMessage(byte frame, byte[] data, int offset, int length) {
    }

    public void onFragment(boolean more, byte opcode, byte[] data, int offset, int length) {
    }
}

