/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.flow.mapping;

import java.util.Objects;
import org.apache.nifi.registry.flow.mapping.ComponentIdLookup;
import org.apache.nifi.registry.flow.mapping.SensitiveValueEncryptor;
import org.apache.nifi.registry.flow.mapping.VersionedComponentStateLookup;

public class FlowMappingOptions {
    private final SensitiveValueEncryptor encryptor;
    private final VersionedComponentStateLookup stateLookup;
    private final ComponentIdLookup componentIdLookup;
    private final boolean mapPropertyDescriptors;
    private final boolean mapSensitiveConfiguration;
    private final boolean mapInstanceIds;
    private final boolean mapControllerServiceReferencesToVersionedId;
    private final boolean mapFlowRegistryClientId;
    private final boolean mapAssetReferences;
    public static final FlowMappingOptions DEFAULT_OPTIONS = new Builder().sensitiveValueEncryptor(null).stateLookup(VersionedComponentStateLookup.ENABLED_OR_DISABLED).componentIdLookup(ComponentIdLookup.VERSIONED_OR_GENERATE).mapPropertyDescriptors(true).mapSensitiveConfiguration(false).mapInstanceIdentifiers(false).mapControllerServiceReferencesToVersionedId(true).mapFlowRegistryClientId(false).mapAssetReferences(false).build();

    private FlowMappingOptions(Builder builder) {
        this.encryptor = builder.encryptor;
        this.stateLookup = builder.stateLookup;
        this.componentIdLookup = builder.componentIdLookup;
        this.mapPropertyDescriptors = builder.mapPropertyDescriptors;
        this.mapSensitiveConfiguration = builder.mapSensitiveConfiguration;
        this.mapInstanceIds = builder.mapInstanceId;
        this.mapControllerServiceReferencesToVersionedId = builder.mapControllerServiceReferencesToVersionedId;
        this.mapFlowRegistryClientId = builder.mapFlowRegistryClientId;
        this.mapAssetReferences = builder.mapAssetReferences;
    }

    public SensitiveValueEncryptor getSensitiveValueEncryptor() {
        return this.encryptor;
    }

    public VersionedComponentStateLookup getStateLookup() {
        return this.stateLookup;
    }

    public ComponentIdLookup getComponentIdLookup() {
        return this.componentIdLookup;
    }

    public boolean isMapPropertyDescriptors() {
        return this.mapPropertyDescriptors;
    }

    public boolean isMapSensitiveConfiguration() {
        return this.mapSensitiveConfiguration;
    }

    public boolean isMapInstanceIdentifiers() {
        return this.mapInstanceIds;
    }

    public boolean isMapControllerServiceReferencesToVersionedId() {
        return this.mapControllerServiceReferencesToVersionedId;
    }

    public boolean isMapFlowRegistryClientId() {
        return this.mapFlowRegistryClientId;
    }

    public boolean isMapAssetReferences() {
        return this.mapAssetReferences;
    }

    public static class Builder {
        private SensitiveValueEncryptor encryptor;
        private VersionedComponentStateLookup stateLookup;
        private ComponentIdLookup componentIdLookup;
        private boolean mapPropertyDescriptors;
        private boolean mapSensitiveConfiguration;
        private boolean mapInstanceId = false;
        private boolean mapControllerServiceReferencesToVersionedId = true;
        private boolean mapFlowRegistryClientId = false;
        private boolean mapAssetReferences = false;

        public Builder sensitiveValueEncryptor(SensitiveValueEncryptor encryptor) {
            this.encryptor = encryptor;
            return this;
        }

        public Builder stateLookup(VersionedComponentStateLookup stateLookup) {
            this.stateLookup = stateLookup;
            return this;
        }

        public Builder componentIdLookup(ComponentIdLookup componentIdLookup) {
            this.componentIdLookup = componentIdLookup;
            return this;
        }

        public Builder mapPropertyDescriptors(boolean mapPropertyDescriptors) {
            this.mapPropertyDescriptors = mapPropertyDescriptors;
            return this;
        }

        public Builder mapSensitiveConfiguration(boolean mapSensitiveConfiguration) {
            this.mapSensitiveConfiguration = mapSensitiveConfiguration;
            return this;
        }

        public Builder mapInstanceIdentifiers(boolean mapInstanceIdentifiers) {
            this.mapInstanceId = mapInstanceIdentifiers;
            return this;
        }

        public Builder mapControllerServiceReferencesToVersionedId(boolean mapControllerServiceReferencesToVersionedId) {
            this.mapControllerServiceReferencesToVersionedId = mapControllerServiceReferencesToVersionedId;
            return this;
        }

        public Builder mapFlowRegistryClientId(boolean mapFlowRegistryClientId) {
            this.mapFlowRegistryClientId = mapFlowRegistryClientId;
            return this;
        }

        public Builder mapAssetReferences(boolean mapAssetReferences) {
            this.mapAssetReferences = mapAssetReferences;
            return this;
        }

        public FlowMappingOptions build() {
            Objects.requireNonNull(this.stateLookup, "State Lookup must be set");
            Objects.requireNonNull(this.componentIdLookup, "Component ID Lookup must be set");
            if (this.mapSensitiveConfiguration) {
                Objects.requireNonNull(this.encryptor, "Property Encryptor must be set when sensitive configuration is to be mapped");
            }
            return new FlowMappingOptions(this);
        }
    }
}

