/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * license agreements; and to You under the Apache License, version 2.0:
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * This file is part of the Apache Pekko project, which was derived from Akka.
 */

/*
 * Copyright (C) 2019-2022 Lightbend Inc. <https://www.lightbend.com>
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// NO CHECKED-IN PROTOBUF GENCODE
// source: WireFormats.proto
// Protobuf Java Version: 4.32.0

package org.apache.pekko.remote;

@org.apache.pekko.protobufv3.internal.Generated
public final class WireFormats {
  private WireFormats() {}
  static {
    org.apache.pekko.protobufv3.internal.RuntimeVersion.validateProtobufGencodeVersion(
      org.apache.pekko.protobufv3.internal.RuntimeVersion.RuntimeDomain.PUBLIC,
      /* major= */ 4,
      /* minor= */ 32,
      /* patch= */ 0,
      /* suffix= */ "",
      WireFormats.class.getName());
  }
  public static void registerAllExtensions(
      org.apache.pekko.protobufv3.internal.ExtensionRegistryLite registry) {
  }

  public static void registerAllExtensions(
      org.apache.pekko.protobufv3.internal.ExtensionRegistry registry) {
    registerAllExtensions(
        (org.apache.pekko.protobufv3.internal.ExtensionRegistryLite) registry);
  }
  /**
   * <pre>
   * *
   * Defines the type of the PekkoControlMessage command type
   * </pre>
   *
   * Protobuf enum {@code CommandType}
   */
  public enum CommandType
      implements org.apache.pekko.protobufv3.internal.ProtocolMessageEnum {
    /**
     * <code>ASSOCIATE = 1;</code>
     */
    ASSOCIATE(1),
    /**
     * <code>DISASSOCIATE = 2;</code>
     */
    DISASSOCIATE(2),
    /**
     * <code>HEARTBEAT = 3;</code>
     */
    HEARTBEAT(3),
    /**
     * <pre>
     * Remote system is going down and will not accepts new connections
     * </pre>
     *
     * <code>DISASSOCIATE_SHUTTING_DOWN = 4;</code>
     */
    DISASSOCIATE_SHUTTING_DOWN(4),
    /**
     * <pre>
     * Remote system refused the association since the current system is quarantined
     * </pre>
     *
     * <code>DISASSOCIATE_QUARANTINED = 5;</code>
     */
    DISASSOCIATE_QUARANTINED(5),
    ;

    static {
      org.apache.pekko.protobufv3.internal.RuntimeVersion.validateProtobufGencodeVersion(
        org.apache.pekko.protobufv3.internal.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 32,
        /* patch= */ 0,
        /* suffix= */ "",
        CommandType.class.getName());
    }
    /**
     * <code>ASSOCIATE = 1;</code>
     */
    public static final int ASSOCIATE_VALUE = 1;
    /**
     * <code>DISASSOCIATE = 2;</code>
     */
    public static final int DISASSOCIATE_VALUE = 2;
    /**
     * <code>HEARTBEAT = 3;</code>
     */
    public static final int HEARTBEAT_VALUE = 3;
    /**
     * <pre>
     * Remote system is going down and will not accepts new connections
     * </pre>
     *
     * <code>DISASSOCIATE_SHUTTING_DOWN = 4;</code>
     */
    public static final int DISASSOCIATE_SHUTTING_DOWN_VALUE = 4;
    /**
     * <pre>
     * Remote system refused the association since the current system is quarantined
     * </pre>
     *
     * <code>DISASSOCIATE_QUARANTINED = 5;</code>
     */
    public static final int DISASSOCIATE_QUARANTINED_VALUE = 5;


    public final int getNumber() {
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static CommandType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static CommandType forNumber(int value) {
      switch (value) {
        case 1: return ASSOCIATE;
        case 2: return DISASSOCIATE;
        case 3: return HEARTBEAT;
        case 4: return DISASSOCIATE_SHUTTING_DOWN;
        case 5: return DISASSOCIATE_QUARANTINED;
        default: return null;
      }
    }

    public static org.apache.pekko.protobufv3.internal.Internal.EnumLiteMap<CommandType>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final org.apache.pekko.protobufv3.internal.Internal.EnumLiteMap<
        CommandType> internalValueMap =
          new org.apache.pekko.protobufv3.internal.Internal.EnumLiteMap<CommandType>() {
            public CommandType findValueByNumber(int number) {
              return CommandType.forNumber(number);
            }
          };

    public final org.apache.pekko.protobufv3.internal.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final org.apache.pekko.protobufv3.internal.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static org.apache.pekko.protobufv3.internal.Descriptors.EnumDescriptor
        getDescriptor() {
      return org.apache.pekko.remote.WireFormats.getDescriptor().getEnumTypes().get(0);
    }

    private static final CommandType[] VALUES = values();

    public static CommandType valueOf(
        org.apache.pekko.protobufv3.internal.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private CommandType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:CommandType)
  }

  /**
   * <pre>
   * *
   * java.util.concurrent.TimeUnit enum
   * </pre>
   *
   * Protobuf enum {@code TimeUnit}
   */
  public enum TimeUnit
      implements org.apache.pekko.protobufv3.internal.ProtocolMessageEnum {
    /**
     * <code>NANOSECONDS = 1;</code>
     */
    NANOSECONDS(1),
    /**
     * <code>MICROSECONDS = 2;</code>
     */
    MICROSECONDS(2),
    /**
     * <code>MILLISECONDS = 3;</code>
     */
    MILLISECONDS(3),
    /**
     * <code>SECONDS = 4;</code>
     */
    SECONDS(4),
    /**
     * <code>MINUTES = 5;</code>
     */
    MINUTES(5),
    /**
     * <code>HOURS = 6;</code>
     */
    HOURS(6),
    /**
     * <code>DAYS = 7;</code>
     */
    DAYS(7),
    ;

    static {
      org.apache.pekko.protobufv3.internal.RuntimeVersion.validateProtobufGencodeVersion(
        org.apache.pekko.protobufv3.internal.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 32,
        /* patch= */ 0,
        /* suffix= */ "",
        TimeUnit.class.getName());
    }
    /**
     * <code>NANOSECONDS = 1;</code>
     */
    public static final int NANOSECONDS_VALUE = 1;
    /**
     * <code>MICROSECONDS = 2;</code>
     */
    public static final int MICROSECONDS_VALUE = 2;
    /**
     * <code>MILLISECONDS = 3;</code>
     */
    public static final int MILLISECONDS_VALUE = 3;
    /**
     * <code>SECONDS = 4;</code>
     */
    public static final int SECONDS_VALUE = 4;
    /**
     * <code>MINUTES = 5;</code>
     */
    public static final int MINUTES_VALUE = 5;
    /**
     * <code>HOURS = 6;</code>
     */
    public static final int HOURS_VALUE = 6;
    /**
     * <code>DAYS = 7;</code>
     */
    public static final int DAYS_VALUE = 7;


    public final int getNumber() {
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TimeUnit valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static TimeUnit forNumber(int value) {
      switch (value) {
        case 1: return NANOSECONDS;
        case 2: return MICROSECONDS;
        case 3: return MILLISECONDS;
        case 4: return SECONDS;
        case 5: return MINUTES;
        case 6: return HOURS;
        case 7: return DAYS;
        default: return null;
      }
    }

    public static org.apache.pekko.protobufv3.internal.Internal.EnumLiteMap<TimeUnit>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final org.apache.pekko.protobufv3.internal.Internal.EnumLiteMap<
        TimeUnit> internalValueMap =
          new org.apache.pekko.protobufv3.internal.Internal.EnumLiteMap<TimeUnit>() {
            public TimeUnit findValueByNumber(int number) {
              return TimeUnit.forNumber(number);
            }
          };

    public final org.apache.pekko.protobufv3.internal.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final org.apache.pekko.protobufv3.internal.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static org.apache.pekko.protobufv3.internal.Descriptors.EnumDescriptor
        getDescriptor() {
      return org.apache.pekko.remote.WireFormats.getDescriptor().getEnumTypes().get(1);
    }

    private static final TimeUnit[] VALUES = values();

    public static TimeUnit valueOf(
        org.apache.pekko.protobufv3.internal.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private TimeUnit(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:TimeUnit)
  }

  public interface AckAndEnvelopeContainerOrBuilder extends
      // @@protoc_insertion_point(interface_extends:AckAndEnvelopeContainer)
      org.apache.pekko.protobufv3.internal.MessageOrBuilder {

    /**
     * <code>optional .AcknowledgementInfo ack = 1;</code>
     * @return Whether the ack field is set.
     */
    boolean hasAck();
    /**
     * <code>optional .AcknowledgementInfo ack = 1;</code>
     * @return The ack.
     */
    org.apache.pekko.remote.WireFormats.AcknowledgementInfo getAck();
    /**
     * <code>optional .AcknowledgementInfo ack = 1;</code>
     */
    org.apache.pekko.remote.WireFormats.AcknowledgementInfoOrBuilder getAckOrBuilder();

    /**
     * <code>optional .RemoteEnvelope envelope = 2;</code>
     * @return Whether the envelope field is set.
     */
    boolean hasEnvelope();
    /**
     * <code>optional .RemoteEnvelope envelope = 2;</code>
     * @return The envelope.
     */
    org.apache.pekko.remote.WireFormats.RemoteEnvelope getEnvelope();
    /**
     * <code>optional .RemoteEnvelope envelope = 2;</code>
     */
    org.apache.pekko.remote.WireFormats.RemoteEnvelopeOrBuilder getEnvelopeOrBuilder();
  }
  /**
   * Protobuf type {@code AckAndEnvelopeContainer}
   */
  public static final class AckAndEnvelopeContainer extends
      org.apache.pekko.protobufv3.internal.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:AckAndEnvelopeContainer)
      AckAndEnvelopeContainerOrBuilder {
  private static final long serialVersionUID = 0L;
    static {
      org.apache.pekko.protobufv3.internal.RuntimeVersion.validateProtobufGencodeVersion(
        org.apache.pekko.protobufv3.internal.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 32,
        /* patch= */ 0,
        /* suffix= */ "",
        AckAndEnvelopeContainer.class.getName());
    }
    // Use AckAndEnvelopeContainer.newBuilder() to construct.
    private AckAndEnvelopeContainer(org.apache.pekko.protobufv3.internal.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }
    private AckAndEnvelopeContainer() {
    }

    public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.pekko.remote.WireFormats.internal_static_AckAndEnvelopeContainer_descriptor;
    }

    @java.lang.Override
    protected org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.pekko.remote.WireFormats.internal_static_AckAndEnvelopeContainer_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.pekko.remote.WireFormats.AckAndEnvelopeContainer.class, org.apache.pekko.remote.WireFormats.AckAndEnvelopeContainer.Builder.class);
    }

    private int bitField0_;
    public static final int ACK_FIELD_NUMBER = 1;
    private org.apache.pekko.remote.WireFormats.AcknowledgementInfo ack_;
    /**
     * <code>optional .AcknowledgementInfo ack = 1;</code>
     * @return Whether the ack field is set.
     */
    @java.lang.Override
    public boolean hasAck() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <code>optional .AcknowledgementInfo ack = 1;</code>
     * @return The ack.
     */
    @java.lang.Override
    public org.apache.pekko.remote.WireFormats.AcknowledgementInfo getAck() {
      return ack_ == null ? org.apache.pekko.remote.WireFormats.AcknowledgementInfo.getDefaultInstance() : ack_;
    }
    /**
     * <code>optional .AcknowledgementInfo ack = 1;</code>
     */
    @java.lang.Override
    public org.apache.pekko.remote.WireFormats.AcknowledgementInfoOrBuilder getAckOrBuilder() {
      return ack_ == null ? org.apache.pekko.remote.WireFormats.AcknowledgementInfo.getDefaultInstance() : ack_;
    }

    public static final int ENVELOPE_FIELD_NUMBER = 2;
    private org.apache.pekko.remote.WireFormats.RemoteEnvelope envelope_;
    /**
     * <code>optional .RemoteEnvelope envelope = 2;</code>
     * @return Whether the envelope field is set.
     */
    @java.lang.Override
    public boolean hasEnvelope() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <code>optional .RemoteEnvelope envelope = 2;</code>
     * @return The envelope.
     */
    @java.lang.Override
    public org.apache.pekko.remote.WireFormats.RemoteEnvelope getEnvelope() {
      return envelope_ == null ? org.apache.pekko.remote.WireFormats.RemoteEnvelope.getDefaultInstance() : envelope_;
    }
    /**
     * <code>optional .RemoteEnvelope envelope = 2;</code>
     */
    @java.lang.Override
    public org.apache.pekko.remote.WireFormats.RemoteEnvelopeOrBuilder getEnvelopeOrBuilder() {
      return envelope_ == null ? org.apache.pekko.remote.WireFormats.RemoteEnvelope.getDefaultInstance() : envelope_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (hasAck()) {
        if (!getAck().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      if (hasEnvelope()) {
        if (!getEnvelope().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(org.apache.pekko.protobufv3.internal.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getAck());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(2, getEnvelope());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeMessageSize(1, getAck());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeMessageSize(2, getEnvelope());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.pekko.remote.WireFormats.AckAndEnvelopeContainer)) {
        return super.equals(obj);
      }
      org.apache.pekko.remote.WireFormats.AckAndEnvelopeContainer other = (org.apache.pekko.remote.WireFormats.AckAndEnvelopeContainer) obj;

      if (hasAck() != other.hasAck()) return false;
      if (hasAck()) {
        if (!getAck()
            .equals(other.getAck())) return false;
      }
      if (hasEnvelope() != other.hasEnvelope()) return false;
      if (hasEnvelope()) {
        if (!getEnvelope()
            .equals(other.getEnvelope())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasAck()) {
        hash = (37 * hash) + ACK_FIELD_NUMBER;
        hash = (53 * hash) + getAck().hashCode();
      }
      if (hasEnvelope()) {
        hash = (37 * hash) + ENVELOPE_FIELD_NUMBER;
        hash = (53 * hash) + getEnvelope().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.pekko.remote.WireFormats.AckAndEnvelopeContainer parseFrom(
        java.nio.ByteBuffer data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.remote.WireFormats.AckAndEnvelopeContainer parseFrom(
        java.nio.ByteBuffer data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.AckAndEnvelopeContainer parseFrom(
        org.apache.pekko.protobufv3.internal.ByteString data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.remote.WireFormats.AckAndEnvelopeContainer parseFrom(
        org.apache.pekko.protobufv3.internal.ByteString data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.AckAndEnvelopeContainer parseFrom(byte[] data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.remote.WireFormats.AckAndEnvelopeContainer parseFrom(
        byte[] data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.AckAndEnvelopeContainer parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.pekko.remote.WireFormats.AckAndEnvelopeContainer parseFrom(
        java.io.InputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static org.apache.pekko.remote.WireFormats.AckAndEnvelopeContainer parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static org.apache.pekko.remote.WireFormats.AckAndEnvelopeContainer parseDelimitedFrom(
        java.io.InputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.AckAndEnvelopeContainer parseFrom(
        org.apache.pekko.protobufv3.internal.CodedInputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.pekko.remote.WireFormats.AckAndEnvelopeContainer parseFrom(
        org.apache.pekko.protobufv3.internal.CodedInputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.pekko.remote.WireFormats.AckAndEnvelopeContainer prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        org.apache.pekko.protobufv3.internal.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code AckAndEnvelopeContainer}
     */
    public static final class Builder extends
        org.apache.pekko.protobufv3.internal.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:AckAndEnvelopeContainer)
        org.apache.pekko.remote.WireFormats.AckAndEnvelopeContainerOrBuilder {
      public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.pekko.remote.WireFormats.internal_static_AckAndEnvelopeContainer_descriptor;
      }

      @java.lang.Override
      protected org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.pekko.remote.WireFormats.internal_static_AckAndEnvelopeContainer_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.pekko.remote.WireFormats.AckAndEnvelopeContainer.class, org.apache.pekko.remote.WireFormats.AckAndEnvelopeContainer.Builder.class);
      }

      // Construct using org.apache.pekko.remote.WireFormats.AckAndEnvelopeContainer.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          org.apache.pekko.protobufv3.internal.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (org.apache.pekko.protobufv3.internal.GeneratedMessage
                .alwaysUseFieldBuilders) {
          internalGetAckFieldBuilder();
          internalGetEnvelopeFieldBuilder();
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        ack_ = null;
        if (ackBuilder_ != null) {
          ackBuilder_.dispose();
          ackBuilder_ = null;
        }
        envelope_ = null;
        if (envelopeBuilder_ != null) {
          envelopeBuilder_.dispose();
          envelopeBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.pekko.remote.WireFormats.internal_static_AckAndEnvelopeContainer_descriptor;
      }

      @java.lang.Override
      public org.apache.pekko.remote.WireFormats.AckAndEnvelopeContainer getDefaultInstanceForType() {
        return org.apache.pekko.remote.WireFormats.AckAndEnvelopeContainer.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.pekko.remote.WireFormats.AckAndEnvelopeContainer build() {
        org.apache.pekko.remote.WireFormats.AckAndEnvelopeContainer result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.pekko.remote.WireFormats.AckAndEnvelopeContainer buildPartial() {
        org.apache.pekko.remote.WireFormats.AckAndEnvelopeContainer result = new org.apache.pekko.remote.WireFormats.AckAndEnvelopeContainer(this);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartial0(org.apache.pekko.remote.WireFormats.AckAndEnvelopeContainer result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.ack_ = ackBuilder_ == null
              ? ack_
              : ackBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.envelope_ = envelopeBuilder_ == null
              ? envelope_
              : envelopeBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder mergeFrom(org.apache.pekko.protobufv3.internal.Message other) {
        if (other instanceof org.apache.pekko.remote.WireFormats.AckAndEnvelopeContainer) {
          return mergeFrom((org.apache.pekko.remote.WireFormats.AckAndEnvelopeContainer)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.pekko.remote.WireFormats.AckAndEnvelopeContainer other) {
        if (other == org.apache.pekko.remote.WireFormats.AckAndEnvelopeContainer.getDefaultInstance()) return this;
        if (other.hasAck()) {
          mergeAck(other.getAck());
        }
        if (other.hasEnvelope()) {
          mergeEnvelope(other.getEnvelope());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        if (hasAck()) {
          if (!getAck().isInitialized()) {
            return false;
          }
        }
        if (hasEnvelope()) {
          if (!getEnvelope().isInitialized()) {
            return false;
          }
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                input.readMessage(
                    internalGetAckFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
              case 18: {
                input.readMessage(
                    internalGetEnvelopeFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private org.apache.pekko.remote.WireFormats.AcknowledgementInfo ack_;
      private org.apache.pekko.protobufv3.internal.SingleFieldBuilder<
          org.apache.pekko.remote.WireFormats.AcknowledgementInfo, org.apache.pekko.remote.WireFormats.AcknowledgementInfo.Builder, org.apache.pekko.remote.WireFormats.AcknowledgementInfoOrBuilder> ackBuilder_;
      /**
       * <code>optional .AcknowledgementInfo ack = 1;</code>
       * @return Whether the ack field is set.
       */
      public boolean hasAck() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <code>optional .AcknowledgementInfo ack = 1;</code>
       * @return The ack.
       */
      public org.apache.pekko.remote.WireFormats.AcknowledgementInfo getAck() {
        if (ackBuilder_ == null) {
          return ack_ == null ? org.apache.pekko.remote.WireFormats.AcknowledgementInfo.getDefaultInstance() : ack_;
        } else {
          return ackBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .AcknowledgementInfo ack = 1;</code>
       */
      public Builder setAck(org.apache.pekko.remote.WireFormats.AcknowledgementInfo value) {
        if (ackBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ack_ = value;
        } else {
          ackBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <code>optional .AcknowledgementInfo ack = 1;</code>
       */
      public Builder setAck(
          org.apache.pekko.remote.WireFormats.AcknowledgementInfo.Builder builderForValue) {
        if (ackBuilder_ == null) {
          ack_ = builderForValue.build();
        } else {
          ackBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <code>optional .AcknowledgementInfo ack = 1;</code>
       */
      public Builder mergeAck(org.apache.pekko.remote.WireFormats.AcknowledgementInfo value) {
        if (ackBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0) &&
            ack_ != null &&
            ack_ != org.apache.pekko.remote.WireFormats.AcknowledgementInfo.getDefaultInstance()) {
            getAckBuilder().mergeFrom(value);
          } else {
            ack_ = value;
          }
        } else {
          ackBuilder_.mergeFrom(value);
        }
        if (ack_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }
      /**
       * <code>optional .AcknowledgementInfo ack = 1;</code>
       */
      public Builder clearAck() {
        bitField0_ = (bitField0_ & ~0x00000001);
        ack_ = null;
        if (ackBuilder_ != null) {
          ackBuilder_.dispose();
          ackBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <code>optional .AcknowledgementInfo ack = 1;</code>
       */
      public org.apache.pekko.remote.WireFormats.AcknowledgementInfo.Builder getAckBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return internalGetAckFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .AcknowledgementInfo ack = 1;</code>
       */
      public org.apache.pekko.remote.WireFormats.AcknowledgementInfoOrBuilder getAckOrBuilder() {
        if (ackBuilder_ != null) {
          return ackBuilder_.getMessageOrBuilder();
        } else {
          return ack_ == null ?
              org.apache.pekko.remote.WireFormats.AcknowledgementInfo.getDefaultInstance() : ack_;
        }
      }
      /**
       * <code>optional .AcknowledgementInfo ack = 1;</code>
       */
      private org.apache.pekko.protobufv3.internal.SingleFieldBuilder<
          org.apache.pekko.remote.WireFormats.AcknowledgementInfo, org.apache.pekko.remote.WireFormats.AcknowledgementInfo.Builder, org.apache.pekko.remote.WireFormats.AcknowledgementInfoOrBuilder> 
          internalGetAckFieldBuilder() {
        if (ackBuilder_ == null) {
          ackBuilder_ = new org.apache.pekko.protobufv3.internal.SingleFieldBuilder<
              org.apache.pekko.remote.WireFormats.AcknowledgementInfo, org.apache.pekko.remote.WireFormats.AcknowledgementInfo.Builder, org.apache.pekko.remote.WireFormats.AcknowledgementInfoOrBuilder>(
                  getAck(),
                  getParentForChildren(),
                  isClean());
          ack_ = null;
        }
        return ackBuilder_;
      }

      private org.apache.pekko.remote.WireFormats.RemoteEnvelope envelope_;
      private org.apache.pekko.protobufv3.internal.SingleFieldBuilder<
          org.apache.pekko.remote.WireFormats.RemoteEnvelope, org.apache.pekko.remote.WireFormats.RemoteEnvelope.Builder, org.apache.pekko.remote.WireFormats.RemoteEnvelopeOrBuilder> envelopeBuilder_;
      /**
       * <code>optional .RemoteEnvelope envelope = 2;</code>
       * @return Whether the envelope field is set.
       */
      public boolean hasEnvelope() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <code>optional .RemoteEnvelope envelope = 2;</code>
       * @return The envelope.
       */
      public org.apache.pekko.remote.WireFormats.RemoteEnvelope getEnvelope() {
        if (envelopeBuilder_ == null) {
          return envelope_ == null ? org.apache.pekko.remote.WireFormats.RemoteEnvelope.getDefaultInstance() : envelope_;
        } else {
          return envelopeBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .RemoteEnvelope envelope = 2;</code>
       */
      public Builder setEnvelope(org.apache.pekko.remote.WireFormats.RemoteEnvelope value) {
        if (envelopeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          envelope_ = value;
        } else {
          envelopeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <code>optional .RemoteEnvelope envelope = 2;</code>
       */
      public Builder setEnvelope(
          org.apache.pekko.remote.WireFormats.RemoteEnvelope.Builder builderForValue) {
        if (envelopeBuilder_ == null) {
          envelope_ = builderForValue.build();
        } else {
          envelopeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <code>optional .RemoteEnvelope envelope = 2;</code>
       */
      public Builder mergeEnvelope(org.apache.pekko.remote.WireFormats.RemoteEnvelope value) {
        if (envelopeBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0) &&
            envelope_ != null &&
            envelope_ != org.apache.pekko.remote.WireFormats.RemoteEnvelope.getDefaultInstance()) {
            getEnvelopeBuilder().mergeFrom(value);
          } else {
            envelope_ = value;
          }
        } else {
          envelopeBuilder_.mergeFrom(value);
        }
        if (envelope_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       * <code>optional .RemoteEnvelope envelope = 2;</code>
       */
      public Builder clearEnvelope() {
        bitField0_ = (bitField0_ & ~0x00000002);
        envelope_ = null;
        if (envelopeBuilder_ != null) {
          envelopeBuilder_.dispose();
          envelopeBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <code>optional .RemoteEnvelope envelope = 2;</code>
       */
      public org.apache.pekko.remote.WireFormats.RemoteEnvelope.Builder getEnvelopeBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return internalGetEnvelopeFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .RemoteEnvelope envelope = 2;</code>
       */
      public org.apache.pekko.remote.WireFormats.RemoteEnvelopeOrBuilder getEnvelopeOrBuilder() {
        if (envelopeBuilder_ != null) {
          return envelopeBuilder_.getMessageOrBuilder();
        } else {
          return envelope_ == null ?
              org.apache.pekko.remote.WireFormats.RemoteEnvelope.getDefaultInstance() : envelope_;
        }
      }
      /**
       * <code>optional .RemoteEnvelope envelope = 2;</code>
       */
      private org.apache.pekko.protobufv3.internal.SingleFieldBuilder<
          org.apache.pekko.remote.WireFormats.RemoteEnvelope, org.apache.pekko.remote.WireFormats.RemoteEnvelope.Builder, org.apache.pekko.remote.WireFormats.RemoteEnvelopeOrBuilder> 
          internalGetEnvelopeFieldBuilder() {
        if (envelopeBuilder_ == null) {
          envelopeBuilder_ = new org.apache.pekko.protobufv3.internal.SingleFieldBuilder<
              org.apache.pekko.remote.WireFormats.RemoteEnvelope, org.apache.pekko.remote.WireFormats.RemoteEnvelope.Builder, org.apache.pekko.remote.WireFormats.RemoteEnvelopeOrBuilder>(
                  getEnvelope(),
                  getParentForChildren(),
                  isClean());
          envelope_ = null;
        }
        return envelopeBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:AckAndEnvelopeContainer)
    }

    // @@protoc_insertion_point(class_scope:AckAndEnvelopeContainer)
    private static final org.apache.pekko.remote.WireFormats.AckAndEnvelopeContainer DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.pekko.remote.WireFormats.AckAndEnvelopeContainer();
    }

    public static org.apache.pekko.remote.WireFormats.AckAndEnvelopeContainer getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final org.apache.pekko.protobufv3.internal.Parser<AckAndEnvelopeContainer>
        PARSER = new org.apache.pekko.protobufv3.internal.AbstractParser<AckAndEnvelopeContainer>() {
      @java.lang.Override
      public AckAndEnvelopeContainer parsePartialFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (org.apache.pekko.protobufv3.internal.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static org.apache.pekko.protobufv3.internal.Parser<AckAndEnvelopeContainer> parser() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.pekko.protobufv3.internal.Parser<AckAndEnvelopeContainer> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.pekko.remote.WireFormats.AckAndEnvelopeContainer getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface RemoteEnvelopeOrBuilder extends
      // @@protoc_insertion_point(interface_extends:RemoteEnvelope)
      org.apache.pekko.protobufv3.internal.MessageOrBuilder {

    /**
     * <code>required .ActorRefData recipient = 1;</code>
     * @return Whether the recipient field is set.
     */
    boolean hasRecipient();
    /**
     * <code>required .ActorRefData recipient = 1;</code>
     * @return The recipient.
     */
    org.apache.pekko.remote.WireFormats.ActorRefData getRecipient();
    /**
     * <code>required .ActorRefData recipient = 1;</code>
     */
    org.apache.pekko.remote.WireFormats.ActorRefDataOrBuilder getRecipientOrBuilder();

    /**
     * <code>required .SerializedMessage message = 2;</code>
     * @return Whether the message field is set.
     */
    boolean hasMessage();
    /**
     * <code>required .SerializedMessage message = 2;</code>
     * @return The message.
     */
    org.apache.pekko.remote.WireFormats.SerializedMessage getMessage();
    /**
     * <code>required .SerializedMessage message = 2;</code>
     */
    org.apache.pekko.remote.WireFormats.SerializedMessageOrBuilder getMessageOrBuilder();

    /**
     * <code>optional .ActorRefData sender = 4;</code>
     * @return Whether the sender field is set.
     */
    boolean hasSender();
    /**
     * <code>optional .ActorRefData sender = 4;</code>
     * @return The sender.
     */
    org.apache.pekko.remote.WireFormats.ActorRefData getSender();
    /**
     * <code>optional .ActorRefData sender = 4;</code>
     */
    org.apache.pekko.remote.WireFormats.ActorRefDataOrBuilder getSenderOrBuilder();

    /**
     * <code>optional fixed64 seq = 5;</code>
     * @return Whether the seq field is set.
     */
    boolean hasSeq();
    /**
     * <code>optional fixed64 seq = 5;</code>
     * @return The seq.
     */
    long getSeq();
  }
  /**
   * <pre>
   * *
   * Defines a remote message.
   * </pre>
   *
   * Protobuf type {@code RemoteEnvelope}
   */
  public static final class RemoteEnvelope extends
      org.apache.pekko.protobufv3.internal.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:RemoteEnvelope)
      RemoteEnvelopeOrBuilder {
  private static final long serialVersionUID = 0L;
    static {
      org.apache.pekko.protobufv3.internal.RuntimeVersion.validateProtobufGencodeVersion(
        org.apache.pekko.protobufv3.internal.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 32,
        /* patch= */ 0,
        /* suffix= */ "",
        RemoteEnvelope.class.getName());
    }
    // Use RemoteEnvelope.newBuilder() to construct.
    private RemoteEnvelope(org.apache.pekko.protobufv3.internal.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }
    private RemoteEnvelope() {
    }

    public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.pekko.remote.WireFormats.internal_static_RemoteEnvelope_descriptor;
    }

    @java.lang.Override
    protected org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.pekko.remote.WireFormats.internal_static_RemoteEnvelope_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.pekko.remote.WireFormats.RemoteEnvelope.class, org.apache.pekko.remote.WireFormats.RemoteEnvelope.Builder.class);
    }

    private int bitField0_;
    public static final int RECIPIENT_FIELD_NUMBER = 1;
    private org.apache.pekko.remote.WireFormats.ActorRefData recipient_;
    /**
     * <code>required .ActorRefData recipient = 1;</code>
     * @return Whether the recipient field is set.
     */
    @java.lang.Override
    public boolean hasRecipient() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <code>required .ActorRefData recipient = 1;</code>
     * @return The recipient.
     */
    @java.lang.Override
    public org.apache.pekko.remote.WireFormats.ActorRefData getRecipient() {
      return recipient_ == null ? org.apache.pekko.remote.WireFormats.ActorRefData.getDefaultInstance() : recipient_;
    }
    /**
     * <code>required .ActorRefData recipient = 1;</code>
     */
    @java.lang.Override
    public org.apache.pekko.remote.WireFormats.ActorRefDataOrBuilder getRecipientOrBuilder() {
      return recipient_ == null ? org.apache.pekko.remote.WireFormats.ActorRefData.getDefaultInstance() : recipient_;
    }

    public static final int MESSAGE_FIELD_NUMBER = 2;
    private org.apache.pekko.remote.WireFormats.SerializedMessage message_;
    /**
     * <code>required .SerializedMessage message = 2;</code>
     * @return Whether the message field is set.
     */
    @java.lang.Override
    public boolean hasMessage() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <code>required .SerializedMessage message = 2;</code>
     * @return The message.
     */
    @java.lang.Override
    public org.apache.pekko.remote.WireFormats.SerializedMessage getMessage() {
      return message_ == null ? org.apache.pekko.remote.WireFormats.SerializedMessage.getDefaultInstance() : message_;
    }
    /**
     * <code>required .SerializedMessage message = 2;</code>
     */
    @java.lang.Override
    public org.apache.pekko.remote.WireFormats.SerializedMessageOrBuilder getMessageOrBuilder() {
      return message_ == null ? org.apache.pekko.remote.WireFormats.SerializedMessage.getDefaultInstance() : message_;
    }

    public static final int SENDER_FIELD_NUMBER = 4;
    private org.apache.pekko.remote.WireFormats.ActorRefData sender_;
    /**
     * <code>optional .ActorRefData sender = 4;</code>
     * @return Whether the sender field is set.
     */
    @java.lang.Override
    public boolean hasSender() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     * <code>optional .ActorRefData sender = 4;</code>
     * @return The sender.
     */
    @java.lang.Override
    public org.apache.pekko.remote.WireFormats.ActorRefData getSender() {
      return sender_ == null ? org.apache.pekko.remote.WireFormats.ActorRefData.getDefaultInstance() : sender_;
    }
    /**
     * <code>optional .ActorRefData sender = 4;</code>
     */
    @java.lang.Override
    public org.apache.pekko.remote.WireFormats.ActorRefDataOrBuilder getSenderOrBuilder() {
      return sender_ == null ? org.apache.pekko.remote.WireFormats.ActorRefData.getDefaultInstance() : sender_;
    }

    public static final int SEQ_FIELD_NUMBER = 5;
    private long seq_ = 0L;
    /**
     * <code>optional fixed64 seq = 5;</code>
     * @return Whether the seq field is set.
     */
    @java.lang.Override
    public boolean hasSeq() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     * <code>optional fixed64 seq = 5;</code>
     * @return The seq.
     */
    @java.lang.Override
    public long getSeq() {
      return seq_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasRecipient()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!hasMessage()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!getRecipient().isInitialized()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!getMessage().isInitialized()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (hasSender()) {
        if (!getSender().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(org.apache.pekko.protobufv3.internal.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getRecipient());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(2, getMessage());
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        output.writeMessage(4, getSender());
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        output.writeFixed64(5, seq_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeMessageSize(1, getRecipient());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeMessageSize(2, getMessage());
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeMessageSize(4, getSender());
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeFixed64Size(5, seq_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.pekko.remote.WireFormats.RemoteEnvelope)) {
        return super.equals(obj);
      }
      org.apache.pekko.remote.WireFormats.RemoteEnvelope other = (org.apache.pekko.remote.WireFormats.RemoteEnvelope) obj;

      if (hasRecipient() != other.hasRecipient()) return false;
      if (hasRecipient()) {
        if (!getRecipient()
            .equals(other.getRecipient())) return false;
      }
      if (hasMessage() != other.hasMessage()) return false;
      if (hasMessage()) {
        if (!getMessage()
            .equals(other.getMessage())) return false;
      }
      if (hasSender() != other.hasSender()) return false;
      if (hasSender()) {
        if (!getSender()
            .equals(other.getSender())) return false;
      }
      if (hasSeq() != other.hasSeq()) return false;
      if (hasSeq()) {
        if (getSeq()
            != other.getSeq()) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasRecipient()) {
        hash = (37 * hash) + RECIPIENT_FIELD_NUMBER;
        hash = (53 * hash) + getRecipient().hashCode();
      }
      if (hasMessage()) {
        hash = (37 * hash) + MESSAGE_FIELD_NUMBER;
        hash = (53 * hash) + getMessage().hashCode();
      }
      if (hasSender()) {
        hash = (37 * hash) + SENDER_FIELD_NUMBER;
        hash = (53 * hash) + getSender().hashCode();
      }
      if (hasSeq()) {
        hash = (37 * hash) + SEQ_FIELD_NUMBER;
        hash = (53 * hash) + org.apache.pekko.protobufv3.internal.Internal.hashLong(
            getSeq());
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.pekko.remote.WireFormats.RemoteEnvelope parseFrom(
        java.nio.ByteBuffer data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.remote.WireFormats.RemoteEnvelope parseFrom(
        java.nio.ByteBuffer data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.RemoteEnvelope parseFrom(
        org.apache.pekko.protobufv3.internal.ByteString data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.remote.WireFormats.RemoteEnvelope parseFrom(
        org.apache.pekko.protobufv3.internal.ByteString data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.RemoteEnvelope parseFrom(byte[] data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.remote.WireFormats.RemoteEnvelope parseFrom(
        byte[] data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.RemoteEnvelope parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.pekko.remote.WireFormats.RemoteEnvelope parseFrom(
        java.io.InputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static org.apache.pekko.remote.WireFormats.RemoteEnvelope parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static org.apache.pekko.remote.WireFormats.RemoteEnvelope parseDelimitedFrom(
        java.io.InputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.RemoteEnvelope parseFrom(
        org.apache.pekko.protobufv3.internal.CodedInputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.pekko.remote.WireFormats.RemoteEnvelope parseFrom(
        org.apache.pekko.protobufv3.internal.CodedInputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.pekko.remote.WireFormats.RemoteEnvelope prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        org.apache.pekko.protobufv3.internal.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * *
     * Defines a remote message.
     * </pre>
     *
     * Protobuf type {@code RemoteEnvelope}
     */
    public static final class Builder extends
        org.apache.pekko.protobufv3.internal.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:RemoteEnvelope)
        org.apache.pekko.remote.WireFormats.RemoteEnvelopeOrBuilder {
      public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.pekko.remote.WireFormats.internal_static_RemoteEnvelope_descriptor;
      }

      @java.lang.Override
      protected org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.pekko.remote.WireFormats.internal_static_RemoteEnvelope_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.pekko.remote.WireFormats.RemoteEnvelope.class, org.apache.pekko.remote.WireFormats.RemoteEnvelope.Builder.class);
      }

      // Construct using org.apache.pekko.remote.WireFormats.RemoteEnvelope.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          org.apache.pekko.protobufv3.internal.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (org.apache.pekko.protobufv3.internal.GeneratedMessage
                .alwaysUseFieldBuilders) {
          internalGetRecipientFieldBuilder();
          internalGetMessageFieldBuilder();
          internalGetSenderFieldBuilder();
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        recipient_ = null;
        if (recipientBuilder_ != null) {
          recipientBuilder_.dispose();
          recipientBuilder_ = null;
        }
        message_ = null;
        if (messageBuilder_ != null) {
          messageBuilder_.dispose();
          messageBuilder_ = null;
        }
        sender_ = null;
        if (senderBuilder_ != null) {
          senderBuilder_.dispose();
          senderBuilder_ = null;
        }
        seq_ = 0L;
        return this;
      }

      @java.lang.Override
      public org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.pekko.remote.WireFormats.internal_static_RemoteEnvelope_descriptor;
      }

      @java.lang.Override
      public org.apache.pekko.remote.WireFormats.RemoteEnvelope getDefaultInstanceForType() {
        return org.apache.pekko.remote.WireFormats.RemoteEnvelope.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.pekko.remote.WireFormats.RemoteEnvelope build() {
        org.apache.pekko.remote.WireFormats.RemoteEnvelope result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.pekko.remote.WireFormats.RemoteEnvelope buildPartial() {
        org.apache.pekko.remote.WireFormats.RemoteEnvelope result = new org.apache.pekko.remote.WireFormats.RemoteEnvelope(this);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartial0(org.apache.pekko.remote.WireFormats.RemoteEnvelope result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.recipient_ = recipientBuilder_ == null
              ? recipient_
              : recipientBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.message_ = messageBuilder_ == null
              ? message_
              : messageBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.sender_ = senderBuilder_ == null
              ? sender_
              : senderBuilder_.build();
          to_bitField0_ |= 0x00000004;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.seq_ = seq_;
          to_bitField0_ |= 0x00000008;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder mergeFrom(org.apache.pekko.protobufv3.internal.Message other) {
        if (other instanceof org.apache.pekko.remote.WireFormats.RemoteEnvelope) {
          return mergeFrom((org.apache.pekko.remote.WireFormats.RemoteEnvelope)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.pekko.remote.WireFormats.RemoteEnvelope other) {
        if (other == org.apache.pekko.remote.WireFormats.RemoteEnvelope.getDefaultInstance()) return this;
        if (other.hasRecipient()) {
          mergeRecipient(other.getRecipient());
        }
        if (other.hasMessage()) {
          mergeMessage(other.getMessage());
        }
        if (other.hasSender()) {
          mergeSender(other.getSender());
        }
        if (other.hasSeq()) {
          setSeq(other.getSeq());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        if (!hasRecipient()) {
          return false;
        }
        if (!hasMessage()) {
          return false;
        }
        if (!getRecipient().isInitialized()) {
          return false;
        }
        if (!getMessage().isInitialized()) {
          return false;
        }
        if (hasSender()) {
          if (!getSender().isInitialized()) {
            return false;
          }
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                input.readMessage(
                    internalGetRecipientFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
              case 18: {
                input.readMessage(
                    internalGetMessageFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
              case 34: {
                input.readMessage(
                    internalGetSenderFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 34
              case 41: {
                seq_ = input.readFixed64();
                bitField0_ |= 0x00000008;
                break;
              } // case 41
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private org.apache.pekko.remote.WireFormats.ActorRefData recipient_;
      private org.apache.pekko.protobufv3.internal.SingleFieldBuilder<
          org.apache.pekko.remote.WireFormats.ActorRefData, org.apache.pekko.remote.WireFormats.ActorRefData.Builder, org.apache.pekko.remote.WireFormats.ActorRefDataOrBuilder> recipientBuilder_;
      /**
       * <code>required .ActorRefData recipient = 1;</code>
       * @return Whether the recipient field is set.
       */
      public boolean hasRecipient() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <code>required .ActorRefData recipient = 1;</code>
       * @return The recipient.
       */
      public org.apache.pekko.remote.WireFormats.ActorRefData getRecipient() {
        if (recipientBuilder_ == null) {
          return recipient_ == null ? org.apache.pekko.remote.WireFormats.ActorRefData.getDefaultInstance() : recipient_;
        } else {
          return recipientBuilder_.getMessage();
        }
      }
      /**
       * <code>required .ActorRefData recipient = 1;</code>
       */
      public Builder setRecipient(org.apache.pekko.remote.WireFormats.ActorRefData value) {
        if (recipientBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          recipient_ = value;
        } else {
          recipientBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <code>required .ActorRefData recipient = 1;</code>
       */
      public Builder setRecipient(
          org.apache.pekko.remote.WireFormats.ActorRefData.Builder builderForValue) {
        if (recipientBuilder_ == null) {
          recipient_ = builderForValue.build();
        } else {
          recipientBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <code>required .ActorRefData recipient = 1;</code>
       */
      public Builder mergeRecipient(org.apache.pekko.remote.WireFormats.ActorRefData value) {
        if (recipientBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0) &&
            recipient_ != null &&
            recipient_ != org.apache.pekko.remote.WireFormats.ActorRefData.getDefaultInstance()) {
            getRecipientBuilder().mergeFrom(value);
          } else {
            recipient_ = value;
          }
        } else {
          recipientBuilder_.mergeFrom(value);
        }
        if (recipient_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }
      /**
       * <code>required .ActorRefData recipient = 1;</code>
       */
      public Builder clearRecipient() {
        bitField0_ = (bitField0_ & ~0x00000001);
        recipient_ = null;
        if (recipientBuilder_ != null) {
          recipientBuilder_.dispose();
          recipientBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <code>required .ActorRefData recipient = 1;</code>
       */
      public org.apache.pekko.remote.WireFormats.ActorRefData.Builder getRecipientBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return internalGetRecipientFieldBuilder().getBuilder();
      }
      /**
       * <code>required .ActorRefData recipient = 1;</code>
       */
      public org.apache.pekko.remote.WireFormats.ActorRefDataOrBuilder getRecipientOrBuilder() {
        if (recipientBuilder_ != null) {
          return recipientBuilder_.getMessageOrBuilder();
        } else {
          return recipient_ == null ?
              org.apache.pekko.remote.WireFormats.ActorRefData.getDefaultInstance() : recipient_;
        }
      }
      /**
       * <code>required .ActorRefData recipient = 1;</code>
       */
      private org.apache.pekko.protobufv3.internal.SingleFieldBuilder<
          org.apache.pekko.remote.WireFormats.ActorRefData, org.apache.pekko.remote.WireFormats.ActorRefData.Builder, org.apache.pekko.remote.WireFormats.ActorRefDataOrBuilder> 
          internalGetRecipientFieldBuilder() {
        if (recipientBuilder_ == null) {
          recipientBuilder_ = new org.apache.pekko.protobufv3.internal.SingleFieldBuilder<
              org.apache.pekko.remote.WireFormats.ActorRefData, org.apache.pekko.remote.WireFormats.ActorRefData.Builder, org.apache.pekko.remote.WireFormats.ActorRefDataOrBuilder>(
                  getRecipient(),
                  getParentForChildren(),
                  isClean());
          recipient_ = null;
        }
        return recipientBuilder_;
      }

      private org.apache.pekko.remote.WireFormats.SerializedMessage message_;
      private org.apache.pekko.protobufv3.internal.SingleFieldBuilder<
          org.apache.pekko.remote.WireFormats.SerializedMessage, org.apache.pekko.remote.WireFormats.SerializedMessage.Builder, org.apache.pekko.remote.WireFormats.SerializedMessageOrBuilder> messageBuilder_;
      /**
       * <code>required .SerializedMessage message = 2;</code>
       * @return Whether the message field is set.
       */
      public boolean hasMessage() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <code>required .SerializedMessage message = 2;</code>
       * @return The message.
       */
      public org.apache.pekko.remote.WireFormats.SerializedMessage getMessage() {
        if (messageBuilder_ == null) {
          return message_ == null ? org.apache.pekko.remote.WireFormats.SerializedMessage.getDefaultInstance() : message_;
        } else {
          return messageBuilder_.getMessage();
        }
      }
      /**
       * <code>required .SerializedMessage message = 2;</code>
       */
      public Builder setMessage(org.apache.pekko.remote.WireFormats.SerializedMessage value) {
        if (messageBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          message_ = value;
        } else {
          messageBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <code>required .SerializedMessage message = 2;</code>
       */
      public Builder setMessage(
          org.apache.pekko.remote.WireFormats.SerializedMessage.Builder builderForValue) {
        if (messageBuilder_ == null) {
          message_ = builderForValue.build();
        } else {
          messageBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <code>required .SerializedMessage message = 2;</code>
       */
      public Builder mergeMessage(org.apache.pekko.remote.WireFormats.SerializedMessage value) {
        if (messageBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0) &&
            message_ != null &&
            message_ != org.apache.pekko.remote.WireFormats.SerializedMessage.getDefaultInstance()) {
            getMessageBuilder().mergeFrom(value);
          } else {
            message_ = value;
          }
        } else {
          messageBuilder_.mergeFrom(value);
        }
        if (message_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       * <code>required .SerializedMessage message = 2;</code>
       */
      public Builder clearMessage() {
        bitField0_ = (bitField0_ & ~0x00000002);
        message_ = null;
        if (messageBuilder_ != null) {
          messageBuilder_.dispose();
          messageBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <code>required .SerializedMessage message = 2;</code>
       */
      public org.apache.pekko.remote.WireFormats.SerializedMessage.Builder getMessageBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return internalGetMessageFieldBuilder().getBuilder();
      }
      /**
       * <code>required .SerializedMessage message = 2;</code>
       */
      public org.apache.pekko.remote.WireFormats.SerializedMessageOrBuilder getMessageOrBuilder() {
        if (messageBuilder_ != null) {
          return messageBuilder_.getMessageOrBuilder();
        } else {
          return message_ == null ?
              org.apache.pekko.remote.WireFormats.SerializedMessage.getDefaultInstance() : message_;
        }
      }
      /**
       * <code>required .SerializedMessage message = 2;</code>
       */
      private org.apache.pekko.protobufv3.internal.SingleFieldBuilder<
          org.apache.pekko.remote.WireFormats.SerializedMessage, org.apache.pekko.remote.WireFormats.SerializedMessage.Builder, org.apache.pekko.remote.WireFormats.SerializedMessageOrBuilder> 
          internalGetMessageFieldBuilder() {
        if (messageBuilder_ == null) {
          messageBuilder_ = new org.apache.pekko.protobufv3.internal.SingleFieldBuilder<
              org.apache.pekko.remote.WireFormats.SerializedMessage, org.apache.pekko.remote.WireFormats.SerializedMessage.Builder, org.apache.pekko.remote.WireFormats.SerializedMessageOrBuilder>(
                  getMessage(),
                  getParentForChildren(),
                  isClean());
          message_ = null;
        }
        return messageBuilder_;
      }

      private org.apache.pekko.remote.WireFormats.ActorRefData sender_;
      private org.apache.pekko.protobufv3.internal.SingleFieldBuilder<
          org.apache.pekko.remote.WireFormats.ActorRefData, org.apache.pekko.remote.WireFormats.ActorRefData.Builder, org.apache.pekko.remote.WireFormats.ActorRefDataOrBuilder> senderBuilder_;
      /**
       * <code>optional .ActorRefData sender = 4;</code>
       * @return Whether the sender field is set.
       */
      public boolean hasSender() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       * <code>optional .ActorRefData sender = 4;</code>
       * @return The sender.
       */
      public org.apache.pekko.remote.WireFormats.ActorRefData getSender() {
        if (senderBuilder_ == null) {
          return sender_ == null ? org.apache.pekko.remote.WireFormats.ActorRefData.getDefaultInstance() : sender_;
        } else {
          return senderBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .ActorRefData sender = 4;</code>
       */
      public Builder setSender(org.apache.pekko.remote.WireFormats.ActorRefData value) {
        if (senderBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          sender_ = value;
        } else {
          senderBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       * <code>optional .ActorRefData sender = 4;</code>
       */
      public Builder setSender(
          org.apache.pekko.remote.WireFormats.ActorRefData.Builder builderForValue) {
        if (senderBuilder_ == null) {
          sender_ = builderForValue.build();
        } else {
          senderBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       * <code>optional .ActorRefData sender = 4;</code>
       */
      public Builder mergeSender(org.apache.pekko.remote.WireFormats.ActorRefData value) {
        if (senderBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0) &&
            sender_ != null &&
            sender_ != org.apache.pekko.remote.WireFormats.ActorRefData.getDefaultInstance()) {
            getSenderBuilder().mergeFrom(value);
          } else {
            sender_ = value;
          }
        } else {
          senderBuilder_.mergeFrom(value);
        }
        if (sender_ != null) {
          bitField0_ |= 0x00000004;
          onChanged();
        }
        return this;
      }
      /**
       * <code>optional .ActorRefData sender = 4;</code>
       */
      public Builder clearSender() {
        bitField0_ = (bitField0_ & ~0x00000004);
        sender_ = null;
        if (senderBuilder_ != null) {
          senderBuilder_.dispose();
          senderBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <code>optional .ActorRefData sender = 4;</code>
       */
      public org.apache.pekko.remote.WireFormats.ActorRefData.Builder getSenderBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return internalGetSenderFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .ActorRefData sender = 4;</code>
       */
      public org.apache.pekko.remote.WireFormats.ActorRefDataOrBuilder getSenderOrBuilder() {
        if (senderBuilder_ != null) {
          return senderBuilder_.getMessageOrBuilder();
        } else {
          return sender_ == null ?
              org.apache.pekko.remote.WireFormats.ActorRefData.getDefaultInstance() : sender_;
        }
      }
      /**
       * <code>optional .ActorRefData sender = 4;</code>
       */
      private org.apache.pekko.protobufv3.internal.SingleFieldBuilder<
          org.apache.pekko.remote.WireFormats.ActorRefData, org.apache.pekko.remote.WireFormats.ActorRefData.Builder, org.apache.pekko.remote.WireFormats.ActorRefDataOrBuilder> 
          internalGetSenderFieldBuilder() {
        if (senderBuilder_ == null) {
          senderBuilder_ = new org.apache.pekko.protobufv3.internal.SingleFieldBuilder<
              org.apache.pekko.remote.WireFormats.ActorRefData, org.apache.pekko.remote.WireFormats.ActorRefData.Builder, org.apache.pekko.remote.WireFormats.ActorRefDataOrBuilder>(
                  getSender(),
                  getParentForChildren(),
                  isClean());
          sender_ = null;
        }
        return senderBuilder_;
      }

      private long seq_ ;
      /**
       * <code>optional fixed64 seq = 5;</code>
       * @return Whether the seq field is set.
       */
      @java.lang.Override
      public boolean hasSeq() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       * <code>optional fixed64 seq = 5;</code>
       * @return The seq.
       */
      @java.lang.Override
      public long getSeq() {
        return seq_;
      }
      /**
       * <code>optional fixed64 seq = 5;</code>
       * @param value The seq to set.
       * @return This builder for chaining.
       */
      public Builder setSeq(long value) {

        seq_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       * <code>optional fixed64 seq = 5;</code>
       * @return This builder for chaining.
       */
      public Builder clearSeq() {
        bitField0_ = (bitField0_ & ~0x00000008);
        seq_ = 0L;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:RemoteEnvelope)
    }

    // @@protoc_insertion_point(class_scope:RemoteEnvelope)
    private static final org.apache.pekko.remote.WireFormats.RemoteEnvelope DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.pekko.remote.WireFormats.RemoteEnvelope();
    }

    public static org.apache.pekko.remote.WireFormats.RemoteEnvelope getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final org.apache.pekko.protobufv3.internal.Parser<RemoteEnvelope>
        PARSER = new org.apache.pekko.protobufv3.internal.AbstractParser<RemoteEnvelope>() {
      @java.lang.Override
      public RemoteEnvelope parsePartialFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (org.apache.pekko.protobufv3.internal.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static org.apache.pekko.protobufv3.internal.Parser<RemoteEnvelope> parser() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.pekko.protobufv3.internal.Parser<RemoteEnvelope> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.pekko.remote.WireFormats.RemoteEnvelope getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface AcknowledgementInfoOrBuilder extends
      // @@protoc_insertion_point(interface_extends:AcknowledgementInfo)
      org.apache.pekko.protobufv3.internal.MessageOrBuilder {

    /**
     * <code>required fixed64 cumulativeAck = 1;</code>
     * @return Whether the cumulativeAck field is set.
     */
    boolean hasCumulativeAck();
    /**
     * <code>required fixed64 cumulativeAck = 1;</code>
     * @return The cumulativeAck.
     */
    long getCumulativeAck();

    /**
     * <code>repeated fixed64 nacks = 2;</code>
     * @return A list containing the nacks.
     */
    java.util.List<java.lang.Long> getNacksList();
    /**
     * <code>repeated fixed64 nacks = 2;</code>
     * @return The count of nacks.
     */
    int getNacksCount();
    /**
     * <code>repeated fixed64 nacks = 2;</code>
     * @param index The index of the element to return.
     * @return The nacks at the given index.
     */
    long getNacks(int index);
  }
  /**
   * Protobuf type {@code AcknowledgementInfo}
   */
  public static final class AcknowledgementInfo extends
      org.apache.pekko.protobufv3.internal.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:AcknowledgementInfo)
      AcknowledgementInfoOrBuilder {
  private static final long serialVersionUID = 0L;
    static {
      org.apache.pekko.protobufv3.internal.RuntimeVersion.validateProtobufGencodeVersion(
        org.apache.pekko.protobufv3.internal.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 32,
        /* patch= */ 0,
        /* suffix= */ "",
        AcknowledgementInfo.class.getName());
    }
    // Use AcknowledgementInfo.newBuilder() to construct.
    private AcknowledgementInfo(org.apache.pekko.protobufv3.internal.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }
    private AcknowledgementInfo() {
      nacks_ = emptyLongList();
    }

    public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.pekko.remote.WireFormats.internal_static_AcknowledgementInfo_descriptor;
    }

    @java.lang.Override
    protected org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.pekko.remote.WireFormats.internal_static_AcknowledgementInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.pekko.remote.WireFormats.AcknowledgementInfo.class, org.apache.pekko.remote.WireFormats.AcknowledgementInfo.Builder.class);
    }

    private int bitField0_;
    public static final int CUMULATIVEACK_FIELD_NUMBER = 1;
    private long cumulativeAck_ = 0L;
    /**
     * <code>required fixed64 cumulativeAck = 1;</code>
     * @return Whether the cumulativeAck field is set.
     */
    @java.lang.Override
    public boolean hasCumulativeAck() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <code>required fixed64 cumulativeAck = 1;</code>
     * @return The cumulativeAck.
     */
    @java.lang.Override
    public long getCumulativeAck() {
      return cumulativeAck_;
    }

    public static final int NACKS_FIELD_NUMBER = 2;
    @SuppressWarnings("serial")
    private org.apache.pekko.protobufv3.internal.Internal.LongList nacks_ =
        emptyLongList();
    /**
     * <code>repeated fixed64 nacks = 2;</code>
     * @return A list containing the nacks.
     */
    @java.lang.Override
    public java.util.List<java.lang.Long>
        getNacksList() {
      return nacks_;
    }
    /**
     * <code>repeated fixed64 nacks = 2;</code>
     * @return The count of nacks.
     */
    public int getNacksCount() {
      return nacks_.size();
    }
    /**
     * <code>repeated fixed64 nacks = 2;</code>
     * @param index The index of the element to return.
     * @return The nacks at the given index.
     */
    public long getNacks(int index) {
      return nacks_.getLong(index);
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasCumulativeAck()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(org.apache.pekko.protobufv3.internal.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeFixed64(1, cumulativeAck_);
      }
      for (int i = 0; i < nacks_.size(); i++) {
        output.writeFixed64(2, nacks_.getLong(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeFixed64Size(1, cumulativeAck_);
      }
      {
        int dataSize = 0;
        dataSize = 8 * getNacksList().size();
        size += dataSize;
        size += 1 * getNacksList().size();
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.pekko.remote.WireFormats.AcknowledgementInfo)) {
        return super.equals(obj);
      }
      org.apache.pekko.remote.WireFormats.AcknowledgementInfo other = (org.apache.pekko.remote.WireFormats.AcknowledgementInfo) obj;

      if (hasCumulativeAck() != other.hasCumulativeAck()) return false;
      if (hasCumulativeAck()) {
        if (getCumulativeAck()
            != other.getCumulativeAck()) return false;
      }
      if (!getNacksList()
          .equals(other.getNacksList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasCumulativeAck()) {
        hash = (37 * hash) + CUMULATIVEACK_FIELD_NUMBER;
        hash = (53 * hash) + org.apache.pekko.protobufv3.internal.Internal.hashLong(
            getCumulativeAck());
      }
      if (getNacksCount() > 0) {
        hash = (37 * hash) + NACKS_FIELD_NUMBER;
        hash = (53 * hash) + getNacksList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.pekko.remote.WireFormats.AcknowledgementInfo parseFrom(
        java.nio.ByteBuffer data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.remote.WireFormats.AcknowledgementInfo parseFrom(
        java.nio.ByteBuffer data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.AcknowledgementInfo parseFrom(
        org.apache.pekko.protobufv3.internal.ByteString data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.remote.WireFormats.AcknowledgementInfo parseFrom(
        org.apache.pekko.protobufv3.internal.ByteString data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.AcknowledgementInfo parseFrom(byte[] data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.remote.WireFormats.AcknowledgementInfo parseFrom(
        byte[] data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.AcknowledgementInfo parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.pekko.remote.WireFormats.AcknowledgementInfo parseFrom(
        java.io.InputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static org.apache.pekko.remote.WireFormats.AcknowledgementInfo parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static org.apache.pekko.remote.WireFormats.AcknowledgementInfo parseDelimitedFrom(
        java.io.InputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.AcknowledgementInfo parseFrom(
        org.apache.pekko.protobufv3.internal.CodedInputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.pekko.remote.WireFormats.AcknowledgementInfo parseFrom(
        org.apache.pekko.protobufv3.internal.CodedInputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.pekko.remote.WireFormats.AcknowledgementInfo prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        org.apache.pekko.protobufv3.internal.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code AcknowledgementInfo}
     */
    public static final class Builder extends
        org.apache.pekko.protobufv3.internal.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:AcknowledgementInfo)
        org.apache.pekko.remote.WireFormats.AcknowledgementInfoOrBuilder {
      public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.pekko.remote.WireFormats.internal_static_AcknowledgementInfo_descriptor;
      }

      @java.lang.Override
      protected org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.pekko.remote.WireFormats.internal_static_AcknowledgementInfo_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.pekko.remote.WireFormats.AcknowledgementInfo.class, org.apache.pekko.remote.WireFormats.AcknowledgementInfo.Builder.class);
      }

      // Construct using org.apache.pekko.remote.WireFormats.AcknowledgementInfo.newBuilder()
      private Builder() {

      }

      private Builder(
          org.apache.pekko.protobufv3.internal.GeneratedMessage.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        cumulativeAck_ = 0L;
        nacks_ = emptyLongList();
        return this;
      }

      @java.lang.Override
      public org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.pekko.remote.WireFormats.internal_static_AcknowledgementInfo_descriptor;
      }

      @java.lang.Override
      public org.apache.pekko.remote.WireFormats.AcknowledgementInfo getDefaultInstanceForType() {
        return org.apache.pekko.remote.WireFormats.AcknowledgementInfo.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.pekko.remote.WireFormats.AcknowledgementInfo build() {
        org.apache.pekko.remote.WireFormats.AcknowledgementInfo result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.pekko.remote.WireFormats.AcknowledgementInfo buildPartial() {
        org.apache.pekko.remote.WireFormats.AcknowledgementInfo result = new org.apache.pekko.remote.WireFormats.AcknowledgementInfo(this);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartial0(org.apache.pekko.remote.WireFormats.AcknowledgementInfo result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.cumulativeAck_ = cumulativeAck_;
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          nacks_.makeImmutable();
          result.nacks_ = nacks_;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder mergeFrom(org.apache.pekko.protobufv3.internal.Message other) {
        if (other instanceof org.apache.pekko.remote.WireFormats.AcknowledgementInfo) {
          return mergeFrom((org.apache.pekko.remote.WireFormats.AcknowledgementInfo)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.pekko.remote.WireFormats.AcknowledgementInfo other) {
        if (other == org.apache.pekko.remote.WireFormats.AcknowledgementInfo.getDefaultInstance()) return this;
        if (other.hasCumulativeAck()) {
          setCumulativeAck(other.getCumulativeAck());
        }
        if (!other.nacks_.isEmpty()) {
          if (nacks_.isEmpty()) {
            nacks_ = other.nacks_;
            nacks_.makeImmutable();
            bitField0_ |= 0x00000002;
          } else {
            ensureNacksIsMutable();
            nacks_.addAll(other.nacks_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        if (!hasCumulativeAck()) {
          return false;
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 9: {
                cumulativeAck_ = input.readFixed64();
                bitField0_ |= 0x00000001;
                break;
              } // case 9
              case 17: {
                long v = input.readFixed64();
                ensureNacksIsMutable();
                nacks_.addLong(v);
                break;
              } // case 17
              case 18: {
                int length = input.readRawVarint32();
                int limit = input.pushLimit(length);
                int alloc = length > 4096 ? 4096 : length;
                ensureNacksIsMutable(alloc / 8);
                while (input.getBytesUntilLimit() > 0) {
                  nacks_.addLong(input.readFixed64());
                }
                input.popLimit(limit);
                break;
              } // case 18
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private long cumulativeAck_ ;
      /**
       * <code>required fixed64 cumulativeAck = 1;</code>
       * @return Whether the cumulativeAck field is set.
       */
      @java.lang.Override
      public boolean hasCumulativeAck() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <code>required fixed64 cumulativeAck = 1;</code>
       * @return The cumulativeAck.
       */
      @java.lang.Override
      public long getCumulativeAck() {
        return cumulativeAck_;
      }
      /**
       * <code>required fixed64 cumulativeAck = 1;</code>
       * @param value The cumulativeAck to set.
       * @return This builder for chaining.
       */
      public Builder setCumulativeAck(long value) {

        cumulativeAck_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <code>required fixed64 cumulativeAck = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearCumulativeAck() {
        bitField0_ = (bitField0_ & ~0x00000001);
        cumulativeAck_ = 0L;
        onChanged();
        return this;
      }

      private org.apache.pekko.protobufv3.internal.Internal.LongList nacks_ = emptyLongList();
      private void ensureNacksIsMutable() {
        if (!nacks_.isModifiable()) {
          nacks_ = makeMutableCopy(nacks_);
        }
        bitField0_ |= 0x00000002;
      }
      private void ensureNacksIsMutable(int capacity) {
        if (!nacks_.isModifiable()) {
          nacks_ = makeMutableCopy(nacks_, capacity);
        }
        bitField0_ |= 0x00000002;
      }
      /**
       * <code>repeated fixed64 nacks = 2;</code>
       * @return A list containing the nacks.
       */
      public java.util.List<java.lang.Long>
          getNacksList() {
        nacks_.makeImmutable();
        return nacks_;
      }
      /**
       * <code>repeated fixed64 nacks = 2;</code>
       * @return The count of nacks.
       */
      public int getNacksCount() {
        return nacks_.size();
      }
      /**
       * <code>repeated fixed64 nacks = 2;</code>
       * @param index The index of the element to return.
       * @return The nacks at the given index.
       */
      public long getNacks(int index) {
        return nacks_.getLong(index);
      }
      /**
       * <code>repeated fixed64 nacks = 2;</code>
       * @param index The index to set the value at.
       * @param value The nacks to set.
       * @return This builder for chaining.
       */
      public Builder setNacks(
          int index, long value) {

        ensureNacksIsMutable();
        nacks_.setLong(index, value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <code>repeated fixed64 nacks = 2;</code>
       * @param value The nacks to add.
       * @return This builder for chaining.
       */
      public Builder addNacks(long value) {

        ensureNacksIsMutable();
        nacks_.addLong(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <code>repeated fixed64 nacks = 2;</code>
       * @param values The nacks to add.
       * @return This builder for chaining.
       */
      public Builder addAllNacks(
          java.lang.Iterable<? extends java.lang.Long> values) {
        ensureNacksIsMutable();
        org.apache.pekko.protobufv3.internal.AbstractMessageLite.Builder.addAll(
            values, nacks_);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <code>repeated fixed64 nacks = 2;</code>
       * @return This builder for chaining.
       */
      public Builder clearNacks() {
        nacks_ = emptyLongList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:AcknowledgementInfo)
    }

    // @@protoc_insertion_point(class_scope:AcknowledgementInfo)
    private static final org.apache.pekko.remote.WireFormats.AcknowledgementInfo DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.pekko.remote.WireFormats.AcknowledgementInfo();
    }

    public static org.apache.pekko.remote.WireFormats.AcknowledgementInfo getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final org.apache.pekko.protobufv3.internal.Parser<AcknowledgementInfo>
        PARSER = new org.apache.pekko.protobufv3.internal.AbstractParser<AcknowledgementInfo>() {
      @java.lang.Override
      public AcknowledgementInfo parsePartialFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (org.apache.pekko.protobufv3.internal.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static org.apache.pekko.protobufv3.internal.Parser<AcknowledgementInfo> parser() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.pekko.protobufv3.internal.Parser<AcknowledgementInfo> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.pekko.remote.WireFormats.AcknowledgementInfo getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface ActorRefDataOrBuilder extends
      // @@protoc_insertion_point(interface_extends:ActorRefData)
      org.apache.pekko.protobufv3.internal.MessageOrBuilder {

    /**
     * <code>required string path = 1;</code>
     * @return Whether the path field is set.
     */
    boolean hasPath();
    /**
     * <code>required string path = 1;</code>
     * @return The path.
     */
    java.lang.String getPath();
    /**
     * <code>required string path = 1;</code>
     * @return The bytes for path.
     */
    org.apache.pekko.protobufv3.internal.ByteString
        getPathBytes();
  }
  /**
   * <pre>
   * *
   * Defines a remote ActorRef that "remembers" and uses its original Actor instance
   * on the original node.
   * </pre>
   *
   * Protobuf type {@code ActorRefData}
   */
  public static final class ActorRefData extends
      org.apache.pekko.protobufv3.internal.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:ActorRefData)
      ActorRefDataOrBuilder {
  private static final long serialVersionUID = 0L;
    static {
      org.apache.pekko.protobufv3.internal.RuntimeVersion.validateProtobufGencodeVersion(
        org.apache.pekko.protobufv3.internal.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 32,
        /* patch= */ 0,
        /* suffix= */ "",
        ActorRefData.class.getName());
    }
    // Use ActorRefData.newBuilder() to construct.
    private ActorRefData(org.apache.pekko.protobufv3.internal.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }
    private ActorRefData() {
      path_ = "";
    }

    public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.pekko.remote.WireFormats.internal_static_ActorRefData_descriptor;
    }

    @java.lang.Override
    protected org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.pekko.remote.WireFormats.internal_static_ActorRefData_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.pekko.remote.WireFormats.ActorRefData.class, org.apache.pekko.remote.WireFormats.ActorRefData.Builder.class);
    }

    private int bitField0_;
    public static final int PATH_FIELD_NUMBER = 1;
    @SuppressWarnings("serial")
    private volatile java.lang.Object path_ = "";
    /**
     * <code>required string path = 1;</code>
     * @return Whether the path field is set.
     */
    @java.lang.Override
    public boolean hasPath() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <code>required string path = 1;</code>
     * @return The path.
     */
    @java.lang.Override
    public java.lang.String getPath() {
      java.lang.Object ref = path_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        org.apache.pekko.protobufv3.internal.ByteString bs = 
            (org.apache.pekko.protobufv3.internal.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          path_ = s;
        }
        return s;
      }
    }
    /**
     * <code>required string path = 1;</code>
     * @return The bytes for path.
     */
    @java.lang.Override
    public org.apache.pekko.protobufv3.internal.ByteString
        getPathBytes() {
      java.lang.Object ref = path_;
      if (ref instanceof java.lang.String) {
        org.apache.pekko.protobufv3.internal.ByteString b = 
            org.apache.pekko.protobufv3.internal.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        path_ = b;
        return b;
      } else {
        return (org.apache.pekko.protobufv3.internal.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasPath()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(org.apache.pekko.protobufv3.internal.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        org.apache.pekko.protobufv3.internal.GeneratedMessage.writeString(output, 1, path_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += org.apache.pekko.protobufv3.internal.GeneratedMessage.computeStringSize(1, path_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.pekko.remote.WireFormats.ActorRefData)) {
        return super.equals(obj);
      }
      org.apache.pekko.remote.WireFormats.ActorRefData other = (org.apache.pekko.remote.WireFormats.ActorRefData) obj;

      if (hasPath() != other.hasPath()) return false;
      if (hasPath()) {
        if (!getPath()
            .equals(other.getPath())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasPath()) {
        hash = (37 * hash) + PATH_FIELD_NUMBER;
        hash = (53 * hash) + getPath().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.pekko.remote.WireFormats.ActorRefData parseFrom(
        java.nio.ByteBuffer data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.remote.WireFormats.ActorRefData parseFrom(
        java.nio.ByteBuffer data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.ActorRefData parseFrom(
        org.apache.pekko.protobufv3.internal.ByteString data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.remote.WireFormats.ActorRefData parseFrom(
        org.apache.pekko.protobufv3.internal.ByteString data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.ActorRefData parseFrom(byte[] data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.remote.WireFormats.ActorRefData parseFrom(
        byte[] data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.ActorRefData parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.pekko.remote.WireFormats.ActorRefData parseFrom(
        java.io.InputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static org.apache.pekko.remote.WireFormats.ActorRefData parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static org.apache.pekko.remote.WireFormats.ActorRefData parseDelimitedFrom(
        java.io.InputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.ActorRefData parseFrom(
        org.apache.pekko.protobufv3.internal.CodedInputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.pekko.remote.WireFormats.ActorRefData parseFrom(
        org.apache.pekko.protobufv3.internal.CodedInputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.pekko.remote.WireFormats.ActorRefData prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        org.apache.pekko.protobufv3.internal.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * *
     * Defines a remote ActorRef that "remembers" and uses its original Actor instance
     * on the original node.
     * </pre>
     *
     * Protobuf type {@code ActorRefData}
     */
    public static final class Builder extends
        org.apache.pekko.protobufv3.internal.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:ActorRefData)
        org.apache.pekko.remote.WireFormats.ActorRefDataOrBuilder {
      public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.pekko.remote.WireFormats.internal_static_ActorRefData_descriptor;
      }

      @java.lang.Override
      protected org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.pekko.remote.WireFormats.internal_static_ActorRefData_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.pekko.remote.WireFormats.ActorRefData.class, org.apache.pekko.remote.WireFormats.ActorRefData.Builder.class);
      }

      // Construct using org.apache.pekko.remote.WireFormats.ActorRefData.newBuilder()
      private Builder() {

      }

      private Builder(
          org.apache.pekko.protobufv3.internal.GeneratedMessage.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        path_ = "";
        return this;
      }

      @java.lang.Override
      public org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.pekko.remote.WireFormats.internal_static_ActorRefData_descriptor;
      }

      @java.lang.Override
      public org.apache.pekko.remote.WireFormats.ActorRefData getDefaultInstanceForType() {
        return org.apache.pekko.remote.WireFormats.ActorRefData.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.pekko.remote.WireFormats.ActorRefData build() {
        org.apache.pekko.remote.WireFormats.ActorRefData result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.pekko.remote.WireFormats.ActorRefData buildPartial() {
        org.apache.pekko.remote.WireFormats.ActorRefData result = new org.apache.pekko.remote.WireFormats.ActorRefData(this);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartial0(org.apache.pekko.remote.WireFormats.ActorRefData result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.path_ = path_;
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder mergeFrom(org.apache.pekko.protobufv3.internal.Message other) {
        if (other instanceof org.apache.pekko.remote.WireFormats.ActorRefData) {
          return mergeFrom((org.apache.pekko.remote.WireFormats.ActorRefData)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.pekko.remote.WireFormats.ActorRefData other) {
        if (other == org.apache.pekko.remote.WireFormats.ActorRefData.getDefaultInstance()) return this;
        if (other.hasPath()) {
          path_ = other.path_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        if (!hasPath()) {
          return false;
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                path_ = input.readBytes();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private java.lang.Object path_ = "";
      /**
       * <code>required string path = 1;</code>
       * @return Whether the path field is set.
       */
      public boolean hasPath() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <code>required string path = 1;</code>
       * @return The path.
       */
      public java.lang.String getPath() {
        java.lang.Object ref = path_;
        if (!(ref instanceof java.lang.String)) {
          org.apache.pekko.protobufv3.internal.ByteString bs =
              (org.apache.pekko.protobufv3.internal.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            path_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>required string path = 1;</code>
       * @return The bytes for path.
       */
      public org.apache.pekko.protobufv3.internal.ByteString
          getPathBytes() {
        java.lang.Object ref = path_;
        if (ref instanceof String) {
          org.apache.pekko.protobufv3.internal.ByteString b = 
              org.apache.pekko.protobufv3.internal.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          path_ = b;
          return b;
        } else {
          return (org.apache.pekko.protobufv3.internal.ByteString) ref;
        }
      }
      /**
       * <code>required string path = 1;</code>
       * @param value The path to set.
       * @return This builder for chaining.
       */
      public Builder setPath(
          java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        path_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <code>required string path = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearPath() {
        path_ = getDefaultInstance().getPath();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       * <code>required string path = 1;</code>
       * @param value The bytes for path to set.
       * @return This builder for chaining.
       */
      public Builder setPathBytes(
          org.apache.pekko.protobufv3.internal.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        path_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:ActorRefData)
    }

    // @@protoc_insertion_point(class_scope:ActorRefData)
    private static final org.apache.pekko.remote.WireFormats.ActorRefData DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.pekko.remote.WireFormats.ActorRefData();
    }

    public static org.apache.pekko.remote.WireFormats.ActorRefData getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final org.apache.pekko.protobufv3.internal.Parser<ActorRefData>
        PARSER = new org.apache.pekko.protobufv3.internal.AbstractParser<ActorRefData>() {
      @java.lang.Override
      public ActorRefData parsePartialFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (org.apache.pekko.protobufv3.internal.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static org.apache.pekko.protobufv3.internal.Parser<ActorRefData> parser() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.pekko.protobufv3.internal.Parser<ActorRefData> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.pekko.remote.WireFormats.ActorRefData getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface SerializedMessageOrBuilder extends
      // @@protoc_insertion_point(interface_extends:SerializedMessage)
      org.apache.pekko.protobufv3.internal.MessageOrBuilder {

    /**
     * <code>required bytes message = 1;</code>
     * @return Whether the message field is set.
     */
    boolean hasMessage();
    /**
     * <code>required bytes message = 1;</code>
     * @return The message.
     */
    org.apache.pekko.protobufv3.internal.ByteString getMessage();

    /**
     * <code>required int32 serializerId = 2;</code>
     * @return Whether the serializerId field is set.
     */
    boolean hasSerializerId();
    /**
     * <code>required int32 serializerId = 2;</code>
     * @return The serializerId.
     */
    int getSerializerId();

    /**
     * <code>optional bytes messageManifest = 3;</code>
     * @return Whether the messageManifest field is set.
     */
    boolean hasMessageManifest();
    /**
     * <code>optional bytes messageManifest = 3;</code>
     * @return The messageManifest.
     */
    org.apache.pekko.protobufv3.internal.ByteString getMessageManifest();
  }
  /**
   * <pre>
   * *
   * Defines a message.
   * </pre>
   *
   * Protobuf type {@code SerializedMessage}
   */
  public static final class SerializedMessage extends
      org.apache.pekko.protobufv3.internal.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:SerializedMessage)
      SerializedMessageOrBuilder {
  private static final long serialVersionUID = 0L;
    static {
      org.apache.pekko.protobufv3.internal.RuntimeVersion.validateProtobufGencodeVersion(
        org.apache.pekko.protobufv3.internal.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 32,
        /* patch= */ 0,
        /* suffix= */ "",
        SerializedMessage.class.getName());
    }
    // Use SerializedMessage.newBuilder() to construct.
    private SerializedMessage(org.apache.pekko.protobufv3.internal.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }
    private SerializedMessage() {
      message_ = org.apache.pekko.protobufv3.internal.ByteString.EMPTY;
      messageManifest_ = org.apache.pekko.protobufv3.internal.ByteString.EMPTY;
    }

    public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.pekko.remote.WireFormats.internal_static_SerializedMessage_descriptor;
    }

    @java.lang.Override
    protected org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.pekko.remote.WireFormats.internal_static_SerializedMessage_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.pekko.remote.WireFormats.SerializedMessage.class, org.apache.pekko.remote.WireFormats.SerializedMessage.Builder.class);
    }

    private int bitField0_;
    public static final int MESSAGE_FIELD_NUMBER = 1;
    private org.apache.pekko.protobufv3.internal.ByteString message_ = org.apache.pekko.protobufv3.internal.ByteString.EMPTY;
    /**
     * <code>required bytes message = 1;</code>
     * @return Whether the message field is set.
     */
    @java.lang.Override
    public boolean hasMessage() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <code>required bytes message = 1;</code>
     * @return The message.
     */
    @java.lang.Override
    public org.apache.pekko.protobufv3.internal.ByteString getMessage() {
      return message_;
    }

    public static final int SERIALIZERID_FIELD_NUMBER = 2;
    private int serializerId_ = 0;
    /**
     * <code>required int32 serializerId = 2;</code>
     * @return Whether the serializerId field is set.
     */
    @java.lang.Override
    public boolean hasSerializerId() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <code>required int32 serializerId = 2;</code>
     * @return The serializerId.
     */
    @java.lang.Override
    public int getSerializerId() {
      return serializerId_;
    }

    public static final int MESSAGEMANIFEST_FIELD_NUMBER = 3;
    private org.apache.pekko.protobufv3.internal.ByteString messageManifest_ = org.apache.pekko.protobufv3.internal.ByteString.EMPTY;
    /**
     * <code>optional bytes messageManifest = 3;</code>
     * @return Whether the messageManifest field is set.
     */
    @java.lang.Override
    public boolean hasMessageManifest() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     * <code>optional bytes messageManifest = 3;</code>
     * @return The messageManifest.
     */
    @java.lang.Override
    public org.apache.pekko.protobufv3.internal.ByteString getMessageManifest() {
      return messageManifest_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasMessage()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!hasSerializerId()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(org.apache.pekko.protobufv3.internal.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeBytes(1, message_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeInt32(2, serializerId_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        output.writeBytes(3, messageManifest_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeBytesSize(1, message_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeInt32Size(2, serializerId_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeBytesSize(3, messageManifest_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.pekko.remote.WireFormats.SerializedMessage)) {
        return super.equals(obj);
      }
      org.apache.pekko.remote.WireFormats.SerializedMessage other = (org.apache.pekko.remote.WireFormats.SerializedMessage) obj;

      if (hasMessage() != other.hasMessage()) return false;
      if (hasMessage()) {
        if (!getMessage()
            .equals(other.getMessage())) return false;
      }
      if (hasSerializerId() != other.hasSerializerId()) return false;
      if (hasSerializerId()) {
        if (getSerializerId()
            != other.getSerializerId()) return false;
      }
      if (hasMessageManifest() != other.hasMessageManifest()) return false;
      if (hasMessageManifest()) {
        if (!getMessageManifest()
            .equals(other.getMessageManifest())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasMessage()) {
        hash = (37 * hash) + MESSAGE_FIELD_NUMBER;
        hash = (53 * hash) + getMessage().hashCode();
      }
      if (hasSerializerId()) {
        hash = (37 * hash) + SERIALIZERID_FIELD_NUMBER;
        hash = (53 * hash) + getSerializerId();
      }
      if (hasMessageManifest()) {
        hash = (37 * hash) + MESSAGEMANIFEST_FIELD_NUMBER;
        hash = (53 * hash) + getMessageManifest().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.pekko.remote.WireFormats.SerializedMessage parseFrom(
        java.nio.ByteBuffer data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.remote.WireFormats.SerializedMessage parseFrom(
        java.nio.ByteBuffer data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.SerializedMessage parseFrom(
        org.apache.pekko.protobufv3.internal.ByteString data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.remote.WireFormats.SerializedMessage parseFrom(
        org.apache.pekko.protobufv3.internal.ByteString data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.SerializedMessage parseFrom(byte[] data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.remote.WireFormats.SerializedMessage parseFrom(
        byte[] data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.SerializedMessage parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.pekko.remote.WireFormats.SerializedMessage parseFrom(
        java.io.InputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static org.apache.pekko.remote.WireFormats.SerializedMessage parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static org.apache.pekko.remote.WireFormats.SerializedMessage parseDelimitedFrom(
        java.io.InputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.SerializedMessage parseFrom(
        org.apache.pekko.protobufv3.internal.CodedInputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.pekko.remote.WireFormats.SerializedMessage parseFrom(
        org.apache.pekko.protobufv3.internal.CodedInputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.pekko.remote.WireFormats.SerializedMessage prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        org.apache.pekko.protobufv3.internal.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * *
     * Defines a message.
     * </pre>
     *
     * Protobuf type {@code SerializedMessage}
     */
    public static final class Builder extends
        org.apache.pekko.protobufv3.internal.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:SerializedMessage)
        org.apache.pekko.remote.WireFormats.SerializedMessageOrBuilder {
      public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.pekko.remote.WireFormats.internal_static_SerializedMessage_descriptor;
      }

      @java.lang.Override
      protected org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.pekko.remote.WireFormats.internal_static_SerializedMessage_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.pekko.remote.WireFormats.SerializedMessage.class, org.apache.pekko.remote.WireFormats.SerializedMessage.Builder.class);
      }

      // Construct using org.apache.pekko.remote.WireFormats.SerializedMessage.newBuilder()
      private Builder() {

      }

      private Builder(
          org.apache.pekko.protobufv3.internal.GeneratedMessage.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        message_ = org.apache.pekko.protobufv3.internal.ByteString.EMPTY;
        serializerId_ = 0;
        messageManifest_ = org.apache.pekko.protobufv3.internal.ByteString.EMPTY;
        return this;
      }

      @java.lang.Override
      public org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.pekko.remote.WireFormats.internal_static_SerializedMessage_descriptor;
      }

      @java.lang.Override
      public org.apache.pekko.remote.WireFormats.SerializedMessage getDefaultInstanceForType() {
        return org.apache.pekko.remote.WireFormats.SerializedMessage.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.pekko.remote.WireFormats.SerializedMessage build() {
        org.apache.pekko.remote.WireFormats.SerializedMessage result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.pekko.remote.WireFormats.SerializedMessage buildPartial() {
        org.apache.pekko.remote.WireFormats.SerializedMessage result = new org.apache.pekko.remote.WireFormats.SerializedMessage(this);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartial0(org.apache.pekko.remote.WireFormats.SerializedMessage result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.message_ = message_;
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.serializerId_ = serializerId_;
          to_bitField0_ |= 0x00000002;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.messageManifest_ = messageManifest_;
          to_bitField0_ |= 0x00000004;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder mergeFrom(org.apache.pekko.protobufv3.internal.Message other) {
        if (other instanceof org.apache.pekko.remote.WireFormats.SerializedMessage) {
          return mergeFrom((org.apache.pekko.remote.WireFormats.SerializedMessage)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.pekko.remote.WireFormats.SerializedMessage other) {
        if (other == org.apache.pekko.remote.WireFormats.SerializedMessage.getDefaultInstance()) return this;
        if (other.hasMessage()) {
          setMessage(other.getMessage());
        }
        if (other.hasSerializerId()) {
          setSerializerId(other.getSerializerId());
        }
        if (other.hasMessageManifest()) {
          setMessageManifest(other.getMessageManifest());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        if (!hasMessage()) {
          return false;
        }
        if (!hasSerializerId()) {
          return false;
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                message_ = input.readBytes();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
              case 16: {
                serializerId_ = input.readInt32();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
              case 26: {
                messageManifest_ = input.readBytes();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private org.apache.pekko.protobufv3.internal.ByteString message_ = org.apache.pekko.protobufv3.internal.ByteString.EMPTY;
      /**
       * <code>required bytes message = 1;</code>
       * @return Whether the message field is set.
       */
      @java.lang.Override
      public boolean hasMessage() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <code>required bytes message = 1;</code>
       * @return The message.
       */
      @java.lang.Override
      public org.apache.pekko.protobufv3.internal.ByteString getMessage() {
        return message_;
      }
      /**
       * <code>required bytes message = 1;</code>
       * @param value The message to set.
       * @return This builder for chaining.
       */
      public Builder setMessage(org.apache.pekko.protobufv3.internal.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        message_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <code>required bytes message = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearMessage() {
        bitField0_ = (bitField0_ & ~0x00000001);
        message_ = getDefaultInstance().getMessage();
        onChanged();
        return this;
      }

      private int serializerId_ ;
      /**
       * <code>required int32 serializerId = 2;</code>
       * @return Whether the serializerId field is set.
       */
      @java.lang.Override
      public boolean hasSerializerId() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <code>required int32 serializerId = 2;</code>
       * @return The serializerId.
       */
      @java.lang.Override
      public int getSerializerId() {
        return serializerId_;
      }
      /**
       * <code>required int32 serializerId = 2;</code>
       * @param value The serializerId to set.
       * @return This builder for chaining.
       */
      public Builder setSerializerId(int value) {

        serializerId_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <code>required int32 serializerId = 2;</code>
       * @return This builder for chaining.
       */
      public Builder clearSerializerId() {
        bitField0_ = (bitField0_ & ~0x00000002);
        serializerId_ = 0;
        onChanged();
        return this;
      }

      private org.apache.pekko.protobufv3.internal.ByteString messageManifest_ = org.apache.pekko.protobufv3.internal.ByteString.EMPTY;
      /**
       * <code>optional bytes messageManifest = 3;</code>
       * @return Whether the messageManifest field is set.
       */
      @java.lang.Override
      public boolean hasMessageManifest() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       * <code>optional bytes messageManifest = 3;</code>
       * @return The messageManifest.
       */
      @java.lang.Override
      public org.apache.pekko.protobufv3.internal.ByteString getMessageManifest() {
        return messageManifest_;
      }
      /**
       * <code>optional bytes messageManifest = 3;</code>
       * @param value The messageManifest to set.
       * @return This builder for chaining.
       */
      public Builder setMessageManifest(org.apache.pekko.protobufv3.internal.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        messageManifest_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       * <code>optional bytes messageManifest = 3;</code>
       * @return This builder for chaining.
       */
      public Builder clearMessageManifest() {
        bitField0_ = (bitField0_ & ~0x00000004);
        messageManifest_ = getDefaultInstance().getMessageManifest();
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:SerializedMessage)
    }

    // @@protoc_insertion_point(class_scope:SerializedMessage)
    private static final org.apache.pekko.remote.WireFormats.SerializedMessage DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.pekko.remote.WireFormats.SerializedMessage();
    }

    public static org.apache.pekko.remote.WireFormats.SerializedMessage getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final org.apache.pekko.protobufv3.internal.Parser<SerializedMessage>
        PARSER = new org.apache.pekko.protobufv3.internal.AbstractParser<SerializedMessage>() {
      @java.lang.Override
      public SerializedMessage parsePartialFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (org.apache.pekko.protobufv3.internal.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static org.apache.pekko.protobufv3.internal.Parser<SerializedMessage> parser() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.pekko.protobufv3.internal.Parser<SerializedMessage> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.pekko.remote.WireFormats.SerializedMessage getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface DaemonMsgCreateDataOrBuilder extends
      // @@protoc_insertion_point(interface_extends:DaemonMsgCreateData)
      org.apache.pekko.protobufv3.internal.MessageOrBuilder {

    /**
     * <code>required .PropsData props = 1;</code>
     * @return Whether the props field is set.
     */
    boolean hasProps();
    /**
     * <code>required .PropsData props = 1;</code>
     * @return The props.
     */
    org.apache.pekko.remote.WireFormats.PropsData getProps();
    /**
     * <code>required .PropsData props = 1;</code>
     */
    org.apache.pekko.remote.WireFormats.PropsDataOrBuilder getPropsOrBuilder();

    /**
     * <code>required .DeployData deploy = 2;</code>
     * @return Whether the deploy field is set.
     */
    boolean hasDeploy();
    /**
     * <code>required .DeployData deploy = 2;</code>
     * @return The deploy.
     */
    org.apache.pekko.remote.WireFormats.DeployData getDeploy();
    /**
     * <code>required .DeployData deploy = 2;</code>
     */
    org.apache.pekko.remote.WireFormats.DeployDataOrBuilder getDeployOrBuilder();

    /**
     * <code>required string path = 3;</code>
     * @return Whether the path field is set.
     */
    boolean hasPath();
    /**
     * <code>required string path = 3;</code>
     * @return The path.
     */
    java.lang.String getPath();
    /**
     * <code>required string path = 3;</code>
     * @return The bytes for path.
     */
    org.apache.pekko.protobufv3.internal.ByteString
        getPathBytes();

    /**
     * <code>required .ActorRefData supervisor = 4;</code>
     * @return Whether the supervisor field is set.
     */
    boolean hasSupervisor();
    /**
     * <code>required .ActorRefData supervisor = 4;</code>
     * @return The supervisor.
     */
    org.apache.pekko.remote.WireFormats.ActorRefData getSupervisor();
    /**
     * <code>required .ActorRefData supervisor = 4;</code>
     */
    org.apache.pekko.remote.WireFormats.ActorRefDataOrBuilder getSupervisorOrBuilder();
  }
  /**
   * <pre>
   * *
   * Defines org.apache.pekko.remote.DaemonMsgCreate
   * </pre>
   *
   * Protobuf type {@code DaemonMsgCreateData}
   */
  public static final class DaemonMsgCreateData extends
      org.apache.pekko.protobufv3.internal.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:DaemonMsgCreateData)
      DaemonMsgCreateDataOrBuilder {
  private static final long serialVersionUID = 0L;
    static {
      org.apache.pekko.protobufv3.internal.RuntimeVersion.validateProtobufGencodeVersion(
        org.apache.pekko.protobufv3.internal.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 32,
        /* patch= */ 0,
        /* suffix= */ "",
        DaemonMsgCreateData.class.getName());
    }
    // Use DaemonMsgCreateData.newBuilder() to construct.
    private DaemonMsgCreateData(org.apache.pekko.protobufv3.internal.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }
    private DaemonMsgCreateData() {
      path_ = "";
    }

    public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.pekko.remote.WireFormats.internal_static_DaemonMsgCreateData_descriptor;
    }

    @java.lang.Override
    protected org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.pekko.remote.WireFormats.internal_static_DaemonMsgCreateData_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.pekko.remote.WireFormats.DaemonMsgCreateData.class, org.apache.pekko.remote.WireFormats.DaemonMsgCreateData.Builder.class);
    }

    private int bitField0_;
    public static final int PROPS_FIELD_NUMBER = 1;
    private org.apache.pekko.remote.WireFormats.PropsData props_;
    /**
     * <code>required .PropsData props = 1;</code>
     * @return Whether the props field is set.
     */
    @java.lang.Override
    public boolean hasProps() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <code>required .PropsData props = 1;</code>
     * @return The props.
     */
    @java.lang.Override
    public org.apache.pekko.remote.WireFormats.PropsData getProps() {
      return props_ == null ? org.apache.pekko.remote.WireFormats.PropsData.getDefaultInstance() : props_;
    }
    /**
     * <code>required .PropsData props = 1;</code>
     */
    @java.lang.Override
    public org.apache.pekko.remote.WireFormats.PropsDataOrBuilder getPropsOrBuilder() {
      return props_ == null ? org.apache.pekko.remote.WireFormats.PropsData.getDefaultInstance() : props_;
    }

    public static final int DEPLOY_FIELD_NUMBER = 2;
    private org.apache.pekko.remote.WireFormats.DeployData deploy_;
    /**
     * <code>required .DeployData deploy = 2;</code>
     * @return Whether the deploy field is set.
     */
    @java.lang.Override
    public boolean hasDeploy() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <code>required .DeployData deploy = 2;</code>
     * @return The deploy.
     */
    @java.lang.Override
    public org.apache.pekko.remote.WireFormats.DeployData getDeploy() {
      return deploy_ == null ? org.apache.pekko.remote.WireFormats.DeployData.getDefaultInstance() : deploy_;
    }
    /**
     * <code>required .DeployData deploy = 2;</code>
     */
    @java.lang.Override
    public org.apache.pekko.remote.WireFormats.DeployDataOrBuilder getDeployOrBuilder() {
      return deploy_ == null ? org.apache.pekko.remote.WireFormats.DeployData.getDefaultInstance() : deploy_;
    }

    public static final int PATH_FIELD_NUMBER = 3;
    @SuppressWarnings("serial")
    private volatile java.lang.Object path_ = "";
    /**
     * <code>required string path = 3;</code>
     * @return Whether the path field is set.
     */
    @java.lang.Override
    public boolean hasPath() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     * <code>required string path = 3;</code>
     * @return The path.
     */
    @java.lang.Override
    public java.lang.String getPath() {
      java.lang.Object ref = path_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        org.apache.pekko.protobufv3.internal.ByteString bs = 
            (org.apache.pekko.protobufv3.internal.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          path_ = s;
        }
        return s;
      }
    }
    /**
     * <code>required string path = 3;</code>
     * @return The bytes for path.
     */
    @java.lang.Override
    public org.apache.pekko.protobufv3.internal.ByteString
        getPathBytes() {
      java.lang.Object ref = path_;
      if (ref instanceof java.lang.String) {
        org.apache.pekko.protobufv3.internal.ByteString b = 
            org.apache.pekko.protobufv3.internal.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        path_ = b;
        return b;
      } else {
        return (org.apache.pekko.protobufv3.internal.ByteString) ref;
      }
    }

    public static final int SUPERVISOR_FIELD_NUMBER = 4;
    private org.apache.pekko.remote.WireFormats.ActorRefData supervisor_;
    /**
     * <code>required .ActorRefData supervisor = 4;</code>
     * @return Whether the supervisor field is set.
     */
    @java.lang.Override
    public boolean hasSupervisor() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     * <code>required .ActorRefData supervisor = 4;</code>
     * @return The supervisor.
     */
    @java.lang.Override
    public org.apache.pekko.remote.WireFormats.ActorRefData getSupervisor() {
      return supervisor_ == null ? org.apache.pekko.remote.WireFormats.ActorRefData.getDefaultInstance() : supervisor_;
    }
    /**
     * <code>required .ActorRefData supervisor = 4;</code>
     */
    @java.lang.Override
    public org.apache.pekko.remote.WireFormats.ActorRefDataOrBuilder getSupervisorOrBuilder() {
      return supervisor_ == null ? org.apache.pekko.remote.WireFormats.ActorRefData.getDefaultInstance() : supervisor_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasProps()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!hasDeploy()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!hasPath()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!hasSupervisor()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!getProps().isInitialized()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!getDeploy().isInitialized()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!getSupervisor().isInitialized()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(org.apache.pekko.protobufv3.internal.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getProps());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(2, getDeploy());
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        org.apache.pekko.protobufv3.internal.GeneratedMessage.writeString(output, 3, path_);
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        output.writeMessage(4, getSupervisor());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeMessageSize(1, getProps());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeMessageSize(2, getDeploy());
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size += org.apache.pekko.protobufv3.internal.GeneratedMessage.computeStringSize(3, path_);
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeMessageSize(4, getSupervisor());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.pekko.remote.WireFormats.DaemonMsgCreateData)) {
        return super.equals(obj);
      }
      org.apache.pekko.remote.WireFormats.DaemonMsgCreateData other = (org.apache.pekko.remote.WireFormats.DaemonMsgCreateData) obj;

      if (hasProps() != other.hasProps()) return false;
      if (hasProps()) {
        if (!getProps()
            .equals(other.getProps())) return false;
      }
      if (hasDeploy() != other.hasDeploy()) return false;
      if (hasDeploy()) {
        if (!getDeploy()
            .equals(other.getDeploy())) return false;
      }
      if (hasPath() != other.hasPath()) return false;
      if (hasPath()) {
        if (!getPath()
            .equals(other.getPath())) return false;
      }
      if (hasSupervisor() != other.hasSupervisor()) return false;
      if (hasSupervisor()) {
        if (!getSupervisor()
            .equals(other.getSupervisor())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasProps()) {
        hash = (37 * hash) + PROPS_FIELD_NUMBER;
        hash = (53 * hash) + getProps().hashCode();
      }
      if (hasDeploy()) {
        hash = (37 * hash) + DEPLOY_FIELD_NUMBER;
        hash = (53 * hash) + getDeploy().hashCode();
      }
      if (hasPath()) {
        hash = (37 * hash) + PATH_FIELD_NUMBER;
        hash = (53 * hash) + getPath().hashCode();
      }
      if (hasSupervisor()) {
        hash = (37 * hash) + SUPERVISOR_FIELD_NUMBER;
        hash = (53 * hash) + getSupervisor().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.pekko.remote.WireFormats.DaemonMsgCreateData parseFrom(
        java.nio.ByteBuffer data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.remote.WireFormats.DaemonMsgCreateData parseFrom(
        java.nio.ByteBuffer data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.DaemonMsgCreateData parseFrom(
        org.apache.pekko.protobufv3.internal.ByteString data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.remote.WireFormats.DaemonMsgCreateData parseFrom(
        org.apache.pekko.protobufv3.internal.ByteString data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.DaemonMsgCreateData parseFrom(byte[] data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.remote.WireFormats.DaemonMsgCreateData parseFrom(
        byte[] data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.DaemonMsgCreateData parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.pekko.remote.WireFormats.DaemonMsgCreateData parseFrom(
        java.io.InputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static org.apache.pekko.remote.WireFormats.DaemonMsgCreateData parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static org.apache.pekko.remote.WireFormats.DaemonMsgCreateData parseDelimitedFrom(
        java.io.InputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.DaemonMsgCreateData parseFrom(
        org.apache.pekko.protobufv3.internal.CodedInputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.pekko.remote.WireFormats.DaemonMsgCreateData parseFrom(
        org.apache.pekko.protobufv3.internal.CodedInputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.pekko.remote.WireFormats.DaemonMsgCreateData prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        org.apache.pekko.protobufv3.internal.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * *
     * Defines org.apache.pekko.remote.DaemonMsgCreate
     * </pre>
     *
     * Protobuf type {@code DaemonMsgCreateData}
     */
    public static final class Builder extends
        org.apache.pekko.protobufv3.internal.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:DaemonMsgCreateData)
        org.apache.pekko.remote.WireFormats.DaemonMsgCreateDataOrBuilder {
      public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.pekko.remote.WireFormats.internal_static_DaemonMsgCreateData_descriptor;
      }

      @java.lang.Override
      protected org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.pekko.remote.WireFormats.internal_static_DaemonMsgCreateData_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.pekko.remote.WireFormats.DaemonMsgCreateData.class, org.apache.pekko.remote.WireFormats.DaemonMsgCreateData.Builder.class);
      }

      // Construct using org.apache.pekko.remote.WireFormats.DaemonMsgCreateData.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          org.apache.pekko.protobufv3.internal.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (org.apache.pekko.protobufv3.internal.GeneratedMessage
                .alwaysUseFieldBuilders) {
          internalGetPropsFieldBuilder();
          internalGetDeployFieldBuilder();
          internalGetSupervisorFieldBuilder();
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        props_ = null;
        if (propsBuilder_ != null) {
          propsBuilder_.dispose();
          propsBuilder_ = null;
        }
        deploy_ = null;
        if (deployBuilder_ != null) {
          deployBuilder_.dispose();
          deployBuilder_ = null;
        }
        path_ = "";
        supervisor_ = null;
        if (supervisorBuilder_ != null) {
          supervisorBuilder_.dispose();
          supervisorBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.pekko.remote.WireFormats.internal_static_DaemonMsgCreateData_descriptor;
      }

      @java.lang.Override
      public org.apache.pekko.remote.WireFormats.DaemonMsgCreateData getDefaultInstanceForType() {
        return org.apache.pekko.remote.WireFormats.DaemonMsgCreateData.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.pekko.remote.WireFormats.DaemonMsgCreateData build() {
        org.apache.pekko.remote.WireFormats.DaemonMsgCreateData result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.pekko.remote.WireFormats.DaemonMsgCreateData buildPartial() {
        org.apache.pekko.remote.WireFormats.DaemonMsgCreateData result = new org.apache.pekko.remote.WireFormats.DaemonMsgCreateData(this);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartial0(org.apache.pekko.remote.WireFormats.DaemonMsgCreateData result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.props_ = propsBuilder_ == null
              ? props_
              : propsBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.deploy_ = deployBuilder_ == null
              ? deploy_
              : deployBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.path_ = path_;
          to_bitField0_ |= 0x00000004;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.supervisor_ = supervisorBuilder_ == null
              ? supervisor_
              : supervisorBuilder_.build();
          to_bitField0_ |= 0x00000008;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder mergeFrom(org.apache.pekko.protobufv3.internal.Message other) {
        if (other instanceof org.apache.pekko.remote.WireFormats.DaemonMsgCreateData) {
          return mergeFrom((org.apache.pekko.remote.WireFormats.DaemonMsgCreateData)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.pekko.remote.WireFormats.DaemonMsgCreateData other) {
        if (other == org.apache.pekko.remote.WireFormats.DaemonMsgCreateData.getDefaultInstance()) return this;
        if (other.hasProps()) {
          mergeProps(other.getProps());
        }
        if (other.hasDeploy()) {
          mergeDeploy(other.getDeploy());
        }
        if (other.hasPath()) {
          path_ = other.path_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        if (other.hasSupervisor()) {
          mergeSupervisor(other.getSupervisor());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        if (!hasProps()) {
          return false;
        }
        if (!hasDeploy()) {
          return false;
        }
        if (!hasPath()) {
          return false;
        }
        if (!hasSupervisor()) {
          return false;
        }
        if (!getProps().isInitialized()) {
          return false;
        }
        if (!getDeploy().isInitialized()) {
          return false;
        }
        if (!getSupervisor().isInitialized()) {
          return false;
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                input.readMessage(
                    internalGetPropsFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
              case 18: {
                input.readMessage(
                    internalGetDeployFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
              case 26: {
                path_ = input.readBytes();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
              case 34: {
                input.readMessage(
                    internalGetSupervisorFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private org.apache.pekko.remote.WireFormats.PropsData props_;
      private org.apache.pekko.protobufv3.internal.SingleFieldBuilder<
          org.apache.pekko.remote.WireFormats.PropsData, org.apache.pekko.remote.WireFormats.PropsData.Builder, org.apache.pekko.remote.WireFormats.PropsDataOrBuilder> propsBuilder_;
      /**
       * <code>required .PropsData props = 1;</code>
       * @return Whether the props field is set.
       */
      public boolean hasProps() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <code>required .PropsData props = 1;</code>
       * @return The props.
       */
      public org.apache.pekko.remote.WireFormats.PropsData getProps() {
        if (propsBuilder_ == null) {
          return props_ == null ? org.apache.pekko.remote.WireFormats.PropsData.getDefaultInstance() : props_;
        } else {
          return propsBuilder_.getMessage();
        }
      }
      /**
       * <code>required .PropsData props = 1;</code>
       */
      public Builder setProps(org.apache.pekko.remote.WireFormats.PropsData value) {
        if (propsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          props_ = value;
        } else {
          propsBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <code>required .PropsData props = 1;</code>
       */
      public Builder setProps(
          org.apache.pekko.remote.WireFormats.PropsData.Builder builderForValue) {
        if (propsBuilder_ == null) {
          props_ = builderForValue.build();
        } else {
          propsBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <code>required .PropsData props = 1;</code>
       */
      public Builder mergeProps(org.apache.pekko.remote.WireFormats.PropsData value) {
        if (propsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0) &&
            props_ != null &&
            props_ != org.apache.pekko.remote.WireFormats.PropsData.getDefaultInstance()) {
            getPropsBuilder().mergeFrom(value);
          } else {
            props_ = value;
          }
        } else {
          propsBuilder_.mergeFrom(value);
        }
        if (props_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }
      /**
       * <code>required .PropsData props = 1;</code>
       */
      public Builder clearProps() {
        bitField0_ = (bitField0_ & ~0x00000001);
        props_ = null;
        if (propsBuilder_ != null) {
          propsBuilder_.dispose();
          propsBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <code>required .PropsData props = 1;</code>
       */
      public org.apache.pekko.remote.WireFormats.PropsData.Builder getPropsBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return internalGetPropsFieldBuilder().getBuilder();
      }
      /**
       * <code>required .PropsData props = 1;</code>
       */
      public org.apache.pekko.remote.WireFormats.PropsDataOrBuilder getPropsOrBuilder() {
        if (propsBuilder_ != null) {
          return propsBuilder_.getMessageOrBuilder();
        } else {
          return props_ == null ?
              org.apache.pekko.remote.WireFormats.PropsData.getDefaultInstance() : props_;
        }
      }
      /**
       * <code>required .PropsData props = 1;</code>
       */
      private org.apache.pekko.protobufv3.internal.SingleFieldBuilder<
          org.apache.pekko.remote.WireFormats.PropsData, org.apache.pekko.remote.WireFormats.PropsData.Builder, org.apache.pekko.remote.WireFormats.PropsDataOrBuilder> 
          internalGetPropsFieldBuilder() {
        if (propsBuilder_ == null) {
          propsBuilder_ = new org.apache.pekko.protobufv3.internal.SingleFieldBuilder<
              org.apache.pekko.remote.WireFormats.PropsData, org.apache.pekko.remote.WireFormats.PropsData.Builder, org.apache.pekko.remote.WireFormats.PropsDataOrBuilder>(
                  getProps(),
                  getParentForChildren(),
                  isClean());
          props_ = null;
        }
        return propsBuilder_;
      }

      private org.apache.pekko.remote.WireFormats.DeployData deploy_;
      private org.apache.pekko.protobufv3.internal.SingleFieldBuilder<
          org.apache.pekko.remote.WireFormats.DeployData, org.apache.pekko.remote.WireFormats.DeployData.Builder, org.apache.pekko.remote.WireFormats.DeployDataOrBuilder> deployBuilder_;
      /**
       * <code>required .DeployData deploy = 2;</code>
       * @return Whether the deploy field is set.
       */
      public boolean hasDeploy() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <code>required .DeployData deploy = 2;</code>
       * @return The deploy.
       */
      public org.apache.pekko.remote.WireFormats.DeployData getDeploy() {
        if (deployBuilder_ == null) {
          return deploy_ == null ? org.apache.pekko.remote.WireFormats.DeployData.getDefaultInstance() : deploy_;
        } else {
          return deployBuilder_.getMessage();
        }
      }
      /**
       * <code>required .DeployData deploy = 2;</code>
       */
      public Builder setDeploy(org.apache.pekko.remote.WireFormats.DeployData value) {
        if (deployBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          deploy_ = value;
        } else {
          deployBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <code>required .DeployData deploy = 2;</code>
       */
      public Builder setDeploy(
          org.apache.pekko.remote.WireFormats.DeployData.Builder builderForValue) {
        if (deployBuilder_ == null) {
          deploy_ = builderForValue.build();
        } else {
          deployBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <code>required .DeployData deploy = 2;</code>
       */
      public Builder mergeDeploy(org.apache.pekko.remote.WireFormats.DeployData value) {
        if (deployBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0) &&
            deploy_ != null &&
            deploy_ != org.apache.pekko.remote.WireFormats.DeployData.getDefaultInstance()) {
            getDeployBuilder().mergeFrom(value);
          } else {
            deploy_ = value;
          }
        } else {
          deployBuilder_.mergeFrom(value);
        }
        if (deploy_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       * <code>required .DeployData deploy = 2;</code>
       */
      public Builder clearDeploy() {
        bitField0_ = (bitField0_ & ~0x00000002);
        deploy_ = null;
        if (deployBuilder_ != null) {
          deployBuilder_.dispose();
          deployBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <code>required .DeployData deploy = 2;</code>
       */
      public org.apache.pekko.remote.WireFormats.DeployData.Builder getDeployBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return internalGetDeployFieldBuilder().getBuilder();
      }
      /**
       * <code>required .DeployData deploy = 2;</code>
       */
      public org.apache.pekko.remote.WireFormats.DeployDataOrBuilder getDeployOrBuilder() {
        if (deployBuilder_ != null) {
          return deployBuilder_.getMessageOrBuilder();
        } else {
          return deploy_ == null ?
              org.apache.pekko.remote.WireFormats.DeployData.getDefaultInstance() : deploy_;
        }
      }
      /**
       * <code>required .DeployData deploy = 2;</code>
       */
      private org.apache.pekko.protobufv3.internal.SingleFieldBuilder<
          org.apache.pekko.remote.WireFormats.DeployData, org.apache.pekko.remote.WireFormats.DeployData.Builder, org.apache.pekko.remote.WireFormats.DeployDataOrBuilder> 
          internalGetDeployFieldBuilder() {
        if (deployBuilder_ == null) {
          deployBuilder_ = new org.apache.pekko.protobufv3.internal.SingleFieldBuilder<
              org.apache.pekko.remote.WireFormats.DeployData, org.apache.pekko.remote.WireFormats.DeployData.Builder, org.apache.pekko.remote.WireFormats.DeployDataOrBuilder>(
                  getDeploy(),
                  getParentForChildren(),
                  isClean());
          deploy_ = null;
        }
        return deployBuilder_;
      }

      private java.lang.Object path_ = "";
      /**
       * <code>required string path = 3;</code>
       * @return Whether the path field is set.
       */
      public boolean hasPath() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       * <code>required string path = 3;</code>
       * @return The path.
       */
      public java.lang.String getPath() {
        java.lang.Object ref = path_;
        if (!(ref instanceof java.lang.String)) {
          org.apache.pekko.protobufv3.internal.ByteString bs =
              (org.apache.pekko.protobufv3.internal.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            path_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>required string path = 3;</code>
       * @return The bytes for path.
       */
      public org.apache.pekko.protobufv3.internal.ByteString
          getPathBytes() {
        java.lang.Object ref = path_;
        if (ref instanceof String) {
          org.apache.pekko.protobufv3.internal.ByteString b = 
              org.apache.pekko.protobufv3.internal.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          path_ = b;
          return b;
        } else {
          return (org.apache.pekko.protobufv3.internal.ByteString) ref;
        }
      }
      /**
       * <code>required string path = 3;</code>
       * @param value The path to set.
       * @return This builder for chaining.
       */
      public Builder setPath(
          java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        path_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       * <code>required string path = 3;</code>
       * @return This builder for chaining.
       */
      public Builder clearPath() {
        path_ = getDefaultInstance().getPath();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       * <code>required string path = 3;</code>
       * @param value The bytes for path to set.
       * @return This builder for chaining.
       */
      public Builder setPathBytes(
          org.apache.pekko.protobufv3.internal.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        path_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private org.apache.pekko.remote.WireFormats.ActorRefData supervisor_;
      private org.apache.pekko.protobufv3.internal.SingleFieldBuilder<
          org.apache.pekko.remote.WireFormats.ActorRefData, org.apache.pekko.remote.WireFormats.ActorRefData.Builder, org.apache.pekko.remote.WireFormats.ActorRefDataOrBuilder> supervisorBuilder_;
      /**
       * <code>required .ActorRefData supervisor = 4;</code>
       * @return Whether the supervisor field is set.
       */
      public boolean hasSupervisor() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       * <code>required .ActorRefData supervisor = 4;</code>
       * @return The supervisor.
       */
      public org.apache.pekko.remote.WireFormats.ActorRefData getSupervisor() {
        if (supervisorBuilder_ == null) {
          return supervisor_ == null ? org.apache.pekko.remote.WireFormats.ActorRefData.getDefaultInstance() : supervisor_;
        } else {
          return supervisorBuilder_.getMessage();
        }
      }
      /**
       * <code>required .ActorRefData supervisor = 4;</code>
       */
      public Builder setSupervisor(org.apache.pekko.remote.WireFormats.ActorRefData value) {
        if (supervisorBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          supervisor_ = value;
        } else {
          supervisorBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       * <code>required .ActorRefData supervisor = 4;</code>
       */
      public Builder setSupervisor(
          org.apache.pekko.remote.WireFormats.ActorRefData.Builder builderForValue) {
        if (supervisorBuilder_ == null) {
          supervisor_ = builderForValue.build();
        } else {
          supervisorBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       * <code>required .ActorRefData supervisor = 4;</code>
       */
      public Builder mergeSupervisor(org.apache.pekko.remote.WireFormats.ActorRefData value) {
        if (supervisorBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0) &&
            supervisor_ != null &&
            supervisor_ != org.apache.pekko.remote.WireFormats.ActorRefData.getDefaultInstance()) {
            getSupervisorBuilder().mergeFrom(value);
          } else {
            supervisor_ = value;
          }
        } else {
          supervisorBuilder_.mergeFrom(value);
        }
        if (supervisor_ != null) {
          bitField0_ |= 0x00000008;
          onChanged();
        }
        return this;
      }
      /**
       * <code>required .ActorRefData supervisor = 4;</code>
       */
      public Builder clearSupervisor() {
        bitField0_ = (bitField0_ & ~0x00000008);
        supervisor_ = null;
        if (supervisorBuilder_ != null) {
          supervisorBuilder_.dispose();
          supervisorBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <code>required .ActorRefData supervisor = 4;</code>
       */
      public org.apache.pekko.remote.WireFormats.ActorRefData.Builder getSupervisorBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return internalGetSupervisorFieldBuilder().getBuilder();
      }
      /**
       * <code>required .ActorRefData supervisor = 4;</code>
       */
      public org.apache.pekko.remote.WireFormats.ActorRefDataOrBuilder getSupervisorOrBuilder() {
        if (supervisorBuilder_ != null) {
          return supervisorBuilder_.getMessageOrBuilder();
        } else {
          return supervisor_ == null ?
              org.apache.pekko.remote.WireFormats.ActorRefData.getDefaultInstance() : supervisor_;
        }
      }
      /**
       * <code>required .ActorRefData supervisor = 4;</code>
       */
      private org.apache.pekko.protobufv3.internal.SingleFieldBuilder<
          org.apache.pekko.remote.WireFormats.ActorRefData, org.apache.pekko.remote.WireFormats.ActorRefData.Builder, org.apache.pekko.remote.WireFormats.ActorRefDataOrBuilder> 
          internalGetSupervisorFieldBuilder() {
        if (supervisorBuilder_ == null) {
          supervisorBuilder_ = new org.apache.pekko.protobufv3.internal.SingleFieldBuilder<
              org.apache.pekko.remote.WireFormats.ActorRefData, org.apache.pekko.remote.WireFormats.ActorRefData.Builder, org.apache.pekko.remote.WireFormats.ActorRefDataOrBuilder>(
                  getSupervisor(),
                  getParentForChildren(),
                  isClean());
          supervisor_ = null;
        }
        return supervisorBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:DaemonMsgCreateData)
    }

    // @@protoc_insertion_point(class_scope:DaemonMsgCreateData)
    private static final org.apache.pekko.remote.WireFormats.DaemonMsgCreateData DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.pekko.remote.WireFormats.DaemonMsgCreateData();
    }

    public static org.apache.pekko.remote.WireFormats.DaemonMsgCreateData getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final org.apache.pekko.protobufv3.internal.Parser<DaemonMsgCreateData>
        PARSER = new org.apache.pekko.protobufv3.internal.AbstractParser<DaemonMsgCreateData>() {
      @java.lang.Override
      public DaemonMsgCreateData parsePartialFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (org.apache.pekko.protobufv3.internal.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static org.apache.pekko.protobufv3.internal.Parser<DaemonMsgCreateData> parser() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.pekko.protobufv3.internal.Parser<DaemonMsgCreateData> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.pekko.remote.WireFormats.DaemonMsgCreateData getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface PropsDataOrBuilder extends
      // @@protoc_insertion_point(interface_extends:PropsData)
      org.apache.pekko.protobufv3.internal.MessageOrBuilder {

    /**
     * <code>required .DeployData deploy = 2;</code>
     * @return Whether the deploy field is set.
     */
    boolean hasDeploy();
    /**
     * <code>required .DeployData deploy = 2;</code>
     * @return The deploy.
     */
    org.apache.pekko.remote.WireFormats.DeployData getDeploy();
    /**
     * <code>required .DeployData deploy = 2;</code>
     */
    org.apache.pekko.remote.WireFormats.DeployDataOrBuilder getDeployOrBuilder();

    /**
     * <code>required string clazz = 3;</code>
     * @return Whether the clazz field is set.
     */
    boolean hasClazz();
    /**
     * <code>required string clazz = 3;</code>
     * @return The clazz.
     */
    java.lang.String getClazz();
    /**
     * <code>required string clazz = 3;</code>
     * @return The bytes for clazz.
     */
    org.apache.pekko.protobufv3.internal.ByteString
        getClazzBytes();

    /**
     * <code>repeated bytes args = 4;</code>
     * @return A list containing the args.
     */
    java.util.List<org.apache.pekko.protobufv3.internal.ByteString> getArgsList();
    /**
     * <code>repeated bytes args = 4;</code>
     * @return The count of args.
     */
    int getArgsCount();
    /**
     * <code>repeated bytes args = 4;</code>
     * @param index The index of the element to return.
     * @return The args at the given index.
     */
    org.apache.pekko.protobufv3.internal.ByteString getArgs(int index);

    /**
     * <pre>
     * serialized props parameters
     * older wire protocol: contains class name for each arg
     * newer wire protocol: contains string manifest for each arg
     * </pre>
     *
     * <code>repeated string manifests = 5;</code>
     * @return A list containing the manifests.
     */
    java.util.List<java.lang.String>
        getManifestsList();
    /**
     * <pre>
     * serialized props parameters
     * older wire protocol: contains class name for each arg
     * newer wire protocol: contains string manifest for each arg
     * </pre>
     *
     * <code>repeated string manifests = 5;</code>
     * @return The count of manifests.
     */
    int getManifestsCount();
    /**
     * <pre>
     * serialized props parameters
     * older wire protocol: contains class name for each arg
     * newer wire protocol: contains string manifest for each arg
     * </pre>
     *
     * <code>repeated string manifests = 5;</code>
     * @param index The index of the element to return.
     * @return The manifests at the given index.
     */
    java.lang.String getManifests(int index);
    /**
     * <pre>
     * serialized props parameters
     * older wire protocol: contains class name for each arg
     * newer wire protocol: contains string manifest for each arg
     * </pre>
     *
     * <code>repeated string manifests = 5;</code>
     * @param index The index of the value to return.
     * @return The bytes of the manifests at the given index.
     */
    org.apache.pekko.protobufv3.internal.ByteString
        getManifestsBytes(int index);

    /**
     * <pre>
     * newer wire protocol: serializer id for each arg
     * </pre>
     *
     * <code>repeated int32 serializerIds = 6;</code>
     * @return A list containing the serializerIds.
     */
    java.util.List<java.lang.Integer> getSerializerIdsList();
    /**
     * <pre>
     * newer wire protocol: serializer id for each arg
     * </pre>
     *
     * <code>repeated int32 serializerIds = 6;</code>
     * @return The count of serializerIds.
     */
    int getSerializerIdsCount();
    /**
     * <pre>
     * newer wire protocol: serializer id for each arg
     * </pre>
     *
     * <code>repeated int32 serializerIds = 6;</code>
     * @param index The index of the element to return.
     * @return The serializerIds at the given index.
     */
    int getSerializerIds(int index);

    /**
     * <pre>
     * additionally a flag per position to indicate if it was
     * serialized with manifest or not
     * </pre>
     *
     * <code>repeated bool hasManifest = 7;</code>
     * @return A list containing the hasManifest.
     */
    java.util.List<java.lang.Boolean> getHasManifestList();
    /**
     * <pre>
     * additionally a flag per position to indicate if it was
     * serialized with manifest or not
     * </pre>
     *
     * <code>repeated bool hasManifest = 7;</code>
     * @return The count of hasManifest.
     */
    int getHasManifestCount();
    /**
     * <pre>
     * additionally a flag per position to indicate if it was
     * serialized with manifest or not
     * </pre>
     *
     * <code>repeated bool hasManifest = 7;</code>
     * @param index The index of the element to return.
     * @return The hasManifest at the given index.
     */
    boolean getHasManifest(int index);
  }
  /**
   * <pre>
   * *
   * Serialization of org.apache.pekko.actor.Props
   * </pre>
   *
   * Protobuf type {@code PropsData}
   */
  public static final class PropsData extends
      org.apache.pekko.protobufv3.internal.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:PropsData)
      PropsDataOrBuilder {
  private static final long serialVersionUID = 0L;
    static {
      org.apache.pekko.protobufv3.internal.RuntimeVersion.validateProtobufGencodeVersion(
        org.apache.pekko.protobufv3.internal.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 32,
        /* patch= */ 0,
        /* suffix= */ "",
        PropsData.class.getName());
    }
    // Use PropsData.newBuilder() to construct.
    private PropsData(org.apache.pekko.protobufv3.internal.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }
    private PropsData() {
      clazz_ = "";
      args_ = emptyList(org.apache.pekko.protobufv3.internal.ByteString.class);
      manifests_ =
          org.apache.pekko.protobufv3.internal.LazyStringArrayList.emptyList();
      serializerIds_ = emptyIntList();
      hasManifest_ = emptyBooleanList();
    }

    public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.pekko.remote.WireFormats.internal_static_PropsData_descriptor;
    }

    @java.lang.Override
    protected org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.pekko.remote.WireFormats.internal_static_PropsData_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.pekko.remote.WireFormats.PropsData.class, org.apache.pekko.remote.WireFormats.PropsData.Builder.class);
    }

    private int bitField0_;
    public static final int DEPLOY_FIELD_NUMBER = 2;
    private org.apache.pekko.remote.WireFormats.DeployData deploy_;
    /**
     * <code>required .DeployData deploy = 2;</code>
     * @return Whether the deploy field is set.
     */
    @java.lang.Override
    public boolean hasDeploy() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <code>required .DeployData deploy = 2;</code>
     * @return The deploy.
     */
    @java.lang.Override
    public org.apache.pekko.remote.WireFormats.DeployData getDeploy() {
      return deploy_ == null ? org.apache.pekko.remote.WireFormats.DeployData.getDefaultInstance() : deploy_;
    }
    /**
     * <code>required .DeployData deploy = 2;</code>
     */
    @java.lang.Override
    public org.apache.pekko.remote.WireFormats.DeployDataOrBuilder getDeployOrBuilder() {
      return deploy_ == null ? org.apache.pekko.remote.WireFormats.DeployData.getDefaultInstance() : deploy_;
    }

    public static final int CLAZZ_FIELD_NUMBER = 3;
    @SuppressWarnings("serial")
    private volatile java.lang.Object clazz_ = "";
    /**
     * <code>required string clazz = 3;</code>
     * @return Whether the clazz field is set.
     */
    @java.lang.Override
    public boolean hasClazz() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <code>required string clazz = 3;</code>
     * @return The clazz.
     */
    @java.lang.Override
    public java.lang.String getClazz() {
      java.lang.Object ref = clazz_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        org.apache.pekko.protobufv3.internal.ByteString bs = 
            (org.apache.pekko.protobufv3.internal.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          clazz_ = s;
        }
        return s;
      }
    }
    /**
     * <code>required string clazz = 3;</code>
     * @return The bytes for clazz.
     */
    @java.lang.Override
    public org.apache.pekko.protobufv3.internal.ByteString
        getClazzBytes() {
      java.lang.Object ref = clazz_;
      if (ref instanceof java.lang.String) {
        org.apache.pekko.protobufv3.internal.ByteString b = 
            org.apache.pekko.protobufv3.internal.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        clazz_ = b;
        return b;
      } else {
        return (org.apache.pekko.protobufv3.internal.ByteString) ref;
      }
    }

    public static final int ARGS_FIELD_NUMBER = 4;
    @SuppressWarnings("serial")
    private org.apache.pekko.protobufv3.internal.Internal.ProtobufList<org.apache.pekko.protobufv3.internal.ByteString> args_ =
        emptyList(org.apache.pekko.protobufv3.internal.ByteString.class);
    /**
     * <code>repeated bytes args = 4;</code>
     * @return A list containing the args.
     */
    @java.lang.Override
    public java.util.List<org.apache.pekko.protobufv3.internal.ByteString>
        getArgsList() {
      return args_;
    }
    /**
     * <code>repeated bytes args = 4;</code>
     * @return The count of args.
     */
    public int getArgsCount() {
      return args_.size();
    }
    /**
     * <code>repeated bytes args = 4;</code>
     * @param index The index of the element to return.
     * @return The args at the given index.
     */
    public org.apache.pekko.protobufv3.internal.ByteString getArgs(int index) {
      return args_.get(index);
    }

    public static final int MANIFESTS_FIELD_NUMBER = 5;
    @SuppressWarnings("serial")
    private org.apache.pekko.protobufv3.internal.LazyStringArrayList manifests_ =
        org.apache.pekko.protobufv3.internal.LazyStringArrayList.emptyList();
    /**
     * <pre>
     * serialized props parameters
     * older wire protocol: contains class name for each arg
     * newer wire protocol: contains string manifest for each arg
     * </pre>
     *
     * <code>repeated string manifests = 5;</code>
     * @return A list containing the manifests.
     */
    public org.apache.pekko.protobufv3.internal.ProtocolStringList
        getManifestsList() {
      return manifests_;
    }
    /**
     * <pre>
     * serialized props parameters
     * older wire protocol: contains class name for each arg
     * newer wire protocol: contains string manifest for each arg
     * </pre>
     *
     * <code>repeated string manifests = 5;</code>
     * @return The count of manifests.
     */
    public int getManifestsCount() {
      return manifests_.size();
    }
    /**
     * <pre>
     * serialized props parameters
     * older wire protocol: contains class name for each arg
     * newer wire protocol: contains string manifest for each arg
     * </pre>
     *
     * <code>repeated string manifests = 5;</code>
     * @param index The index of the element to return.
     * @return The manifests at the given index.
     */
    public java.lang.String getManifests(int index) {
      return manifests_.get(index);
    }
    /**
     * <pre>
     * serialized props parameters
     * older wire protocol: contains class name for each arg
     * newer wire protocol: contains string manifest for each arg
     * </pre>
     *
     * <code>repeated string manifests = 5;</code>
     * @param index The index of the value to return.
     * @return The bytes of the manifests at the given index.
     */
    public org.apache.pekko.protobufv3.internal.ByteString
        getManifestsBytes(int index) {
      return manifests_.getByteString(index);
    }

    public static final int SERIALIZERIDS_FIELD_NUMBER = 6;
    @SuppressWarnings("serial")
    private org.apache.pekko.protobufv3.internal.Internal.IntList serializerIds_ =
        emptyIntList();
    /**
     * <pre>
     * newer wire protocol: serializer id for each arg
     * </pre>
     *
     * <code>repeated int32 serializerIds = 6;</code>
     * @return A list containing the serializerIds.
     */
    @java.lang.Override
    public java.util.List<java.lang.Integer>
        getSerializerIdsList() {
      return serializerIds_;
    }
    /**
     * <pre>
     * newer wire protocol: serializer id for each arg
     * </pre>
     *
     * <code>repeated int32 serializerIds = 6;</code>
     * @return The count of serializerIds.
     */
    public int getSerializerIdsCount() {
      return serializerIds_.size();
    }
    /**
     * <pre>
     * newer wire protocol: serializer id for each arg
     * </pre>
     *
     * <code>repeated int32 serializerIds = 6;</code>
     * @param index The index of the element to return.
     * @return The serializerIds at the given index.
     */
    public int getSerializerIds(int index) {
      return serializerIds_.getInt(index);
    }

    public static final int HASMANIFEST_FIELD_NUMBER = 7;
    @SuppressWarnings("serial")
    private org.apache.pekko.protobufv3.internal.Internal.BooleanList hasManifest_ =
        emptyBooleanList();
    /**
     * <pre>
     * additionally a flag per position to indicate if it was
     * serialized with manifest or not
     * </pre>
     *
     * <code>repeated bool hasManifest = 7;</code>
     * @return A list containing the hasManifest.
     */
    @java.lang.Override
    public java.util.List<java.lang.Boolean>
        getHasManifestList() {
      return hasManifest_;
    }
    /**
     * <pre>
     * additionally a flag per position to indicate if it was
     * serialized with manifest or not
     * </pre>
     *
     * <code>repeated bool hasManifest = 7;</code>
     * @return The count of hasManifest.
     */
    public int getHasManifestCount() {
      return hasManifest_.size();
    }
    /**
     * <pre>
     * additionally a flag per position to indicate if it was
     * serialized with manifest or not
     * </pre>
     *
     * <code>repeated bool hasManifest = 7;</code>
     * @param index The index of the element to return.
     * @return The hasManifest at the given index.
     */
    public boolean getHasManifest(int index) {
      return hasManifest_.getBoolean(index);
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasDeploy()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!hasClazz()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!getDeploy().isInitialized()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(org.apache.pekko.protobufv3.internal.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(2, getDeploy());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        org.apache.pekko.protobufv3.internal.GeneratedMessage.writeString(output, 3, clazz_);
      }
      for (int i = 0; i < args_.size(); i++) {
        output.writeBytes(4, args_.get(i));
      }
      for (int i = 0; i < manifests_.size(); i++) {
        org.apache.pekko.protobufv3.internal.GeneratedMessage.writeString(output, 5, manifests_.getRaw(i));
      }
      for (int i = 0; i < serializerIds_.size(); i++) {
        output.writeInt32(6, serializerIds_.getInt(i));
      }
      for (int i = 0; i < hasManifest_.size(); i++) {
        output.writeBool(7, hasManifest_.getBoolean(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeMessageSize(2, getDeploy());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += org.apache.pekko.protobufv3.internal.GeneratedMessage.computeStringSize(3, clazz_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < args_.size(); i++) {
          dataSize += org.apache.pekko.protobufv3.internal.CodedOutputStream
            .computeBytesSizeNoTag(args_.get(i));
        }
        size += dataSize;
        size += 1 * getArgsList().size();
      }
      {
        int dataSize = 0;
        for (int i = 0; i < manifests_.size(); i++) {
          dataSize += computeStringSizeNoTag(manifests_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getManifestsList().size();
      }
      {
        int dataSize = 0;
        for (int i = 0; i < serializerIds_.size(); i++) {
          dataSize += org.apache.pekko.protobufv3.internal.CodedOutputStream
            .computeInt32SizeNoTag(serializerIds_.getInt(i));
        }
        size += dataSize;
        size += 1 * getSerializerIdsList().size();
      }
      {
        int dataSize = 0;
        dataSize = 1 * getHasManifestList().size();
        size += dataSize;
        size += 1 * getHasManifestList().size();
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.pekko.remote.WireFormats.PropsData)) {
        return super.equals(obj);
      }
      org.apache.pekko.remote.WireFormats.PropsData other = (org.apache.pekko.remote.WireFormats.PropsData) obj;

      if (hasDeploy() != other.hasDeploy()) return false;
      if (hasDeploy()) {
        if (!getDeploy()
            .equals(other.getDeploy())) return false;
      }
      if (hasClazz() != other.hasClazz()) return false;
      if (hasClazz()) {
        if (!getClazz()
            .equals(other.getClazz())) return false;
      }
      if (!getArgsList()
          .equals(other.getArgsList())) return false;
      if (!getManifestsList()
          .equals(other.getManifestsList())) return false;
      if (!getSerializerIdsList()
          .equals(other.getSerializerIdsList())) return false;
      if (!getHasManifestList()
          .equals(other.getHasManifestList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasDeploy()) {
        hash = (37 * hash) + DEPLOY_FIELD_NUMBER;
        hash = (53 * hash) + getDeploy().hashCode();
      }
      if (hasClazz()) {
        hash = (37 * hash) + CLAZZ_FIELD_NUMBER;
        hash = (53 * hash) + getClazz().hashCode();
      }
      if (getArgsCount() > 0) {
        hash = (37 * hash) + ARGS_FIELD_NUMBER;
        hash = (53 * hash) + getArgsList().hashCode();
      }
      if (getManifestsCount() > 0) {
        hash = (37 * hash) + MANIFESTS_FIELD_NUMBER;
        hash = (53 * hash) + getManifestsList().hashCode();
      }
      if (getSerializerIdsCount() > 0) {
        hash = (37 * hash) + SERIALIZERIDS_FIELD_NUMBER;
        hash = (53 * hash) + getSerializerIdsList().hashCode();
      }
      if (getHasManifestCount() > 0) {
        hash = (37 * hash) + HASMANIFEST_FIELD_NUMBER;
        hash = (53 * hash) + getHasManifestList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.pekko.remote.WireFormats.PropsData parseFrom(
        java.nio.ByteBuffer data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.remote.WireFormats.PropsData parseFrom(
        java.nio.ByteBuffer data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.PropsData parseFrom(
        org.apache.pekko.protobufv3.internal.ByteString data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.remote.WireFormats.PropsData parseFrom(
        org.apache.pekko.protobufv3.internal.ByteString data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.PropsData parseFrom(byte[] data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.remote.WireFormats.PropsData parseFrom(
        byte[] data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.PropsData parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.pekko.remote.WireFormats.PropsData parseFrom(
        java.io.InputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static org.apache.pekko.remote.WireFormats.PropsData parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static org.apache.pekko.remote.WireFormats.PropsData parseDelimitedFrom(
        java.io.InputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.PropsData parseFrom(
        org.apache.pekko.protobufv3.internal.CodedInputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.pekko.remote.WireFormats.PropsData parseFrom(
        org.apache.pekko.protobufv3.internal.CodedInputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.pekko.remote.WireFormats.PropsData prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        org.apache.pekko.protobufv3.internal.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * *
     * Serialization of org.apache.pekko.actor.Props
     * </pre>
     *
     * Protobuf type {@code PropsData}
     */
    public static final class Builder extends
        org.apache.pekko.protobufv3.internal.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:PropsData)
        org.apache.pekko.remote.WireFormats.PropsDataOrBuilder {
      public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.pekko.remote.WireFormats.internal_static_PropsData_descriptor;
      }

      @java.lang.Override
      protected org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.pekko.remote.WireFormats.internal_static_PropsData_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.pekko.remote.WireFormats.PropsData.class, org.apache.pekko.remote.WireFormats.PropsData.Builder.class);
      }

      // Construct using org.apache.pekko.remote.WireFormats.PropsData.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          org.apache.pekko.protobufv3.internal.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (org.apache.pekko.protobufv3.internal.GeneratedMessage
                .alwaysUseFieldBuilders) {
          internalGetDeployFieldBuilder();
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        deploy_ = null;
        if (deployBuilder_ != null) {
          deployBuilder_.dispose();
          deployBuilder_ = null;
        }
        clazz_ = "";
        args_ = emptyList(org.apache.pekko.protobufv3.internal.ByteString.class);
        manifests_ =
            org.apache.pekko.protobufv3.internal.LazyStringArrayList.emptyList();
        serializerIds_ = emptyIntList();
        hasManifest_ = emptyBooleanList();
        return this;
      }

      @java.lang.Override
      public org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.pekko.remote.WireFormats.internal_static_PropsData_descriptor;
      }

      @java.lang.Override
      public org.apache.pekko.remote.WireFormats.PropsData getDefaultInstanceForType() {
        return org.apache.pekko.remote.WireFormats.PropsData.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.pekko.remote.WireFormats.PropsData build() {
        org.apache.pekko.remote.WireFormats.PropsData result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.pekko.remote.WireFormats.PropsData buildPartial() {
        org.apache.pekko.remote.WireFormats.PropsData result = new org.apache.pekko.remote.WireFormats.PropsData(this);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartial0(org.apache.pekko.remote.WireFormats.PropsData result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.deploy_ = deployBuilder_ == null
              ? deploy_
              : deployBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.clazz_ = clazz_;
          to_bitField0_ |= 0x00000002;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          args_.makeImmutable();
          result.args_ = args_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          manifests_.makeImmutable();
          result.manifests_ = manifests_;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          serializerIds_.makeImmutable();
          result.serializerIds_ = serializerIds_;
        }
        if (((from_bitField0_ & 0x00000020) != 0)) {
          hasManifest_.makeImmutable();
          result.hasManifest_ = hasManifest_;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder mergeFrom(org.apache.pekko.protobufv3.internal.Message other) {
        if (other instanceof org.apache.pekko.remote.WireFormats.PropsData) {
          return mergeFrom((org.apache.pekko.remote.WireFormats.PropsData)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.pekko.remote.WireFormats.PropsData other) {
        if (other == org.apache.pekko.remote.WireFormats.PropsData.getDefaultInstance()) return this;
        if (other.hasDeploy()) {
          mergeDeploy(other.getDeploy());
        }
        if (other.hasClazz()) {
          clazz_ = other.clazz_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.args_.isEmpty()) {
          if (args_.isEmpty()) {
            args_ = other.args_;
            args_.makeImmutable();
            bitField0_ |= 0x00000004;
          } else {
            ensureArgsIsMutable();
            args_.addAll(other.args_);
          }
          onChanged();
        }
        if (!other.manifests_.isEmpty()) {
          if (manifests_.isEmpty()) {
            manifests_ = other.manifests_;
            bitField0_ |= 0x00000008;
          } else {
            ensureManifestsIsMutable();
            manifests_.addAll(other.manifests_);
          }
          onChanged();
        }
        if (!other.serializerIds_.isEmpty()) {
          if (serializerIds_.isEmpty()) {
            serializerIds_ = other.serializerIds_;
            serializerIds_.makeImmutable();
            bitField0_ |= 0x00000010;
          } else {
            ensureSerializerIdsIsMutable();
            serializerIds_.addAll(other.serializerIds_);
          }
          onChanged();
        }
        if (!other.hasManifest_.isEmpty()) {
          if (hasManifest_.isEmpty()) {
            hasManifest_ = other.hasManifest_;
            hasManifest_.makeImmutable();
            bitField0_ |= 0x00000020;
          } else {
            ensureHasManifestIsMutable();
            hasManifest_.addAll(other.hasManifest_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        if (!hasDeploy()) {
          return false;
        }
        if (!hasClazz()) {
          return false;
        }
        if (!getDeploy().isInitialized()) {
          return false;
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 18: {
                input.readMessage(
                    internalGetDeployFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 18
              case 26: {
                clazz_ = input.readBytes();
                bitField0_ |= 0x00000002;
                break;
              } // case 26
              case 34: {
                org.apache.pekko.protobufv3.internal.ByteString v = input.readBytes();
                ensureArgsIsMutable();
                args_.add(v);
                break;
              } // case 34
              case 42: {
                org.apache.pekko.protobufv3.internal.ByteString bs = input.readBytes();
                ensureManifestsIsMutable();
                manifests_.add(bs);
                break;
              } // case 42
              case 48: {
                int v = input.readInt32();
                ensureSerializerIdsIsMutable();
                serializerIds_.addInt(v);
                break;
              } // case 48
              case 50: {
                int length = input.readRawVarint32();
                int limit = input.pushLimit(length);
                ensureSerializerIdsIsMutable();
                while (input.getBytesUntilLimit() > 0) {
                  serializerIds_.addInt(input.readInt32());
                }
                input.popLimit(limit);
                break;
              } // case 50
              case 56: {
                boolean v = input.readBool();
                ensureHasManifestIsMutable();
                hasManifest_.addBoolean(v);
                break;
              } // case 56
              case 58: {
                int length = input.readRawVarint32();
                int limit = input.pushLimit(length);
                int alloc = length > 4096 ? 4096 : length;
                ensureHasManifestIsMutable(alloc / 1);
                while (input.getBytesUntilLimit() > 0) {
                  hasManifest_.addBoolean(input.readBool());
                }
                input.popLimit(limit);
                break;
              } // case 58
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private org.apache.pekko.remote.WireFormats.DeployData deploy_;
      private org.apache.pekko.protobufv3.internal.SingleFieldBuilder<
          org.apache.pekko.remote.WireFormats.DeployData, org.apache.pekko.remote.WireFormats.DeployData.Builder, org.apache.pekko.remote.WireFormats.DeployDataOrBuilder> deployBuilder_;
      /**
       * <code>required .DeployData deploy = 2;</code>
       * @return Whether the deploy field is set.
       */
      public boolean hasDeploy() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <code>required .DeployData deploy = 2;</code>
       * @return The deploy.
       */
      public org.apache.pekko.remote.WireFormats.DeployData getDeploy() {
        if (deployBuilder_ == null) {
          return deploy_ == null ? org.apache.pekko.remote.WireFormats.DeployData.getDefaultInstance() : deploy_;
        } else {
          return deployBuilder_.getMessage();
        }
      }
      /**
       * <code>required .DeployData deploy = 2;</code>
       */
      public Builder setDeploy(org.apache.pekko.remote.WireFormats.DeployData value) {
        if (deployBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          deploy_ = value;
        } else {
          deployBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <code>required .DeployData deploy = 2;</code>
       */
      public Builder setDeploy(
          org.apache.pekko.remote.WireFormats.DeployData.Builder builderForValue) {
        if (deployBuilder_ == null) {
          deploy_ = builderForValue.build();
        } else {
          deployBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <code>required .DeployData deploy = 2;</code>
       */
      public Builder mergeDeploy(org.apache.pekko.remote.WireFormats.DeployData value) {
        if (deployBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0) &&
            deploy_ != null &&
            deploy_ != org.apache.pekko.remote.WireFormats.DeployData.getDefaultInstance()) {
            getDeployBuilder().mergeFrom(value);
          } else {
            deploy_ = value;
          }
        } else {
          deployBuilder_.mergeFrom(value);
        }
        if (deploy_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }
      /**
       * <code>required .DeployData deploy = 2;</code>
       */
      public Builder clearDeploy() {
        bitField0_ = (bitField0_ & ~0x00000001);
        deploy_ = null;
        if (deployBuilder_ != null) {
          deployBuilder_.dispose();
          deployBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <code>required .DeployData deploy = 2;</code>
       */
      public org.apache.pekko.remote.WireFormats.DeployData.Builder getDeployBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return internalGetDeployFieldBuilder().getBuilder();
      }
      /**
       * <code>required .DeployData deploy = 2;</code>
       */
      public org.apache.pekko.remote.WireFormats.DeployDataOrBuilder getDeployOrBuilder() {
        if (deployBuilder_ != null) {
          return deployBuilder_.getMessageOrBuilder();
        } else {
          return deploy_ == null ?
              org.apache.pekko.remote.WireFormats.DeployData.getDefaultInstance() : deploy_;
        }
      }
      /**
       * <code>required .DeployData deploy = 2;</code>
       */
      private org.apache.pekko.protobufv3.internal.SingleFieldBuilder<
          org.apache.pekko.remote.WireFormats.DeployData, org.apache.pekko.remote.WireFormats.DeployData.Builder, org.apache.pekko.remote.WireFormats.DeployDataOrBuilder> 
          internalGetDeployFieldBuilder() {
        if (deployBuilder_ == null) {
          deployBuilder_ = new org.apache.pekko.protobufv3.internal.SingleFieldBuilder<
              org.apache.pekko.remote.WireFormats.DeployData, org.apache.pekko.remote.WireFormats.DeployData.Builder, org.apache.pekko.remote.WireFormats.DeployDataOrBuilder>(
                  getDeploy(),
                  getParentForChildren(),
                  isClean());
          deploy_ = null;
        }
        return deployBuilder_;
      }

      private java.lang.Object clazz_ = "";
      /**
       * <code>required string clazz = 3;</code>
       * @return Whether the clazz field is set.
       */
      public boolean hasClazz() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <code>required string clazz = 3;</code>
       * @return The clazz.
       */
      public java.lang.String getClazz() {
        java.lang.Object ref = clazz_;
        if (!(ref instanceof java.lang.String)) {
          org.apache.pekko.protobufv3.internal.ByteString bs =
              (org.apache.pekko.protobufv3.internal.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            clazz_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>required string clazz = 3;</code>
       * @return The bytes for clazz.
       */
      public org.apache.pekko.protobufv3.internal.ByteString
          getClazzBytes() {
        java.lang.Object ref = clazz_;
        if (ref instanceof String) {
          org.apache.pekko.protobufv3.internal.ByteString b = 
              org.apache.pekko.protobufv3.internal.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          clazz_ = b;
          return b;
        } else {
          return (org.apache.pekko.protobufv3.internal.ByteString) ref;
        }
      }
      /**
       * <code>required string clazz = 3;</code>
       * @param value The clazz to set.
       * @return This builder for chaining.
       */
      public Builder setClazz(
          java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        clazz_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <code>required string clazz = 3;</code>
       * @return This builder for chaining.
       */
      public Builder clearClazz() {
        clazz_ = getDefaultInstance().getClazz();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       * <code>required string clazz = 3;</code>
       * @param value The bytes for clazz to set.
       * @return This builder for chaining.
       */
      public Builder setClazzBytes(
          org.apache.pekko.protobufv3.internal.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        clazz_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private org.apache.pekko.protobufv3.internal.Internal.ProtobufList<org.apache.pekko.protobufv3.internal.ByteString> args_ = emptyList(org.apache.pekko.protobufv3.internal.ByteString.class);
      private void ensureArgsIsMutable() {
        if (!args_.isModifiable()) {
          args_ = makeMutableCopy(args_);
        }
        bitField0_ |= 0x00000004;
      }
      /**
       * <code>repeated bytes args = 4;</code>
       * @return A list containing the args.
       */
      public java.util.List<org.apache.pekko.protobufv3.internal.ByteString>
          getArgsList() {
        args_.makeImmutable();
        return args_;
      }
      /**
       * <code>repeated bytes args = 4;</code>
       * @return The count of args.
       */
      public int getArgsCount() {
        return args_.size();
      }
      /**
       * <code>repeated bytes args = 4;</code>
       * @param index The index of the element to return.
       * @return The args at the given index.
       */
      public org.apache.pekko.protobufv3.internal.ByteString getArgs(int index) {
        return args_.get(index);
      }
      /**
       * <code>repeated bytes args = 4;</code>
       * @param index The index to set the value at.
       * @param value The args to set.
       * @return This builder for chaining.
       */
      public Builder setArgs(
          int index, org.apache.pekko.protobufv3.internal.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        ensureArgsIsMutable();
        args_.set(index, value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       * <code>repeated bytes args = 4;</code>
       * @param value The args to add.
       * @return This builder for chaining.
       */
      public Builder addArgs(org.apache.pekko.protobufv3.internal.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        ensureArgsIsMutable();
        args_.add(value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       * <code>repeated bytes args = 4;</code>
       * @param values The args to add.
       * @return This builder for chaining.
       */
      public Builder addAllArgs(
          java.lang.Iterable<? extends org.apache.pekko.protobufv3.internal.ByteString> values) {
        ensureArgsIsMutable();
        org.apache.pekko.protobufv3.internal.AbstractMessageLite.Builder.addAll(
            values, args_);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       * <code>repeated bytes args = 4;</code>
       * @return This builder for chaining.
       */
      public Builder clearArgs() {
        args_ = emptyList(org.apache.pekko.protobufv3.internal.ByteString.class);
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }

      private org.apache.pekko.protobufv3.internal.LazyStringArrayList manifests_ =
          org.apache.pekko.protobufv3.internal.LazyStringArrayList.emptyList();
      private void ensureManifestsIsMutable() {
        if (!manifests_.isModifiable()) {
          manifests_ = new org.apache.pekko.protobufv3.internal.LazyStringArrayList(manifests_);
        }
        bitField0_ |= 0x00000008;
      }
      /**
       * <pre>
       * serialized props parameters
       * older wire protocol: contains class name for each arg
       * newer wire protocol: contains string manifest for each arg
       * </pre>
       *
       * <code>repeated string manifests = 5;</code>
       * @return A list containing the manifests.
       */
      public org.apache.pekko.protobufv3.internal.ProtocolStringList
          getManifestsList() {
        manifests_.makeImmutable();
        return manifests_;
      }
      /**
       * <pre>
       * serialized props parameters
       * older wire protocol: contains class name for each arg
       * newer wire protocol: contains string manifest for each arg
       * </pre>
       *
       * <code>repeated string manifests = 5;</code>
       * @return The count of manifests.
       */
      public int getManifestsCount() {
        return manifests_.size();
      }
      /**
       * <pre>
       * serialized props parameters
       * older wire protocol: contains class name for each arg
       * newer wire protocol: contains string manifest for each arg
       * </pre>
       *
       * <code>repeated string manifests = 5;</code>
       * @param index The index of the element to return.
       * @return The manifests at the given index.
       */
      public java.lang.String getManifests(int index) {
        return manifests_.get(index);
      }
      /**
       * <pre>
       * serialized props parameters
       * older wire protocol: contains class name for each arg
       * newer wire protocol: contains string manifest for each arg
       * </pre>
       *
       * <code>repeated string manifests = 5;</code>
       * @param index The index of the value to return.
       * @return The bytes of the manifests at the given index.
       */
      public org.apache.pekko.protobufv3.internal.ByteString
          getManifestsBytes(int index) {
        return manifests_.getByteString(index);
      }
      /**
       * <pre>
       * serialized props parameters
       * older wire protocol: contains class name for each arg
       * newer wire protocol: contains string manifest for each arg
       * </pre>
       *
       * <code>repeated string manifests = 5;</code>
       * @param index The index to set the value at.
       * @param value The manifests to set.
       * @return This builder for chaining.
       */
      public Builder setManifests(
          int index, java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        ensureManifestsIsMutable();
        manifests_.set(index, value);
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * serialized props parameters
       * older wire protocol: contains class name for each arg
       * newer wire protocol: contains string manifest for each arg
       * </pre>
       *
       * <code>repeated string manifests = 5;</code>
       * @param value The manifests to add.
       * @return This builder for chaining.
       */
      public Builder addManifests(
          java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        ensureManifestsIsMutable();
        manifests_.add(value);
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * serialized props parameters
       * older wire protocol: contains class name for each arg
       * newer wire protocol: contains string manifest for each arg
       * </pre>
       *
       * <code>repeated string manifests = 5;</code>
       * @param values The manifests to add.
       * @return This builder for chaining.
       */
      public Builder addAllManifests(
          java.lang.Iterable<java.lang.String> values) {
        ensureManifestsIsMutable();
        org.apache.pekko.protobufv3.internal.AbstractMessageLite.Builder.addAll(
            values, manifests_);
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * serialized props parameters
       * older wire protocol: contains class name for each arg
       * newer wire protocol: contains string manifest for each arg
       * </pre>
       *
       * <code>repeated string manifests = 5;</code>
       * @return This builder for chaining.
       */
      public Builder clearManifests() {
        manifests_ =
          org.apache.pekko.protobufv3.internal.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * serialized props parameters
       * older wire protocol: contains class name for each arg
       * newer wire protocol: contains string manifest for each arg
       * </pre>
       *
       * <code>repeated string manifests = 5;</code>
       * @param value The bytes of the manifests to add.
       * @return This builder for chaining.
       */
      public Builder addManifestsBytes(
          org.apache.pekko.protobufv3.internal.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        ensureManifestsIsMutable();
        manifests_.add(value);
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      private org.apache.pekko.protobufv3.internal.Internal.IntList serializerIds_ = emptyIntList();
      private void ensureSerializerIdsIsMutable() {
        if (!serializerIds_.isModifiable()) {
          serializerIds_ = makeMutableCopy(serializerIds_);
        }
        bitField0_ |= 0x00000010;
      }
      /**
       * <pre>
       * newer wire protocol: serializer id for each arg
       * </pre>
       *
       * <code>repeated int32 serializerIds = 6;</code>
       * @return A list containing the serializerIds.
       */
      public java.util.List<java.lang.Integer>
          getSerializerIdsList() {
        serializerIds_.makeImmutable();
        return serializerIds_;
      }
      /**
       * <pre>
       * newer wire protocol: serializer id for each arg
       * </pre>
       *
       * <code>repeated int32 serializerIds = 6;</code>
       * @return The count of serializerIds.
       */
      public int getSerializerIdsCount() {
        return serializerIds_.size();
      }
      /**
       * <pre>
       * newer wire protocol: serializer id for each arg
       * </pre>
       *
       * <code>repeated int32 serializerIds = 6;</code>
       * @param index The index of the element to return.
       * @return The serializerIds at the given index.
       */
      public int getSerializerIds(int index) {
        return serializerIds_.getInt(index);
      }
      /**
       * <pre>
       * newer wire protocol: serializer id for each arg
       * </pre>
       *
       * <code>repeated int32 serializerIds = 6;</code>
       * @param index The index to set the value at.
       * @param value The serializerIds to set.
       * @return This builder for chaining.
       */
      public Builder setSerializerIds(
          int index, int value) {

        ensureSerializerIdsIsMutable();
        serializerIds_.setInt(index, value);
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * newer wire protocol: serializer id for each arg
       * </pre>
       *
       * <code>repeated int32 serializerIds = 6;</code>
       * @param value The serializerIds to add.
       * @return This builder for chaining.
       */
      public Builder addSerializerIds(int value) {

        ensureSerializerIdsIsMutable();
        serializerIds_.addInt(value);
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * newer wire protocol: serializer id for each arg
       * </pre>
       *
       * <code>repeated int32 serializerIds = 6;</code>
       * @param values The serializerIds to add.
       * @return This builder for chaining.
       */
      public Builder addAllSerializerIds(
          java.lang.Iterable<? extends java.lang.Integer> values) {
        ensureSerializerIdsIsMutable();
        org.apache.pekko.protobufv3.internal.AbstractMessageLite.Builder.addAll(
            values, serializerIds_);
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * newer wire protocol: serializer id for each arg
       * </pre>
       *
       * <code>repeated int32 serializerIds = 6;</code>
       * @return This builder for chaining.
       */
      public Builder clearSerializerIds() {
        serializerIds_ = emptyIntList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
        return this;
      }

      private org.apache.pekko.protobufv3.internal.Internal.BooleanList hasManifest_ = emptyBooleanList();
      private void ensureHasManifestIsMutable() {
        if (!hasManifest_.isModifiable()) {
          hasManifest_ = makeMutableCopy(hasManifest_);
        }
        bitField0_ |= 0x00000020;
      }
      private void ensureHasManifestIsMutable(int capacity) {
        if (!hasManifest_.isModifiable()) {
          hasManifest_ = makeMutableCopy(hasManifest_, capacity);
        }
        bitField0_ |= 0x00000020;
      }
      /**
       * <pre>
       * additionally a flag per position to indicate if it was
       * serialized with manifest or not
       * </pre>
       *
       * <code>repeated bool hasManifest = 7;</code>
       * @return A list containing the hasManifest.
       */
      public java.util.List<java.lang.Boolean>
          getHasManifestList() {
        hasManifest_.makeImmutable();
        return hasManifest_;
      }
      /**
       * <pre>
       * additionally a flag per position to indicate if it was
       * serialized with manifest or not
       * </pre>
       *
       * <code>repeated bool hasManifest = 7;</code>
       * @return The count of hasManifest.
       */
      public int getHasManifestCount() {
        return hasManifest_.size();
      }
      /**
       * <pre>
       * additionally a flag per position to indicate if it was
       * serialized with manifest or not
       * </pre>
       *
       * <code>repeated bool hasManifest = 7;</code>
       * @param index The index of the element to return.
       * @return The hasManifest at the given index.
       */
      public boolean getHasManifest(int index) {
        return hasManifest_.getBoolean(index);
      }
      /**
       * <pre>
       * additionally a flag per position to indicate if it was
       * serialized with manifest or not
       * </pre>
       *
       * <code>repeated bool hasManifest = 7;</code>
       * @param index The index to set the value at.
       * @param value The hasManifest to set.
       * @return This builder for chaining.
       */
      public Builder setHasManifest(
          int index, boolean value) {

        ensureHasManifestIsMutable();
        hasManifest_.setBoolean(index, value);
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * additionally a flag per position to indicate if it was
       * serialized with manifest or not
       * </pre>
       *
       * <code>repeated bool hasManifest = 7;</code>
       * @param value The hasManifest to add.
       * @return This builder for chaining.
       */
      public Builder addHasManifest(boolean value) {

        ensureHasManifestIsMutable();
        hasManifest_.addBoolean(value);
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * additionally a flag per position to indicate if it was
       * serialized with manifest or not
       * </pre>
       *
       * <code>repeated bool hasManifest = 7;</code>
       * @param values The hasManifest to add.
       * @return This builder for chaining.
       */
      public Builder addAllHasManifest(
          java.lang.Iterable<? extends java.lang.Boolean> values) {
        ensureHasManifestIsMutable();
        org.apache.pekko.protobufv3.internal.AbstractMessageLite.Builder.addAll(
            values, hasManifest_);
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * additionally a flag per position to indicate if it was
       * serialized with manifest or not
       * </pre>
       *
       * <code>repeated bool hasManifest = 7;</code>
       * @return This builder for chaining.
       */
      public Builder clearHasManifest() {
        hasManifest_ = emptyBooleanList();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:PropsData)
    }

    // @@protoc_insertion_point(class_scope:PropsData)
    private static final org.apache.pekko.remote.WireFormats.PropsData DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.pekko.remote.WireFormats.PropsData();
    }

    public static org.apache.pekko.remote.WireFormats.PropsData getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final org.apache.pekko.protobufv3.internal.Parser<PropsData>
        PARSER = new org.apache.pekko.protobufv3.internal.AbstractParser<PropsData>() {
      @java.lang.Override
      public PropsData parsePartialFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (org.apache.pekko.protobufv3.internal.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static org.apache.pekko.protobufv3.internal.Parser<PropsData> parser() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.pekko.protobufv3.internal.Parser<PropsData> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.pekko.remote.WireFormats.PropsData getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface DeployDataOrBuilder extends
      // @@protoc_insertion_point(interface_extends:DeployData)
      org.apache.pekko.protobufv3.internal.MessageOrBuilder {

    /**
     * <code>required string path = 1;</code>
     * @return Whether the path field is set.
     */
    boolean hasPath();
    /**
     * <code>required string path = 1;</code>
     * @return The path.
     */
    java.lang.String getPath();
    /**
     * <code>required string path = 1;</code>
     * @return The bytes for path.
     */
    org.apache.pekko.protobufv3.internal.ByteString
        getPathBytes();

    /**
     * <code>optional bytes config = 2;</code>
     * @return Whether the config field is set.
     */
    boolean hasConfig();
    /**
     * <code>optional bytes config = 2;</code>
     * @return The config.
     */
    org.apache.pekko.protobufv3.internal.ByteString getConfig();

    /**
     * <code>optional bytes routerConfig = 3;</code>
     * @return Whether the routerConfig field is set.
     */
    boolean hasRouterConfig();
    /**
     * <code>optional bytes routerConfig = 3;</code>
     * @return The routerConfig.
     */
    org.apache.pekko.protobufv3.internal.ByteString getRouterConfig();

    /**
     * <code>optional bytes scope = 4;</code>
     * @return Whether the scope field is set.
     */
    boolean hasScope();
    /**
     * <code>optional bytes scope = 4;</code>
     * @return The scope.
     */
    org.apache.pekko.protobufv3.internal.ByteString getScope();

    /**
     * <code>optional string dispatcher = 5;</code>
     * @return Whether the dispatcher field is set.
     */
    boolean hasDispatcher();
    /**
     * <code>optional string dispatcher = 5;</code>
     * @return The dispatcher.
     */
    java.lang.String getDispatcher();
    /**
     * <code>optional string dispatcher = 5;</code>
     * @return The bytes for dispatcher.
     */
    org.apache.pekko.protobufv3.internal.ByteString
        getDispatcherBytes();

    /**
     * <pre>
     * older wire protocol: hardcoded class used to look up serializer
     * newer wire protocol: serializer id and manifest available for each
     * </pre>
     *
     * <code>optional int32 scopeSerializerId = 6;</code>
     * @return Whether the scopeSerializerId field is set.
     */
    boolean hasScopeSerializerId();
    /**
     * <pre>
     * older wire protocol: hardcoded class used to look up serializer
     * newer wire protocol: serializer id and manifest available for each
     * </pre>
     *
     * <code>optional int32 scopeSerializerId = 6;</code>
     * @return The scopeSerializerId.
     */
    int getScopeSerializerId();

    /**
     * <code>optional string scopeManifest = 7;</code>
     * @return Whether the scopeManifest field is set.
     */
    boolean hasScopeManifest();
    /**
     * <code>optional string scopeManifest = 7;</code>
     * @return The scopeManifest.
     */
    java.lang.String getScopeManifest();
    /**
     * <code>optional string scopeManifest = 7;</code>
     * @return The bytes for scopeManifest.
     */
    org.apache.pekko.protobufv3.internal.ByteString
        getScopeManifestBytes();

    /**
     * <code>optional int32 configSerializerId = 8;</code>
     * @return Whether the configSerializerId field is set.
     */
    boolean hasConfigSerializerId();
    /**
     * <code>optional int32 configSerializerId = 8;</code>
     * @return The configSerializerId.
     */
    int getConfigSerializerId();

    /**
     * <code>optional string configManifest = 9;</code>
     * @return Whether the configManifest field is set.
     */
    boolean hasConfigManifest();
    /**
     * <code>optional string configManifest = 9;</code>
     * @return The configManifest.
     */
    java.lang.String getConfigManifest();
    /**
     * <code>optional string configManifest = 9;</code>
     * @return The bytes for configManifest.
     */
    org.apache.pekko.protobufv3.internal.ByteString
        getConfigManifestBytes();

    /**
     * <code>optional int32 routerConfigSerializerId = 10;</code>
     * @return Whether the routerConfigSerializerId field is set.
     */
    boolean hasRouterConfigSerializerId();
    /**
     * <code>optional int32 routerConfigSerializerId = 10;</code>
     * @return The routerConfigSerializerId.
     */
    int getRouterConfigSerializerId();

    /**
     * <code>optional string routerConfigManifest = 11;</code>
     * @return Whether the routerConfigManifest field is set.
     */
    boolean hasRouterConfigManifest();
    /**
     * <code>optional string routerConfigManifest = 11;</code>
     * @return The routerConfigManifest.
     */
    java.lang.String getRouterConfigManifest();
    /**
     * <code>optional string routerConfigManifest = 11;</code>
     * @return The bytes for routerConfigManifest.
     */
    org.apache.pekko.protobufv3.internal.ByteString
        getRouterConfigManifestBytes();

    /**
     * <code>repeated string tags = 12;</code>
     * @return A list containing the tags.
     */
    java.util.List<java.lang.String>
        getTagsList();
    /**
     * <code>repeated string tags = 12;</code>
     * @return The count of tags.
     */
    int getTagsCount();
    /**
     * <code>repeated string tags = 12;</code>
     * @param index The index of the element to return.
     * @return The tags at the given index.
     */
    java.lang.String getTags(int index);
    /**
     * <code>repeated string tags = 12;</code>
     * @param index The index of the value to return.
     * @return The bytes of the tags at the given index.
     */
    org.apache.pekko.protobufv3.internal.ByteString
        getTagsBytes(int index);
  }
  /**
   * <pre>
   * *
   * Serialization of org.apache.pekko.actor.Deploy
   * </pre>
   *
   * Protobuf type {@code DeployData}
   */
  public static final class DeployData extends
      org.apache.pekko.protobufv3.internal.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:DeployData)
      DeployDataOrBuilder {
  private static final long serialVersionUID = 0L;
    static {
      org.apache.pekko.protobufv3.internal.RuntimeVersion.validateProtobufGencodeVersion(
        org.apache.pekko.protobufv3.internal.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 32,
        /* patch= */ 0,
        /* suffix= */ "",
        DeployData.class.getName());
    }
    // Use DeployData.newBuilder() to construct.
    private DeployData(org.apache.pekko.protobufv3.internal.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }
    private DeployData() {
      path_ = "";
      config_ = org.apache.pekko.protobufv3.internal.ByteString.EMPTY;
      routerConfig_ = org.apache.pekko.protobufv3.internal.ByteString.EMPTY;
      scope_ = org.apache.pekko.protobufv3.internal.ByteString.EMPTY;
      dispatcher_ = "";
      scopeManifest_ = "";
      configManifest_ = "";
      routerConfigManifest_ = "";
      tags_ =
          org.apache.pekko.protobufv3.internal.LazyStringArrayList.emptyList();
    }

    public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.pekko.remote.WireFormats.internal_static_DeployData_descriptor;
    }

    @java.lang.Override
    protected org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.pekko.remote.WireFormats.internal_static_DeployData_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.pekko.remote.WireFormats.DeployData.class, org.apache.pekko.remote.WireFormats.DeployData.Builder.class);
    }

    private int bitField0_;
    public static final int PATH_FIELD_NUMBER = 1;
    @SuppressWarnings("serial")
    private volatile java.lang.Object path_ = "";
    /**
     * <code>required string path = 1;</code>
     * @return Whether the path field is set.
     */
    @java.lang.Override
    public boolean hasPath() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <code>required string path = 1;</code>
     * @return The path.
     */
    @java.lang.Override
    public java.lang.String getPath() {
      java.lang.Object ref = path_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        org.apache.pekko.protobufv3.internal.ByteString bs = 
            (org.apache.pekko.protobufv3.internal.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          path_ = s;
        }
        return s;
      }
    }
    /**
     * <code>required string path = 1;</code>
     * @return The bytes for path.
     */
    @java.lang.Override
    public org.apache.pekko.protobufv3.internal.ByteString
        getPathBytes() {
      java.lang.Object ref = path_;
      if (ref instanceof java.lang.String) {
        org.apache.pekko.protobufv3.internal.ByteString b = 
            org.apache.pekko.protobufv3.internal.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        path_ = b;
        return b;
      } else {
        return (org.apache.pekko.protobufv3.internal.ByteString) ref;
      }
    }

    public static final int CONFIG_FIELD_NUMBER = 2;
    private org.apache.pekko.protobufv3.internal.ByteString config_ = org.apache.pekko.protobufv3.internal.ByteString.EMPTY;
    /**
     * <code>optional bytes config = 2;</code>
     * @return Whether the config field is set.
     */
    @java.lang.Override
    public boolean hasConfig() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <code>optional bytes config = 2;</code>
     * @return The config.
     */
    @java.lang.Override
    public org.apache.pekko.protobufv3.internal.ByteString getConfig() {
      return config_;
    }

    public static final int ROUTERCONFIG_FIELD_NUMBER = 3;
    private org.apache.pekko.protobufv3.internal.ByteString routerConfig_ = org.apache.pekko.protobufv3.internal.ByteString.EMPTY;
    /**
     * <code>optional bytes routerConfig = 3;</code>
     * @return Whether the routerConfig field is set.
     */
    @java.lang.Override
    public boolean hasRouterConfig() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     * <code>optional bytes routerConfig = 3;</code>
     * @return The routerConfig.
     */
    @java.lang.Override
    public org.apache.pekko.protobufv3.internal.ByteString getRouterConfig() {
      return routerConfig_;
    }

    public static final int SCOPE_FIELD_NUMBER = 4;
    private org.apache.pekko.protobufv3.internal.ByteString scope_ = org.apache.pekko.protobufv3.internal.ByteString.EMPTY;
    /**
     * <code>optional bytes scope = 4;</code>
     * @return Whether the scope field is set.
     */
    @java.lang.Override
    public boolean hasScope() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     * <code>optional bytes scope = 4;</code>
     * @return The scope.
     */
    @java.lang.Override
    public org.apache.pekko.protobufv3.internal.ByteString getScope() {
      return scope_;
    }

    public static final int DISPATCHER_FIELD_NUMBER = 5;
    @SuppressWarnings("serial")
    private volatile java.lang.Object dispatcher_ = "";
    /**
     * <code>optional string dispatcher = 5;</code>
     * @return Whether the dispatcher field is set.
     */
    @java.lang.Override
    public boolean hasDispatcher() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     * <code>optional string dispatcher = 5;</code>
     * @return The dispatcher.
     */
    @java.lang.Override
    public java.lang.String getDispatcher() {
      java.lang.Object ref = dispatcher_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        org.apache.pekko.protobufv3.internal.ByteString bs = 
            (org.apache.pekko.protobufv3.internal.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          dispatcher_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string dispatcher = 5;</code>
     * @return The bytes for dispatcher.
     */
    @java.lang.Override
    public org.apache.pekko.protobufv3.internal.ByteString
        getDispatcherBytes() {
      java.lang.Object ref = dispatcher_;
      if (ref instanceof java.lang.String) {
        org.apache.pekko.protobufv3.internal.ByteString b = 
            org.apache.pekko.protobufv3.internal.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        dispatcher_ = b;
        return b;
      } else {
        return (org.apache.pekko.protobufv3.internal.ByteString) ref;
      }
    }

    public static final int SCOPESERIALIZERID_FIELD_NUMBER = 6;
    private int scopeSerializerId_ = 0;
    /**
     * <pre>
     * older wire protocol: hardcoded class used to look up serializer
     * newer wire protocol: serializer id and manifest available for each
     * </pre>
     *
     * <code>optional int32 scopeSerializerId = 6;</code>
     * @return Whether the scopeSerializerId field is set.
     */
    @java.lang.Override
    public boolean hasScopeSerializerId() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     * <pre>
     * older wire protocol: hardcoded class used to look up serializer
     * newer wire protocol: serializer id and manifest available for each
     * </pre>
     *
     * <code>optional int32 scopeSerializerId = 6;</code>
     * @return The scopeSerializerId.
     */
    @java.lang.Override
    public int getScopeSerializerId() {
      return scopeSerializerId_;
    }

    public static final int SCOPEMANIFEST_FIELD_NUMBER = 7;
    @SuppressWarnings("serial")
    private volatile java.lang.Object scopeManifest_ = "";
    /**
     * <code>optional string scopeManifest = 7;</code>
     * @return Whether the scopeManifest field is set.
     */
    @java.lang.Override
    public boolean hasScopeManifest() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     * <code>optional string scopeManifest = 7;</code>
     * @return The scopeManifest.
     */
    @java.lang.Override
    public java.lang.String getScopeManifest() {
      java.lang.Object ref = scopeManifest_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        org.apache.pekko.protobufv3.internal.ByteString bs = 
            (org.apache.pekko.protobufv3.internal.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          scopeManifest_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string scopeManifest = 7;</code>
     * @return The bytes for scopeManifest.
     */
    @java.lang.Override
    public org.apache.pekko.protobufv3.internal.ByteString
        getScopeManifestBytes() {
      java.lang.Object ref = scopeManifest_;
      if (ref instanceof java.lang.String) {
        org.apache.pekko.protobufv3.internal.ByteString b = 
            org.apache.pekko.protobufv3.internal.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        scopeManifest_ = b;
        return b;
      } else {
        return (org.apache.pekko.protobufv3.internal.ByteString) ref;
      }
    }

    public static final int CONFIGSERIALIZERID_FIELD_NUMBER = 8;
    private int configSerializerId_ = 0;
    /**
     * <code>optional int32 configSerializerId = 8;</code>
     * @return Whether the configSerializerId field is set.
     */
    @java.lang.Override
    public boolean hasConfigSerializerId() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     * <code>optional int32 configSerializerId = 8;</code>
     * @return The configSerializerId.
     */
    @java.lang.Override
    public int getConfigSerializerId() {
      return configSerializerId_;
    }

    public static final int CONFIGMANIFEST_FIELD_NUMBER = 9;
    @SuppressWarnings("serial")
    private volatile java.lang.Object configManifest_ = "";
    /**
     * <code>optional string configManifest = 9;</code>
     * @return Whether the configManifest field is set.
     */
    @java.lang.Override
    public boolean hasConfigManifest() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     * <code>optional string configManifest = 9;</code>
     * @return The configManifest.
     */
    @java.lang.Override
    public java.lang.String getConfigManifest() {
      java.lang.Object ref = configManifest_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        org.apache.pekko.protobufv3.internal.ByteString bs = 
            (org.apache.pekko.protobufv3.internal.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          configManifest_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string configManifest = 9;</code>
     * @return The bytes for configManifest.
     */
    @java.lang.Override
    public org.apache.pekko.protobufv3.internal.ByteString
        getConfigManifestBytes() {
      java.lang.Object ref = configManifest_;
      if (ref instanceof java.lang.String) {
        org.apache.pekko.protobufv3.internal.ByteString b = 
            org.apache.pekko.protobufv3.internal.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        configManifest_ = b;
        return b;
      } else {
        return (org.apache.pekko.protobufv3.internal.ByteString) ref;
      }
    }

    public static final int ROUTERCONFIGSERIALIZERID_FIELD_NUMBER = 10;
    private int routerConfigSerializerId_ = 0;
    /**
     * <code>optional int32 routerConfigSerializerId = 10;</code>
     * @return Whether the routerConfigSerializerId field is set.
     */
    @java.lang.Override
    public boolean hasRouterConfigSerializerId() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     * <code>optional int32 routerConfigSerializerId = 10;</code>
     * @return The routerConfigSerializerId.
     */
    @java.lang.Override
    public int getRouterConfigSerializerId() {
      return routerConfigSerializerId_;
    }

    public static final int ROUTERCONFIGMANIFEST_FIELD_NUMBER = 11;
    @SuppressWarnings("serial")
    private volatile java.lang.Object routerConfigManifest_ = "";
    /**
     * <code>optional string routerConfigManifest = 11;</code>
     * @return Whether the routerConfigManifest field is set.
     */
    @java.lang.Override
    public boolean hasRouterConfigManifest() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     * <code>optional string routerConfigManifest = 11;</code>
     * @return The routerConfigManifest.
     */
    @java.lang.Override
    public java.lang.String getRouterConfigManifest() {
      java.lang.Object ref = routerConfigManifest_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        org.apache.pekko.protobufv3.internal.ByteString bs = 
            (org.apache.pekko.protobufv3.internal.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          routerConfigManifest_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string routerConfigManifest = 11;</code>
     * @return The bytes for routerConfigManifest.
     */
    @java.lang.Override
    public org.apache.pekko.protobufv3.internal.ByteString
        getRouterConfigManifestBytes() {
      java.lang.Object ref = routerConfigManifest_;
      if (ref instanceof java.lang.String) {
        org.apache.pekko.protobufv3.internal.ByteString b = 
            org.apache.pekko.protobufv3.internal.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        routerConfigManifest_ = b;
        return b;
      } else {
        return (org.apache.pekko.protobufv3.internal.ByteString) ref;
      }
    }

    public static final int TAGS_FIELD_NUMBER = 12;
    @SuppressWarnings("serial")
    private org.apache.pekko.protobufv3.internal.LazyStringArrayList tags_ =
        org.apache.pekko.protobufv3.internal.LazyStringArrayList.emptyList();
    /**
     * <code>repeated string tags = 12;</code>
     * @return A list containing the tags.
     */
    public org.apache.pekko.protobufv3.internal.ProtocolStringList
        getTagsList() {
      return tags_;
    }
    /**
     * <code>repeated string tags = 12;</code>
     * @return The count of tags.
     */
    public int getTagsCount() {
      return tags_.size();
    }
    /**
     * <code>repeated string tags = 12;</code>
     * @param index The index of the element to return.
     * @return The tags at the given index.
     */
    public java.lang.String getTags(int index) {
      return tags_.get(index);
    }
    /**
     * <code>repeated string tags = 12;</code>
     * @param index The index of the value to return.
     * @return The bytes of the tags at the given index.
     */
    public org.apache.pekko.protobufv3.internal.ByteString
        getTagsBytes(int index) {
      return tags_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasPath()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(org.apache.pekko.protobufv3.internal.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        org.apache.pekko.protobufv3.internal.GeneratedMessage.writeString(output, 1, path_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeBytes(2, config_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        output.writeBytes(3, routerConfig_);
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        output.writeBytes(4, scope_);
      }
      if (((bitField0_ & 0x00000010) != 0)) {
        org.apache.pekko.protobufv3.internal.GeneratedMessage.writeString(output, 5, dispatcher_);
      }
      if (((bitField0_ & 0x00000020) != 0)) {
        output.writeInt32(6, scopeSerializerId_);
      }
      if (((bitField0_ & 0x00000040) != 0)) {
        org.apache.pekko.protobufv3.internal.GeneratedMessage.writeString(output, 7, scopeManifest_);
      }
      if (((bitField0_ & 0x00000080) != 0)) {
        output.writeInt32(8, configSerializerId_);
      }
      if (((bitField0_ & 0x00000100) != 0)) {
        org.apache.pekko.protobufv3.internal.GeneratedMessage.writeString(output, 9, configManifest_);
      }
      if (((bitField0_ & 0x00000200) != 0)) {
        output.writeInt32(10, routerConfigSerializerId_);
      }
      if (((bitField0_ & 0x00000400) != 0)) {
        org.apache.pekko.protobufv3.internal.GeneratedMessage.writeString(output, 11, routerConfigManifest_);
      }
      for (int i = 0; i < tags_.size(); i++) {
        org.apache.pekko.protobufv3.internal.GeneratedMessage.writeString(output, 12, tags_.getRaw(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += org.apache.pekko.protobufv3.internal.GeneratedMessage.computeStringSize(1, path_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeBytesSize(2, config_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeBytesSize(3, routerConfig_);
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeBytesSize(4, scope_);
      }
      if (((bitField0_ & 0x00000010) != 0)) {
        size += org.apache.pekko.protobufv3.internal.GeneratedMessage.computeStringSize(5, dispatcher_);
      }
      if (((bitField0_ & 0x00000020) != 0)) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeInt32Size(6, scopeSerializerId_);
      }
      if (((bitField0_ & 0x00000040) != 0)) {
        size += org.apache.pekko.protobufv3.internal.GeneratedMessage.computeStringSize(7, scopeManifest_);
      }
      if (((bitField0_ & 0x00000080) != 0)) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeInt32Size(8, configSerializerId_);
      }
      if (((bitField0_ & 0x00000100) != 0)) {
        size += org.apache.pekko.protobufv3.internal.GeneratedMessage.computeStringSize(9, configManifest_);
      }
      if (((bitField0_ & 0x00000200) != 0)) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeInt32Size(10, routerConfigSerializerId_);
      }
      if (((bitField0_ & 0x00000400) != 0)) {
        size += org.apache.pekko.protobufv3.internal.GeneratedMessage.computeStringSize(11, routerConfigManifest_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < tags_.size(); i++) {
          dataSize += computeStringSizeNoTag(tags_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getTagsList().size();
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.pekko.remote.WireFormats.DeployData)) {
        return super.equals(obj);
      }
      org.apache.pekko.remote.WireFormats.DeployData other = (org.apache.pekko.remote.WireFormats.DeployData) obj;

      if (hasPath() != other.hasPath()) return false;
      if (hasPath()) {
        if (!getPath()
            .equals(other.getPath())) return false;
      }
      if (hasConfig() != other.hasConfig()) return false;
      if (hasConfig()) {
        if (!getConfig()
            .equals(other.getConfig())) return false;
      }
      if (hasRouterConfig() != other.hasRouterConfig()) return false;
      if (hasRouterConfig()) {
        if (!getRouterConfig()
            .equals(other.getRouterConfig())) return false;
      }
      if (hasScope() != other.hasScope()) return false;
      if (hasScope()) {
        if (!getScope()
            .equals(other.getScope())) return false;
      }
      if (hasDispatcher() != other.hasDispatcher()) return false;
      if (hasDispatcher()) {
        if (!getDispatcher()
            .equals(other.getDispatcher())) return false;
      }
      if (hasScopeSerializerId() != other.hasScopeSerializerId()) return false;
      if (hasScopeSerializerId()) {
        if (getScopeSerializerId()
            != other.getScopeSerializerId()) return false;
      }
      if (hasScopeManifest() != other.hasScopeManifest()) return false;
      if (hasScopeManifest()) {
        if (!getScopeManifest()
            .equals(other.getScopeManifest())) return false;
      }
      if (hasConfigSerializerId() != other.hasConfigSerializerId()) return false;
      if (hasConfigSerializerId()) {
        if (getConfigSerializerId()
            != other.getConfigSerializerId()) return false;
      }
      if (hasConfigManifest() != other.hasConfigManifest()) return false;
      if (hasConfigManifest()) {
        if (!getConfigManifest()
            .equals(other.getConfigManifest())) return false;
      }
      if (hasRouterConfigSerializerId() != other.hasRouterConfigSerializerId()) return false;
      if (hasRouterConfigSerializerId()) {
        if (getRouterConfigSerializerId()
            != other.getRouterConfigSerializerId()) return false;
      }
      if (hasRouterConfigManifest() != other.hasRouterConfigManifest()) return false;
      if (hasRouterConfigManifest()) {
        if (!getRouterConfigManifest()
            .equals(other.getRouterConfigManifest())) return false;
      }
      if (!getTagsList()
          .equals(other.getTagsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasPath()) {
        hash = (37 * hash) + PATH_FIELD_NUMBER;
        hash = (53 * hash) + getPath().hashCode();
      }
      if (hasConfig()) {
        hash = (37 * hash) + CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getConfig().hashCode();
      }
      if (hasRouterConfig()) {
        hash = (37 * hash) + ROUTERCONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getRouterConfig().hashCode();
      }
      if (hasScope()) {
        hash = (37 * hash) + SCOPE_FIELD_NUMBER;
        hash = (53 * hash) + getScope().hashCode();
      }
      if (hasDispatcher()) {
        hash = (37 * hash) + DISPATCHER_FIELD_NUMBER;
        hash = (53 * hash) + getDispatcher().hashCode();
      }
      if (hasScopeSerializerId()) {
        hash = (37 * hash) + SCOPESERIALIZERID_FIELD_NUMBER;
        hash = (53 * hash) + getScopeSerializerId();
      }
      if (hasScopeManifest()) {
        hash = (37 * hash) + SCOPEMANIFEST_FIELD_NUMBER;
        hash = (53 * hash) + getScopeManifest().hashCode();
      }
      if (hasConfigSerializerId()) {
        hash = (37 * hash) + CONFIGSERIALIZERID_FIELD_NUMBER;
        hash = (53 * hash) + getConfigSerializerId();
      }
      if (hasConfigManifest()) {
        hash = (37 * hash) + CONFIGMANIFEST_FIELD_NUMBER;
        hash = (53 * hash) + getConfigManifest().hashCode();
      }
      if (hasRouterConfigSerializerId()) {
        hash = (37 * hash) + ROUTERCONFIGSERIALIZERID_FIELD_NUMBER;
        hash = (53 * hash) + getRouterConfigSerializerId();
      }
      if (hasRouterConfigManifest()) {
        hash = (37 * hash) + ROUTERCONFIGMANIFEST_FIELD_NUMBER;
        hash = (53 * hash) + getRouterConfigManifest().hashCode();
      }
      if (getTagsCount() > 0) {
        hash = (37 * hash) + TAGS_FIELD_NUMBER;
        hash = (53 * hash) + getTagsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.pekko.remote.WireFormats.DeployData parseFrom(
        java.nio.ByteBuffer data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.remote.WireFormats.DeployData parseFrom(
        java.nio.ByteBuffer data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.DeployData parseFrom(
        org.apache.pekko.protobufv3.internal.ByteString data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.remote.WireFormats.DeployData parseFrom(
        org.apache.pekko.protobufv3.internal.ByteString data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.DeployData parseFrom(byte[] data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.remote.WireFormats.DeployData parseFrom(
        byte[] data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.DeployData parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.pekko.remote.WireFormats.DeployData parseFrom(
        java.io.InputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static org.apache.pekko.remote.WireFormats.DeployData parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static org.apache.pekko.remote.WireFormats.DeployData parseDelimitedFrom(
        java.io.InputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.DeployData parseFrom(
        org.apache.pekko.protobufv3.internal.CodedInputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.pekko.remote.WireFormats.DeployData parseFrom(
        org.apache.pekko.protobufv3.internal.CodedInputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.pekko.remote.WireFormats.DeployData prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        org.apache.pekko.protobufv3.internal.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * *
     * Serialization of org.apache.pekko.actor.Deploy
     * </pre>
     *
     * Protobuf type {@code DeployData}
     */
    public static final class Builder extends
        org.apache.pekko.protobufv3.internal.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:DeployData)
        org.apache.pekko.remote.WireFormats.DeployDataOrBuilder {
      public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.pekko.remote.WireFormats.internal_static_DeployData_descriptor;
      }

      @java.lang.Override
      protected org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.pekko.remote.WireFormats.internal_static_DeployData_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.pekko.remote.WireFormats.DeployData.class, org.apache.pekko.remote.WireFormats.DeployData.Builder.class);
      }

      // Construct using org.apache.pekko.remote.WireFormats.DeployData.newBuilder()
      private Builder() {

      }

      private Builder(
          org.apache.pekko.protobufv3.internal.GeneratedMessage.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        path_ = "";
        config_ = org.apache.pekko.protobufv3.internal.ByteString.EMPTY;
        routerConfig_ = org.apache.pekko.protobufv3.internal.ByteString.EMPTY;
        scope_ = org.apache.pekko.protobufv3.internal.ByteString.EMPTY;
        dispatcher_ = "";
        scopeSerializerId_ = 0;
        scopeManifest_ = "";
        configSerializerId_ = 0;
        configManifest_ = "";
        routerConfigSerializerId_ = 0;
        routerConfigManifest_ = "";
        tags_ =
            org.apache.pekko.protobufv3.internal.LazyStringArrayList.emptyList();
        return this;
      }

      @java.lang.Override
      public org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.pekko.remote.WireFormats.internal_static_DeployData_descriptor;
      }

      @java.lang.Override
      public org.apache.pekko.remote.WireFormats.DeployData getDefaultInstanceForType() {
        return org.apache.pekko.remote.WireFormats.DeployData.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.pekko.remote.WireFormats.DeployData build() {
        org.apache.pekko.remote.WireFormats.DeployData result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.pekko.remote.WireFormats.DeployData buildPartial() {
        org.apache.pekko.remote.WireFormats.DeployData result = new org.apache.pekko.remote.WireFormats.DeployData(this);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartial0(org.apache.pekko.remote.WireFormats.DeployData result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.path_ = path_;
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.config_ = config_;
          to_bitField0_ |= 0x00000002;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.routerConfig_ = routerConfig_;
          to_bitField0_ |= 0x00000004;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.scope_ = scope_;
          to_bitField0_ |= 0x00000008;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.dispatcher_ = dispatcher_;
          to_bitField0_ |= 0x00000010;
        }
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.scopeSerializerId_ = scopeSerializerId_;
          to_bitField0_ |= 0x00000020;
        }
        if (((from_bitField0_ & 0x00000040) != 0)) {
          result.scopeManifest_ = scopeManifest_;
          to_bitField0_ |= 0x00000040;
        }
        if (((from_bitField0_ & 0x00000080) != 0)) {
          result.configSerializerId_ = configSerializerId_;
          to_bitField0_ |= 0x00000080;
        }
        if (((from_bitField0_ & 0x00000100) != 0)) {
          result.configManifest_ = configManifest_;
          to_bitField0_ |= 0x00000100;
        }
        if (((from_bitField0_ & 0x00000200) != 0)) {
          result.routerConfigSerializerId_ = routerConfigSerializerId_;
          to_bitField0_ |= 0x00000200;
        }
        if (((from_bitField0_ & 0x00000400) != 0)) {
          result.routerConfigManifest_ = routerConfigManifest_;
          to_bitField0_ |= 0x00000400;
        }
        if (((from_bitField0_ & 0x00000800) != 0)) {
          tags_.makeImmutable();
          result.tags_ = tags_;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder mergeFrom(org.apache.pekko.protobufv3.internal.Message other) {
        if (other instanceof org.apache.pekko.remote.WireFormats.DeployData) {
          return mergeFrom((org.apache.pekko.remote.WireFormats.DeployData)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.pekko.remote.WireFormats.DeployData other) {
        if (other == org.apache.pekko.remote.WireFormats.DeployData.getDefaultInstance()) return this;
        if (other.hasPath()) {
          path_ = other.path_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.hasConfig()) {
          setConfig(other.getConfig());
        }
        if (other.hasRouterConfig()) {
          setRouterConfig(other.getRouterConfig());
        }
        if (other.hasScope()) {
          setScope(other.getScope());
        }
        if (other.hasDispatcher()) {
          dispatcher_ = other.dispatcher_;
          bitField0_ |= 0x00000010;
          onChanged();
        }
        if (other.hasScopeSerializerId()) {
          setScopeSerializerId(other.getScopeSerializerId());
        }
        if (other.hasScopeManifest()) {
          scopeManifest_ = other.scopeManifest_;
          bitField0_ |= 0x00000040;
          onChanged();
        }
        if (other.hasConfigSerializerId()) {
          setConfigSerializerId(other.getConfigSerializerId());
        }
        if (other.hasConfigManifest()) {
          configManifest_ = other.configManifest_;
          bitField0_ |= 0x00000100;
          onChanged();
        }
        if (other.hasRouterConfigSerializerId()) {
          setRouterConfigSerializerId(other.getRouterConfigSerializerId());
        }
        if (other.hasRouterConfigManifest()) {
          routerConfigManifest_ = other.routerConfigManifest_;
          bitField0_ |= 0x00000400;
          onChanged();
        }
        if (!other.tags_.isEmpty()) {
          if (tags_.isEmpty()) {
            tags_ = other.tags_;
            bitField0_ |= 0x00000800;
          } else {
            ensureTagsIsMutable();
            tags_.addAll(other.tags_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        if (!hasPath()) {
          return false;
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                path_ = input.readBytes();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
              case 18: {
                config_ = input.readBytes();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
              case 26: {
                routerConfig_ = input.readBytes();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
              case 34: {
                scope_ = input.readBytes();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
              case 42: {
                dispatcher_ = input.readBytes();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
              case 48: {
                scopeSerializerId_ = input.readInt32();
                bitField0_ |= 0x00000020;
                break;
              } // case 48
              case 58: {
                scopeManifest_ = input.readBytes();
                bitField0_ |= 0x00000040;
                break;
              } // case 58
              case 64: {
                configSerializerId_ = input.readInt32();
                bitField0_ |= 0x00000080;
                break;
              } // case 64
              case 74: {
                configManifest_ = input.readBytes();
                bitField0_ |= 0x00000100;
                break;
              } // case 74
              case 80: {
                routerConfigSerializerId_ = input.readInt32();
                bitField0_ |= 0x00000200;
                break;
              } // case 80
              case 90: {
                routerConfigManifest_ = input.readBytes();
                bitField0_ |= 0x00000400;
                break;
              } // case 90
              case 98: {
                org.apache.pekko.protobufv3.internal.ByteString bs = input.readBytes();
                ensureTagsIsMutable();
                tags_.add(bs);
                break;
              } // case 98
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private java.lang.Object path_ = "";
      /**
       * <code>required string path = 1;</code>
       * @return Whether the path field is set.
       */
      public boolean hasPath() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <code>required string path = 1;</code>
       * @return The path.
       */
      public java.lang.String getPath() {
        java.lang.Object ref = path_;
        if (!(ref instanceof java.lang.String)) {
          org.apache.pekko.protobufv3.internal.ByteString bs =
              (org.apache.pekko.protobufv3.internal.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            path_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>required string path = 1;</code>
       * @return The bytes for path.
       */
      public org.apache.pekko.protobufv3.internal.ByteString
          getPathBytes() {
        java.lang.Object ref = path_;
        if (ref instanceof String) {
          org.apache.pekko.protobufv3.internal.ByteString b = 
              org.apache.pekko.protobufv3.internal.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          path_ = b;
          return b;
        } else {
          return (org.apache.pekko.protobufv3.internal.ByteString) ref;
        }
      }
      /**
       * <code>required string path = 1;</code>
       * @param value The path to set.
       * @return This builder for chaining.
       */
      public Builder setPath(
          java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        path_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <code>required string path = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearPath() {
        path_ = getDefaultInstance().getPath();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       * <code>required string path = 1;</code>
       * @param value The bytes for path to set.
       * @return This builder for chaining.
       */
      public Builder setPathBytes(
          org.apache.pekko.protobufv3.internal.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        path_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private org.apache.pekko.protobufv3.internal.ByteString config_ = org.apache.pekko.protobufv3.internal.ByteString.EMPTY;
      /**
       * <code>optional bytes config = 2;</code>
       * @return Whether the config field is set.
       */
      @java.lang.Override
      public boolean hasConfig() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <code>optional bytes config = 2;</code>
       * @return The config.
       */
      @java.lang.Override
      public org.apache.pekko.protobufv3.internal.ByteString getConfig() {
        return config_;
      }
      /**
       * <code>optional bytes config = 2;</code>
       * @param value The config to set.
       * @return This builder for chaining.
       */
      public Builder setConfig(org.apache.pekko.protobufv3.internal.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        config_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <code>optional bytes config = 2;</code>
       * @return This builder for chaining.
       */
      public Builder clearConfig() {
        bitField0_ = (bitField0_ & ~0x00000002);
        config_ = getDefaultInstance().getConfig();
        onChanged();
        return this;
      }

      private org.apache.pekko.protobufv3.internal.ByteString routerConfig_ = org.apache.pekko.protobufv3.internal.ByteString.EMPTY;
      /**
       * <code>optional bytes routerConfig = 3;</code>
       * @return Whether the routerConfig field is set.
       */
      @java.lang.Override
      public boolean hasRouterConfig() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       * <code>optional bytes routerConfig = 3;</code>
       * @return The routerConfig.
       */
      @java.lang.Override
      public org.apache.pekko.protobufv3.internal.ByteString getRouterConfig() {
        return routerConfig_;
      }
      /**
       * <code>optional bytes routerConfig = 3;</code>
       * @param value The routerConfig to set.
       * @return This builder for chaining.
       */
      public Builder setRouterConfig(org.apache.pekko.protobufv3.internal.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        routerConfig_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       * <code>optional bytes routerConfig = 3;</code>
       * @return This builder for chaining.
       */
      public Builder clearRouterConfig() {
        bitField0_ = (bitField0_ & ~0x00000004);
        routerConfig_ = getDefaultInstance().getRouterConfig();
        onChanged();
        return this;
      }

      private org.apache.pekko.protobufv3.internal.ByteString scope_ = org.apache.pekko.protobufv3.internal.ByteString.EMPTY;
      /**
       * <code>optional bytes scope = 4;</code>
       * @return Whether the scope field is set.
       */
      @java.lang.Override
      public boolean hasScope() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       * <code>optional bytes scope = 4;</code>
       * @return The scope.
       */
      @java.lang.Override
      public org.apache.pekko.protobufv3.internal.ByteString getScope() {
        return scope_;
      }
      /**
       * <code>optional bytes scope = 4;</code>
       * @param value The scope to set.
       * @return This builder for chaining.
       */
      public Builder setScope(org.apache.pekko.protobufv3.internal.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        scope_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       * <code>optional bytes scope = 4;</code>
       * @return This builder for chaining.
       */
      public Builder clearScope() {
        bitField0_ = (bitField0_ & ~0x00000008);
        scope_ = getDefaultInstance().getScope();
        onChanged();
        return this;
      }

      private java.lang.Object dispatcher_ = "";
      /**
       * <code>optional string dispatcher = 5;</code>
       * @return Whether the dispatcher field is set.
       */
      public boolean hasDispatcher() {
        return ((bitField0_ & 0x00000010) != 0);
      }
      /**
       * <code>optional string dispatcher = 5;</code>
       * @return The dispatcher.
       */
      public java.lang.String getDispatcher() {
        java.lang.Object ref = dispatcher_;
        if (!(ref instanceof java.lang.String)) {
          org.apache.pekko.protobufv3.internal.ByteString bs =
              (org.apache.pekko.protobufv3.internal.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            dispatcher_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string dispatcher = 5;</code>
       * @return The bytes for dispatcher.
       */
      public org.apache.pekko.protobufv3.internal.ByteString
          getDispatcherBytes() {
        java.lang.Object ref = dispatcher_;
        if (ref instanceof String) {
          org.apache.pekko.protobufv3.internal.ByteString b = 
              org.apache.pekko.protobufv3.internal.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          dispatcher_ = b;
          return b;
        } else {
          return (org.apache.pekko.protobufv3.internal.ByteString) ref;
        }
      }
      /**
       * <code>optional string dispatcher = 5;</code>
       * @param value The dispatcher to set.
       * @return This builder for chaining.
       */
      public Builder setDispatcher(
          java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        dispatcher_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       * <code>optional string dispatcher = 5;</code>
       * @return This builder for chaining.
       */
      public Builder clearDispatcher() {
        dispatcher_ = getDefaultInstance().getDispatcher();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
        return this;
      }
      /**
       * <code>optional string dispatcher = 5;</code>
       * @param value The bytes for dispatcher to set.
       * @return This builder for chaining.
       */
      public Builder setDispatcherBytes(
          org.apache.pekko.protobufv3.internal.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        dispatcher_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      private int scopeSerializerId_ ;
      /**
       * <pre>
       * older wire protocol: hardcoded class used to look up serializer
       * newer wire protocol: serializer id and manifest available for each
       * </pre>
       *
       * <code>optional int32 scopeSerializerId = 6;</code>
       * @return Whether the scopeSerializerId field is set.
       */
      @java.lang.Override
      public boolean hasScopeSerializerId() {
        return ((bitField0_ & 0x00000020) != 0);
      }
      /**
       * <pre>
       * older wire protocol: hardcoded class used to look up serializer
       * newer wire protocol: serializer id and manifest available for each
       * </pre>
       *
       * <code>optional int32 scopeSerializerId = 6;</code>
       * @return The scopeSerializerId.
       */
      @java.lang.Override
      public int getScopeSerializerId() {
        return scopeSerializerId_;
      }
      /**
       * <pre>
       * older wire protocol: hardcoded class used to look up serializer
       * newer wire protocol: serializer id and manifest available for each
       * </pre>
       *
       * <code>optional int32 scopeSerializerId = 6;</code>
       * @param value The scopeSerializerId to set.
       * @return This builder for chaining.
       */
      public Builder setScopeSerializerId(int value) {

        scopeSerializerId_ = value;
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * older wire protocol: hardcoded class used to look up serializer
       * newer wire protocol: serializer id and manifest available for each
       * </pre>
       *
       * <code>optional int32 scopeSerializerId = 6;</code>
       * @return This builder for chaining.
       */
      public Builder clearScopeSerializerId() {
        bitField0_ = (bitField0_ & ~0x00000020);
        scopeSerializerId_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object scopeManifest_ = "";
      /**
       * <code>optional string scopeManifest = 7;</code>
       * @return Whether the scopeManifest field is set.
       */
      public boolean hasScopeManifest() {
        return ((bitField0_ & 0x00000040) != 0);
      }
      /**
       * <code>optional string scopeManifest = 7;</code>
       * @return The scopeManifest.
       */
      public java.lang.String getScopeManifest() {
        java.lang.Object ref = scopeManifest_;
        if (!(ref instanceof java.lang.String)) {
          org.apache.pekko.protobufv3.internal.ByteString bs =
              (org.apache.pekko.protobufv3.internal.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            scopeManifest_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string scopeManifest = 7;</code>
       * @return The bytes for scopeManifest.
       */
      public org.apache.pekko.protobufv3.internal.ByteString
          getScopeManifestBytes() {
        java.lang.Object ref = scopeManifest_;
        if (ref instanceof String) {
          org.apache.pekko.protobufv3.internal.ByteString b = 
              org.apache.pekko.protobufv3.internal.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          scopeManifest_ = b;
          return b;
        } else {
          return (org.apache.pekko.protobufv3.internal.ByteString) ref;
        }
      }
      /**
       * <code>optional string scopeManifest = 7;</code>
       * @param value The scopeManifest to set.
       * @return This builder for chaining.
       */
      public Builder setScopeManifest(
          java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        scopeManifest_ = value;
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }
      /**
       * <code>optional string scopeManifest = 7;</code>
       * @return This builder for chaining.
       */
      public Builder clearScopeManifest() {
        scopeManifest_ = getDefaultInstance().getScopeManifest();
        bitField0_ = (bitField0_ & ~0x00000040);
        onChanged();
        return this;
      }
      /**
       * <code>optional string scopeManifest = 7;</code>
       * @param value The bytes for scopeManifest to set.
       * @return This builder for chaining.
       */
      public Builder setScopeManifestBytes(
          org.apache.pekko.protobufv3.internal.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        scopeManifest_ = value;
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }

      private int configSerializerId_ ;
      /**
       * <code>optional int32 configSerializerId = 8;</code>
       * @return Whether the configSerializerId field is set.
       */
      @java.lang.Override
      public boolean hasConfigSerializerId() {
        return ((bitField0_ & 0x00000080) != 0);
      }
      /**
       * <code>optional int32 configSerializerId = 8;</code>
       * @return The configSerializerId.
       */
      @java.lang.Override
      public int getConfigSerializerId() {
        return configSerializerId_;
      }
      /**
       * <code>optional int32 configSerializerId = 8;</code>
       * @param value The configSerializerId to set.
       * @return This builder for chaining.
       */
      public Builder setConfigSerializerId(int value) {

        configSerializerId_ = value;
        bitField0_ |= 0x00000080;
        onChanged();
        return this;
      }
      /**
       * <code>optional int32 configSerializerId = 8;</code>
       * @return This builder for chaining.
       */
      public Builder clearConfigSerializerId() {
        bitField0_ = (bitField0_ & ~0x00000080);
        configSerializerId_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object configManifest_ = "";
      /**
       * <code>optional string configManifest = 9;</code>
       * @return Whether the configManifest field is set.
       */
      public boolean hasConfigManifest() {
        return ((bitField0_ & 0x00000100) != 0);
      }
      /**
       * <code>optional string configManifest = 9;</code>
       * @return The configManifest.
       */
      public java.lang.String getConfigManifest() {
        java.lang.Object ref = configManifest_;
        if (!(ref instanceof java.lang.String)) {
          org.apache.pekko.protobufv3.internal.ByteString bs =
              (org.apache.pekko.protobufv3.internal.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            configManifest_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string configManifest = 9;</code>
       * @return The bytes for configManifest.
       */
      public org.apache.pekko.protobufv3.internal.ByteString
          getConfigManifestBytes() {
        java.lang.Object ref = configManifest_;
        if (ref instanceof String) {
          org.apache.pekko.protobufv3.internal.ByteString b = 
              org.apache.pekko.protobufv3.internal.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          configManifest_ = b;
          return b;
        } else {
          return (org.apache.pekko.protobufv3.internal.ByteString) ref;
        }
      }
      /**
       * <code>optional string configManifest = 9;</code>
       * @param value The configManifest to set.
       * @return This builder for chaining.
       */
      public Builder setConfigManifest(
          java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        configManifest_ = value;
        bitField0_ |= 0x00000100;
        onChanged();
        return this;
      }
      /**
       * <code>optional string configManifest = 9;</code>
       * @return This builder for chaining.
       */
      public Builder clearConfigManifest() {
        configManifest_ = getDefaultInstance().getConfigManifest();
        bitField0_ = (bitField0_ & ~0x00000100);
        onChanged();
        return this;
      }
      /**
       * <code>optional string configManifest = 9;</code>
       * @param value The bytes for configManifest to set.
       * @return This builder for chaining.
       */
      public Builder setConfigManifestBytes(
          org.apache.pekko.protobufv3.internal.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        configManifest_ = value;
        bitField0_ |= 0x00000100;
        onChanged();
        return this;
      }

      private int routerConfigSerializerId_ ;
      /**
       * <code>optional int32 routerConfigSerializerId = 10;</code>
       * @return Whether the routerConfigSerializerId field is set.
       */
      @java.lang.Override
      public boolean hasRouterConfigSerializerId() {
        return ((bitField0_ & 0x00000200) != 0);
      }
      /**
       * <code>optional int32 routerConfigSerializerId = 10;</code>
       * @return The routerConfigSerializerId.
       */
      @java.lang.Override
      public int getRouterConfigSerializerId() {
        return routerConfigSerializerId_;
      }
      /**
       * <code>optional int32 routerConfigSerializerId = 10;</code>
       * @param value The routerConfigSerializerId to set.
       * @return This builder for chaining.
       */
      public Builder setRouterConfigSerializerId(int value) {

        routerConfigSerializerId_ = value;
        bitField0_ |= 0x00000200;
        onChanged();
        return this;
      }
      /**
       * <code>optional int32 routerConfigSerializerId = 10;</code>
       * @return This builder for chaining.
       */
      public Builder clearRouterConfigSerializerId() {
        bitField0_ = (bitField0_ & ~0x00000200);
        routerConfigSerializerId_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object routerConfigManifest_ = "";
      /**
       * <code>optional string routerConfigManifest = 11;</code>
       * @return Whether the routerConfigManifest field is set.
       */
      public boolean hasRouterConfigManifest() {
        return ((bitField0_ & 0x00000400) != 0);
      }
      /**
       * <code>optional string routerConfigManifest = 11;</code>
       * @return The routerConfigManifest.
       */
      public java.lang.String getRouterConfigManifest() {
        java.lang.Object ref = routerConfigManifest_;
        if (!(ref instanceof java.lang.String)) {
          org.apache.pekko.protobufv3.internal.ByteString bs =
              (org.apache.pekko.protobufv3.internal.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            routerConfigManifest_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string routerConfigManifest = 11;</code>
       * @return The bytes for routerConfigManifest.
       */
      public org.apache.pekko.protobufv3.internal.ByteString
          getRouterConfigManifestBytes() {
        java.lang.Object ref = routerConfigManifest_;
        if (ref instanceof String) {
          org.apache.pekko.protobufv3.internal.ByteString b = 
              org.apache.pekko.protobufv3.internal.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          routerConfigManifest_ = b;
          return b;
        } else {
          return (org.apache.pekko.protobufv3.internal.ByteString) ref;
        }
      }
      /**
       * <code>optional string routerConfigManifest = 11;</code>
       * @param value The routerConfigManifest to set.
       * @return This builder for chaining.
       */
      public Builder setRouterConfigManifest(
          java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        routerConfigManifest_ = value;
        bitField0_ |= 0x00000400;
        onChanged();
        return this;
      }
      /**
       * <code>optional string routerConfigManifest = 11;</code>
       * @return This builder for chaining.
       */
      public Builder clearRouterConfigManifest() {
        routerConfigManifest_ = getDefaultInstance().getRouterConfigManifest();
        bitField0_ = (bitField0_ & ~0x00000400);
        onChanged();
        return this;
      }
      /**
       * <code>optional string routerConfigManifest = 11;</code>
       * @param value The bytes for routerConfigManifest to set.
       * @return This builder for chaining.
       */
      public Builder setRouterConfigManifestBytes(
          org.apache.pekko.protobufv3.internal.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        routerConfigManifest_ = value;
        bitField0_ |= 0x00000400;
        onChanged();
        return this;
      }

      private org.apache.pekko.protobufv3.internal.LazyStringArrayList tags_ =
          org.apache.pekko.protobufv3.internal.LazyStringArrayList.emptyList();
      private void ensureTagsIsMutable() {
        if (!tags_.isModifiable()) {
          tags_ = new org.apache.pekko.protobufv3.internal.LazyStringArrayList(tags_);
        }
        bitField0_ |= 0x00000800;
      }
      /**
       * <code>repeated string tags = 12;</code>
       * @return A list containing the tags.
       */
      public org.apache.pekko.protobufv3.internal.ProtocolStringList
          getTagsList() {
        tags_.makeImmutable();
        return tags_;
      }
      /**
       * <code>repeated string tags = 12;</code>
       * @return The count of tags.
       */
      public int getTagsCount() {
        return tags_.size();
      }
      /**
       * <code>repeated string tags = 12;</code>
       * @param index The index of the element to return.
       * @return The tags at the given index.
       */
      public java.lang.String getTags(int index) {
        return tags_.get(index);
      }
      /**
       * <code>repeated string tags = 12;</code>
       * @param index The index of the value to return.
       * @return The bytes of the tags at the given index.
       */
      public org.apache.pekko.protobufv3.internal.ByteString
          getTagsBytes(int index) {
        return tags_.getByteString(index);
      }
      /**
       * <code>repeated string tags = 12;</code>
       * @param index The index to set the value at.
       * @param value The tags to set.
       * @return This builder for chaining.
       */
      public Builder setTags(
          int index, java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        ensureTagsIsMutable();
        tags_.set(index, value);
        bitField0_ |= 0x00000800;
        onChanged();
        return this;
      }
      /**
       * <code>repeated string tags = 12;</code>
       * @param value The tags to add.
       * @return This builder for chaining.
       */
      public Builder addTags(
          java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        ensureTagsIsMutable();
        tags_.add(value);
        bitField0_ |= 0x00000800;
        onChanged();
        return this;
      }
      /**
       * <code>repeated string tags = 12;</code>
       * @param values The tags to add.
       * @return This builder for chaining.
       */
      public Builder addAllTags(
          java.lang.Iterable<java.lang.String> values) {
        ensureTagsIsMutable();
        org.apache.pekko.protobufv3.internal.AbstractMessageLite.Builder.addAll(
            values, tags_);
        bitField0_ |= 0x00000800;
        onChanged();
        return this;
      }
      /**
       * <code>repeated string tags = 12;</code>
       * @return This builder for chaining.
       */
      public Builder clearTags() {
        tags_ =
          org.apache.pekko.protobufv3.internal.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000800);;
        onChanged();
        return this;
      }
      /**
       * <code>repeated string tags = 12;</code>
       * @param value The bytes of the tags to add.
       * @return This builder for chaining.
       */
      public Builder addTagsBytes(
          org.apache.pekko.protobufv3.internal.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        ensureTagsIsMutable();
        tags_.add(value);
        bitField0_ |= 0x00000800;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:DeployData)
    }

    // @@protoc_insertion_point(class_scope:DeployData)
    private static final org.apache.pekko.remote.WireFormats.DeployData DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.pekko.remote.WireFormats.DeployData();
    }

    public static org.apache.pekko.remote.WireFormats.DeployData getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final org.apache.pekko.protobufv3.internal.Parser<DeployData>
        PARSER = new org.apache.pekko.protobufv3.internal.AbstractParser<DeployData>() {
      @java.lang.Override
      public DeployData parsePartialFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (org.apache.pekko.protobufv3.internal.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static org.apache.pekko.protobufv3.internal.Parser<DeployData> parser() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.pekko.protobufv3.internal.Parser<DeployData> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.pekko.remote.WireFormats.DeployData getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface PekkoProtocolMessageOrBuilder extends
      // @@protoc_insertion_point(interface_extends:PekkoProtocolMessage)
      org.apache.pekko.protobufv3.internal.MessageOrBuilder {

    /**
     * <code>optional bytes payload = 1;</code>
     * @return Whether the payload field is set.
     */
    boolean hasPayload();
    /**
     * <code>optional bytes payload = 1;</code>
     * @return The payload.
     */
    org.apache.pekko.protobufv3.internal.ByteString getPayload();

    /**
     * <code>optional .PekkoControlMessage instruction = 2;</code>
     * @return Whether the instruction field is set.
     */
    boolean hasInstruction();
    /**
     * <code>optional .PekkoControlMessage instruction = 2;</code>
     * @return The instruction.
     */
    org.apache.pekko.remote.WireFormats.PekkoControlMessage getInstruction();
    /**
     * <code>optional .PekkoControlMessage instruction = 2;</code>
     */
    org.apache.pekko.remote.WireFormats.PekkoControlMessageOrBuilder getInstructionOrBuilder();
  }
  /**
   * <pre>
   * *
   * Message format of Pekko Protocol.
   * Message contains either a payload or an instruction.
   * </pre>
   *
   * Protobuf type {@code PekkoProtocolMessage}
   */
  public static final class PekkoProtocolMessage extends
      org.apache.pekko.protobufv3.internal.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:PekkoProtocolMessage)
      PekkoProtocolMessageOrBuilder {
  private static final long serialVersionUID = 0L;
    static {
      org.apache.pekko.protobufv3.internal.RuntimeVersion.validateProtobufGencodeVersion(
        org.apache.pekko.protobufv3.internal.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 32,
        /* patch= */ 0,
        /* suffix= */ "",
        PekkoProtocolMessage.class.getName());
    }
    // Use PekkoProtocolMessage.newBuilder() to construct.
    private PekkoProtocolMessage(org.apache.pekko.protobufv3.internal.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }
    private PekkoProtocolMessage() {
      payload_ = org.apache.pekko.protobufv3.internal.ByteString.EMPTY;
    }

    public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.pekko.remote.WireFormats.internal_static_PekkoProtocolMessage_descriptor;
    }

    @java.lang.Override
    protected org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.pekko.remote.WireFormats.internal_static_PekkoProtocolMessage_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.pekko.remote.WireFormats.PekkoProtocolMessage.class, org.apache.pekko.remote.WireFormats.PekkoProtocolMessage.Builder.class);
    }

    private int bitField0_;
    public static final int PAYLOAD_FIELD_NUMBER = 1;
    private org.apache.pekko.protobufv3.internal.ByteString payload_ = org.apache.pekko.protobufv3.internal.ByteString.EMPTY;
    /**
     * <code>optional bytes payload = 1;</code>
     * @return Whether the payload field is set.
     */
    @java.lang.Override
    public boolean hasPayload() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <code>optional bytes payload = 1;</code>
     * @return The payload.
     */
    @java.lang.Override
    public org.apache.pekko.protobufv3.internal.ByteString getPayload() {
      return payload_;
    }

    public static final int INSTRUCTION_FIELD_NUMBER = 2;
    private org.apache.pekko.remote.WireFormats.PekkoControlMessage instruction_;
    /**
     * <code>optional .PekkoControlMessage instruction = 2;</code>
     * @return Whether the instruction field is set.
     */
    @java.lang.Override
    public boolean hasInstruction() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <code>optional .PekkoControlMessage instruction = 2;</code>
     * @return The instruction.
     */
    @java.lang.Override
    public org.apache.pekko.remote.WireFormats.PekkoControlMessage getInstruction() {
      return instruction_ == null ? org.apache.pekko.remote.WireFormats.PekkoControlMessage.getDefaultInstance() : instruction_;
    }
    /**
     * <code>optional .PekkoControlMessage instruction = 2;</code>
     */
    @java.lang.Override
    public org.apache.pekko.remote.WireFormats.PekkoControlMessageOrBuilder getInstructionOrBuilder() {
      return instruction_ == null ? org.apache.pekko.remote.WireFormats.PekkoControlMessage.getDefaultInstance() : instruction_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (hasInstruction()) {
        if (!getInstruction().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(org.apache.pekko.protobufv3.internal.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeBytes(1, payload_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(2, getInstruction());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeBytesSize(1, payload_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeMessageSize(2, getInstruction());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.pekko.remote.WireFormats.PekkoProtocolMessage)) {
        return super.equals(obj);
      }
      org.apache.pekko.remote.WireFormats.PekkoProtocolMessage other = (org.apache.pekko.remote.WireFormats.PekkoProtocolMessage) obj;

      if (hasPayload() != other.hasPayload()) return false;
      if (hasPayload()) {
        if (!getPayload()
            .equals(other.getPayload())) return false;
      }
      if (hasInstruction() != other.hasInstruction()) return false;
      if (hasInstruction()) {
        if (!getInstruction()
            .equals(other.getInstruction())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasPayload()) {
        hash = (37 * hash) + PAYLOAD_FIELD_NUMBER;
        hash = (53 * hash) + getPayload().hashCode();
      }
      if (hasInstruction()) {
        hash = (37 * hash) + INSTRUCTION_FIELD_NUMBER;
        hash = (53 * hash) + getInstruction().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.pekko.remote.WireFormats.PekkoProtocolMessage parseFrom(
        java.nio.ByteBuffer data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.remote.WireFormats.PekkoProtocolMessage parseFrom(
        java.nio.ByteBuffer data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.PekkoProtocolMessage parseFrom(
        org.apache.pekko.protobufv3.internal.ByteString data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.remote.WireFormats.PekkoProtocolMessage parseFrom(
        org.apache.pekko.protobufv3.internal.ByteString data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.PekkoProtocolMessage parseFrom(byte[] data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.remote.WireFormats.PekkoProtocolMessage parseFrom(
        byte[] data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.PekkoProtocolMessage parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.pekko.remote.WireFormats.PekkoProtocolMessage parseFrom(
        java.io.InputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static org.apache.pekko.remote.WireFormats.PekkoProtocolMessage parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static org.apache.pekko.remote.WireFormats.PekkoProtocolMessage parseDelimitedFrom(
        java.io.InputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.PekkoProtocolMessage parseFrom(
        org.apache.pekko.protobufv3.internal.CodedInputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.pekko.remote.WireFormats.PekkoProtocolMessage parseFrom(
        org.apache.pekko.protobufv3.internal.CodedInputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.pekko.remote.WireFormats.PekkoProtocolMessage prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        org.apache.pekko.protobufv3.internal.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * *
     * Message format of Pekko Protocol.
     * Message contains either a payload or an instruction.
     * </pre>
     *
     * Protobuf type {@code PekkoProtocolMessage}
     */
    public static final class Builder extends
        org.apache.pekko.protobufv3.internal.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:PekkoProtocolMessage)
        org.apache.pekko.remote.WireFormats.PekkoProtocolMessageOrBuilder {
      public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.pekko.remote.WireFormats.internal_static_PekkoProtocolMessage_descriptor;
      }

      @java.lang.Override
      protected org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.pekko.remote.WireFormats.internal_static_PekkoProtocolMessage_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.pekko.remote.WireFormats.PekkoProtocolMessage.class, org.apache.pekko.remote.WireFormats.PekkoProtocolMessage.Builder.class);
      }

      // Construct using org.apache.pekko.remote.WireFormats.PekkoProtocolMessage.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          org.apache.pekko.protobufv3.internal.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (org.apache.pekko.protobufv3.internal.GeneratedMessage
                .alwaysUseFieldBuilders) {
          internalGetInstructionFieldBuilder();
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        payload_ = org.apache.pekko.protobufv3.internal.ByteString.EMPTY;
        instruction_ = null;
        if (instructionBuilder_ != null) {
          instructionBuilder_.dispose();
          instructionBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.pekko.remote.WireFormats.internal_static_PekkoProtocolMessage_descriptor;
      }

      @java.lang.Override
      public org.apache.pekko.remote.WireFormats.PekkoProtocolMessage getDefaultInstanceForType() {
        return org.apache.pekko.remote.WireFormats.PekkoProtocolMessage.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.pekko.remote.WireFormats.PekkoProtocolMessage build() {
        org.apache.pekko.remote.WireFormats.PekkoProtocolMessage result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.pekko.remote.WireFormats.PekkoProtocolMessage buildPartial() {
        org.apache.pekko.remote.WireFormats.PekkoProtocolMessage result = new org.apache.pekko.remote.WireFormats.PekkoProtocolMessage(this);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartial0(org.apache.pekko.remote.WireFormats.PekkoProtocolMessage result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.payload_ = payload_;
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.instruction_ = instructionBuilder_ == null
              ? instruction_
              : instructionBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder mergeFrom(org.apache.pekko.protobufv3.internal.Message other) {
        if (other instanceof org.apache.pekko.remote.WireFormats.PekkoProtocolMessage) {
          return mergeFrom((org.apache.pekko.remote.WireFormats.PekkoProtocolMessage)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.pekko.remote.WireFormats.PekkoProtocolMessage other) {
        if (other == org.apache.pekko.remote.WireFormats.PekkoProtocolMessage.getDefaultInstance()) return this;
        if (other.hasPayload()) {
          setPayload(other.getPayload());
        }
        if (other.hasInstruction()) {
          mergeInstruction(other.getInstruction());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        if (hasInstruction()) {
          if (!getInstruction().isInitialized()) {
            return false;
          }
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                payload_ = input.readBytes();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
              case 18: {
                input.readMessage(
                    internalGetInstructionFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private org.apache.pekko.protobufv3.internal.ByteString payload_ = org.apache.pekko.protobufv3.internal.ByteString.EMPTY;
      /**
       * <code>optional bytes payload = 1;</code>
       * @return Whether the payload field is set.
       */
      @java.lang.Override
      public boolean hasPayload() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <code>optional bytes payload = 1;</code>
       * @return The payload.
       */
      @java.lang.Override
      public org.apache.pekko.protobufv3.internal.ByteString getPayload() {
        return payload_;
      }
      /**
       * <code>optional bytes payload = 1;</code>
       * @param value The payload to set.
       * @return This builder for chaining.
       */
      public Builder setPayload(org.apache.pekko.protobufv3.internal.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        payload_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <code>optional bytes payload = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearPayload() {
        bitField0_ = (bitField0_ & ~0x00000001);
        payload_ = getDefaultInstance().getPayload();
        onChanged();
        return this;
      }

      private org.apache.pekko.remote.WireFormats.PekkoControlMessage instruction_;
      private org.apache.pekko.protobufv3.internal.SingleFieldBuilder<
          org.apache.pekko.remote.WireFormats.PekkoControlMessage, org.apache.pekko.remote.WireFormats.PekkoControlMessage.Builder, org.apache.pekko.remote.WireFormats.PekkoControlMessageOrBuilder> instructionBuilder_;
      /**
       * <code>optional .PekkoControlMessage instruction = 2;</code>
       * @return Whether the instruction field is set.
       */
      public boolean hasInstruction() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <code>optional .PekkoControlMessage instruction = 2;</code>
       * @return The instruction.
       */
      public org.apache.pekko.remote.WireFormats.PekkoControlMessage getInstruction() {
        if (instructionBuilder_ == null) {
          return instruction_ == null ? org.apache.pekko.remote.WireFormats.PekkoControlMessage.getDefaultInstance() : instruction_;
        } else {
          return instructionBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .PekkoControlMessage instruction = 2;</code>
       */
      public Builder setInstruction(org.apache.pekko.remote.WireFormats.PekkoControlMessage value) {
        if (instructionBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          instruction_ = value;
        } else {
          instructionBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <code>optional .PekkoControlMessage instruction = 2;</code>
       */
      public Builder setInstruction(
          org.apache.pekko.remote.WireFormats.PekkoControlMessage.Builder builderForValue) {
        if (instructionBuilder_ == null) {
          instruction_ = builderForValue.build();
        } else {
          instructionBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <code>optional .PekkoControlMessage instruction = 2;</code>
       */
      public Builder mergeInstruction(org.apache.pekko.remote.WireFormats.PekkoControlMessage value) {
        if (instructionBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0) &&
            instruction_ != null &&
            instruction_ != org.apache.pekko.remote.WireFormats.PekkoControlMessage.getDefaultInstance()) {
            getInstructionBuilder().mergeFrom(value);
          } else {
            instruction_ = value;
          }
        } else {
          instructionBuilder_.mergeFrom(value);
        }
        if (instruction_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       * <code>optional .PekkoControlMessage instruction = 2;</code>
       */
      public Builder clearInstruction() {
        bitField0_ = (bitField0_ & ~0x00000002);
        instruction_ = null;
        if (instructionBuilder_ != null) {
          instructionBuilder_.dispose();
          instructionBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <code>optional .PekkoControlMessage instruction = 2;</code>
       */
      public org.apache.pekko.remote.WireFormats.PekkoControlMessage.Builder getInstructionBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return internalGetInstructionFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .PekkoControlMessage instruction = 2;</code>
       */
      public org.apache.pekko.remote.WireFormats.PekkoControlMessageOrBuilder getInstructionOrBuilder() {
        if (instructionBuilder_ != null) {
          return instructionBuilder_.getMessageOrBuilder();
        } else {
          return instruction_ == null ?
              org.apache.pekko.remote.WireFormats.PekkoControlMessage.getDefaultInstance() : instruction_;
        }
      }
      /**
       * <code>optional .PekkoControlMessage instruction = 2;</code>
       */
      private org.apache.pekko.protobufv3.internal.SingleFieldBuilder<
          org.apache.pekko.remote.WireFormats.PekkoControlMessage, org.apache.pekko.remote.WireFormats.PekkoControlMessage.Builder, org.apache.pekko.remote.WireFormats.PekkoControlMessageOrBuilder> 
          internalGetInstructionFieldBuilder() {
        if (instructionBuilder_ == null) {
          instructionBuilder_ = new org.apache.pekko.protobufv3.internal.SingleFieldBuilder<
              org.apache.pekko.remote.WireFormats.PekkoControlMessage, org.apache.pekko.remote.WireFormats.PekkoControlMessage.Builder, org.apache.pekko.remote.WireFormats.PekkoControlMessageOrBuilder>(
                  getInstruction(),
                  getParentForChildren(),
                  isClean());
          instruction_ = null;
        }
        return instructionBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:PekkoProtocolMessage)
    }

    // @@protoc_insertion_point(class_scope:PekkoProtocolMessage)
    private static final org.apache.pekko.remote.WireFormats.PekkoProtocolMessage DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.pekko.remote.WireFormats.PekkoProtocolMessage();
    }

    public static org.apache.pekko.remote.WireFormats.PekkoProtocolMessage getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final org.apache.pekko.protobufv3.internal.Parser<PekkoProtocolMessage>
        PARSER = new org.apache.pekko.protobufv3.internal.AbstractParser<PekkoProtocolMessage>() {
      @java.lang.Override
      public PekkoProtocolMessage parsePartialFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (org.apache.pekko.protobufv3.internal.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static org.apache.pekko.protobufv3.internal.Parser<PekkoProtocolMessage> parser() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.pekko.protobufv3.internal.Parser<PekkoProtocolMessage> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.pekko.remote.WireFormats.PekkoProtocolMessage getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface PekkoControlMessageOrBuilder extends
      // @@protoc_insertion_point(interface_extends:PekkoControlMessage)
      org.apache.pekko.protobufv3.internal.MessageOrBuilder {

    /**
     * <code>required .CommandType commandType = 1;</code>
     * @return Whether the commandType field is set.
     */
    boolean hasCommandType();
    /**
     * <code>required .CommandType commandType = 1;</code>
     * @return The commandType.
     */
    org.apache.pekko.remote.WireFormats.CommandType getCommandType();

    /**
     * <code>optional .PekkoHandshakeInfo handshakeInfo = 2;</code>
     * @return Whether the handshakeInfo field is set.
     */
    boolean hasHandshakeInfo();
    /**
     * <code>optional .PekkoHandshakeInfo handshakeInfo = 2;</code>
     * @return The handshakeInfo.
     */
    org.apache.pekko.remote.WireFormats.PekkoHandshakeInfo getHandshakeInfo();
    /**
     * <code>optional .PekkoHandshakeInfo handshakeInfo = 2;</code>
     */
    org.apache.pekko.remote.WireFormats.PekkoHandshakeInfoOrBuilder getHandshakeInfoOrBuilder();
  }
  /**
   * <pre>
   * *
   * Defines some control messages for the remoting
   * </pre>
   *
   * Protobuf type {@code PekkoControlMessage}
   */
  public static final class PekkoControlMessage extends
      org.apache.pekko.protobufv3.internal.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:PekkoControlMessage)
      PekkoControlMessageOrBuilder {
  private static final long serialVersionUID = 0L;
    static {
      org.apache.pekko.protobufv3.internal.RuntimeVersion.validateProtobufGencodeVersion(
        org.apache.pekko.protobufv3.internal.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 32,
        /* patch= */ 0,
        /* suffix= */ "",
        PekkoControlMessage.class.getName());
    }
    // Use PekkoControlMessage.newBuilder() to construct.
    private PekkoControlMessage(org.apache.pekko.protobufv3.internal.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }
    private PekkoControlMessage() {
      commandType_ = 1;
    }

    public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.pekko.remote.WireFormats.internal_static_PekkoControlMessage_descriptor;
    }

    @java.lang.Override
    protected org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.pekko.remote.WireFormats.internal_static_PekkoControlMessage_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.pekko.remote.WireFormats.PekkoControlMessage.class, org.apache.pekko.remote.WireFormats.PekkoControlMessage.Builder.class);
    }

    private int bitField0_;
    public static final int COMMANDTYPE_FIELD_NUMBER = 1;
    private int commandType_ = 1;
    /**
     * <code>required .CommandType commandType = 1;</code>
     * @return Whether the commandType field is set.
     */
    @java.lang.Override public boolean hasCommandType() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <code>required .CommandType commandType = 1;</code>
     * @return The commandType.
     */
    @java.lang.Override public org.apache.pekko.remote.WireFormats.CommandType getCommandType() {
      org.apache.pekko.remote.WireFormats.CommandType result = org.apache.pekko.remote.WireFormats.CommandType.forNumber(commandType_);
      return result == null ? org.apache.pekko.remote.WireFormats.CommandType.ASSOCIATE : result;
    }

    public static final int HANDSHAKEINFO_FIELD_NUMBER = 2;
    private org.apache.pekko.remote.WireFormats.PekkoHandshakeInfo handshakeInfo_;
    /**
     * <code>optional .PekkoHandshakeInfo handshakeInfo = 2;</code>
     * @return Whether the handshakeInfo field is set.
     */
    @java.lang.Override
    public boolean hasHandshakeInfo() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <code>optional .PekkoHandshakeInfo handshakeInfo = 2;</code>
     * @return The handshakeInfo.
     */
    @java.lang.Override
    public org.apache.pekko.remote.WireFormats.PekkoHandshakeInfo getHandshakeInfo() {
      return handshakeInfo_ == null ? org.apache.pekko.remote.WireFormats.PekkoHandshakeInfo.getDefaultInstance() : handshakeInfo_;
    }
    /**
     * <code>optional .PekkoHandshakeInfo handshakeInfo = 2;</code>
     */
    @java.lang.Override
    public org.apache.pekko.remote.WireFormats.PekkoHandshakeInfoOrBuilder getHandshakeInfoOrBuilder() {
      return handshakeInfo_ == null ? org.apache.pekko.remote.WireFormats.PekkoHandshakeInfo.getDefaultInstance() : handshakeInfo_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasCommandType()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (hasHandshakeInfo()) {
        if (!getHandshakeInfo().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(org.apache.pekko.protobufv3.internal.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeEnum(1, commandType_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(2, getHandshakeInfo());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeEnumSize(1, commandType_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeMessageSize(2, getHandshakeInfo());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.pekko.remote.WireFormats.PekkoControlMessage)) {
        return super.equals(obj);
      }
      org.apache.pekko.remote.WireFormats.PekkoControlMessage other = (org.apache.pekko.remote.WireFormats.PekkoControlMessage) obj;

      if (hasCommandType() != other.hasCommandType()) return false;
      if (hasCommandType()) {
        if (commandType_ != other.commandType_) return false;
      }
      if (hasHandshakeInfo() != other.hasHandshakeInfo()) return false;
      if (hasHandshakeInfo()) {
        if (!getHandshakeInfo()
            .equals(other.getHandshakeInfo())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasCommandType()) {
        hash = (37 * hash) + COMMANDTYPE_FIELD_NUMBER;
        hash = (53 * hash) + commandType_;
      }
      if (hasHandshakeInfo()) {
        hash = (37 * hash) + HANDSHAKEINFO_FIELD_NUMBER;
        hash = (53 * hash) + getHandshakeInfo().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.pekko.remote.WireFormats.PekkoControlMessage parseFrom(
        java.nio.ByteBuffer data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.remote.WireFormats.PekkoControlMessage parseFrom(
        java.nio.ByteBuffer data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.PekkoControlMessage parseFrom(
        org.apache.pekko.protobufv3.internal.ByteString data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.remote.WireFormats.PekkoControlMessage parseFrom(
        org.apache.pekko.protobufv3.internal.ByteString data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.PekkoControlMessage parseFrom(byte[] data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.remote.WireFormats.PekkoControlMessage parseFrom(
        byte[] data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.PekkoControlMessage parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.pekko.remote.WireFormats.PekkoControlMessage parseFrom(
        java.io.InputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static org.apache.pekko.remote.WireFormats.PekkoControlMessage parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static org.apache.pekko.remote.WireFormats.PekkoControlMessage parseDelimitedFrom(
        java.io.InputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.PekkoControlMessage parseFrom(
        org.apache.pekko.protobufv3.internal.CodedInputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.pekko.remote.WireFormats.PekkoControlMessage parseFrom(
        org.apache.pekko.protobufv3.internal.CodedInputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.pekko.remote.WireFormats.PekkoControlMessage prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        org.apache.pekko.protobufv3.internal.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * *
     * Defines some control messages for the remoting
     * </pre>
     *
     * Protobuf type {@code PekkoControlMessage}
     */
    public static final class Builder extends
        org.apache.pekko.protobufv3.internal.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:PekkoControlMessage)
        org.apache.pekko.remote.WireFormats.PekkoControlMessageOrBuilder {
      public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.pekko.remote.WireFormats.internal_static_PekkoControlMessage_descriptor;
      }

      @java.lang.Override
      protected org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.pekko.remote.WireFormats.internal_static_PekkoControlMessage_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.pekko.remote.WireFormats.PekkoControlMessage.class, org.apache.pekko.remote.WireFormats.PekkoControlMessage.Builder.class);
      }

      // Construct using org.apache.pekko.remote.WireFormats.PekkoControlMessage.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          org.apache.pekko.protobufv3.internal.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (org.apache.pekko.protobufv3.internal.GeneratedMessage
                .alwaysUseFieldBuilders) {
          internalGetHandshakeInfoFieldBuilder();
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        commandType_ = 1;
        handshakeInfo_ = null;
        if (handshakeInfoBuilder_ != null) {
          handshakeInfoBuilder_.dispose();
          handshakeInfoBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.pekko.remote.WireFormats.internal_static_PekkoControlMessage_descriptor;
      }

      @java.lang.Override
      public org.apache.pekko.remote.WireFormats.PekkoControlMessage getDefaultInstanceForType() {
        return org.apache.pekko.remote.WireFormats.PekkoControlMessage.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.pekko.remote.WireFormats.PekkoControlMessage build() {
        org.apache.pekko.remote.WireFormats.PekkoControlMessage result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.pekko.remote.WireFormats.PekkoControlMessage buildPartial() {
        org.apache.pekko.remote.WireFormats.PekkoControlMessage result = new org.apache.pekko.remote.WireFormats.PekkoControlMessage(this);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartial0(org.apache.pekko.remote.WireFormats.PekkoControlMessage result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.commandType_ = commandType_;
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.handshakeInfo_ = handshakeInfoBuilder_ == null
              ? handshakeInfo_
              : handshakeInfoBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder mergeFrom(org.apache.pekko.protobufv3.internal.Message other) {
        if (other instanceof org.apache.pekko.remote.WireFormats.PekkoControlMessage) {
          return mergeFrom((org.apache.pekko.remote.WireFormats.PekkoControlMessage)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.pekko.remote.WireFormats.PekkoControlMessage other) {
        if (other == org.apache.pekko.remote.WireFormats.PekkoControlMessage.getDefaultInstance()) return this;
        if (other.hasCommandType()) {
          setCommandType(other.getCommandType());
        }
        if (other.hasHandshakeInfo()) {
          mergeHandshakeInfo(other.getHandshakeInfo());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        if (!hasCommandType()) {
          return false;
        }
        if (hasHandshakeInfo()) {
          if (!getHandshakeInfo().isInitialized()) {
            return false;
          }
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8: {
                int tmpRaw = input.readEnum();
                org.apache.pekko.remote.WireFormats.CommandType tmpValue =
                    org.apache.pekko.remote.WireFormats.CommandType.forNumber(tmpRaw);
                if (tmpValue == null) {
                  mergeUnknownVarintField(1, tmpRaw);
                } else {
                  commandType_ = tmpRaw;
                  bitField0_ |= 0x00000001;
                }
                break;
              } // case 8
              case 18: {
                input.readMessage(
                    internalGetHandshakeInfoFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private int commandType_ = 1;
      /**
       * <code>required .CommandType commandType = 1;</code>
       * @return Whether the commandType field is set.
       */
      @java.lang.Override public boolean hasCommandType() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <code>required .CommandType commandType = 1;</code>
       * @return The commandType.
       */
      @java.lang.Override
      public org.apache.pekko.remote.WireFormats.CommandType getCommandType() {
        org.apache.pekko.remote.WireFormats.CommandType result = org.apache.pekko.remote.WireFormats.CommandType.forNumber(commandType_);
        return result == null ? org.apache.pekko.remote.WireFormats.CommandType.ASSOCIATE : result;
      }
      /**
       * <code>required .CommandType commandType = 1;</code>
       * @param value The commandType to set.
       * @return This builder for chaining.
       */
      public Builder setCommandType(org.apache.pekko.remote.WireFormats.CommandType value) {
        if (value == null) { throw new NullPointerException(); }
        bitField0_ |= 0x00000001;
        commandType_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <code>required .CommandType commandType = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearCommandType() {
        bitField0_ = (bitField0_ & ~0x00000001);
        commandType_ = 1;
        onChanged();
        return this;
      }

      private org.apache.pekko.remote.WireFormats.PekkoHandshakeInfo handshakeInfo_;
      private org.apache.pekko.protobufv3.internal.SingleFieldBuilder<
          org.apache.pekko.remote.WireFormats.PekkoHandshakeInfo, org.apache.pekko.remote.WireFormats.PekkoHandshakeInfo.Builder, org.apache.pekko.remote.WireFormats.PekkoHandshakeInfoOrBuilder> handshakeInfoBuilder_;
      /**
       * <code>optional .PekkoHandshakeInfo handshakeInfo = 2;</code>
       * @return Whether the handshakeInfo field is set.
       */
      public boolean hasHandshakeInfo() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <code>optional .PekkoHandshakeInfo handshakeInfo = 2;</code>
       * @return The handshakeInfo.
       */
      public org.apache.pekko.remote.WireFormats.PekkoHandshakeInfo getHandshakeInfo() {
        if (handshakeInfoBuilder_ == null) {
          return handshakeInfo_ == null ? org.apache.pekko.remote.WireFormats.PekkoHandshakeInfo.getDefaultInstance() : handshakeInfo_;
        } else {
          return handshakeInfoBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .PekkoHandshakeInfo handshakeInfo = 2;</code>
       */
      public Builder setHandshakeInfo(org.apache.pekko.remote.WireFormats.PekkoHandshakeInfo value) {
        if (handshakeInfoBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          handshakeInfo_ = value;
        } else {
          handshakeInfoBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <code>optional .PekkoHandshakeInfo handshakeInfo = 2;</code>
       */
      public Builder setHandshakeInfo(
          org.apache.pekko.remote.WireFormats.PekkoHandshakeInfo.Builder builderForValue) {
        if (handshakeInfoBuilder_ == null) {
          handshakeInfo_ = builderForValue.build();
        } else {
          handshakeInfoBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <code>optional .PekkoHandshakeInfo handshakeInfo = 2;</code>
       */
      public Builder mergeHandshakeInfo(org.apache.pekko.remote.WireFormats.PekkoHandshakeInfo value) {
        if (handshakeInfoBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0) &&
            handshakeInfo_ != null &&
            handshakeInfo_ != org.apache.pekko.remote.WireFormats.PekkoHandshakeInfo.getDefaultInstance()) {
            getHandshakeInfoBuilder().mergeFrom(value);
          } else {
            handshakeInfo_ = value;
          }
        } else {
          handshakeInfoBuilder_.mergeFrom(value);
        }
        if (handshakeInfo_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       * <code>optional .PekkoHandshakeInfo handshakeInfo = 2;</code>
       */
      public Builder clearHandshakeInfo() {
        bitField0_ = (bitField0_ & ~0x00000002);
        handshakeInfo_ = null;
        if (handshakeInfoBuilder_ != null) {
          handshakeInfoBuilder_.dispose();
          handshakeInfoBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <code>optional .PekkoHandshakeInfo handshakeInfo = 2;</code>
       */
      public org.apache.pekko.remote.WireFormats.PekkoHandshakeInfo.Builder getHandshakeInfoBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return internalGetHandshakeInfoFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .PekkoHandshakeInfo handshakeInfo = 2;</code>
       */
      public org.apache.pekko.remote.WireFormats.PekkoHandshakeInfoOrBuilder getHandshakeInfoOrBuilder() {
        if (handshakeInfoBuilder_ != null) {
          return handshakeInfoBuilder_.getMessageOrBuilder();
        } else {
          return handshakeInfo_ == null ?
              org.apache.pekko.remote.WireFormats.PekkoHandshakeInfo.getDefaultInstance() : handshakeInfo_;
        }
      }
      /**
       * <code>optional .PekkoHandshakeInfo handshakeInfo = 2;</code>
       */
      private org.apache.pekko.protobufv3.internal.SingleFieldBuilder<
          org.apache.pekko.remote.WireFormats.PekkoHandshakeInfo, org.apache.pekko.remote.WireFormats.PekkoHandshakeInfo.Builder, org.apache.pekko.remote.WireFormats.PekkoHandshakeInfoOrBuilder> 
          internalGetHandshakeInfoFieldBuilder() {
        if (handshakeInfoBuilder_ == null) {
          handshakeInfoBuilder_ = new org.apache.pekko.protobufv3.internal.SingleFieldBuilder<
              org.apache.pekko.remote.WireFormats.PekkoHandshakeInfo, org.apache.pekko.remote.WireFormats.PekkoHandshakeInfo.Builder, org.apache.pekko.remote.WireFormats.PekkoHandshakeInfoOrBuilder>(
                  getHandshakeInfo(),
                  getParentForChildren(),
                  isClean());
          handshakeInfo_ = null;
        }
        return handshakeInfoBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:PekkoControlMessage)
    }

    // @@protoc_insertion_point(class_scope:PekkoControlMessage)
    private static final org.apache.pekko.remote.WireFormats.PekkoControlMessage DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.pekko.remote.WireFormats.PekkoControlMessage();
    }

    public static org.apache.pekko.remote.WireFormats.PekkoControlMessage getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final org.apache.pekko.protobufv3.internal.Parser<PekkoControlMessage>
        PARSER = new org.apache.pekko.protobufv3.internal.AbstractParser<PekkoControlMessage>() {
      @java.lang.Override
      public PekkoControlMessage parsePartialFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (org.apache.pekko.protobufv3.internal.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static org.apache.pekko.protobufv3.internal.Parser<PekkoControlMessage> parser() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.pekko.protobufv3.internal.Parser<PekkoControlMessage> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.pekko.remote.WireFormats.PekkoControlMessage getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface PekkoHandshakeInfoOrBuilder extends
      // @@protoc_insertion_point(interface_extends:PekkoHandshakeInfo)
      org.apache.pekko.protobufv3.internal.MessageOrBuilder {

    /**
     * <code>required .AddressData origin = 1;</code>
     * @return Whether the origin field is set.
     */
    boolean hasOrigin();
    /**
     * <code>required .AddressData origin = 1;</code>
     * @return The origin.
     */
    org.apache.pekko.remote.WireFormats.AddressData getOrigin();
    /**
     * <code>required .AddressData origin = 1;</code>
     */
    org.apache.pekko.remote.WireFormats.AddressDataOrBuilder getOriginOrBuilder();

    /**
     * <code>required fixed64 uid = 2;</code>
     * @return Whether the uid field is set.
     */
    boolean hasUid();
    /**
     * <code>required fixed64 uid = 2;</code>
     * @return The uid.
     */
    long getUid();

    /**
     * <code>optional string cookie = 3;</code>
     * @return Whether the cookie field is set.
     */
    boolean hasCookie();
    /**
     * <code>optional string cookie = 3;</code>
     * @return The cookie.
     */
    java.lang.String getCookie();
    /**
     * <code>optional string cookie = 3;</code>
     * @return The bytes for cookie.
     */
    org.apache.pekko.protobufv3.internal.ByteString
        getCookieBytes();
  }
  /**
   * Protobuf type {@code PekkoHandshakeInfo}
   */
  public static final class PekkoHandshakeInfo extends
      org.apache.pekko.protobufv3.internal.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:PekkoHandshakeInfo)
      PekkoHandshakeInfoOrBuilder {
  private static final long serialVersionUID = 0L;
    static {
      org.apache.pekko.protobufv3.internal.RuntimeVersion.validateProtobufGencodeVersion(
        org.apache.pekko.protobufv3.internal.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 32,
        /* patch= */ 0,
        /* suffix= */ "",
        PekkoHandshakeInfo.class.getName());
    }
    // Use PekkoHandshakeInfo.newBuilder() to construct.
    private PekkoHandshakeInfo(org.apache.pekko.protobufv3.internal.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }
    private PekkoHandshakeInfo() {
      cookie_ = "";
    }

    public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.pekko.remote.WireFormats.internal_static_PekkoHandshakeInfo_descriptor;
    }

    @java.lang.Override
    protected org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.pekko.remote.WireFormats.internal_static_PekkoHandshakeInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.pekko.remote.WireFormats.PekkoHandshakeInfo.class, org.apache.pekko.remote.WireFormats.PekkoHandshakeInfo.Builder.class);
    }

    private int bitField0_;
    public static final int ORIGIN_FIELD_NUMBER = 1;
    private org.apache.pekko.remote.WireFormats.AddressData origin_;
    /**
     * <code>required .AddressData origin = 1;</code>
     * @return Whether the origin field is set.
     */
    @java.lang.Override
    public boolean hasOrigin() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <code>required .AddressData origin = 1;</code>
     * @return The origin.
     */
    @java.lang.Override
    public org.apache.pekko.remote.WireFormats.AddressData getOrigin() {
      return origin_ == null ? org.apache.pekko.remote.WireFormats.AddressData.getDefaultInstance() : origin_;
    }
    /**
     * <code>required .AddressData origin = 1;</code>
     */
    @java.lang.Override
    public org.apache.pekko.remote.WireFormats.AddressDataOrBuilder getOriginOrBuilder() {
      return origin_ == null ? org.apache.pekko.remote.WireFormats.AddressData.getDefaultInstance() : origin_;
    }

    public static final int UID_FIELD_NUMBER = 2;
    private long uid_ = 0L;
    /**
     * <code>required fixed64 uid = 2;</code>
     * @return Whether the uid field is set.
     */
    @java.lang.Override
    public boolean hasUid() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <code>required fixed64 uid = 2;</code>
     * @return The uid.
     */
    @java.lang.Override
    public long getUid() {
      return uid_;
    }

    public static final int COOKIE_FIELD_NUMBER = 3;
    @SuppressWarnings("serial")
    private volatile java.lang.Object cookie_ = "";
    /**
     * <code>optional string cookie = 3;</code>
     * @return Whether the cookie field is set.
     */
    @java.lang.Override
    public boolean hasCookie() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     * <code>optional string cookie = 3;</code>
     * @return The cookie.
     */
    @java.lang.Override
    public java.lang.String getCookie() {
      java.lang.Object ref = cookie_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        org.apache.pekko.protobufv3.internal.ByteString bs = 
            (org.apache.pekko.protobufv3.internal.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          cookie_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string cookie = 3;</code>
     * @return The bytes for cookie.
     */
    @java.lang.Override
    public org.apache.pekko.protobufv3.internal.ByteString
        getCookieBytes() {
      java.lang.Object ref = cookie_;
      if (ref instanceof java.lang.String) {
        org.apache.pekko.protobufv3.internal.ByteString b = 
            org.apache.pekko.protobufv3.internal.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        cookie_ = b;
        return b;
      } else {
        return (org.apache.pekko.protobufv3.internal.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasOrigin()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!hasUid()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!getOrigin().isInitialized()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(org.apache.pekko.protobufv3.internal.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getOrigin());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeFixed64(2, uid_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        org.apache.pekko.protobufv3.internal.GeneratedMessage.writeString(output, 3, cookie_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeMessageSize(1, getOrigin());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeFixed64Size(2, uid_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size += org.apache.pekko.protobufv3.internal.GeneratedMessage.computeStringSize(3, cookie_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.pekko.remote.WireFormats.PekkoHandshakeInfo)) {
        return super.equals(obj);
      }
      org.apache.pekko.remote.WireFormats.PekkoHandshakeInfo other = (org.apache.pekko.remote.WireFormats.PekkoHandshakeInfo) obj;

      if (hasOrigin() != other.hasOrigin()) return false;
      if (hasOrigin()) {
        if (!getOrigin()
            .equals(other.getOrigin())) return false;
      }
      if (hasUid() != other.hasUid()) return false;
      if (hasUid()) {
        if (getUid()
            != other.getUid()) return false;
      }
      if (hasCookie() != other.hasCookie()) return false;
      if (hasCookie()) {
        if (!getCookie()
            .equals(other.getCookie())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasOrigin()) {
        hash = (37 * hash) + ORIGIN_FIELD_NUMBER;
        hash = (53 * hash) + getOrigin().hashCode();
      }
      if (hasUid()) {
        hash = (37 * hash) + UID_FIELD_NUMBER;
        hash = (53 * hash) + org.apache.pekko.protobufv3.internal.Internal.hashLong(
            getUid());
      }
      if (hasCookie()) {
        hash = (37 * hash) + COOKIE_FIELD_NUMBER;
        hash = (53 * hash) + getCookie().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.pekko.remote.WireFormats.PekkoHandshakeInfo parseFrom(
        java.nio.ByteBuffer data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.remote.WireFormats.PekkoHandshakeInfo parseFrom(
        java.nio.ByteBuffer data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.PekkoHandshakeInfo parseFrom(
        org.apache.pekko.protobufv3.internal.ByteString data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.remote.WireFormats.PekkoHandshakeInfo parseFrom(
        org.apache.pekko.protobufv3.internal.ByteString data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.PekkoHandshakeInfo parseFrom(byte[] data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.remote.WireFormats.PekkoHandshakeInfo parseFrom(
        byte[] data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.PekkoHandshakeInfo parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.pekko.remote.WireFormats.PekkoHandshakeInfo parseFrom(
        java.io.InputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static org.apache.pekko.remote.WireFormats.PekkoHandshakeInfo parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static org.apache.pekko.remote.WireFormats.PekkoHandshakeInfo parseDelimitedFrom(
        java.io.InputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.PekkoHandshakeInfo parseFrom(
        org.apache.pekko.protobufv3.internal.CodedInputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.pekko.remote.WireFormats.PekkoHandshakeInfo parseFrom(
        org.apache.pekko.protobufv3.internal.CodedInputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.pekko.remote.WireFormats.PekkoHandshakeInfo prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        org.apache.pekko.protobufv3.internal.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code PekkoHandshakeInfo}
     */
    public static final class Builder extends
        org.apache.pekko.protobufv3.internal.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:PekkoHandshakeInfo)
        org.apache.pekko.remote.WireFormats.PekkoHandshakeInfoOrBuilder {
      public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.pekko.remote.WireFormats.internal_static_PekkoHandshakeInfo_descriptor;
      }

      @java.lang.Override
      protected org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.pekko.remote.WireFormats.internal_static_PekkoHandshakeInfo_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.pekko.remote.WireFormats.PekkoHandshakeInfo.class, org.apache.pekko.remote.WireFormats.PekkoHandshakeInfo.Builder.class);
      }

      // Construct using org.apache.pekko.remote.WireFormats.PekkoHandshakeInfo.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          org.apache.pekko.protobufv3.internal.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (org.apache.pekko.protobufv3.internal.GeneratedMessage
                .alwaysUseFieldBuilders) {
          internalGetOriginFieldBuilder();
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        origin_ = null;
        if (originBuilder_ != null) {
          originBuilder_.dispose();
          originBuilder_ = null;
        }
        uid_ = 0L;
        cookie_ = "";
        return this;
      }

      @java.lang.Override
      public org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.pekko.remote.WireFormats.internal_static_PekkoHandshakeInfo_descriptor;
      }

      @java.lang.Override
      public org.apache.pekko.remote.WireFormats.PekkoHandshakeInfo getDefaultInstanceForType() {
        return org.apache.pekko.remote.WireFormats.PekkoHandshakeInfo.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.pekko.remote.WireFormats.PekkoHandshakeInfo build() {
        org.apache.pekko.remote.WireFormats.PekkoHandshakeInfo result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.pekko.remote.WireFormats.PekkoHandshakeInfo buildPartial() {
        org.apache.pekko.remote.WireFormats.PekkoHandshakeInfo result = new org.apache.pekko.remote.WireFormats.PekkoHandshakeInfo(this);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartial0(org.apache.pekko.remote.WireFormats.PekkoHandshakeInfo result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.origin_ = originBuilder_ == null
              ? origin_
              : originBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.uid_ = uid_;
          to_bitField0_ |= 0x00000002;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.cookie_ = cookie_;
          to_bitField0_ |= 0x00000004;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder mergeFrom(org.apache.pekko.protobufv3.internal.Message other) {
        if (other instanceof org.apache.pekko.remote.WireFormats.PekkoHandshakeInfo) {
          return mergeFrom((org.apache.pekko.remote.WireFormats.PekkoHandshakeInfo)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.pekko.remote.WireFormats.PekkoHandshakeInfo other) {
        if (other == org.apache.pekko.remote.WireFormats.PekkoHandshakeInfo.getDefaultInstance()) return this;
        if (other.hasOrigin()) {
          mergeOrigin(other.getOrigin());
        }
        if (other.hasUid()) {
          setUid(other.getUid());
        }
        if (other.hasCookie()) {
          cookie_ = other.cookie_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        if (!hasOrigin()) {
          return false;
        }
        if (!hasUid()) {
          return false;
        }
        if (!getOrigin().isInitialized()) {
          return false;
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                input.readMessage(
                    internalGetOriginFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
              case 17: {
                uid_ = input.readFixed64();
                bitField0_ |= 0x00000002;
                break;
              } // case 17
              case 26: {
                cookie_ = input.readBytes();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private org.apache.pekko.remote.WireFormats.AddressData origin_;
      private org.apache.pekko.protobufv3.internal.SingleFieldBuilder<
          org.apache.pekko.remote.WireFormats.AddressData, org.apache.pekko.remote.WireFormats.AddressData.Builder, org.apache.pekko.remote.WireFormats.AddressDataOrBuilder> originBuilder_;
      /**
       * <code>required .AddressData origin = 1;</code>
       * @return Whether the origin field is set.
       */
      public boolean hasOrigin() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <code>required .AddressData origin = 1;</code>
       * @return The origin.
       */
      public org.apache.pekko.remote.WireFormats.AddressData getOrigin() {
        if (originBuilder_ == null) {
          return origin_ == null ? org.apache.pekko.remote.WireFormats.AddressData.getDefaultInstance() : origin_;
        } else {
          return originBuilder_.getMessage();
        }
      }
      /**
       * <code>required .AddressData origin = 1;</code>
       */
      public Builder setOrigin(org.apache.pekko.remote.WireFormats.AddressData value) {
        if (originBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          origin_ = value;
        } else {
          originBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <code>required .AddressData origin = 1;</code>
       */
      public Builder setOrigin(
          org.apache.pekko.remote.WireFormats.AddressData.Builder builderForValue) {
        if (originBuilder_ == null) {
          origin_ = builderForValue.build();
        } else {
          originBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <code>required .AddressData origin = 1;</code>
       */
      public Builder mergeOrigin(org.apache.pekko.remote.WireFormats.AddressData value) {
        if (originBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0) &&
            origin_ != null &&
            origin_ != org.apache.pekko.remote.WireFormats.AddressData.getDefaultInstance()) {
            getOriginBuilder().mergeFrom(value);
          } else {
            origin_ = value;
          }
        } else {
          originBuilder_.mergeFrom(value);
        }
        if (origin_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }
      /**
       * <code>required .AddressData origin = 1;</code>
       */
      public Builder clearOrigin() {
        bitField0_ = (bitField0_ & ~0x00000001);
        origin_ = null;
        if (originBuilder_ != null) {
          originBuilder_.dispose();
          originBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <code>required .AddressData origin = 1;</code>
       */
      public org.apache.pekko.remote.WireFormats.AddressData.Builder getOriginBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return internalGetOriginFieldBuilder().getBuilder();
      }
      /**
       * <code>required .AddressData origin = 1;</code>
       */
      public org.apache.pekko.remote.WireFormats.AddressDataOrBuilder getOriginOrBuilder() {
        if (originBuilder_ != null) {
          return originBuilder_.getMessageOrBuilder();
        } else {
          return origin_ == null ?
              org.apache.pekko.remote.WireFormats.AddressData.getDefaultInstance() : origin_;
        }
      }
      /**
       * <code>required .AddressData origin = 1;</code>
       */
      private org.apache.pekko.protobufv3.internal.SingleFieldBuilder<
          org.apache.pekko.remote.WireFormats.AddressData, org.apache.pekko.remote.WireFormats.AddressData.Builder, org.apache.pekko.remote.WireFormats.AddressDataOrBuilder> 
          internalGetOriginFieldBuilder() {
        if (originBuilder_ == null) {
          originBuilder_ = new org.apache.pekko.protobufv3.internal.SingleFieldBuilder<
              org.apache.pekko.remote.WireFormats.AddressData, org.apache.pekko.remote.WireFormats.AddressData.Builder, org.apache.pekko.remote.WireFormats.AddressDataOrBuilder>(
                  getOrigin(),
                  getParentForChildren(),
                  isClean());
          origin_ = null;
        }
        return originBuilder_;
      }

      private long uid_ ;
      /**
       * <code>required fixed64 uid = 2;</code>
       * @return Whether the uid field is set.
       */
      @java.lang.Override
      public boolean hasUid() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <code>required fixed64 uid = 2;</code>
       * @return The uid.
       */
      @java.lang.Override
      public long getUid() {
        return uid_;
      }
      /**
       * <code>required fixed64 uid = 2;</code>
       * @param value The uid to set.
       * @return This builder for chaining.
       */
      public Builder setUid(long value) {

        uid_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <code>required fixed64 uid = 2;</code>
       * @return This builder for chaining.
       */
      public Builder clearUid() {
        bitField0_ = (bitField0_ & ~0x00000002);
        uid_ = 0L;
        onChanged();
        return this;
      }

      private java.lang.Object cookie_ = "";
      /**
       * <code>optional string cookie = 3;</code>
       * @return Whether the cookie field is set.
       */
      public boolean hasCookie() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       * <code>optional string cookie = 3;</code>
       * @return The cookie.
       */
      public java.lang.String getCookie() {
        java.lang.Object ref = cookie_;
        if (!(ref instanceof java.lang.String)) {
          org.apache.pekko.protobufv3.internal.ByteString bs =
              (org.apache.pekko.protobufv3.internal.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            cookie_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string cookie = 3;</code>
       * @return The bytes for cookie.
       */
      public org.apache.pekko.protobufv3.internal.ByteString
          getCookieBytes() {
        java.lang.Object ref = cookie_;
        if (ref instanceof String) {
          org.apache.pekko.protobufv3.internal.ByteString b = 
              org.apache.pekko.protobufv3.internal.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          cookie_ = b;
          return b;
        } else {
          return (org.apache.pekko.protobufv3.internal.ByteString) ref;
        }
      }
      /**
       * <code>optional string cookie = 3;</code>
       * @param value The cookie to set.
       * @return This builder for chaining.
       */
      public Builder setCookie(
          java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        cookie_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       * <code>optional string cookie = 3;</code>
       * @return This builder for chaining.
       */
      public Builder clearCookie() {
        cookie_ = getDefaultInstance().getCookie();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       * <code>optional string cookie = 3;</code>
       * @param value The bytes for cookie to set.
       * @return This builder for chaining.
       */
      public Builder setCookieBytes(
          org.apache.pekko.protobufv3.internal.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        cookie_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:PekkoHandshakeInfo)
    }

    // @@protoc_insertion_point(class_scope:PekkoHandshakeInfo)
    private static final org.apache.pekko.remote.WireFormats.PekkoHandshakeInfo DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.pekko.remote.WireFormats.PekkoHandshakeInfo();
    }

    public static org.apache.pekko.remote.WireFormats.PekkoHandshakeInfo getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final org.apache.pekko.protobufv3.internal.Parser<PekkoHandshakeInfo>
        PARSER = new org.apache.pekko.protobufv3.internal.AbstractParser<PekkoHandshakeInfo>() {
      @java.lang.Override
      public PekkoHandshakeInfo parsePartialFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (org.apache.pekko.protobufv3.internal.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static org.apache.pekko.protobufv3.internal.Parser<PekkoHandshakeInfo> parser() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.pekko.protobufv3.internal.Parser<PekkoHandshakeInfo> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.pekko.remote.WireFormats.PekkoHandshakeInfo getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface FiniteDurationOrBuilder extends
      // @@protoc_insertion_point(interface_extends:FiniteDuration)
      org.apache.pekko.protobufv3.internal.MessageOrBuilder {

    /**
     * <code>required int64 value = 1;</code>
     * @return Whether the value field is set.
     */
    boolean hasValue();
    /**
     * <code>required int64 value = 1;</code>
     * @return The value.
     */
    long getValue();

    /**
     * <code>required .TimeUnit unit = 2;</code>
     * @return Whether the unit field is set.
     */
    boolean hasUnit();
    /**
     * <code>required .TimeUnit unit = 2;</code>
     * @return The unit.
     */
    org.apache.pekko.remote.WireFormats.TimeUnit getUnit();
  }
  /**
   * Protobuf type {@code FiniteDuration}
   */
  public static final class FiniteDuration extends
      org.apache.pekko.protobufv3.internal.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:FiniteDuration)
      FiniteDurationOrBuilder {
  private static final long serialVersionUID = 0L;
    static {
      org.apache.pekko.protobufv3.internal.RuntimeVersion.validateProtobufGencodeVersion(
        org.apache.pekko.protobufv3.internal.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 32,
        /* patch= */ 0,
        /* suffix= */ "",
        FiniteDuration.class.getName());
    }
    // Use FiniteDuration.newBuilder() to construct.
    private FiniteDuration(org.apache.pekko.protobufv3.internal.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }
    private FiniteDuration() {
      unit_ = 1;
    }

    public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.pekko.remote.WireFormats.internal_static_FiniteDuration_descriptor;
    }

    @java.lang.Override
    protected org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.pekko.remote.WireFormats.internal_static_FiniteDuration_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.pekko.remote.WireFormats.FiniteDuration.class, org.apache.pekko.remote.WireFormats.FiniteDuration.Builder.class);
    }

    private int bitField0_;
    public static final int VALUE_FIELD_NUMBER = 1;
    private long value_ = 0L;
    /**
     * <code>required int64 value = 1;</code>
     * @return Whether the value field is set.
     */
    @java.lang.Override
    public boolean hasValue() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <code>required int64 value = 1;</code>
     * @return The value.
     */
    @java.lang.Override
    public long getValue() {
      return value_;
    }

    public static final int UNIT_FIELD_NUMBER = 2;
    private int unit_ = 1;
    /**
     * <code>required .TimeUnit unit = 2;</code>
     * @return Whether the unit field is set.
     */
    @java.lang.Override public boolean hasUnit() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <code>required .TimeUnit unit = 2;</code>
     * @return The unit.
     */
    @java.lang.Override public org.apache.pekko.remote.WireFormats.TimeUnit getUnit() {
      org.apache.pekko.remote.WireFormats.TimeUnit result = org.apache.pekko.remote.WireFormats.TimeUnit.forNumber(unit_);
      return result == null ? org.apache.pekko.remote.WireFormats.TimeUnit.NANOSECONDS : result;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasValue()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!hasUnit()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(org.apache.pekko.protobufv3.internal.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeInt64(1, value_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeEnum(2, unit_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeInt64Size(1, value_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeEnumSize(2, unit_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.pekko.remote.WireFormats.FiniteDuration)) {
        return super.equals(obj);
      }
      org.apache.pekko.remote.WireFormats.FiniteDuration other = (org.apache.pekko.remote.WireFormats.FiniteDuration) obj;

      if (hasValue() != other.hasValue()) return false;
      if (hasValue()) {
        if (getValue()
            != other.getValue()) return false;
      }
      if (hasUnit() != other.hasUnit()) return false;
      if (hasUnit()) {
        if (unit_ != other.unit_) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasValue()) {
        hash = (37 * hash) + VALUE_FIELD_NUMBER;
        hash = (53 * hash) + org.apache.pekko.protobufv3.internal.Internal.hashLong(
            getValue());
      }
      if (hasUnit()) {
        hash = (37 * hash) + UNIT_FIELD_NUMBER;
        hash = (53 * hash) + unit_;
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.pekko.remote.WireFormats.FiniteDuration parseFrom(
        java.nio.ByteBuffer data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.remote.WireFormats.FiniteDuration parseFrom(
        java.nio.ByteBuffer data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.FiniteDuration parseFrom(
        org.apache.pekko.protobufv3.internal.ByteString data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.remote.WireFormats.FiniteDuration parseFrom(
        org.apache.pekko.protobufv3.internal.ByteString data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.FiniteDuration parseFrom(byte[] data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.remote.WireFormats.FiniteDuration parseFrom(
        byte[] data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.FiniteDuration parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.pekko.remote.WireFormats.FiniteDuration parseFrom(
        java.io.InputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static org.apache.pekko.remote.WireFormats.FiniteDuration parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static org.apache.pekko.remote.WireFormats.FiniteDuration parseDelimitedFrom(
        java.io.InputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.FiniteDuration parseFrom(
        org.apache.pekko.protobufv3.internal.CodedInputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.pekko.remote.WireFormats.FiniteDuration parseFrom(
        org.apache.pekko.protobufv3.internal.CodedInputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.pekko.remote.WireFormats.FiniteDuration prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        org.apache.pekko.protobufv3.internal.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code FiniteDuration}
     */
    public static final class Builder extends
        org.apache.pekko.protobufv3.internal.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:FiniteDuration)
        org.apache.pekko.remote.WireFormats.FiniteDurationOrBuilder {
      public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.pekko.remote.WireFormats.internal_static_FiniteDuration_descriptor;
      }

      @java.lang.Override
      protected org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.pekko.remote.WireFormats.internal_static_FiniteDuration_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.pekko.remote.WireFormats.FiniteDuration.class, org.apache.pekko.remote.WireFormats.FiniteDuration.Builder.class);
      }

      // Construct using org.apache.pekko.remote.WireFormats.FiniteDuration.newBuilder()
      private Builder() {

      }

      private Builder(
          org.apache.pekko.protobufv3.internal.GeneratedMessage.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        value_ = 0L;
        unit_ = 1;
        return this;
      }

      @java.lang.Override
      public org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.pekko.remote.WireFormats.internal_static_FiniteDuration_descriptor;
      }

      @java.lang.Override
      public org.apache.pekko.remote.WireFormats.FiniteDuration getDefaultInstanceForType() {
        return org.apache.pekko.remote.WireFormats.FiniteDuration.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.pekko.remote.WireFormats.FiniteDuration build() {
        org.apache.pekko.remote.WireFormats.FiniteDuration result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.pekko.remote.WireFormats.FiniteDuration buildPartial() {
        org.apache.pekko.remote.WireFormats.FiniteDuration result = new org.apache.pekko.remote.WireFormats.FiniteDuration(this);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartial0(org.apache.pekko.remote.WireFormats.FiniteDuration result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.value_ = value_;
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.unit_ = unit_;
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder mergeFrom(org.apache.pekko.protobufv3.internal.Message other) {
        if (other instanceof org.apache.pekko.remote.WireFormats.FiniteDuration) {
          return mergeFrom((org.apache.pekko.remote.WireFormats.FiniteDuration)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.pekko.remote.WireFormats.FiniteDuration other) {
        if (other == org.apache.pekko.remote.WireFormats.FiniteDuration.getDefaultInstance()) return this;
        if (other.hasValue()) {
          setValue(other.getValue());
        }
        if (other.hasUnit()) {
          setUnit(other.getUnit());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        if (!hasValue()) {
          return false;
        }
        if (!hasUnit()) {
          return false;
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8: {
                value_ = input.readInt64();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
              case 16: {
                int tmpRaw = input.readEnum();
                org.apache.pekko.remote.WireFormats.TimeUnit tmpValue =
                    org.apache.pekko.remote.WireFormats.TimeUnit.forNumber(tmpRaw);
                if (tmpValue == null) {
                  mergeUnknownVarintField(2, tmpRaw);
                } else {
                  unit_ = tmpRaw;
                  bitField0_ |= 0x00000002;
                }
                break;
              } // case 16
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private long value_ ;
      /**
       * <code>required int64 value = 1;</code>
       * @return Whether the value field is set.
       */
      @java.lang.Override
      public boolean hasValue() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <code>required int64 value = 1;</code>
       * @return The value.
       */
      @java.lang.Override
      public long getValue() {
        return value_;
      }
      /**
       * <code>required int64 value = 1;</code>
       * @param value The value to set.
       * @return This builder for chaining.
       */
      public Builder setValue(long value) {

        value_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <code>required int64 value = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearValue() {
        bitField0_ = (bitField0_ & ~0x00000001);
        value_ = 0L;
        onChanged();
        return this;
      }

      private int unit_ = 1;
      /**
       * <code>required .TimeUnit unit = 2;</code>
       * @return Whether the unit field is set.
       */
      @java.lang.Override public boolean hasUnit() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <code>required .TimeUnit unit = 2;</code>
       * @return The unit.
       */
      @java.lang.Override
      public org.apache.pekko.remote.WireFormats.TimeUnit getUnit() {
        org.apache.pekko.remote.WireFormats.TimeUnit result = org.apache.pekko.remote.WireFormats.TimeUnit.forNumber(unit_);
        return result == null ? org.apache.pekko.remote.WireFormats.TimeUnit.NANOSECONDS : result;
      }
      /**
       * <code>required .TimeUnit unit = 2;</code>
       * @param value The unit to set.
       * @return This builder for chaining.
       */
      public Builder setUnit(org.apache.pekko.remote.WireFormats.TimeUnit value) {
        if (value == null) { throw new NullPointerException(); }
        bitField0_ |= 0x00000002;
        unit_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <code>required .TimeUnit unit = 2;</code>
       * @return This builder for chaining.
       */
      public Builder clearUnit() {
        bitField0_ = (bitField0_ & ~0x00000002);
        unit_ = 1;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:FiniteDuration)
    }

    // @@protoc_insertion_point(class_scope:FiniteDuration)
    private static final org.apache.pekko.remote.WireFormats.FiniteDuration DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.pekko.remote.WireFormats.FiniteDuration();
    }

    public static org.apache.pekko.remote.WireFormats.FiniteDuration getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final org.apache.pekko.protobufv3.internal.Parser<FiniteDuration>
        PARSER = new org.apache.pekko.protobufv3.internal.AbstractParser<FiniteDuration>() {
      @java.lang.Override
      public FiniteDuration parsePartialFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (org.apache.pekko.protobufv3.internal.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static org.apache.pekko.protobufv3.internal.Parser<FiniteDuration> parser() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.pekko.protobufv3.internal.Parser<FiniteDuration> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.pekko.remote.WireFormats.FiniteDuration getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface RemoteScopeOrBuilder extends
      // @@protoc_insertion_point(interface_extends:RemoteScope)
      org.apache.pekko.protobufv3.internal.MessageOrBuilder {

    /**
     * <code>required .AddressData node = 1;</code>
     * @return Whether the node field is set.
     */
    boolean hasNode();
    /**
     * <code>required .AddressData node = 1;</code>
     * @return The node.
     */
    org.apache.pekko.remote.WireFormats.AddressData getNode();
    /**
     * <code>required .AddressData node = 1;</code>
     */
    org.apache.pekko.remote.WireFormats.AddressDataOrBuilder getNodeOrBuilder();
  }
  /**
   * Protobuf type {@code RemoteScope}
   */
  public static final class RemoteScope extends
      org.apache.pekko.protobufv3.internal.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:RemoteScope)
      RemoteScopeOrBuilder {
  private static final long serialVersionUID = 0L;
    static {
      org.apache.pekko.protobufv3.internal.RuntimeVersion.validateProtobufGencodeVersion(
        org.apache.pekko.protobufv3.internal.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 32,
        /* patch= */ 0,
        /* suffix= */ "",
        RemoteScope.class.getName());
    }
    // Use RemoteScope.newBuilder() to construct.
    private RemoteScope(org.apache.pekko.protobufv3.internal.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }
    private RemoteScope() {
    }

    public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.pekko.remote.WireFormats.internal_static_RemoteScope_descriptor;
    }

    @java.lang.Override
    protected org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.pekko.remote.WireFormats.internal_static_RemoteScope_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.pekko.remote.WireFormats.RemoteScope.class, org.apache.pekko.remote.WireFormats.RemoteScope.Builder.class);
    }

    private int bitField0_;
    public static final int NODE_FIELD_NUMBER = 1;
    private org.apache.pekko.remote.WireFormats.AddressData node_;
    /**
     * <code>required .AddressData node = 1;</code>
     * @return Whether the node field is set.
     */
    @java.lang.Override
    public boolean hasNode() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <code>required .AddressData node = 1;</code>
     * @return The node.
     */
    @java.lang.Override
    public org.apache.pekko.remote.WireFormats.AddressData getNode() {
      return node_ == null ? org.apache.pekko.remote.WireFormats.AddressData.getDefaultInstance() : node_;
    }
    /**
     * <code>required .AddressData node = 1;</code>
     */
    @java.lang.Override
    public org.apache.pekko.remote.WireFormats.AddressDataOrBuilder getNodeOrBuilder() {
      return node_ == null ? org.apache.pekko.remote.WireFormats.AddressData.getDefaultInstance() : node_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasNode()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!getNode().isInitialized()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(org.apache.pekko.protobufv3.internal.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getNode());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeMessageSize(1, getNode());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.pekko.remote.WireFormats.RemoteScope)) {
        return super.equals(obj);
      }
      org.apache.pekko.remote.WireFormats.RemoteScope other = (org.apache.pekko.remote.WireFormats.RemoteScope) obj;

      if (hasNode() != other.hasNode()) return false;
      if (hasNode()) {
        if (!getNode()
            .equals(other.getNode())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasNode()) {
        hash = (37 * hash) + NODE_FIELD_NUMBER;
        hash = (53 * hash) + getNode().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.pekko.remote.WireFormats.RemoteScope parseFrom(
        java.nio.ByteBuffer data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.remote.WireFormats.RemoteScope parseFrom(
        java.nio.ByteBuffer data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.RemoteScope parseFrom(
        org.apache.pekko.protobufv3.internal.ByteString data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.remote.WireFormats.RemoteScope parseFrom(
        org.apache.pekko.protobufv3.internal.ByteString data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.RemoteScope parseFrom(byte[] data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.remote.WireFormats.RemoteScope parseFrom(
        byte[] data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.RemoteScope parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.pekko.remote.WireFormats.RemoteScope parseFrom(
        java.io.InputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static org.apache.pekko.remote.WireFormats.RemoteScope parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static org.apache.pekko.remote.WireFormats.RemoteScope parseDelimitedFrom(
        java.io.InputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.RemoteScope parseFrom(
        org.apache.pekko.protobufv3.internal.CodedInputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.pekko.remote.WireFormats.RemoteScope parseFrom(
        org.apache.pekko.protobufv3.internal.CodedInputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.pekko.remote.WireFormats.RemoteScope prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        org.apache.pekko.protobufv3.internal.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code RemoteScope}
     */
    public static final class Builder extends
        org.apache.pekko.protobufv3.internal.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:RemoteScope)
        org.apache.pekko.remote.WireFormats.RemoteScopeOrBuilder {
      public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.pekko.remote.WireFormats.internal_static_RemoteScope_descriptor;
      }

      @java.lang.Override
      protected org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.pekko.remote.WireFormats.internal_static_RemoteScope_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.pekko.remote.WireFormats.RemoteScope.class, org.apache.pekko.remote.WireFormats.RemoteScope.Builder.class);
      }

      // Construct using org.apache.pekko.remote.WireFormats.RemoteScope.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          org.apache.pekko.protobufv3.internal.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (org.apache.pekko.protobufv3.internal.GeneratedMessage
                .alwaysUseFieldBuilders) {
          internalGetNodeFieldBuilder();
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        node_ = null;
        if (nodeBuilder_ != null) {
          nodeBuilder_.dispose();
          nodeBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.pekko.remote.WireFormats.internal_static_RemoteScope_descriptor;
      }

      @java.lang.Override
      public org.apache.pekko.remote.WireFormats.RemoteScope getDefaultInstanceForType() {
        return org.apache.pekko.remote.WireFormats.RemoteScope.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.pekko.remote.WireFormats.RemoteScope build() {
        org.apache.pekko.remote.WireFormats.RemoteScope result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.pekko.remote.WireFormats.RemoteScope buildPartial() {
        org.apache.pekko.remote.WireFormats.RemoteScope result = new org.apache.pekko.remote.WireFormats.RemoteScope(this);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartial0(org.apache.pekko.remote.WireFormats.RemoteScope result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.node_ = nodeBuilder_ == null
              ? node_
              : nodeBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder mergeFrom(org.apache.pekko.protobufv3.internal.Message other) {
        if (other instanceof org.apache.pekko.remote.WireFormats.RemoteScope) {
          return mergeFrom((org.apache.pekko.remote.WireFormats.RemoteScope)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.pekko.remote.WireFormats.RemoteScope other) {
        if (other == org.apache.pekko.remote.WireFormats.RemoteScope.getDefaultInstance()) return this;
        if (other.hasNode()) {
          mergeNode(other.getNode());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        if (!hasNode()) {
          return false;
        }
        if (!getNode().isInitialized()) {
          return false;
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                input.readMessage(
                    internalGetNodeFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private org.apache.pekko.remote.WireFormats.AddressData node_;
      private org.apache.pekko.protobufv3.internal.SingleFieldBuilder<
          org.apache.pekko.remote.WireFormats.AddressData, org.apache.pekko.remote.WireFormats.AddressData.Builder, org.apache.pekko.remote.WireFormats.AddressDataOrBuilder> nodeBuilder_;
      /**
       * <code>required .AddressData node = 1;</code>
       * @return Whether the node field is set.
       */
      public boolean hasNode() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <code>required .AddressData node = 1;</code>
       * @return The node.
       */
      public org.apache.pekko.remote.WireFormats.AddressData getNode() {
        if (nodeBuilder_ == null) {
          return node_ == null ? org.apache.pekko.remote.WireFormats.AddressData.getDefaultInstance() : node_;
        } else {
          return nodeBuilder_.getMessage();
        }
      }
      /**
       * <code>required .AddressData node = 1;</code>
       */
      public Builder setNode(org.apache.pekko.remote.WireFormats.AddressData value) {
        if (nodeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          node_ = value;
        } else {
          nodeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <code>required .AddressData node = 1;</code>
       */
      public Builder setNode(
          org.apache.pekko.remote.WireFormats.AddressData.Builder builderForValue) {
        if (nodeBuilder_ == null) {
          node_ = builderForValue.build();
        } else {
          nodeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <code>required .AddressData node = 1;</code>
       */
      public Builder mergeNode(org.apache.pekko.remote.WireFormats.AddressData value) {
        if (nodeBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0) &&
            node_ != null &&
            node_ != org.apache.pekko.remote.WireFormats.AddressData.getDefaultInstance()) {
            getNodeBuilder().mergeFrom(value);
          } else {
            node_ = value;
          }
        } else {
          nodeBuilder_.mergeFrom(value);
        }
        if (node_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }
      /**
       * <code>required .AddressData node = 1;</code>
       */
      public Builder clearNode() {
        bitField0_ = (bitField0_ & ~0x00000001);
        node_ = null;
        if (nodeBuilder_ != null) {
          nodeBuilder_.dispose();
          nodeBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <code>required .AddressData node = 1;</code>
       */
      public org.apache.pekko.remote.WireFormats.AddressData.Builder getNodeBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return internalGetNodeFieldBuilder().getBuilder();
      }
      /**
       * <code>required .AddressData node = 1;</code>
       */
      public org.apache.pekko.remote.WireFormats.AddressDataOrBuilder getNodeOrBuilder() {
        if (nodeBuilder_ != null) {
          return nodeBuilder_.getMessageOrBuilder();
        } else {
          return node_ == null ?
              org.apache.pekko.remote.WireFormats.AddressData.getDefaultInstance() : node_;
        }
      }
      /**
       * <code>required .AddressData node = 1;</code>
       */
      private org.apache.pekko.protobufv3.internal.SingleFieldBuilder<
          org.apache.pekko.remote.WireFormats.AddressData, org.apache.pekko.remote.WireFormats.AddressData.Builder, org.apache.pekko.remote.WireFormats.AddressDataOrBuilder> 
          internalGetNodeFieldBuilder() {
        if (nodeBuilder_ == null) {
          nodeBuilder_ = new org.apache.pekko.protobufv3.internal.SingleFieldBuilder<
              org.apache.pekko.remote.WireFormats.AddressData, org.apache.pekko.remote.WireFormats.AddressData.Builder, org.apache.pekko.remote.WireFormats.AddressDataOrBuilder>(
                  getNode(),
                  getParentForChildren(),
                  isClean());
          node_ = null;
        }
        return nodeBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:RemoteScope)
    }

    // @@protoc_insertion_point(class_scope:RemoteScope)
    private static final org.apache.pekko.remote.WireFormats.RemoteScope DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.pekko.remote.WireFormats.RemoteScope();
    }

    public static org.apache.pekko.remote.WireFormats.RemoteScope getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final org.apache.pekko.protobufv3.internal.Parser<RemoteScope>
        PARSER = new org.apache.pekko.protobufv3.internal.AbstractParser<RemoteScope>() {
      @java.lang.Override
      public RemoteScope parsePartialFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (org.apache.pekko.protobufv3.internal.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static org.apache.pekko.protobufv3.internal.Parser<RemoteScope> parser() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.pekko.protobufv3.internal.Parser<RemoteScope> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.pekko.remote.WireFormats.RemoteScope getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface DefaultResizerOrBuilder extends
      // @@protoc_insertion_point(interface_extends:DefaultResizer)
      org.apache.pekko.protobufv3.internal.MessageOrBuilder {

    /**
     * <code>required uint32 lowerBound = 1;</code>
     * @return Whether the lowerBound field is set.
     */
    boolean hasLowerBound();
    /**
     * <code>required uint32 lowerBound = 1;</code>
     * @return The lowerBound.
     */
    int getLowerBound();

    /**
     * <code>required uint32 upperBound = 2;</code>
     * @return Whether the upperBound field is set.
     */
    boolean hasUpperBound();
    /**
     * <code>required uint32 upperBound = 2;</code>
     * @return The upperBound.
     */
    int getUpperBound();

    /**
     * <code>required uint32 pressureThreshold = 3;</code>
     * @return Whether the pressureThreshold field is set.
     */
    boolean hasPressureThreshold();
    /**
     * <code>required uint32 pressureThreshold = 3;</code>
     * @return The pressureThreshold.
     */
    int getPressureThreshold();

    /**
     * <code>required double rampupRate = 4;</code>
     * @return Whether the rampupRate field is set.
     */
    boolean hasRampupRate();
    /**
     * <code>required double rampupRate = 4;</code>
     * @return The rampupRate.
     */
    double getRampupRate();

    /**
     * <code>required double backoffThreshold = 5;</code>
     * @return Whether the backoffThreshold field is set.
     */
    boolean hasBackoffThreshold();
    /**
     * <code>required double backoffThreshold = 5;</code>
     * @return The backoffThreshold.
     */
    double getBackoffThreshold();

    /**
     * <code>required double backoffRate = 6;</code>
     * @return Whether the backoffRate field is set.
     */
    boolean hasBackoffRate();
    /**
     * <code>required double backoffRate = 6;</code>
     * @return The backoffRate.
     */
    double getBackoffRate();

    /**
     * <code>required uint32 messagesPerResize = 7;</code>
     * @return Whether the messagesPerResize field is set.
     */
    boolean hasMessagesPerResize();
    /**
     * <code>required uint32 messagesPerResize = 7;</code>
     * @return The messagesPerResize.
     */
    int getMessagesPerResize();
  }
  /**
   * Protobuf type {@code DefaultResizer}
   */
  public static final class DefaultResizer extends
      org.apache.pekko.protobufv3.internal.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:DefaultResizer)
      DefaultResizerOrBuilder {
  private static final long serialVersionUID = 0L;
    static {
      org.apache.pekko.protobufv3.internal.RuntimeVersion.validateProtobufGencodeVersion(
        org.apache.pekko.protobufv3.internal.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 32,
        /* patch= */ 0,
        /* suffix= */ "",
        DefaultResizer.class.getName());
    }
    // Use DefaultResizer.newBuilder() to construct.
    private DefaultResizer(org.apache.pekko.protobufv3.internal.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }
    private DefaultResizer() {
    }

    public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.pekko.remote.WireFormats.internal_static_DefaultResizer_descriptor;
    }

    @java.lang.Override
    protected org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.pekko.remote.WireFormats.internal_static_DefaultResizer_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.pekko.remote.WireFormats.DefaultResizer.class, org.apache.pekko.remote.WireFormats.DefaultResizer.Builder.class);
    }

    private int bitField0_;
    public static final int LOWERBOUND_FIELD_NUMBER = 1;
    private int lowerBound_ = 0;
    /**
     * <code>required uint32 lowerBound = 1;</code>
     * @return Whether the lowerBound field is set.
     */
    @java.lang.Override
    public boolean hasLowerBound() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <code>required uint32 lowerBound = 1;</code>
     * @return The lowerBound.
     */
    @java.lang.Override
    public int getLowerBound() {
      return lowerBound_;
    }

    public static final int UPPERBOUND_FIELD_NUMBER = 2;
    private int upperBound_ = 0;
    /**
     * <code>required uint32 upperBound = 2;</code>
     * @return Whether the upperBound field is set.
     */
    @java.lang.Override
    public boolean hasUpperBound() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <code>required uint32 upperBound = 2;</code>
     * @return The upperBound.
     */
    @java.lang.Override
    public int getUpperBound() {
      return upperBound_;
    }

    public static final int PRESSURETHRESHOLD_FIELD_NUMBER = 3;
    private int pressureThreshold_ = 0;
    /**
     * <code>required uint32 pressureThreshold = 3;</code>
     * @return Whether the pressureThreshold field is set.
     */
    @java.lang.Override
    public boolean hasPressureThreshold() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     * <code>required uint32 pressureThreshold = 3;</code>
     * @return The pressureThreshold.
     */
    @java.lang.Override
    public int getPressureThreshold() {
      return pressureThreshold_;
    }

    public static final int RAMPUPRATE_FIELD_NUMBER = 4;
    private double rampupRate_ = 0D;
    /**
     * <code>required double rampupRate = 4;</code>
     * @return Whether the rampupRate field is set.
     */
    @java.lang.Override
    public boolean hasRampupRate() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     * <code>required double rampupRate = 4;</code>
     * @return The rampupRate.
     */
    @java.lang.Override
    public double getRampupRate() {
      return rampupRate_;
    }

    public static final int BACKOFFTHRESHOLD_FIELD_NUMBER = 5;
    private double backoffThreshold_ = 0D;
    /**
     * <code>required double backoffThreshold = 5;</code>
     * @return Whether the backoffThreshold field is set.
     */
    @java.lang.Override
    public boolean hasBackoffThreshold() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     * <code>required double backoffThreshold = 5;</code>
     * @return The backoffThreshold.
     */
    @java.lang.Override
    public double getBackoffThreshold() {
      return backoffThreshold_;
    }

    public static final int BACKOFFRATE_FIELD_NUMBER = 6;
    private double backoffRate_ = 0D;
    /**
     * <code>required double backoffRate = 6;</code>
     * @return Whether the backoffRate field is set.
     */
    @java.lang.Override
    public boolean hasBackoffRate() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     * <code>required double backoffRate = 6;</code>
     * @return The backoffRate.
     */
    @java.lang.Override
    public double getBackoffRate() {
      return backoffRate_;
    }

    public static final int MESSAGESPERRESIZE_FIELD_NUMBER = 7;
    private int messagesPerResize_ = 0;
    /**
     * <code>required uint32 messagesPerResize = 7;</code>
     * @return Whether the messagesPerResize field is set.
     */
    @java.lang.Override
    public boolean hasMessagesPerResize() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     * <code>required uint32 messagesPerResize = 7;</code>
     * @return The messagesPerResize.
     */
    @java.lang.Override
    public int getMessagesPerResize() {
      return messagesPerResize_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasLowerBound()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!hasUpperBound()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!hasPressureThreshold()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!hasRampupRate()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!hasBackoffThreshold()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!hasBackoffRate()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!hasMessagesPerResize()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(org.apache.pekko.protobufv3.internal.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeUInt32(1, lowerBound_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeUInt32(2, upperBound_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        output.writeUInt32(3, pressureThreshold_);
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        output.writeDouble(4, rampupRate_);
      }
      if (((bitField0_ & 0x00000010) != 0)) {
        output.writeDouble(5, backoffThreshold_);
      }
      if (((bitField0_ & 0x00000020) != 0)) {
        output.writeDouble(6, backoffRate_);
      }
      if (((bitField0_ & 0x00000040) != 0)) {
        output.writeUInt32(7, messagesPerResize_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeUInt32Size(1, lowerBound_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeUInt32Size(2, upperBound_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeUInt32Size(3, pressureThreshold_);
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeDoubleSize(4, rampupRate_);
      }
      if (((bitField0_ & 0x00000010) != 0)) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeDoubleSize(5, backoffThreshold_);
      }
      if (((bitField0_ & 0x00000020) != 0)) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeDoubleSize(6, backoffRate_);
      }
      if (((bitField0_ & 0x00000040) != 0)) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeUInt32Size(7, messagesPerResize_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.pekko.remote.WireFormats.DefaultResizer)) {
        return super.equals(obj);
      }
      org.apache.pekko.remote.WireFormats.DefaultResizer other = (org.apache.pekko.remote.WireFormats.DefaultResizer) obj;

      if (hasLowerBound() != other.hasLowerBound()) return false;
      if (hasLowerBound()) {
        if (getLowerBound()
            != other.getLowerBound()) return false;
      }
      if (hasUpperBound() != other.hasUpperBound()) return false;
      if (hasUpperBound()) {
        if (getUpperBound()
            != other.getUpperBound()) return false;
      }
      if (hasPressureThreshold() != other.hasPressureThreshold()) return false;
      if (hasPressureThreshold()) {
        if (getPressureThreshold()
            != other.getPressureThreshold()) return false;
      }
      if (hasRampupRate() != other.hasRampupRate()) return false;
      if (hasRampupRate()) {
        if (java.lang.Double.doubleToLongBits(getRampupRate())
            != java.lang.Double.doubleToLongBits(
                other.getRampupRate())) return false;
      }
      if (hasBackoffThreshold() != other.hasBackoffThreshold()) return false;
      if (hasBackoffThreshold()) {
        if (java.lang.Double.doubleToLongBits(getBackoffThreshold())
            != java.lang.Double.doubleToLongBits(
                other.getBackoffThreshold())) return false;
      }
      if (hasBackoffRate() != other.hasBackoffRate()) return false;
      if (hasBackoffRate()) {
        if (java.lang.Double.doubleToLongBits(getBackoffRate())
            != java.lang.Double.doubleToLongBits(
                other.getBackoffRate())) return false;
      }
      if (hasMessagesPerResize() != other.hasMessagesPerResize()) return false;
      if (hasMessagesPerResize()) {
        if (getMessagesPerResize()
            != other.getMessagesPerResize()) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasLowerBound()) {
        hash = (37 * hash) + LOWERBOUND_FIELD_NUMBER;
        hash = (53 * hash) + getLowerBound();
      }
      if (hasUpperBound()) {
        hash = (37 * hash) + UPPERBOUND_FIELD_NUMBER;
        hash = (53 * hash) + getUpperBound();
      }
      if (hasPressureThreshold()) {
        hash = (37 * hash) + PRESSURETHRESHOLD_FIELD_NUMBER;
        hash = (53 * hash) + getPressureThreshold();
      }
      if (hasRampupRate()) {
        hash = (37 * hash) + RAMPUPRATE_FIELD_NUMBER;
        hash = (53 * hash) + org.apache.pekko.protobufv3.internal.Internal.hashLong(
            java.lang.Double.doubleToLongBits(getRampupRate()));
      }
      if (hasBackoffThreshold()) {
        hash = (37 * hash) + BACKOFFTHRESHOLD_FIELD_NUMBER;
        hash = (53 * hash) + org.apache.pekko.protobufv3.internal.Internal.hashLong(
            java.lang.Double.doubleToLongBits(getBackoffThreshold()));
      }
      if (hasBackoffRate()) {
        hash = (37 * hash) + BACKOFFRATE_FIELD_NUMBER;
        hash = (53 * hash) + org.apache.pekko.protobufv3.internal.Internal.hashLong(
            java.lang.Double.doubleToLongBits(getBackoffRate()));
      }
      if (hasMessagesPerResize()) {
        hash = (37 * hash) + MESSAGESPERRESIZE_FIELD_NUMBER;
        hash = (53 * hash) + getMessagesPerResize();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.pekko.remote.WireFormats.DefaultResizer parseFrom(
        java.nio.ByteBuffer data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.remote.WireFormats.DefaultResizer parseFrom(
        java.nio.ByteBuffer data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.DefaultResizer parseFrom(
        org.apache.pekko.protobufv3.internal.ByteString data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.remote.WireFormats.DefaultResizer parseFrom(
        org.apache.pekko.protobufv3.internal.ByteString data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.DefaultResizer parseFrom(byte[] data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.remote.WireFormats.DefaultResizer parseFrom(
        byte[] data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.DefaultResizer parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.pekko.remote.WireFormats.DefaultResizer parseFrom(
        java.io.InputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static org.apache.pekko.remote.WireFormats.DefaultResizer parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static org.apache.pekko.remote.WireFormats.DefaultResizer parseDelimitedFrom(
        java.io.InputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.DefaultResizer parseFrom(
        org.apache.pekko.protobufv3.internal.CodedInputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.pekko.remote.WireFormats.DefaultResizer parseFrom(
        org.apache.pekko.protobufv3.internal.CodedInputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.pekko.remote.WireFormats.DefaultResizer prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        org.apache.pekko.protobufv3.internal.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code DefaultResizer}
     */
    public static final class Builder extends
        org.apache.pekko.protobufv3.internal.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:DefaultResizer)
        org.apache.pekko.remote.WireFormats.DefaultResizerOrBuilder {
      public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.pekko.remote.WireFormats.internal_static_DefaultResizer_descriptor;
      }

      @java.lang.Override
      protected org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.pekko.remote.WireFormats.internal_static_DefaultResizer_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.pekko.remote.WireFormats.DefaultResizer.class, org.apache.pekko.remote.WireFormats.DefaultResizer.Builder.class);
      }

      // Construct using org.apache.pekko.remote.WireFormats.DefaultResizer.newBuilder()
      private Builder() {

      }

      private Builder(
          org.apache.pekko.protobufv3.internal.GeneratedMessage.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        lowerBound_ = 0;
        upperBound_ = 0;
        pressureThreshold_ = 0;
        rampupRate_ = 0D;
        backoffThreshold_ = 0D;
        backoffRate_ = 0D;
        messagesPerResize_ = 0;
        return this;
      }

      @java.lang.Override
      public org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.pekko.remote.WireFormats.internal_static_DefaultResizer_descriptor;
      }

      @java.lang.Override
      public org.apache.pekko.remote.WireFormats.DefaultResizer getDefaultInstanceForType() {
        return org.apache.pekko.remote.WireFormats.DefaultResizer.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.pekko.remote.WireFormats.DefaultResizer build() {
        org.apache.pekko.remote.WireFormats.DefaultResizer result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.pekko.remote.WireFormats.DefaultResizer buildPartial() {
        org.apache.pekko.remote.WireFormats.DefaultResizer result = new org.apache.pekko.remote.WireFormats.DefaultResizer(this);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartial0(org.apache.pekko.remote.WireFormats.DefaultResizer result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.lowerBound_ = lowerBound_;
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.upperBound_ = upperBound_;
          to_bitField0_ |= 0x00000002;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.pressureThreshold_ = pressureThreshold_;
          to_bitField0_ |= 0x00000004;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.rampupRate_ = rampupRate_;
          to_bitField0_ |= 0x00000008;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.backoffThreshold_ = backoffThreshold_;
          to_bitField0_ |= 0x00000010;
        }
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.backoffRate_ = backoffRate_;
          to_bitField0_ |= 0x00000020;
        }
        if (((from_bitField0_ & 0x00000040) != 0)) {
          result.messagesPerResize_ = messagesPerResize_;
          to_bitField0_ |= 0x00000040;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder mergeFrom(org.apache.pekko.protobufv3.internal.Message other) {
        if (other instanceof org.apache.pekko.remote.WireFormats.DefaultResizer) {
          return mergeFrom((org.apache.pekko.remote.WireFormats.DefaultResizer)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.pekko.remote.WireFormats.DefaultResizer other) {
        if (other == org.apache.pekko.remote.WireFormats.DefaultResizer.getDefaultInstance()) return this;
        if (other.hasLowerBound()) {
          setLowerBound(other.getLowerBound());
        }
        if (other.hasUpperBound()) {
          setUpperBound(other.getUpperBound());
        }
        if (other.hasPressureThreshold()) {
          setPressureThreshold(other.getPressureThreshold());
        }
        if (other.hasRampupRate()) {
          setRampupRate(other.getRampupRate());
        }
        if (other.hasBackoffThreshold()) {
          setBackoffThreshold(other.getBackoffThreshold());
        }
        if (other.hasBackoffRate()) {
          setBackoffRate(other.getBackoffRate());
        }
        if (other.hasMessagesPerResize()) {
          setMessagesPerResize(other.getMessagesPerResize());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        if (!hasLowerBound()) {
          return false;
        }
        if (!hasUpperBound()) {
          return false;
        }
        if (!hasPressureThreshold()) {
          return false;
        }
        if (!hasRampupRate()) {
          return false;
        }
        if (!hasBackoffThreshold()) {
          return false;
        }
        if (!hasBackoffRate()) {
          return false;
        }
        if (!hasMessagesPerResize()) {
          return false;
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8: {
                lowerBound_ = input.readUInt32();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
              case 16: {
                upperBound_ = input.readUInt32();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
              case 24: {
                pressureThreshold_ = input.readUInt32();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
              case 33: {
                rampupRate_ = input.readDouble();
                bitField0_ |= 0x00000008;
                break;
              } // case 33
              case 41: {
                backoffThreshold_ = input.readDouble();
                bitField0_ |= 0x00000010;
                break;
              } // case 41
              case 49: {
                backoffRate_ = input.readDouble();
                bitField0_ |= 0x00000020;
                break;
              } // case 49
              case 56: {
                messagesPerResize_ = input.readUInt32();
                bitField0_ |= 0x00000040;
                break;
              } // case 56
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private int lowerBound_ ;
      /**
       * <code>required uint32 lowerBound = 1;</code>
       * @return Whether the lowerBound field is set.
       */
      @java.lang.Override
      public boolean hasLowerBound() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <code>required uint32 lowerBound = 1;</code>
       * @return The lowerBound.
       */
      @java.lang.Override
      public int getLowerBound() {
        return lowerBound_;
      }
      /**
       * <code>required uint32 lowerBound = 1;</code>
       * @param value The lowerBound to set.
       * @return This builder for chaining.
       */
      public Builder setLowerBound(int value) {

        lowerBound_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <code>required uint32 lowerBound = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearLowerBound() {
        bitField0_ = (bitField0_ & ~0x00000001);
        lowerBound_ = 0;
        onChanged();
        return this;
      }

      private int upperBound_ ;
      /**
       * <code>required uint32 upperBound = 2;</code>
       * @return Whether the upperBound field is set.
       */
      @java.lang.Override
      public boolean hasUpperBound() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <code>required uint32 upperBound = 2;</code>
       * @return The upperBound.
       */
      @java.lang.Override
      public int getUpperBound() {
        return upperBound_;
      }
      /**
       * <code>required uint32 upperBound = 2;</code>
       * @param value The upperBound to set.
       * @return This builder for chaining.
       */
      public Builder setUpperBound(int value) {

        upperBound_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <code>required uint32 upperBound = 2;</code>
       * @return This builder for chaining.
       */
      public Builder clearUpperBound() {
        bitField0_ = (bitField0_ & ~0x00000002);
        upperBound_ = 0;
        onChanged();
        return this;
      }

      private int pressureThreshold_ ;
      /**
       * <code>required uint32 pressureThreshold = 3;</code>
       * @return Whether the pressureThreshold field is set.
       */
      @java.lang.Override
      public boolean hasPressureThreshold() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       * <code>required uint32 pressureThreshold = 3;</code>
       * @return The pressureThreshold.
       */
      @java.lang.Override
      public int getPressureThreshold() {
        return pressureThreshold_;
      }
      /**
       * <code>required uint32 pressureThreshold = 3;</code>
       * @param value The pressureThreshold to set.
       * @return This builder for chaining.
       */
      public Builder setPressureThreshold(int value) {

        pressureThreshold_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       * <code>required uint32 pressureThreshold = 3;</code>
       * @return This builder for chaining.
       */
      public Builder clearPressureThreshold() {
        bitField0_ = (bitField0_ & ~0x00000004);
        pressureThreshold_ = 0;
        onChanged();
        return this;
      }

      private double rampupRate_ ;
      /**
       * <code>required double rampupRate = 4;</code>
       * @return Whether the rampupRate field is set.
       */
      @java.lang.Override
      public boolean hasRampupRate() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       * <code>required double rampupRate = 4;</code>
       * @return The rampupRate.
       */
      @java.lang.Override
      public double getRampupRate() {
        return rampupRate_;
      }
      /**
       * <code>required double rampupRate = 4;</code>
       * @param value The rampupRate to set.
       * @return This builder for chaining.
       */
      public Builder setRampupRate(double value) {

        rampupRate_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       * <code>required double rampupRate = 4;</code>
       * @return This builder for chaining.
       */
      public Builder clearRampupRate() {
        bitField0_ = (bitField0_ & ~0x00000008);
        rampupRate_ = 0D;
        onChanged();
        return this;
      }

      private double backoffThreshold_ ;
      /**
       * <code>required double backoffThreshold = 5;</code>
       * @return Whether the backoffThreshold field is set.
       */
      @java.lang.Override
      public boolean hasBackoffThreshold() {
        return ((bitField0_ & 0x00000010) != 0);
      }
      /**
       * <code>required double backoffThreshold = 5;</code>
       * @return The backoffThreshold.
       */
      @java.lang.Override
      public double getBackoffThreshold() {
        return backoffThreshold_;
      }
      /**
       * <code>required double backoffThreshold = 5;</code>
       * @param value The backoffThreshold to set.
       * @return This builder for chaining.
       */
      public Builder setBackoffThreshold(double value) {

        backoffThreshold_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       * <code>required double backoffThreshold = 5;</code>
       * @return This builder for chaining.
       */
      public Builder clearBackoffThreshold() {
        bitField0_ = (bitField0_ & ~0x00000010);
        backoffThreshold_ = 0D;
        onChanged();
        return this;
      }

      private double backoffRate_ ;
      /**
       * <code>required double backoffRate = 6;</code>
       * @return Whether the backoffRate field is set.
       */
      @java.lang.Override
      public boolean hasBackoffRate() {
        return ((bitField0_ & 0x00000020) != 0);
      }
      /**
       * <code>required double backoffRate = 6;</code>
       * @return The backoffRate.
       */
      @java.lang.Override
      public double getBackoffRate() {
        return backoffRate_;
      }
      /**
       * <code>required double backoffRate = 6;</code>
       * @param value The backoffRate to set.
       * @return This builder for chaining.
       */
      public Builder setBackoffRate(double value) {

        backoffRate_ = value;
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       * <code>required double backoffRate = 6;</code>
       * @return This builder for chaining.
       */
      public Builder clearBackoffRate() {
        bitField0_ = (bitField0_ & ~0x00000020);
        backoffRate_ = 0D;
        onChanged();
        return this;
      }

      private int messagesPerResize_ ;
      /**
       * <code>required uint32 messagesPerResize = 7;</code>
       * @return Whether the messagesPerResize field is set.
       */
      @java.lang.Override
      public boolean hasMessagesPerResize() {
        return ((bitField0_ & 0x00000040) != 0);
      }
      /**
       * <code>required uint32 messagesPerResize = 7;</code>
       * @return The messagesPerResize.
       */
      @java.lang.Override
      public int getMessagesPerResize() {
        return messagesPerResize_;
      }
      /**
       * <code>required uint32 messagesPerResize = 7;</code>
       * @param value The messagesPerResize to set.
       * @return This builder for chaining.
       */
      public Builder setMessagesPerResize(int value) {

        messagesPerResize_ = value;
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }
      /**
       * <code>required uint32 messagesPerResize = 7;</code>
       * @return This builder for chaining.
       */
      public Builder clearMessagesPerResize() {
        bitField0_ = (bitField0_ & ~0x00000040);
        messagesPerResize_ = 0;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:DefaultResizer)
    }

    // @@protoc_insertion_point(class_scope:DefaultResizer)
    private static final org.apache.pekko.remote.WireFormats.DefaultResizer DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.pekko.remote.WireFormats.DefaultResizer();
    }

    public static org.apache.pekko.remote.WireFormats.DefaultResizer getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final org.apache.pekko.protobufv3.internal.Parser<DefaultResizer>
        PARSER = new org.apache.pekko.protobufv3.internal.AbstractParser<DefaultResizer>() {
      @java.lang.Override
      public DefaultResizer parsePartialFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (org.apache.pekko.protobufv3.internal.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static org.apache.pekko.protobufv3.internal.Parser<DefaultResizer> parser() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.pekko.protobufv3.internal.Parser<DefaultResizer> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.pekko.remote.WireFormats.DefaultResizer getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface FromConfigOrBuilder extends
      // @@protoc_insertion_point(interface_extends:FromConfig)
      org.apache.pekko.protobufv3.internal.MessageOrBuilder {

    /**
     * <code>optional .Payload resizer = 1;</code>
     * @return Whether the resizer field is set.
     */
    boolean hasResizer();
    /**
     * <code>optional .Payload resizer = 1;</code>
     * @return The resizer.
     */
    org.apache.pekko.remote.ContainerFormats.Payload getResizer();
    /**
     * <code>optional .Payload resizer = 1;</code>
     */
    org.apache.pekko.remote.ContainerFormats.PayloadOrBuilder getResizerOrBuilder();

    /**
     * <code>optional string routerDispatcher = 2;</code>
     * @return Whether the routerDispatcher field is set.
     */
    boolean hasRouterDispatcher();
    /**
     * <code>optional string routerDispatcher = 2;</code>
     * @return The routerDispatcher.
     */
    java.lang.String getRouterDispatcher();
    /**
     * <code>optional string routerDispatcher = 2;</code>
     * @return The bytes for routerDispatcher.
     */
    org.apache.pekko.protobufv3.internal.ByteString
        getRouterDispatcherBytes();
  }
  /**
   * Protobuf type {@code FromConfig}
   */
  public static final class FromConfig extends
      org.apache.pekko.protobufv3.internal.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:FromConfig)
      FromConfigOrBuilder {
  private static final long serialVersionUID = 0L;
    static {
      org.apache.pekko.protobufv3.internal.RuntimeVersion.validateProtobufGencodeVersion(
        org.apache.pekko.protobufv3.internal.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 32,
        /* patch= */ 0,
        /* suffix= */ "",
        FromConfig.class.getName());
    }
    // Use FromConfig.newBuilder() to construct.
    private FromConfig(org.apache.pekko.protobufv3.internal.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }
    private FromConfig() {
      routerDispatcher_ = "";
    }

    public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.pekko.remote.WireFormats.internal_static_FromConfig_descriptor;
    }

    @java.lang.Override
    protected org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.pekko.remote.WireFormats.internal_static_FromConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.pekko.remote.WireFormats.FromConfig.class, org.apache.pekko.remote.WireFormats.FromConfig.Builder.class);
    }

    private int bitField0_;
    public static final int RESIZER_FIELD_NUMBER = 1;
    private org.apache.pekko.remote.ContainerFormats.Payload resizer_;
    /**
     * <code>optional .Payload resizer = 1;</code>
     * @return Whether the resizer field is set.
     */
    @java.lang.Override
    public boolean hasResizer() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <code>optional .Payload resizer = 1;</code>
     * @return The resizer.
     */
    @java.lang.Override
    public org.apache.pekko.remote.ContainerFormats.Payload getResizer() {
      return resizer_ == null ? org.apache.pekko.remote.ContainerFormats.Payload.getDefaultInstance() : resizer_;
    }
    /**
     * <code>optional .Payload resizer = 1;</code>
     */
    @java.lang.Override
    public org.apache.pekko.remote.ContainerFormats.PayloadOrBuilder getResizerOrBuilder() {
      return resizer_ == null ? org.apache.pekko.remote.ContainerFormats.Payload.getDefaultInstance() : resizer_;
    }

    public static final int ROUTERDISPATCHER_FIELD_NUMBER = 2;
    @SuppressWarnings("serial")
    private volatile java.lang.Object routerDispatcher_ = "";
    /**
     * <code>optional string routerDispatcher = 2;</code>
     * @return Whether the routerDispatcher field is set.
     */
    @java.lang.Override
    public boolean hasRouterDispatcher() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <code>optional string routerDispatcher = 2;</code>
     * @return The routerDispatcher.
     */
    @java.lang.Override
    public java.lang.String getRouterDispatcher() {
      java.lang.Object ref = routerDispatcher_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        org.apache.pekko.protobufv3.internal.ByteString bs = 
            (org.apache.pekko.protobufv3.internal.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          routerDispatcher_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string routerDispatcher = 2;</code>
     * @return The bytes for routerDispatcher.
     */
    @java.lang.Override
    public org.apache.pekko.protobufv3.internal.ByteString
        getRouterDispatcherBytes() {
      java.lang.Object ref = routerDispatcher_;
      if (ref instanceof java.lang.String) {
        org.apache.pekko.protobufv3.internal.ByteString b = 
            org.apache.pekko.protobufv3.internal.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        routerDispatcher_ = b;
        return b;
      } else {
        return (org.apache.pekko.protobufv3.internal.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (hasResizer()) {
        if (!getResizer().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(org.apache.pekko.protobufv3.internal.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getResizer());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        org.apache.pekko.protobufv3.internal.GeneratedMessage.writeString(output, 2, routerDispatcher_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeMessageSize(1, getResizer());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += org.apache.pekko.protobufv3.internal.GeneratedMessage.computeStringSize(2, routerDispatcher_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.pekko.remote.WireFormats.FromConfig)) {
        return super.equals(obj);
      }
      org.apache.pekko.remote.WireFormats.FromConfig other = (org.apache.pekko.remote.WireFormats.FromConfig) obj;

      if (hasResizer() != other.hasResizer()) return false;
      if (hasResizer()) {
        if (!getResizer()
            .equals(other.getResizer())) return false;
      }
      if (hasRouterDispatcher() != other.hasRouterDispatcher()) return false;
      if (hasRouterDispatcher()) {
        if (!getRouterDispatcher()
            .equals(other.getRouterDispatcher())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasResizer()) {
        hash = (37 * hash) + RESIZER_FIELD_NUMBER;
        hash = (53 * hash) + getResizer().hashCode();
      }
      if (hasRouterDispatcher()) {
        hash = (37 * hash) + ROUTERDISPATCHER_FIELD_NUMBER;
        hash = (53 * hash) + getRouterDispatcher().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.pekko.remote.WireFormats.FromConfig parseFrom(
        java.nio.ByteBuffer data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.remote.WireFormats.FromConfig parseFrom(
        java.nio.ByteBuffer data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.FromConfig parseFrom(
        org.apache.pekko.protobufv3.internal.ByteString data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.remote.WireFormats.FromConfig parseFrom(
        org.apache.pekko.protobufv3.internal.ByteString data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.FromConfig parseFrom(byte[] data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.remote.WireFormats.FromConfig parseFrom(
        byte[] data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.FromConfig parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.pekko.remote.WireFormats.FromConfig parseFrom(
        java.io.InputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static org.apache.pekko.remote.WireFormats.FromConfig parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static org.apache.pekko.remote.WireFormats.FromConfig parseDelimitedFrom(
        java.io.InputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.FromConfig parseFrom(
        org.apache.pekko.protobufv3.internal.CodedInputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.pekko.remote.WireFormats.FromConfig parseFrom(
        org.apache.pekko.protobufv3.internal.CodedInputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.pekko.remote.WireFormats.FromConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        org.apache.pekko.protobufv3.internal.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code FromConfig}
     */
    public static final class Builder extends
        org.apache.pekko.protobufv3.internal.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:FromConfig)
        org.apache.pekko.remote.WireFormats.FromConfigOrBuilder {
      public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.pekko.remote.WireFormats.internal_static_FromConfig_descriptor;
      }

      @java.lang.Override
      protected org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.pekko.remote.WireFormats.internal_static_FromConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.pekko.remote.WireFormats.FromConfig.class, org.apache.pekko.remote.WireFormats.FromConfig.Builder.class);
      }

      // Construct using org.apache.pekko.remote.WireFormats.FromConfig.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          org.apache.pekko.protobufv3.internal.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (org.apache.pekko.protobufv3.internal.GeneratedMessage
                .alwaysUseFieldBuilders) {
          internalGetResizerFieldBuilder();
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        resizer_ = null;
        if (resizerBuilder_ != null) {
          resizerBuilder_.dispose();
          resizerBuilder_ = null;
        }
        routerDispatcher_ = "";
        return this;
      }

      @java.lang.Override
      public org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.pekko.remote.WireFormats.internal_static_FromConfig_descriptor;
      }

      @java.lang.Override
      public org.apache.pekko.remote.WireFormats.FromConfig getDefaultInstanceForType() {
        return org.apache.pekko.remote.WireFormats.FromConfig.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.pekko.remote.WireFormats.FromConfig build() {
        org.apache.pekko.remote.WireFormats.FromConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.pekko.remote.WireFormats.FromConfig buildPartial() {
        org.apache.pekko.remote.WireFormats.FromConfig result = new org.apache.pekko.remote.WireFormats.FromConfig(this);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartial0(org.apache.pekko.remote.WireFormats.FromConfig result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.resizer_ = resizerBuilder_ == null
              ? resizer_
              : resizerBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.routerDispatcher_ = routerDispatcher_;
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder mergeFrom(org.apache.pekko.protobufv3.internal.Message other) {
        if (other instanceof org.apache.pekko.remote.WireFormats.FromConfig) {
          return mergeFrom((org.apache.pekko.remote.WireFormats.FromConfig)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.pekko.remote.WireFormats.FromConfig other) {
        if (other == org.apache.pekko.remote.WireFormats.FromConfig.getDefaultInstance()) return this;
        if (other.hasResizer()) {
          mergeResizer(other.getResizer());
        }
        if (other.hasRouterDispatcher()) {
          routerDispatcher_ = other.routerDispatcher_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        if (hasResizer()) {
          if (!getResizer().isInitialized()) {
            return false;
          }
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                input.readMessage(
                    internalGetResizerFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
              case 18: {
                routerDispatcher_ = input.readBytes();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private org.apache.pekko.remote.ContainerFormats.Payload resizer_;
      private org.apache.pekko.protobufv3.internal.SingleFieldBuilder<
          org.apache.pekko.remote.ContainerFormats.Payload, org.apache.pekko.remote.ContainerFormats.Payload.Builder, org.apache.pekko.remote.ContainerFormats.PayloadOrBuilder> resizerBuilder_;
      /**
       * <code>optional .Payload resizer = 1;</code>
       * @return Whether the resizer field is set.
       */
      public boolean hasResizer() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <code>optional .Payload resizer = 1;</code>
       * @return The resizer.
       */
      public org.apache.pekko.remote.ContainerFormats.Payload getResizer() {
        if (resizerBuilder_ == null) {
          return resizer_ == null ? org.apache.pekko.remote.ContainerFormats.Payload.getDefaultInstance() : resizer_;
        } else {
          return resizerBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .Payload resizer = 1;</code>
       */
      public Builder setResizer(org.apache.pekko.remote.ContainerFormats.Payload value) {
        if (resizerBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          resizer_ = value;
        } else {
          resizerBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <code>optional .Payload resizer = 1;</code>
       */
      public Builder setResizer(
          org.apache.pekko.remote.ContainerFormats.Payload.Builder builderForValue) {
        if (resizerBuilder_ == null) {
          resizer_ = builderForValue.build();
        } else {
          resizerBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <code>optional .Payload resizer = 1;</code>
       */
      public Builder mergeResizer(org.apache.pekko.remote.ContainerFormats.Payload value) {
        if (resizerBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0) &&
            resizer_ != null &&
            resizer_ != org.apache.pekko.remote.ContainerFormats.Payload.getDefaultInstance()) {
            getResizerBuilder().mergeFrom(value);
          } else {
            resizer_ = value;
          }
        } else {
          resizerBuilder_.mergeFrom(value);
        }
        if (resizer_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }
      /**
       * <code>optional .Payload resizer = 1;</code>
       */
      public Builder clearResizer() {
        bitField0_ = (bitField0_ & ~0x00000001);
        resizer_ = null;
        if (resizerBuilder_ != null) {
          resizerBuilder_.dispose();
          resizerBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <code>optional .Payload resizer = 1;</code>
       */
      public org.apache.pekko.remote.ContainerFormats.Payload.Builder getResizerBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return internalGetResizerFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .Payload resizer = 1;</code>
       */
      public org.apache.pekko.remote.ContainerFormats.PayloadOrBuilder getResizerOrBuilder() {
        if (resizerBuilder_ != null) {
          return resizerBuilder_.getMessageOrBuilder();
        } else {
          return resizer_ == null ?
              org.apache.pekko.remote.ContainerFormats.Payload.getDefaultInstance() : resizer_;
        }
      }
      /**
       * <code>optional .Payload resizer = 1;</code>
       */
      private org.apache.pekko.protobufv3.internal.SingleFieldBuilder<
          org.apache.pekko.remote.ContainerFormats.Payload, org.apache.pekko.remote.ContainerFormats.Payload.Builder, org.apache.pekko.remote.ContainerFormats.PayloadOrBuilder> 
          internalGetResizerFieldBuilder() {
        if (resizerBuilder_ == null) {
          resizerBuilder_ = new org.apache.pekko.protobufv3.internal.SingleFieldBuilder<
              org.apache.pekko.remote.ContainerFormats.Payload, org.apache.pekko.remote.ContainerFormats.Payload.Builder, org.apache.pekko.remote.ContainerFormats.PayloadOrBuilder>(
                  getResizer(),
                  getParentForChildren(),
                  isClean());
          resizer_ = null;
        }
        return resizerBuilder_;
      }

      private java.lang.Object routerDispatcher_ = "";
      /**
       * <code>optional string routerDispatcher = 2;</code>
       * @return Whether the routerDispatcher field is set.
       */
      public boolean hasRouterDispatcher() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <code>optional string routerDispatcher = 2;</code>
       * @return The routerDispatcher.
       */
      public java.lang.String getRouterDispatcher() {
        java.lang.Object ref = routerDispatcher_;
        if (!(ref instanceof java.lang.String)) {
          org.apache.pekko.protobufv3.internal.ByteString bs =
              (org.apache.pekko.protobufv3.internal.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            routerDispatcher_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string routerDispatcher = 2;</code>
       * @return The bytes for routerDispatcher.
       */
      public org.apache.pekko.protobufv3.internal.ByteString
          getRouterDispatcherBytes() {
        java.lang.Object ref = routerDispatcher_;
        if (ref instanceof String) {
          org.apache.pekko.protobufv3.internal.ByteString b = 
              org.apache.pekko.protobufv3.internal.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          routerDispatcher_ = b;
          return b;
        } else {
          return (org.apache.pekko.protobufv3.internal.ByteString) ref;
        }
      }
      /**
       * <code>optional string routerDispatcher = 2;</code>
       * @param value The routerDispatcher to set.
       * @return This builder for chaining.
       */
      public Builder setRouterDispatcher(
          java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        routerDispatcher_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <code>optional string routerDispatcher = 2;</code>
       * @return This builder for chaining.
       */
      public Builder clearRouterDispatcher() {
        routerDispatcher_ = getDefaultInstance().getRouterDispatcher();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       * <code>optional string routerDispatcher = 2;</code>
       * @param value The bytes for routerDispatcher to set.
       * @return This builder for chaining.
       */
      public Builder setRouterDispatcherBytes(
          org.apache.pekko.protobufv3.internal.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        routerDispatcher_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:FromConfig)
    }

    // @@protoc_insertion_point(class_scope:FromConfig)
    private static final org.apache.pekko.remote.WireFormats.FromConfig DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.pekko.remote.WireFormats.FromConfig();
    }

    public static org.apache.pekko.remote.WireFormats.FromConfig getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final org.apache.pekko.protobufv3.internal.Parser<FromConfig>
        PARSER = new org.apache.pekko.protobufv3.internal.AbstractParser<FromConfig>() {
      @java.lang.Override
      public FromConfig parsePartialFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (org.apache.pekko.protobufv3.internal.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static org.apache.pekko.protobufv3.internal.Parser<FromConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.pekko.protobufv3.internal.Parser<FromConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.pekko.remote.WireFormats.FromConfig getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface GenericRoutingPoolOrBuilder extends
      // @@protoc_insertion_point(interface_extends:GenericRoutingPool)
      org.apache.pekko.protobufv3.internal.MessageOrBuilder {

    /**
     * <code>required uint32 nrOfInstances = 1;</code>
     * @return Whether the nrOfInstances field is set.
     */
    boolean hasNrOfInstances();
    /**
     * <code>required uint32 nrOfInstances = 1;</code>
     * @return The nrOfInstances.
     */
    int getNrOfInstances();

    /**
     * <code>optional string routerDispatcher = 2;</code>
     * @return Whether the routerDispatcher field is set.
     */
    boolean hasRouterDispatcher();
    /**
     * <code>optional string routerDispatcher = 2;</code>
     * @return The routerDispatcher.
     */
    java.lang.String getRouterDispatcher();
    /**
     * <code>optional string routerDispatcher = 2;</code>
     * @return The bytes for routerDispatcher.
     */
    org.apache.pekko.protobufv3.internal.ByteString
        getRouterDispatcherBytes();

    /**
     * <code>required bool usePoolDispatcher = 3;</code>
     * @return Whether the usePoolDispatcher field is set.
     */
    boolean hasUsePoolDispatcher();
    /**
     * <code>required bool usePoolDispatcher = 3;</code>
     * @return The usePoolDispatcher.
     */
    boolean getUsePoolDispatcher();

    /**
     * <code>optional .Payload resizer = 4;</code>
     * @return Whether the resizer field is set.
     */
    boolean hasResizer();
    /**
     * <code>optional .Payload resizer = 4;</code>
     * @return The resizer.
     */
    org.apache.pekko.remote.ContainerFormats.Payload getResizer();
    /**
     * <code>optional .Payload resizer = 4;</code>
     */
    org.apache.pekko.remote.ContainerFormats.PayloadOrBuilder getResizerOrBuilder();
  }
  /**
   * Protobuf type {@code GenericRoutingPool}
   */
  public static final class GenericRoutingPool extends
      org.apache.pekko.protobufv3.internal.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:GenericRoutingPool)
      GenericRoutingPoolOrBuilder {
  private static final long serialVersionUID = 0L;
    static {
      org.apache.pekko.protobufv3.internal.RuntimeVersion.validateProtobufGencodeVersion(
        org.apache.pekko.protobufv3.internal.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 32,
        /* patch= */ 0,
        /* suffix= */ "",
        GenericRoutingPool.class.getName());
    }
    // Use GenericRoutingPool.newBuilder() to construct.
    private GenericRoutingPool(org.apache.pekko.protobufv3.internal.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }
    private GenericRoutingPool() {
      routerDispatcher_ = "";
    }

    public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.pekko.remote.WireFormats.internal_static_GenericRoutingPool_descriptor;
    }

    @java.lang.Override
    protected org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.pekko.remote.WireFormats.internal_static_GenericRoutingPool_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.pekko.remote.WireFormats.GenericRoutingPool.class, org.apache.pekko.remote.WireFormats.GenericRoutingPool.Builder.class);
    }

    private int bitField0_;
    public static final int NROFINSTANCES_FIELD_NUMBER = 1;
    private int nrOfInstances_ = 0;
    /**
     * <code>required uint32 nrOfInstances = 1;</code>
     * @return Whether the nrOfInstances field is set.
     */
    @java.lang.Override
    public boolean hasNrOfInstances() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <code>required uint32 nrOfInstances = 1;</code>
     * @return The nrOfInstances.
     */
    @java.lang.Override
    public int getNrOfInstances() {
      return nrOfInstances_;
    }

    public static final int ROUTERDISPATCHER_FIELD_NUMBER = 2;
    @SuppressWarnings("serial")
    private volatile java.lang.Object routerDispatcher_ = "";
    /**
     * <code>optional string routerDispatcher = 2;</code>
     * @return Whether the routerDispatcher field is set.
     */
    @java.lang.Override
    public boolean hasRouterDispatcher() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <code>optional string routerDispatcher = 2;</code>
     * @return The routerDispatcher.
     */
    @java.lang.Override
    public java.lang.String getRouterDispatcher() {
      java.lang.Object ref = routerDispatcher_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        org.apache.pekko.protobufv3.internal.ByteString bs = 
            (org.apache.pekko.protobufv3.internal.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          routerDispatcher_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string routerDispatcher = 2;</code>
     * @return The bytes for routerDispatcher.
     */
    @java.lang.Override
    public org.apache.pekko.protobufv3.internal.ByteString
        getRouterDispatcherBytes() {
      java.lang.Object ref = routerDispatcher_;
      if (ref instanceof java.lang.String) {
        org.apache.pekko.protobufv3.internal.ByteString b = 
            org.apache.pekko.protobufv3.internal.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        routerDispatcher_ = b;
        return b;
      } else {
        return (org.apache.pekko.protobufv3.internal.ByteString) ref;
      }
    }

    public static final int USEPOOLDISPATCHER_FIELD_NUMBER = 3;
    private boolean usePoolDispatcher_ = false;
    /**
     * <code>required bool usePoolDispatcher = 3;</code>
     * @return Whether the usePoolDispatcher field is set.
     */
    @java.lang.Override
    public boolean hasUsePoolDispatcher() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     * <code>required bool usePoolDispatcher = 3;</code>
     * @return The usePoolDispatcher.
     */
    @java.lang.Override
    public boolean getUsePoolDispatcher() {
      return usePoolDispatcher_;
    }

    public static final int RESIZER_FIELD_NUMBER = 4;
    private org.apache.pekko.remote.ContainerFormats.Payload resizer_;
    /**
     * <code>optional .Payload resizer = 4;</code>
     * @return Whether the resizer field is set.
     */
    @java.lang.Override
    public boolean hasResizer() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     * <code>optional .Payload resizer = 4;</code>
     * @return The resizer.
     */
    @java.lang.Override
    public org.apache.pekko.remote.ContainerFormats.Payload getResizer() {
      return resizer_ == null ? org.apache.pekko.remote.ContainerFormats.Payload.getDefaultInstance() : resizer_;
    }
    /**
     * <code>optional .Payload resizer = 4;</code>
     */
    @java.lang.Override
    public org.apache.pekko.remote.ContainerFormats.PayloadOrBuilder getResizerOrBuilder() {
      return resizer_ == null ? org.apache.pekko.remote.ContainerFormats.Payload.getDefaultInstance() : resizer_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasNrOfInstances()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!hasUsePoolDispatcher()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (hasResizer()) {
        if (!getResizer().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(org.apache.pekko.protobufv3.internal.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeUInt32(1, nrOfInstances_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        org.apache.pekko.protobufv3.internal.GeneratedMessage.writeString(output, 2, routerDispatcher_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        output.writeBool(3, usePoolDispatcher_);
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        output.writeMessage(4, getResizer());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeUInt32Size(1, nrOfInstances_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += org.apache.pekko.protobufv3.internal.GeneratedMessage.computeStringSize(2, routerDispatcher_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeBoolSize(3, usePoolDispatcher_);
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeMessageSize(4, getResizer());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.pekko.remote.WireFormats.GenericRoutingPool)) {
        return super.equals(obj);
      }
      org.apache.pekko.remote.WireFormats.GenericRoutingPool other = (org.apache.pekko.remote.WireFormats.GenericRoutingPool) obj;

      if (hasNrOfInstances() != other.hasNrOfInstances()) return false;
      if (hasNrOfInstances()) {
        if (getNrOfInstances()
            != other.getNrOfInstances()) return false;
      }
      if (hasRouterDispatcher() != other.hasRouterDispatcher()) return false;
      if (hasRouterDispatcher()) {
        if (!getRouterDispatcher()
            .equals(other.getRouterDispatcher())) return false;
      }
      if (hasUsePoolDispatcher() != other.hasUsePoolDispatcher()) return false;
      if (hasUsePoolDispatcher()) {
        if (getUsePoolDispatcher()
            != other.getUsePoolDispatcher()) return false;
      }
      if (hasResizer() != other.hasResizer()) return false;
      if (hasResizer()) {
        if (!getResizer()
            .equals(other.getResizer())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasNrOfInstances()) {
        hash = (37 * hash) + NROFINSTANCES_FIELD_NUMBER;
        hash = (53 * hash) + getNrOfInstances();
      }
      if (hasRouterDispatcher()) {
        hash = (37 * hash) + ROUTERDISPATCHER_FIELD_NUMBER;
        hash = (53 * hash) + getRouterDispatcher().hashCode();
      }
      if (hasUsePoolDispatcher()) {
        hash = (37 * hash) + USEPOOLDISPATCHER_FIELD_NUMBER;
        hash = (53 * hash) + org.apache.pekko.protobufv3.internal.Internal.hashBoolean(
            getUsePoolDispatcher());
      }
      if (hasResizer()) {
        hash = (37 * hash) + RESIZER_FIELD_NUMBER;
        hash = (53 * hash) + getResizer().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.pekko.remote.WireFormats.GenericRoutingPool parseFrom(
        java.nio.ByteBuffer data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.remote.WireFormats.GenericRoutingPool parseFrom(
        java.nio.ByteBuffer data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.GenericRoutingPool parseFrom(
        org.apache.pekko.protobufv3.internal.ByteString data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.remote.WireFormats.GenericRoutingPool parseFrom(
        org.apache.pekko.protobufv3.internal.ByteString data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.GenericRoutingPool parseFrom(byte[] data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.remote.WireFormats.GenericRoutingPool parseFrom(
        byte[] data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.GenericRoutingPool parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.pekko.remote.WireFormats.GenericRoutingPool parseFrom(
        java.io.InputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static org.apache.pekko.remote.WireFormats.GenericRoutingPool parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static org.apache.pekko.remote.WireFormats.GenericRoutingPool parseDelimitedFrom(
        java.io.InputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.GenericRoutingPool parseFrom(
        org.apache.pekko.protobufv3.internal.CodedInputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.pekko.remote.WireFormats.GenericRoutingPool parseFrom(
        org.apache.pekko.protobufv3.internal.CodedInputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.pekko.remote.WireFormats.GenericRoutingPool prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        org.apache.pekko.protobufv3.internal.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code GenericRoutingPool}
     */
    public static final class Builder extends
        org.apache.pekko.protobufv3.internal.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:GenericRoutingPool)
        org.apache.pekko.remote.WireFormats.GenericRoutingPoolOrBuilder {
      public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.pekko.remote.WireFormats.internal_static_GenericRoutingPool_descriptor;
      }

      @java.lang.Override
      protected org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.pekko.remote.WireFormats.internal_static_GenericRoutingPool_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.pekko.remote.WireFormats.GenericRoutingPool.class, org.apache.pekko.remote.WireFormats.GenericRoutingPool.Builder.class);
      }

      // Construct using org.apache.pekko.remote.WireFormats.GenericRoutingPool.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          org.apache.pekko.protobufv3.internal.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (org.apache.pekko.protobufv3.internal.GeneratedMessage
                .alwaysUseFieldBuilders) {
          internalGetResizerFieldBuilder();
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        nrOfInstances_ = 0;
        routerDispatcher_ = "";
        usePoolDispatcher_ = false;
        resizer_ = null;
        if (resizerBuilder_ != null) {
          resizerBuilder_.dispose();
          resizerBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.pekko.remote.WireFormats.internal_static_GenericRoutingPool_descriptor;
      }

      @java.lang.Override
      public org.apache.pekko.remote.WireFormats.GenericRoutingPool getDefaultInstanceForType() {
        return org.apache.pekko.remote.WireFormats.GenericRoutingPool.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.pekko.remote.WireFormats.GenericRoutingPool build() {
        org.apache.pekko.remote.WireFormats.GenericRoutingPool result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.pekko.remote.WireFormats.GenericRoutingPool buildPartial() {
        org.apache.pekko.remote.WireFormats.GenericRoutingPool result = new org.apache.pekko.remote.WireFormats.GenericRoutingPool(this);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartial0(org.apache.pekko.remote.WireFormats.GenericRoutingPool result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.nrOfInstances_ = nrOfInstances_;
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.routerDispatcher_ = routerDispatcher_;
          to_bitField0_ |= 0x00000002;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.usePoolDispatcher_ = usePoolDispatcher_;
          to_bitField0_ |= 0x00000004;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.resizer_ = resizerBuilder_ == null
              ? resizer_
              : resizerBuilder_.build();
          to_bitField0_ |= 0x00000008;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder mergeFrom(org.apache.pekko.protobufv3.internal.Message other) {
        if (other instanceof org.apache.pekko.remote.WireFormats.GenericRoutingPool) {
          return mergeFrom((org.apache.pekko.remote.WireFormats.GenericRoutingPool)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.pekko.remote.WireFormats.GenericRoutingPool other) {
        if (other == org.apache.pekko.remote.WireFormats.GenericRoutingPool.getDefaultInstance()) return this;
        if (other.hasNrOfInstances()) {
          setNrOfInstances(other.getNrOfInstances());
        }
        if (other.hasRouterDispatcher()) {
          routerDispatcher_ = other.routerDispatcher_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (other.hasUsePoolDispatcher()) {
          setUsePoolDispatcher(other.getUsePoolDispatcher());
        }
        if (other.hasResizer()) {
          mergeResizer(other.getResizer());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        if (!hasNrOfInstances()) {
          return false;
        }
        if (!hasUsePoolDispatcher()) {
          return false;
        }
        if (hasResizer()) {
          if (!getResizer().isInitialized()) {
            return false;
          }
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8: {
                nrOfInstances_ = input.readUInt32();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
              case 18: {
                routerDispatcher_ = input.readBytes();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
              case 24: {
                usePoolDispatcher_ = input.readBool();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
              case 34: {
                input.readMessage(
                    internalGetResizerFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private int nrOfInstances_ ;
      /**
       * <code>required uint32 nrOfInstances = 1;</code>
       * @return Whether the nrOfInstances field is set.
       */
      @java.lang.Override
      public boolean hasNrOfInstances() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <code>required uint32 nrOfInstances = 1;</code>
       * @return The nrOfInstances.
       */
      @java.lang.Override
      public int getNrOfInstances() {
        return nrOfInstances_;
      }
      /**
       * <code>required uint32 nrOfInstances = 1;</code>
       * @param value The nrOfInstances to set.
       * @return This builder for chaining.
       */
      public Builder setNrOfInstances(int value) {

        nrOfInstances_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <code>required uint32 nrOfInstances = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearNrOfInstances() {
        bitField0_ = (bitField0_ & ~0x00000001);
        nrOfInstances_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object routerDispatcher_ = "";
      /**
       * <code>optional string routerDispatcher = 2;</code>
       * @return Whether the routerDispatcher field is set.
       */
      public boolean hasRouterDispatcher() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <code>optional string routerDispatcher = 2;</code>
       * @return The routerDispatcher.
       */
      public java.lang.String getRouterDispatcher() {
        java.lang.Object ref = routerDispatcher_;
        if (!(ref instanceof java.lang.String)) {
          org.apache.pekko.protobufv3.internal.ByteString bs =
              (org.apache.pekko.protobufv3.internal.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            routerDispatcher_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string routerDispatcher = 2;</code>
       * @return The bytes for routerDispatcher.
       */
      public org.apache.pekko.protobufv3.internal.ByteString
          getRouterDispatcherBytes() {
        java.lang.Object ref = routerDispatcher_;
        if (ref instanceof String) {
          org.apache.pekko.protobufv3.internal.ByteString b = 
              org.apache.pekko.protobufv3.internal.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          routerDispatcher_ = b;
          return b;
        } else {
          return (org.apache.pekko.protobufv3.internal.ByteString) ref;
        }
      }
      /**
       * <code>optional string routerDispatcher = 2;</code>
       * @param value The routerDispatcher to set.
       * @return This builder for chaining.
       */
      public Builder setRouterDispatcher(
          java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        routerDispatcher_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <code>optional string routerDispatcher = 2;</code>
       * @return This builder for chaining.
       */
      public Builder clearRouterDispatcher() {
        routerDispatcher_ = getDefaultInstance().getRouterDispatcher();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       * <code>optional string routerDispatcher = 2;</code>
       * @param value The bytes for routerDispatcher to set.
       * @return This builder for chaining.
       */
      public Builder setRouterDispatcherBytes(
          org.apache.pekko.protobufv3.internal.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        routerDispatcher_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private boolean usePoolDispatcher_ ;
      /**
       * <code>required bool usePoolDispatcher = 3;</code>
       * @return Whether the usePoolDispatcher field is set.
       */
      @java.lang.Override
      public boolean hasUsePoolDispatcher() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       * <code>required bool usePoolDispatcher = 3;</code>
       * @return The usePoolDispatcher.
       */
      @java.lang.Override
      public boolean getUsePoolDispatcher() {
        return usePoolDispatcher_;
      }
      /**
       * <code>required bool usePoolDispatcher = 3;</code>
       * @param value The usePoolDispatcher to set.
       * @return This builder for chaining.
       */
      public Builder setUsePoolDispatcher(boolean value) {

        usePoolDispatcher_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       * <code>required bool usePoolDispatcher = 3;</code>
       * @return This builder for chaining.
       */
      public Builder clearUsePoolDispatcher() {
        bitField0_ = (bitField0_ & ~0x00000004);
        usePoolDispatcher_ = false;
        onChanged();
        return this;
      }

      private org.apache.pekko.remote.ContainerFormats.Payload resizer_;
      private org.apache.pekko.protobufv3.internal.SingleFieldBuilder<
          org.apache.pekko.remote.ContainerFormats.Payload, org.apache.pekko.remote.ContainerFormats.Payload.Builder, org.apache.pekko.remote.ContainerFormats.PayloadOrBuilder> resizerBuilder_;
      /**
       * <code>optional .Payload resizer = 4;</code>
       * @return Whether the resizer field is set.
       */
      public boolean hasResizer() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       * <code>optional .Payload resizer = 4;</code>
       * @return The resizer.
       */
      public org.apache.pekko.remote.ContainerFormats.Payload getResizer() {
        if (resizerBuilder_ == null) {
          return resizer_ == null ? org.apache.pekko.remote.ContainerFormats.Payload.getDefaultInstance() : resizer_;
        } else {
          return resizerBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .Payload resizer = 4;</code>
       */
      public Builder setResizer(org.apache.pekko.remote.ContainerFormats.Payload value) {
        if (resizerBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          resizer_ = value;
        } else {
          resizerBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       * <code>optional .Payload resizer = 4;</code>
       */
      public Builder setResizer(
          org.apache.pekko.remote.ContainerFormats.Payload.Builder builderForValue) {
        if (resizerBuilder_ == null) {
          resizer_ = builderForValue.build();
        } else {
          resizerBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       * <code>optional .Payload resizer = 4;</code>
       */
      public Builder mergeResizer(org.apache.pekko.remote.ContainerFormats.Payload value) {
        if (resizerBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0) &&
            resizer_ != null &&
            resizer_ != org.apache.pekko.remote.ContainerFormats.Payload.getDefaultInstance()) {
            getResizerBuilder().mergeFrom(value);
          } else {
            resizer_ = value;
          }
        } else {
          resizerBuilder_.mergeFrom(value);
        }
        if (resizer_ != null) {
          bitField0_ |= 0x00000008;
          onChanged();
        }
        return this;
      }
      /**
       * <code>optional .Payload resizer = 4;</code>
       */
      public Builder clearResizer() {
        bitField0_ = (bitField0_ & ~0x00000008);
        resizer_ = null;
        if (resizerBuilder_ != null) {
          resizerBuilder_.dispose();
          resizerBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <code>optional .Payload resizer = 4;</code>
       */
      public org.apache.pekko.remote.ContainerFormats.Payload.Builder getResizerBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return internalGetResizerFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .Payload resizer = 4;</code>
       */
      public org.apache.pekko.remote.ContainerFormats.PayloadOrBuilder getResizerOrBuilder() {
        if (resizerBuilder_ != null) {
          return resizerBuilder_.getMessageOrBuilder();
        } else {
          return resizer_ == null ?
              org.apache.pekko.remote.ContainerFormats.Payload.getDefaultInstance() : resizer_;
        }
      }
      /**
       * <code>optional .Payload resizer = 4;</code>
       */
      private org.apache.pekko.protobufv3.internal.SingleFieldBuilder<
          org.apache.pekko.remote.ContainerFormats.Payload, org.apache.pekko.remote.ContainerFormats.Payload.Builder, org.apache.pekko.remote.ContainerFormats.PayloadOrBuilder> 
          internalGetResizerFieldBuilder() {
        if (resizerBuilder_ == null) {
          resizerBuilder_ = new org.apache.pekko.protobufv3.internal.SingleFieldBuilder<
              org.apache.pekko.remote.ContainerFormats.Payload, org.apache.pekko.remote.ContainerFormats.Payload.Builder, org.apache.pekko.remote.ContainerFormats.PayloadOrBuilder>(
                  getResizer(),
                  getParentForChildren(),
                  isClean());
          resizer_ = null;
        }
        return resizerBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:GenericRoutingPool)
    }

    // @@protoc_insertion_point(class_scope:GenericRoutingPool)
    private static final org.apache.pekko.remote.WireFormats.GenericRoutingPool DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.pekko.remote.WireFormats.GenericRoutingPool();
    }

    public static org.apache.pekko.remote.WireFormats.GenericRoutingPool getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final org.apache.pekko.protobufv3.internal.Parser<GenericRoutingPool>
        PARSER = new org.apache.pekko.protobufv3.internal.AbstractParser<GenericRoutingPool>() {
      @java.lang.Override
      public GenericRoutingPool parsePartialFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (org.apache.pekko.protobufv3.internal.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static org.apache.pekko.protobufv3.internal.Parser<GenericRoutingPool> parser() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.pekko.protobufv3.internal.Parser<GenericRoutingPool> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.pekko.remote.WireFormats.GenericRoutingPool getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface ScatterGatherPoolOrBuilder extends
      // @@protoc_insertion_point(interface_extends:ScatterGatherPool)
      org.apache.pekko.protobufv3.internal.MessageOrBuilder {

    /**
     * <code>required .GenericRoutingPool generic = 1;</code>
     * @return Whether the generic field is set.
     */
    boolean hasGeneric();
    /**
     * <code>required .GenericRoutingPool generic = 1;</code>
     * @return The generic.
     */
    org.apache.pekko.remote.WireFormats.GenericRoutingPool getGeneric();
    /**
     * <code>required .GenericRoutingPool generic = 1;</code>
     */
    org.apache.pekko.remote.WireFormats.GenericRoutingPoolOrBuilder getGenericOrBuilder();

    /**
     * <code>required .FiniteDuration within = 2;</code>
     * @return Whether the within field is set.
     */
    boolean hasWithin();
    /**
     * <code>required .FiniteDuration within = 2;</code>
     * @return The within.
     */
    org.apache.pekko.remote.WireFormats.FiniteDuration getWithin();
    /**
     * <code>required .FiniteDuration within = 2;</code>
     */
    org.apache.pekko.remote.WireFormats.FiniteDurationOrBuilder getWithinOrBuilder();
  }
  /**
   * Protobuf type {@code ScatterGatherPool}
   */
  public static final class ScatterGatherPool extends
      org.apache.pekko.protobufv3.internal.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:ScatterGatherPool)
      ScatterGatherPoolOrBuilder {
  private static final long serialVersionUID = 0L;
    static {
      org.apache.pekko.protobufv3.internal.RuntimeVersion.validateProtobufGencodeVersion(
        org.apache.pekko.protobufv3.internal.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 32,
        /* patch= */ 0,
        /* suffix= */ "",
        ScatterGatherPool.class.getName());
    }
    // Use ScatterGatherPool.newBuilder() to construct.
    private ScatterGatherPool(org.apache.pekko.protobufv3.internal.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }
    private ScatterGatherPool() {
    }

    public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.pekko.remote.WireFormats.internal_static_ScatterGatherPool_descriptor;
    }

    @java.lang.Override
    protected org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.pekko.remote.WireFormats.internal_static_ScatterGatherPool_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.pekko.remote.WireFormats.ScatterGatherPool.class, org.apache.pekko.remote.WireFormats.ScatterGatherPool.Builder.class);
    }

    private int bitField0_;
    public static final int GENERIC_FIELD_NUMBER = 1;
    private org.apache.pekko.remote.WireFormats.GenericRoutingPool generic_;
    /**
     * <code>required .GenericRoutingPool generic = 1;</code>
     * @return Whether the generic field is set.
     */
    @java.lang.Override
    public boolean hasGeneric() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <code>required .GenericRoutingPool generic = 1;</code>
     * @return The generic.
     */
    @java.lang.Override
    public org.apache.pekko.remote.WireFormats.GenericRoutingPool getGeneric() {
      return generic_ == null ? org.apache.pekko.remote.WireFormats.GenericRoutingPool.getDefaultInstance() : generic_;
    }
    /**
     * <code>required .GenericRoutingPool generic = 1;</code>
     */
    @java.lang.Override
    public org.apache.pekko.remote.WireFormats.GenericRoutingPoolOrBuilder getGenericOrBuilder() {
      return generic_ == null ? org.apache.pekko.remote.WireFormats.GenericRoutingPool.getDefaultInstance() : generic_;
    }

    public static final int WITHIN_FIELD_NUMBER = 2;
    private org.apache.pekko.remote.WireFormats.FiniteDuration within_;
    /**
     * <code>required .FiniteDuration within = 2;</code>
     * @return Whether the within field is set.
     */
    @java.lang.Override
    public boolean hasWithin() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <code>required .FiniteDuration within = 2;</code>
     * @return The within.
     */
    @java.lang.Override
    public org.apache.pekko.remote.WireFormats.FiniteDuration getWithin() {
      return within_ == null ? org.apache.pekko.remote.WireFormats.FiniteDuration.getDefaultInstance() : within_;
    }
    /**
     * <code>required .FiniteDuration within = 2;</code>
     */
    @java.lang.Override
    public org.apache.pekko.remote.WireFormats.FiniteDurationOrBuilder getWithinOrBuilder() {
      return within_ == null ? org.apache.pekko.remote.WireFormats.FiniteDuration.getDefaultInstance() : within_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasGeneric()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!hasWithin()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!getGeneric().isInitialized()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!getWithin().isInitialized()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(org.apache.pekko.protobufv3.internal.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getGeneric());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(2, getWithin());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeMessageSize(1, getGeneric());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeMessageSize(2, getWithin());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.pekko.remote.WireFormats.ScatterGatherPool)) {
        return super.equals(obj);
      }
      org.apache.pekko.remote.WireFormats.ScatterGatherPool other = (org.apache.pekko.remote.WireFormats.ScatterGatherPool) obj;

      if (hasGeneric() != other.hasGeneric()) return false;
      if (hasGeneric()) {
        if (!getGeneric()
            .equals(other.getGeneric())) return false;
      }
      if (hasWithin() != other.hasWithin()) return false;
      if (hasWithin()) {
        if (!getWithin()
            .equals(other.getWithin())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasGeneric()) {
        hash = (37 * hash) + GENERIC_FIELD_NUMBER;
        hash = (53 * hash) + getGeneric().hashCode();
      }
      if (hasWithin()) {
        hash = (37 * hash) + WITHIN_FIELD_NUMBER;
        hash = (53 * hash) + getWithin().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.pekko.remote.WireFormats.ScatterGatherPool parseFrom(
        java.nio.ByteBuffer data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.remote.WireFormats.ScatterGatherPool parseFrom(
        java.nio.ByteBuffer data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.ScatterGatherPool parseFrom(
        org.apache.pekko.protobufv3.internal.ByteString data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.remote.WireFormats.ScatterGatherPool parseFrom(
        org.apache.pekko.protobufv3.internal.ByteString data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.ScatterGatherPool parseFrom(byte[] data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.remote.WireFormats.ScatterGatherPool parseFrom(
        byte[] data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.ScatterGatherPool parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.pekko.remote.WireFormats.ScatterGatherPool parseFrom(
        java.io.InputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static org.apache.pekko.remote.WireFormats.ScatterGatherPool parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static org.apache.pekko.remote.WireFormats.ScatterGatherPool parseDelimitedFrom(
        java.io.InputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.ScatterGatherPool parseFrom(
        org.apache.pekko.protobufv3.internal.CodedInputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.pekko.remote.WireFormats.ScatterGatherPool parseFrom(
        org.apache.pekko.protobufv3.internal.CodedInputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.pekko.remote.WireFormats.ScatterGatherPool prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        org.apache.pekko.protobufv3.internal.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code ScatterGatherPool}
     */
    public static final class Builder extends
        org.apache.pekko.protobufv3.internal.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:ScatterGatherPool)
        org.apache.pekko.remote.WireFormats.ScatterGatherPoolOrBuilder {
      public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.pekko.remote.WireFormats.internal_static_ScatterGatherPool_descriptor;
      }

      @java.lang.Override
      protected org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.pekko.remote.WireFormats.internal_static_ScatterGatherPool_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.pekko.remote.WireFormats.ScatterGatherPool.class, org.apache.pekko.remote.WireFormats.ScatterGatherPool.Builder.class);
      }

      // Construct using org.apache.pekko.remote.WireFormats.ScatterGatherPool.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          org.apache.pekko.protobufv3.internal.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (org.apache.pekko.protobufv3.internal.GeneratedMessage
                .alwaysUseFieldBuilders) {
          internalGetGenericFieldBuilder();
          internalGetWithinFieldBuilder();
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        generic_ = null;
        if (genericBuilder_ != null) {
          genericBuilder_.dispose();
          genericBuilder_ = null;
        }
        within_ = null;
        if (withinBuilder_ != null) {
          withinBuilder_.dispose();
          withinBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.pekko.remote.WireFormats.internal_static_ScatterGatherPool_descriptor;
      }

      @java.lang.Override
      public org.apache.pekko.remote.WireFormats.ScatterGatherPool getDefaultInstanceForType() {
        return org.apache.pekko.remote.WireFormats.ScatterGatherPool.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.pekko.remote.WireFormats.ScatterGatherPool build() {
        org.apache.pekko.remote.WireFormats.ScatterGatherPool result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.pekko.remote.WireFormats.ScatterGatherPool buildPartial() {
        org.apache.pekko.remote.WireFormats.ScatterGatherPool result = new org.apache.pekko.remote.WireFormats.ScatterGatherPool(this);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartial0(org.apache.pekko.remote.WireFormats.ScatterGatherPool result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.generic_ = genericBuilder_ == null
              ? generic_
              : genericBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.within_ = withinBuilder_ == null
              ? within_
              : withinBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder mergeFrom(org.apache.pekko.protobufv3.internal.Message other) {
        if (other instanceof org.apache.pekko.remote.WireFormats.ScatterGatherPool) {
          return mergeFrom((org.apache.pekko.remote.WireFormats.ScatterGatherPool)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.pekko.remote.WireFormats.ScatterGatherPool other) {
        if (other == org.apache.pekko.remote.WireFormats.ScatterGatherPool.getDefaultInstance()) return this;
        if (other.hasGeneric()) {
          mergeGeneric(other.getGeneric());
        }
        if (other.hasWithin()) {
          mergeWithin(other.getWithin());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        if (!hasGeneric()) {
          return false;
        }
        if (!hasWithin()) {
          return false;
        }
        if (!getGeneric().isInitialized()) {
          return false;
        }
        if (!getWithin().isInitialized()) {
          return false;
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                input.readMessage(
                    internalGetGenericFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
              case 18: {
                input.readMessage(
                    internalGetWithinFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private org.apache.pekko.remote.WireFormats.GenericRoutingPool generic_;
      private org.apache.pekko.protobufv3.internal.SingleFieldBuilder<
          org.apache.pekko.remote.WireFormats.GenericRoutingPool, org.apache.pekko.remote.WireFormats.GenericRoutingPool.Builder, org.apache.pekko.remote.WireFormats.GenericRoutingPoolOrBuilder> genericBuilder_;
      /**
       * <code>required .GenericRoutingPool generic = 1;</code>
       * @return Whether the generic field is set.
       */
      public boolean hasGeneric() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <code>required .GenericRoutingPool generic = 1;</code>
       * @return The generic.
       */
      public org.apache.pekko.remote.WireFormats.GenericRoutingPool getGeneric() {
        if (genericBuilder_ == null) {
          return generic_ == null ? org.apache.pekko.remote.WireFormats.GenericRoutingPool.getDefaultInstance() : generic_;
        } else {
          return genericBuilder_.getMessage();
        }
      }
      /**
       * <code>required .GenericRoutingPool generic = 1;</code>
       */
      public Builder setGeneric(org.apache.pekko.remote.WireFormats.GenericRoutingPool value) {
        if (genericBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          generic_ = value;
        } else {
          genericBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <code>required .GenericRoutingPool generic = 1;</code>
       */
      public Builder setGeneric(
          org.apache.pekko.remote.WireFormats.GenericRoutingPool.Builder builderForValue) {
        if (genericBuilder_ == null) {
          generic_ = builderForValue.build();
        } else {
          genericBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <code>required .GenericRoutingPool generic = 1;</code>
       */
      public Builder mergeGeneric(org.apache.pekko.remote.WireFormats.GenericRoutingPool value) {
        if (genericBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0) &&
            generic_ != null &&
            generic_ != org.apache.pekko.remote.WireFormats.GenericRoutingPool.getDefaultInstance()) {
            getGenericBuilder().mergeFrom(value);
          } else {
            generic_ = value;
          }
        } else {
          genericBuilder_.mergeFrom(value);
        }
        if (generic_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }
      /**
       * <code>required .GenericRoutingPool generic = 1;</code>
       */
      public Builder clearGeneric() {
        bitField0_ = (bitField0_ & ~0x00000001);
        generic_ = null;
        if (genericBuilder_ != null) {
          genericBuilder_.dispose();
          genericBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <code>required .GenericRoutingPool generic = 1;</code>
       */
      public org.apache.pekko.remote.WireFormats.GenericRoutingPool.Builder getGenericBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return internalGetGenericFieldBuilder().getBuilder();
      }
      /**
       * <code>required .GenericRoutingPool generic = 1;</code>
       */
      public org.apache.pekko.remote.WireFormats.GenericRoutingPoolOrBuilder getGenericOrBuilder() {
        if (genericBuilder_ != null) {
          return genericBuilder_.getMessageOrBuilder();
        } else {
          return generic_ == null ?
              org.apache.pekko.remote.WireFormats.GenericRoutingPool.getDefaultInstance() : generic_;
        }
      }
      /**
       * <code>required .GenericRoutingPool generic = 1;</code>
       */
      private org.apache.pekko.protobufv3.internal.SingleFieldBuilder<
          org.apache.pekko.remote.WireFormats.GenericRoutingPool, org.apache.pekko.remote.WireFormats.GenericRoutingPool.Builder, org.apache.pekko.remote.WireFormats.GenericRoutingPoolOrBuilder> 
          internalGetGenericFieldBuilder() {
        if (genericBuilder_ == null) {
          genericBuilder_ = new org.apache.pekko.protobufv3.internal.SingleFieldBuilder<
              org.apache.pekko.remote.WireFormats.GenericRoutingPool, org.apache.pekko.remote.WireFormats.GenericRoutingPool.Builder, org.apache.pekko.remote.WireFormats.GenericRoutingPoolOrBuilder>(
                  getGeneric(),
                  getParentForChildren(),
                  isClean());
          generic_ = null;
        }
        return genericBuilder_;
      }

      private org.apache.pekko.remote.WireFormats.FiniteDuration within_;
      private org.apache.pekko.protobufv3.internal.SingleFieldBuilder<
          org.apache.pekko.remote.WireFormats.FiniteDuration, org.apache.pekko.remote.WireFormats.FiniteDuration.Builder, org.apache.pekko.remote.WireFormats.FiniteDurationOrBuilder> withinBuilder_;
      /**
       * <code>required .FiniteDuration within = 2;</code>
       * @return Whether the within field is set.
       */
      public boolean hasWithin() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <code>required .FiniteDuration within = 2;</code>
       * @return The within.
       */
      public org.apache.pekko.remote.WireFormats.FiniteDuration getWithin() {
        if (withinBuilder_ == null) {
          return within_ == null ? org.apache.pekko.remote.WireFormats.FiniteDuration.getDefaultInstance() : within_;
        } else {
          return withinBuilder_.getMessage();
        }
      }
      /**
       * <code>required .FiniteDuration within = 2;</code>
       */
      public Builder setWithin(org.apache.pekko.remote.WireFormats.FiniteDuration value) {
        if (withinBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          within_ = value;
        } else {
          withinBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <code>required .FiniteDuration within = 2;</code>
       */
      public Builder setWithin(
          org.apache.pekko.remote.WireFormats.FiniteDuration.Builder builderForValue) {
        if (withinBuilder_ == null) {
          within_ = builderForValue.build();
        } else {
          withinBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <code>required .FiniteDuration within = 2;</code>
       */
      public Builder mergeWithin(org.apache.pekko.remote.WireFormats.FiniteDuration value) {
        if (withinBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0) &&
            within_ != null &&
            within_ != org.apache.pekko.remote.WireFormats.FiniteDuration.getDefaultInstance()) {
            getWithinBuilder().mergeFrom(value);
          } else {
            within_ = value;
          }
        } else {
          withinBuilder_.mergeFrom(value);
        }
        if (within_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       * <code>required .FiniteDuration within = 2;</code>
       */
      public Builder clearWithin() {
        bitField0_ = (bitField0_ & ~0x00000002);
        within_ = null;
        if (withinBuilder_ != null) {
          withinBuilder_.dispose();
          withinBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <code>required .FiniteDuration within = 2;</code>
       */
      public org.apache.pekko.remote.WireFormats.FiniteDuration.Builder getWithinBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return internalGetWithinFieldBuilder().getBuilder();
      }
      /**
       * <code>required .FiniteDuration within = 2;</code>
       */
      public org.apache.pekko.remote.WireFormats.FiniteDurationOrBuilder getWithinOrBuilder() {
        if (withinBuilder_ != null) {
          return withinBuilder_.getMessageOrBuilder();
        } else {
          return within_ == null ?
              org.apache.pekko.remote.WireFormats.FiniteDuration.getDefaultInstance() : within_;
        }
      }
      /**
       * <code>required .FiniteDuration within = 2;</code>
       */
      private org.apache.pekko.protobufv3.internal.SingleFieldBuilder<
          org.apache.pekko.remote.WireFormats.FiniteDuration, org.apache.pekko.remote.WireFormats.FiniteDuration.Builder, org.apache.pekko.remote.WireFormats.FiniteDurationOrBuilder> 
          internalGetWithinFieldBuilder() {
        if (withinBuilder_ == null) {
          withinBuilder_ = new org.apache.pekko.protobufv3.internal.SingleFieldBuilder<
              org.apache.pekko.remote.WireFormats.FiniteDuration, org.apache.pekko.remote.WireFormats.FiniteDuration.Builder, org.apache.pekko.remote.WireFormats.FiniteDurationOrBuilder>(
                  getWithin(),
                  getParentForChildren(),
                  isClean());
          within_ = null;
        }
        return withinBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:ScatterGatherPool)
    }

    // @@protoc_insertion_point(class_scope:ScatterGatherPool)
    private static final org.apache.pekko.remote.WireFormats.ScatterGatherPool DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.pekko.remote.WireFormats.ScatterGatherPool();
    }

    public static org.apache.pekko.remote.WireFormats.ScatterGatherPool getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final org.apache.pekko.protobufv3.internal.Parser<ScatterGatherPool>
        PARSER = new org.apache.pekko.protobufv3.internal.AbstractParser<ScatterGatherPool>() {
      @java.lang.Override
      public ScatterGatherPool parsePartialFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (org.apache.pekko.protobufv3.internal.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static org.apache.pekko.protobufv3.internal.Parser<ScatterGatherPool> parser() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.pekko.protobufv3.internal.Parser<ScatterGatherPool> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.pekko.remote.WireFormats.ScatterGatherPool getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface TailChoppingPoolOrBuilder extends
      // @@protoc_insertion_point(interface_extends:TailChoppingPool)
      org.apache.pekko.protobufv3.internal.MessageOrBuilder {

    /**
     * <code>required .GenericRoutingPool generic = 1;</code>
     * @return Whether the generic field is set.
     */
    boolean hasGeneric();
    /**
     * <code>required .GenericRoutingPool generic = 1;</code>
     * @return The generic.
     */
    org.apache.pekko.remote.WireFormats.GenericRoutingPool getGeneric();
    /**
     * <code>required .GenericRoutingPool generic = 1;</code>
     */
    org.apache.pekko.remote.WireFormats.GenericRoutingPoolOrBuilder getGenericOrBuilder();

    /**
     * <code>required .FiniteDuration within = 2;</code>
     * @return Whether the within field is set.
     */
    boolean hasWithin();
    /**
     * <code>required .FiniteDuration within = 2;</code>
     * @return The within.
     */
    org.apache.pekko.remote.WireFormats.FiniteDuration getWithin();
    /**
     * <code>required .FiniteDuration within = 2;</code>
     */
    org.apache.pekko.remote.WireFormats.FiniteDurationOrBuilder getWithinOrBuilder();

    /**
     * <code>required .FiniteDuration interval = 3;</code>
     * @return Whether the interval field is set.
     */
    boolean hasInterval();
    /**
     * <code>required .FiniteDuration interval = 3;</code>
     * @return The interval.
     */
    org.apache.pekko.remote.WireFormats.FiniteDuration getInterval();
    /**
     * <code>required .FiniteDuration interval = 3;</code>
     */
    org.apache.pekko.remote.WireFormats.FiniteDurationOrBuilder getIntervalOrBuilder();
  }
  /**
   * Protobuf type {@code TailChoppingPool}
   */
  public static final class TailChoppingPool extends
      org.apache.pekko.protobufv3.internal.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:TailChoppingPool)
      TailChoppingPoolOrBuilder {
  private static final long serialVersionUID = 0L;
    static {
      org.apache.pekko.protobufv3.internal.RuntimeVersion.validateProtobufGencodeVersion(
        org.apache.pekko.protobufv3.internal.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 32,
        /* patch= */ 0,
        /* suffix= */ "",
        TailChoppingPool.class.getName());
    }
    // Use TailChoppingPool.newBuilder() to construct.
    private TailChoppingPool(org.apache.pekko.protobufv3.internal.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }
    private TailChoppingPool() {
    }

    public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.pekko.remote.WireFormats.internal_static_TailChoppingPool_descriptor;
    }

    @java.lang.Override
    protected org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.pekko.remote.WireFormats.internal_static_TailChoppingPool_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.pekko.remote.WireFormats.TailChoppingPool.class, org.apache.pekko.remote.WireFormats.TailChoppingPool.Builder.class);
    }

    private int bitField0_;
    public static final int GENERIC_FIELD_NUMBER = 1;
    private org.apache.pekko.remote.WireFormats.GenericRoutingPool generic_;
    /**
     * <code>required .GenericRoutingPool generic = 1;</code>
     * @return Whether the generic field is set.
     */
    @java.lang.Override
    public boolean hasGeneric() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <code>required .GenericRoutingPool generic = 1;</code>
     * @return The generic.
     */
    @java.lang.Override
    public org.apache.pekko.remote.WireFormats.GenericRoutingPool getGeneric() {
      return generic_ == null ? org.apache.pekko.remote.WireFormats.GenericRoutingPool.getDefaultInstance() : generic_;
    }
    /**
     * <code>required .GenericRoutingPool generic = 1;</code>
     */
    @java.lang.Override
    public org.apache.pekko.remote.WireFormats.GenericRoutingPoolOrBuilder getGenericOrBuilder() {
      return generic_ == null ? org.apache.pekko.remote.WireFormats.GenericRoutingPool.getDefaultInstance() : generic_;
    }

    public static final int WITHIN_FIELD_NUMBER = 2;
    private org.apache.pekko.remote.WireFormats.FiniteDuration within_;
    /**
     * <code>required .FiniteDuration within = 2;</code>
     * @return Whether the within field is set.
     */
    @java.lang.Override
    public boolean hasWithin() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <code>required .FiniteDuration within = 2;</code>
     * @return The within.
     */
    @java.lang.Override
    public org.apache.pekko.remote.WireFormats.FiniteDuration getWithin() {
      return within_ == null ? org.apache.pekko.remote.WireFormats.FiniteDuration.getDefaultInstance() : within_;
    }
    /**
     * <code>required .FiniteDuration within = 2;</code>
     */
    @java.lang.Override
    public org.apache.pekko.remote.WireFormats.FiniteDurationOrBuilder getWithinOrBuilder() {
      return within_ == null ? org.apache.pekko.remote.WireFormats.FiniteDuration.getDefaultInstance() : within_;
    }

    public static final int INTERVAL_FIELD_NUMBER = 3;
    private org.apache.pekko.remote.WireFormats.FiniteDuration interval_;
    /**
     * <code>required .FiniteDuration interval = 3;</code>
     * @return Whether the interval field is set.
     */
    @java.lang.Override
    public boolean hasInterval() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     * <code>required .FiniteDuration interval = 3;</code>
     * @return The interval.
     */
    @java.lang.Override
    public org.apache.pekko.remote.WireFormats.FiniteDuration getInterval() {
      return interval_ == null ? org.apache.pekko.remote.WireFormats.FiniteDuration.getDefaultInstance() : interval_;
    }
    /**
     * <code>required .FiniteDuration interval = 3;</code>
     */
    @java.lang.Override
    public org.apache.pekko.remote.WireFormats.FiniteDurationOrBuilder getIntervalOrBuilder() {
      return interval_ == null ? org.apache.pekko.remote.WireFormats.FiniteDuration.getDefaultInstance() : interval_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasGeneric()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!hasWithin()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!hasInterval()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!getGeneric().isInitialized()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!getWithin().isInitialized()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!getInterval().isInitialized()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(org.apache.pekko.protobufv3.internal.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getGeneric());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(2, getWithin());
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        output.writeMessage(3, getInterval());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeMessageSize(1, getGeneric());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeMessageSize(2, getWithin());
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeMessageSize(3, getInterval());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.pekko.remote.WireFormats.TailChoppingPool)) {
        return super.equals(obj);
      }
      org.apache.pekko.remote.WireFormats.TailChoppingPool other = (org.apache.pekko.remote.WireFormats.TailChoppingPool) obj;

      if (hasGeneric() != other.hasGeneric()) return false;
      if (hasGeneric()) {
        if (!getGeneric()
            .equals(other.getGeneric())) return false;
      }
      if (hasWithin() != other.hasWithin()) return false;
      if (hasWithin()) {
        if (!getWithin()
            .equals(other.getWithin())) return false;
      }
      if (hasInterval() != other.hasInterval()) return false;
      if (hasInterval()) {
        if (!getInterval()
            .equals(other.getInterval())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasGeneric()) {
        hash = (37 * hash) + GENERIC_FIELD_NUMBER;
        hash = (53 * hash) + getGeneric().hashCode();
      }
      if (hasWithin()) {
        hash = (37 * hash) + WITHIN_FIELD_NUMBER;
        hash = (53 * hash) + getWithin().hashCode();
      }
      if (hasInterval()) {
        hash = (37 * hash) + INTERVAL_FIELD_NUMBER;
        hash = (53 * hash) + getInterval().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.pekko.remote.WireFormats.TailChoppingPool parseFrom(
        java.nio.ByteBuffer data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.remote.WireFormats.TailChoppingPool parseFrom(
        java.nio.ByteBuffer data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.TailChoppingPool parseFrom(
        org.apache.pekko.protobufv3.internal.ByteString data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.remote.WireFormats.TailChoppingPool parseFrom(
        org.apache.pekko.protobufv3.internal.ByteString data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.TailChoppingPool parseFrom(byte[] data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.remote.WireFormats.TailChoppingPool parseFrom(
        byte[] data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.TailChoppingPool parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.pekko.remote.WireFormats.TailChoppingPool parseFrom(
        java.io.InputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static org.apache.pekko.remote.WireFormats.TailChoppingPool parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static org.apache.pekko.remote.WireFormats.TailChoppingPool parseDelimitedFrom(
        java.io.InputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.TailChoppingPool parseFrom(
        org.apache.pekko.protobufv3.internal.CodedInputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.pekko.remote.WireFormats.TailChoppingPool parseFrom(
        org.apache.pekko.protobufv3.internal.CodedInputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.pekko.remote.WireFormats.TailChoppingPool prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        org.apache.pekko.protobufv3.internal.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code TailChoppingPool}
     */
    public static final class Builder extends
        org.apache.pekko.protobufv3.internal.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:TailChoppingPool)
        org.apache.pekko.remote.WireFormats.TailChoppingPoolOrBuilder {
      public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.pekko.remote.WireFormats.internal_static_TailChoppingPool_descriptor;
      }

      @java.lang.Override
      protected org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.pekko.remote.WireFormats.internal_static_TailChoppingPool_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.pekko.remote.WireFormats.TailChoppingPool.class, org.apache.pekko.remote.WireFormats.TailChoppingPool.Builder.class);
      }

      // Construct using org.apache.pekko.remote.WireFormats.TailChoppingPool.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          org.apache.pekko.protobufv3.internal.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (org.apache.pekko.protobufv3.internal.GeneratedMessage
                .alwaysUseFieldBuilders) {
          internalGetGenericFieldBuilder();
          internalGetWithinFieldBuilder();
          internalGetIntervalFieldBuilder();
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        generic_ = null;
        if (genericBuilder_ != null) {
          genericBuilder_.dispose();
          genericBuilder_ = null;
        }
        within_ = null;
        if (withinBuilder_ != null) {
          withinBuilder_.dispose();
          withinBuilder_ = null;
        }
        interval_ = null;
        if (intervalBuilder_ != null) {
          intervalBuilder_.dispose();
          intervalBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.pekko.remote.WireFormats.internal_static_TailChoppingPool_descriptor;
      }

      @java.lang.Override
      public org.apache.pekko.remote.WireFormats.TailChoppingPool getDefaultInstanceForType() {
        return org.apache.pekko.remote.WireFormats.TailChoppingPool.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.pekko.remote.WireFormats.TailChoppingPool build() {
        org.apache.pekko.remote.WireFormats.TailChoppingPool result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.pekko.remote.WireFormats.TailChoppingPool buildPartial() {
        org.apache.pekko.remote.WireFormats.TailChoppingPool result = new org.apache.pekko.remote.WireFormats.TailChoppingPool(this);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartial0(org.apache.pekko.remote.WireFormats.TailChoppingPool result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.generic_ = genericBuilder_ == null
              ? generic_
              : genericBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.within_ = withinBuilder_ == null
              ? within_
              : withinBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.interval_ = intervalBuilder_ == null
              ? interval_
              : intervalBuilder_.build();
          to_bitField0_ |= 0x00000004;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder mergeFrom(org.apache.pekko.protobufv3.internal.Message other) {
        if (other instanceof org.apache.pekko.remote.WireFormats.TailChoppingPool) {
          return mergeFrom((org.apache.pekko.remote.WireFormats.TailChoppingPool)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.pekko.remote.WireFormats.TailChoppingPool other) {
        if (other == org.apache.pekko.remote.WireFormats.TailChoppingPool.getDefaultInstance()) return this;
        if (other.hasGeneric()) {
          mergeGeneric(other.getGeneric());
        }
        if (other.hasWithin()) {
          mergeWithin(other.getWithin());
        }
        if (other.hasInterval()) {
          mergeInterval(other.getInterval());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        if (!hasGeneric()) {
          return false;
        }
        if (!hasWithin()) {
          return false;
        }
        if (!hasInterval()) {
          return false;
        }
        if (!getGeneric().isInitialized()) {
          return false;
        }
        if (!getWithin().isInitialized()) {
          return false;
        }
        if (!getInterval().isInitialized()) {
          return false;
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                input.readMessage(
                    internalGetGenericFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
              case 18: {
                input.readMessage(
                    internalGetWithinFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
              case 26: {
                input.readMessage(
                    internalGetIntervalFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private org.apache.pekko.remote.WireFormats.GenericRoutingPool generic_;
      private org.apache.pekko.protobufv3.internal.SingleFieldBuilder<
          org.apache.pekko.remote.WireFormats.GenericRoutingPool, org.apache.pekko.remote.WireFormats.GenericRoutingPool.Builder, org.apache.pekko.remote.WireFormats.GenericRoutingPoolOrBuilder> genericBuilder_;
      /**
       * <code>required .GenericRoutingPool generic = 1;</code>
       * @return Whether the generic field is set.
       */
      public boolean hasGeneric() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <code>required .GenericRoutingPool generic = 1;</code>
       * @return The generic.
       */
      public org.apache.pekko.remote.WireFormats.GenericRoutingPool getGeneric() {
        if (genericBuilder_ == null) {
          return generic_ == null ? org.apache.pekko.remote.WireFormats.GenericRoutingPool.getDefaultInstance() : generic_;
        } else {
          return genericBuilder_.getMessage();
        }
      }
      /**
       * <code>required .GenericRoutingPool generic = 1;</code>
       */
      public Builder setGeneric(org.apache.pekko.remote.WireFormats.GenericRoutingPool value) {
        if (genericBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          generic_ = value;
        } else {
          genericBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <code>required .GenericRoutingPool generic = 1;</code>
       */
      public Builder setGeneric(
          org.apache.pekko.remote.WireFormats.GenericRoutingPool.Builder builderForValue) {
        if (genericBuilder_ == null) {
          generic_ = builderForValue.build();
        } else {
          genericBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <code>required .GenericRoutingPool generic = 1;</code>
       */
      public Builder mergeGeneric(org.apache.pekko.remote.WireFormats.GenericRoutingPool value) {
        if (genericBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0) &&
            generic_ != null &&
            generic_ != org.apache.pekko.remote.WireFormats.GenericRoutingPool.getDefaultInstance()) {
            getGenericBuilder().mergeFrom(value);
          } else {
            generic_ = value;
          }
        } else {
          genericBuilder_.mergeFrom(value);
        }
        if (generic_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }
      /**
       * <code>required .GenericRoutingPool generic = 1;</code>
       */
      public Builder clearGeneric() {
        bitField0_ = (bitField0_ & ~0x00000001);
        generic_ = null;
        if (genericBuilder_ != null) {
          genericBuilder_.dispose();
          genericBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <code>required .GenericRoutingPool generic = 1;</code>
       */
      public org.apache.pekko.remote.WireFormats.GenericRoutingPool.Builder getGenericBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return internalGetGenericFieldBuilder().getBuilder();
      }
      /**
       * <code>required .GenericRoutingPool generic = 1;</code>
       */
      public org.apache.pekko.remote.WireFormats.GenericRoutingPoolOrBuilder getGenericOrBuilder() {
        if (genericBuilder_ != null) {
          return genericBuilder_.getMessageOrBuilder();
        } else {
          return generic_ == null ?
              org.apache.pekko.remote.WireFormats.GenericRoutingPool.getDefaultInstance() : generic_;
        }
      }
      /**
       * <code>required .GenericRoutingPool generic = 1;</code>
       */
      private org.apache.pekko.protobufv3.internal.SingleFieldBuilder<
          org.apache.pekko.remote.WireFormats.GenericRoutingPool, org.apache.pekko.remote.WireFormats.GenericRoutingPool.Builder, org.apache.pekko.remote.WireFormats.GenericRoutingPoolOrBuilder> 
          internalGetGenericFieldBuilder() {
        if (genericBuilder_ == null) {
          genericBuilder_ = new org.apache.pekko.protobufv3.internal.SingleFieldBuilder<
              org.apache.pekko.remote.WireFormats.GenericRoutingPool, org.apache.pekko.remote.WireFormats.GenericRoutingPool.Builder, org.apache.pekko.remote.WireFormats.GenericRoutingPoolOrBuilder>(
                  getGeneric(),
                  getParentForChildren(),
                  isClean());
          generic_ = null;
        }
        return genericBuilder_;
      }

      private org.apache.pekko.remote.WireFormats.FiniteDuration within_;
      private org.apache.pekko.protobufv3.internal.SingleFieldBuilder<
          org.apache.pekko.remote.WireFormats.FiniteDuration, org.apache.pekko.remote.WireFormats.FiniteDuration.Builder, org.apache.pekko.remote.WireFormats.FiniteDurationOrBuilder> withinBuilder_;
      /**
       * <code>required .FiniteDuration within = 2;</code>
       * @return Whether the within field is set.
       */
      public boolean hasWithin() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <code>required .FiniteDuration within = 2;</code>
       * @return The within.
       */
      public org.apache.pekko.remote.WireFormats.FiniteDuration getWithin() {
        if (withinBuilder_ == null) {
          return within_ == null ? org.apache.pekko.remote.WireFormats.FiniteDuration.getDefaultInstance() : within_;
        } else {
          return withinBuilder_.getMessage();
        }
      }
      /**
       * <code>required .FiniteDuration within = 2;</code>
       */
      public Builder setWithin(org.apache.pekko.remote.WireFormats.FiniteDuration value) {
        if (withinBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          within_ = value;
        } else {
          withinBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <code>required .FiniteDuration within = 2;</code>
       */
      public Builder setWithin(
          org.apache.pekko.remote.WireFormats.FiniteDuration.Builder builderForValue) {
        if (withinBuilder_ == null) {
          within_ = builderForValue.build();
        } else {
          withinBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <code>required .FiniteDuration within = 2;</code>
       */
      public Builder mergeWithin(org.apache.pekko.remote.WireFormats.FiniteDuration value) {
        if (withinBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0) &&
            within_ != null &&
            within_ != org.apache.pekko.remote.WireFormats.FiniteDuration.getDefaultInstance()) {
            getWithinBuilder().mergeFrom(value);
          } else {
            within_ = value;
          }
        } else {
          withinBuilder_.mergeFrom(value);
        }
        if (within_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       * <code>required .FiniteDuration within = 2;</code>
       */
      public Builder clearWithin() {
        bitField0_ = (bitField0_ & ~0x00000002);
        within_ = null;
        if (withinBuilder_ != null) {
          withinBuilder_.dispose();
          withinBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <code>required .FiniteDuration within = 2;</code>
       */
      public org.apache.pekko.remote.WireFormats.FiniteDuration.Builder getWithinBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return internalGetWithinFieldBuilder().getBuilder();
      }
      /**
       * <code>required .FiniteDuration within = 2;</code>
       */
      public org.apache.pekko.remote.WireFormats.FiniteDurationOrBuilder getWithinOrBuilder() {
        if (withinBuilder_ != null) {
          return withinBuilder_.getMessageOrBuilder();
        } else {
          return within_ == null ?
              org.apache.pekko.remote.WireFormats.FiniteDuration.getDefaultInstance() : within_;
        }
      }
      /**
       * <code>required .FiniteDuration within = 2;</code>
       */
      private org.apache.pekko.protobufv3.internal.SingleFieldBuilder<
          org.apache.pekko.remote.WireFormats.FiniteDuration, org.apache.pekko.remote.WireFormats.FiniteDuration.Builder, org.apache.pekko.remote.WireFormats.FiniteDurationOrBuilder> 
          internalGetWithinFieldBuilder() {
        if (withinBuilder_ == null) {
          withinBuilder_ = new org.apache.pekko.protobufv3.internal.SingleFieldBuilder<
              org.apache.pekko.remote.WireFormats.FiniteDuration, org.apache.pekko.remote.WireFormats.FiniteDuration.Builder, org.apache.pekko.remote.WireFormats.FiniteDurationOrBuilder>(
                  getWithin(),
                  getParentForChildren(),
                  isClean());
          within_ = null;
        }
        return withinBuilder_;
      }

      private org.apache.pekko.remote.WireFormats.FiniteDuration interval_;
      private org.apache.pekko.protobufv3.internal.SingleFieldBuilder<
          org.apache.pekko.remote.WireFormats.FiniteDuration, org.apache.pekko.remote.WireFormats.FiniteDuration.Builder, org.apache.pekko.remote.WireFormats.FiniteDurationOrBuilder> intervalBuilder_;
      /**
       * <code>required .FiniteDuration interval = 3;</code>
       * @return Whether the interval field is set.
       */
      public boolean hasInterval() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       * <code>required .FiniteDuration interval = 3;</code>
       * @return The interval.
       */
      public org.apache.pekko.remote.WireFormats.FiniteDuration getInterval() {
        if (intervalBuilder_ == null) {
          return interval_ == null ? org.apache.pekko.remote.WireFormats.FiniteDuration.getDefaultInstance() : interval_;
        } else {
          return intervalBuilder_.getMessage();
        }
      }
      /**
       * <code>required .FiniteDuration interval = 3;</code>
       */
      public Builder setInterval(org.apache.pekko.remote.WireFormats.FiniteDuration value) {
        if (intervalBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          interval_ = value;
        } else {
          intervalBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       * <code>required .FiniteDuration interval = 3;</code>
       */
      public Builder setInterval(
          org.apache.pekko.remote.WireFormats.FiniteDuration.Builder builderForValue) {
        if (intervalBuilder_ == null) {
          interval_ = builderForValue.build();
        } else {
          intervalBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       * <code>required .FiniteDuration interval = 3;</code>
       */
      public Builder mergeInterval(org.apache.pekko.remote.WireFormats.FiniteDuration value) {
        if (intervalBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0) &&
            interval_ != null &&
            interval_ != org.apache.pekko.remote.WireFormats.FiniteDuration.getDefaultInstance()) {
            getIntervalBuilder().mergeFrom(value);
          } else {
            interval_ = value;
          }
        } else {
          intervalBuilder_.mergeFrom(value);
        }
        if (interval_ != null) {
          bitField0_ |= 0x00000004;
          onChanged();
        }
        return this;
      }
      /**
       * <code>required .FiniteDuration interval = 3;</code>
       */
      public Builder clearInterval() {
        bitField0_ = (bitField0_ & ~0x00000004);
        interval_ = null;
        if (intervalBuilder_ != null) {
          intervalBuilder_.dispose();
          intervalBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <code>required .FiniteDuration interval = 3;</code>
       */
      public org.apache.pekko.remote.WireFormats.FiniteDuration.Builder getIntervalBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return internalGetIntervalFieldBuilder().getBuilder();
      }
      /**
       * <code>required .FiniteDuration interval = 3;</code>
       */
      public org.apache.pekko.remote.WireFormats.FiniteDurationOrBuilder getIntervalOrBuilder() {
        if (intervalBuilder_ != null) {
          return intervalBuilder_.getMessageOrBuilder();
        } else {
          return interval_ == null ?
              org.apache.pekko.remote.WireFormats.FiniteDuration.getDefaultInstance() : interval_;
        }
      }
      /**
       * <code>required .FiniteDuration interval = 3;</code>
       */
      private org.apache.pekko.protobufv3.internal.SingleFieldBuilder<
          org.apache.pekko.remote.WireFormats.FiniteDuration, org.apache.pekko.remote.WireFormats.FiniteDuration.Builder, org.apache.pekko.remote.WireFormats.FiniteDurationOrBuilder> 
          internalGetIntervalFieldBuilder() {
        if (intervalBuilder_ == null) {
          intervalBuilder_ = new org.apache.pekko.protobufv3.internal.SingleFieldBuilder<
              org.apache.pekko.remote.WireFormats.FiniteDuration, org.apache.pekko.remote.WireFormats.FiniteDuration.Builder, org.apache.pekko.remote.WireFormats.FiniteDurationOrBuilder>(
                  getInterval(),
                  getParentForChildren(),
                  isClean());
          interval_ = null;
        }
        return intervalBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:TailChoppingPool)
    }

    // @@protoc_insertion_point(class_scope:TailChoppingPool)
    private static final org.apache.pekko.remote.WireFormats.TailChoppingPool DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.pekko.remote.WireFormats.TailChoppingPool();
    }

    public static org.apache.pekko.remote.WireFormats.TailChoppingPool getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final org.apache.pekko.protobufv3.internal.Parser<TailChoppingPool>
        PARSER = new org.apache.pekko.protobufv3.internal.AbstractParser<TailChoppingPool>() {
      @java.lang.Override
      public TailChoppingPool parsePartialFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (org.apache.pekko.protobufv3.internal.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static org.apache.pekko.protobufv3.internal.Parser<TailChoppingPool> parser() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.pekko.protobufv3.internal.Parser<TailChoppingPool> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.pekko.remote.WireFormats.TailChoppingPool getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface AddressDataOrBuilder extends
      // @@protoc_insertion_point(interface_extends:AddressData)
      org.apache.pekko.protobufv3.internal.MessageOrBuilder {

    /**
     * <code>required string system = 1;</code>
     * @return Whether the system field is set.
     */
    boolean hasSystem();
    /**
     * <code>required string system = 1;</code>
     * @return The system.
     */
    java.lang.String getSystem();
    /**
     * <code>required string system = 1;</code>
     * @return The bytes for system.
     */
    org.apache.pekko.protobufv3.internal.ByteString
        getSystemBytes();

    /**
     * <code>required string hostname = 2;</code>
     * @return Whether the hostname field is set.
     */
    boolean hasHostname();
    /**
     * <code>required string hostname = 2;</code>
     * @return The hostname.
     */
    java.lang.String getHostname();
    /**
     * <code>required string hostname = 2;</code>
     * @return The bytes for hostname.
     */
    org.apache.pekko.protobufv3.internal.ByteString
        getHostnameBytes();

    /**
     * <code>required uint32 port = 3;</code>
     * @return Whether the port field is set.
     */
    boolean hasPort();
    /**
     * <code>required uint32 port = 3;</code>
     * @return The port.
     */
    int getPort();

    /**
     * <code>optional string protocol = 4;</code>
     * @return Whether the protocol field is set.
     */
    boolean hasProtocol();
    /**
     * <code>optional string protocol = 4;</code>
     * @return The protocol.
     */
    java.lang.String getProtocol();
    /**
     * <code>optional string protocol = 4;</code>
     * @return The bytes for protocol.
     */
    org.apache.pekko.protobufv3.internal.ByteString
        getProtocolBytes();
  }
  /**
   * <pre>
   * *
   * Defines a remote address.
   * </pre>
   *
   * Protobuf type {@code AddressData}
   */
  public static final class AddressData extends
      org.apache.pekko.protobufv3.internal.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:AddressData)
      AddressDataOrBuilder {
  private static final long serialVersionUID = 0L;
    static {
      org.apache.pekko.protobufv3.internal.RuntimeVersion.validateProtobufGencodeVersion(
        org.apache.pekko.protobufv3.internal.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 32,
        /* patch= */ 0,
        /* suffix= */ "",
        AddressData.class.getName());
    }
    // Use AddressData.newBuilder() to construct.
    private AddressData(org.apache.pekko.protobufv3.internal.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }
    private AddressData() {
      system_ = "";
      hostname_ = "";
      protocol_ = "";
    }

    public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.pekko.remote.WireFormats.internal_static_AddressData_descriptor;
    }

    @java.lang.Override
    protected org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.pekko.remote.WireFormats.internal_static_AddressData_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.pekko.remote.WireFormats.AddressData.class, org.apache.pekko.remote.WireFormats.AddressData.Builder.class);
    }

    private int bitField0_;
    public static final int SYSTEM_FIELD_NUMBER = 1;
    @SuppressWarnings("serial")
    private volatile java.lang.Object system_ = "";
    /**
     * <code>required string system = 1;</code>
     * @return Whether the system field is set.
     */
    @java.lang.Override
    public boolean hasSystem() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <code>required string system = 1;</code>
     * @return The system.
     */
    @java.lang.Override
    public java.lang.String getSystem() {
      java.lang.Object ref = system_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        org.apache.pekko.protobufv3.internal.ByteString bs = 
            (org.apache.pekko.protobufv3.internal.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          system_ = s;
        }
        return s;
      }
    }
    /**
     * <code>required string system = 1;</code>
     * @return The bytes for system.
     */
    @java.lang.Override
    public org.apache.pekko.protobufv3.internal.ByteString
        getSystemBytes() {
      java.lang.Object ref = system_;
      if (ref instanceof java.lang.String) {
        org.apache.pekko.protobufv3.internal.ByteString b = 
            org.apache.pekko.protobufv3.internal.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        system_ = b;
        return b;
      } else {
        return (org.apache.pekko.protobufv3.internal.ByteString) ref;
      }
    }

    public static final int HOSTNAME_FIELD_NUMBER = 2;
    @SuppressWarnings("serial")
    private volatile java.lang.Object hostname_ = "";
    /**
     * <code>required string hostname = 2;</code>
     * @return Whether the hostname field is set.
     */
    @java.lang.Override
    public boolean hasHostname() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <code>required string hostname = 2;</code>
     * @return The hostname.
     */
    @java.lang.Override
    public java.lang.String getHostname() {
      java.lang.Object ref = hostname_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        org.apache.pekko.protobufv3.internal.ByteString bs = 
            (org.apache.pekko.protobufv3.internal.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          hostname_ = s;
        }
        return s;
      }
    }
    /**
     * <code>required string hostname = 2;</code>
     * @return The bytes for hostname.
     */
    @java.lang.Override
    public org.apache.pekko.protobufv3.internal.ByteString
        getHostnameBytes() {
      java.lang.Object ref = hostname_;
      if (ref instanceof java.lang.String) {
        org.apache.pekko.protobufv3.internal.ByteString b = 
            org.apache.pekko.protobufv3.internal.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        hostname_ = b;
        return b;
      } else {
        return (org.apache.pekko.protobufv3.internal.ByteString) ref;
      }
    }

    public static final int PORT_FIELD_NUMBER = 3;
    private int port_ = 0;
    /**
     * <code>required uint32 port = 3;</code>
     * @return Whether the port field is set.
     */
    @java.lang.Override
    public boolean hasPort() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     * <code>required uint32 port = 3;</code>
     * @return The port.
     */
    @java.lang.Override
    public int getPort() {
      return port_;
    }

    public static final int PROTOCOL_FIELD_NUMBER = 4;
    @SuppressWarnings("serial")
    private volatile java.lang.Object protocol_ = "";
    /**
     * <code>optional string protocol = 4;</code>
     * @return Whether the protocol field is set.
     */
    @java.lang.Override
    public boolean hasProtocol() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     * <code>optional string protocol = 4;</code>
     * @return The protocol.
     */
    @java.lang.Override
    public java.lang.String getProtocol() {
      java.lang.Object ref = protocol_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        org.apache.pekko.protobufv3.internal.ByteString bs = 
            (org.apache.pekko.protobufv3.internal.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          protocol_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string protocol = 4;</code>
     * @return The bytes for protocol.
     */
    @java.lang.Override
    public org.apache.pekko.protobufv3.internal.ByteString
        getProtocolBytes() {
      java.lang.Object ref = protocol_;
      if (ref instanceof java.lang.String) {
        org.apache.pekko.protobufv3.internal.ByteString b = 
            org.apache.pekko.protobufv3.internal.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        protocol_ = b;
        return b;
      } else {
        return (org.apache.pekko.protobufv3.internal.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasSystem()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!hasHostname()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!hasPort()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(org.apache.pekko.protobufv3.internal.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        org.apache.pekko.protobufv3.internal.GeneratedMessage.writeString(output, 1, system_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        org.apache.pekko.protobufv3.internal.GeneratedMessage.writeString(output, 2, hostname_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        output.writeUInt32(3, port_);
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        org.apache.pekko.protobufv3.internal.GeneratedMessage.writeString(output, 4, protocol_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += org.apache.pekko.protobufv3.internal.GeneratedMessage.computeStringSize(1, system_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += org.apache.pekko.protobufv3.internal.GeneratedMessage.computeStringSize(2, hostname_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeUInt32Size(3, port_);
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        size += org.apache.pekko.protobufv3.internal.GeneratedMessage.computeStringSize(4, protocol_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.pekko.remote.WireFormats.AddressData)) {
        return super.equals(obj);
      }
      org.apache.pekko.remote.WireFormats.AddressData other = (org.apache.pekko.remote.WireFormats.AddressData) obj;

      if (hasSystem() != other.hasSystem()) return false;
      if (hasSystem()) {
        if (!getSystem()
            .equals(other.getSystem())) return false;
      }
      if (hasHostname() != other.hasHostname()) return false;
      if (hasHostname()) {
        if (!getHostname()
            .equals(other.getHostname())) return false;
      }
      if (hasPort() != other.hasPort()) return false;
      if (hasPort()) {
        if (getPort()
            != other.getPort()) return false;
      }
      if (hasProtocol() != other.hasProtocol()) return false;
      if (hasProtocol()) {
        if (!getProtocol()
            .equals(other.getProtocol())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasSystem()) {
        hash = (37 * hash) + SYSTEM_FIELD_NUMBER;
        hash = (53 * hash) + getSystem().hashCode();
      }
      if (hasHostname()) {
        hash = (37 * hash) + HOSTNAME_FIELD_NUMBER;
        hash = (53 * hash) + getHostname().hashCode();
      }
      if (hasPort()) {
        hash = (37 * hash) + PORT_FIELD_NUMBER;
        hash = (53 * hash) + getPort();
      }
      if (hasProtocol()) {
        hash = (37 * hash) + PROTOCOL_FIELD_NUMBER;
        hash = (53 * hash) + getProtocol().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.pekko.remote.WireFormats.AddressData parseFrom(
        java.nio.ByteBuffer data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.remote.WireFormats.AddressData parseFrom(
        java.nio.ByteBuffer data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.AddressData parseFrom(
        org.apache.pekko.protobufv3.internal.ByteString data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.remote.WireFormats.AddressData parseFrom(
        org.apache.pekko.protobufv3.internal.ByteString data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.AddressData parseFrom(byte[] data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.remote.WireFormats.AddressData parseFrom(
        byte[] data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.AddressData parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.pekko.remote.WireFormats.AddressData parseFrom(
        java.io.InputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static org.apache.pekko.remote.WireFormats.AddressData parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static org.apache.pekko.remote.WireFormats.AddressData parseDelimitedFrom(
        java.io.InputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.AddressData parseFrom(
        org.apache.pekko.protobufv3.internal.CodedInputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.pekko.remote.WireFormats.AddressData parseFrom(
        org.apache.pekko.protobufv3.internal.CodedInputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.pekko.remote.WireFormats.AddressData prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        org.apache.pekko.protobufv3.internal.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * *
     * Defines a remote address.
     * </pre>
     *
     * Protobuf type {@code AddressData}
     */
    public static final class Builder extends
        org.apache.pekko.protobufv3.internal.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:AddressData)
        org.apache.pekko.remote.WireFormats.AddressDataOrBuilder {
      public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.pekko.remote.WireFormats.internal_static_AddressData_descriptor;
      }

      @java.lang.Override
      protected org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.pekko.remote.WireFormats.internal_static_AddressData_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.pekko.remote.WireFormats.AddressData.class, org.apache.pekko.remote.WireFormats.AddressData.Builder.class);
      }

      // Construct using org.apache.pekko.remote.WireFormats.AddressData.newBuilder()
      private Builder() {

      }

      private Builder(
          org.apache.pekko.protobufv3.internal.GeneratedMessage.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        system_ = "";
        hostname_ = "";
        port_ = 0;
        protocol_ = "";
        return this;
      }

      @java.lang.Override
      public org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.pekko.remote.WireFormats.internal_static_AddressData_descriptor;
      }

      @java.lang.Override
      public org.apache.pekko.remote.WireFormats.AddressData getDefaultInstanceForType() {
        return org.apache.pekko.remote.WireFormats.AddressData.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.pekko.remote.WireFormats.AddressData build() {
        org.apache.pekko.remote.WireFormats.AddressData result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.pekko.remote.WireFormats.AddressData buildPartial() {
        org.apache.pekko.remote.WireFormats.AddressData result = new org.apache.pekko.remote.WireFormats.AddressData(this);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartial0(org.apache.pekko.remote.WireFormats.AddressData result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.system_ = system_;
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.hostname_ = hostname_;
          to_bitField0_ |= 0x00000002;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.port_ = port_;
          to_bitField0_ |= 0x00000004;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.protocol_ = protocol_;
          to_bitField0_ |= 0x00000008;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder mergeFrom(org.apache.pekko.protobufv3.internal.Message other) {
        if (other instanceof org.apache.pekko.remote.WireFormats.AddressData) {
          return mergeFrom((org.apache.pekko.remote.WireFormats.AddressData)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.pekko.remote.WireFormats.AddressData other) {
        if (other == org.apache.pekko.remote.WireFormats.AddressData.getDefaultInstance()) return this;
        if (other.hasSystem()) {
          system_ = other.system_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.hasHostname()) {
          hostname_ = other.hostname_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (other.hasPort()) {
          setPort(other.getPort());
        }
        if (other.hasProtocol()) {
          protocol_ = other.protocol_;
          bitField0_ |= 0x00000008;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        if (!hasSystem()) {
          return false;
        }
        if (!hasHostname()) {
          return false;
        }
        if (!hasPort()) {
          return false;
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                system_ = input.readBytes();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
              case 18: {
                hostname_ = input.readBytes();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
              case 24: {
                port_ = input.readUInt32();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
              case 34: {
                protocol_ = input.readBytes();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private java.lang.Object system_ = "";
      /**
       * <code>required string system = 1;</code>
       * @return Whether the system field is set.
       */
      public boolean hasSystem() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <code>required string system = 1;</code>
       * @return The system.
       */
      public java.lang.String getSystem() {
        java.lang.Object ref = system_;
        if (!(ref instanceof java.lang.String)) {
          org.apache.pekko.protobufv3.internal.ByteString bs =
              (org.apache.pekko.protobufv3.internal.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            system_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>required string system = 1;</code>
       * @return The bytes for system.
       */
      public org.apache.pekko.protobufv3.internal.ByteString
          getSystemBytes() {
        java.lang.Object ref = system_;
        if (ref instanceof String) {
          org.apache.pekko.protobufv3.internal.ByteString b = 
              org.apache.pekko.protobufv3.internal.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          system_ = b;
          return b;
        } else {
          return (org.apache.pekko.protobufv3.internal.ByteString) ref;
        }
      }
      /**
       * <code>required string system = 1;</code>
       * @param value The system to set.
       * @return This builder for chaining.
       */
      public Builder setSystem(
          java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        system_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <code>required string system = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearSystem() {
        system_ = getDefaultInstance().getSystem();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       * <code>required string system = 1;</code>
       * @param value The bytes for system to set.
       * @return This builder for chaining.
       */
      public Builder setSystemBytes(
          org.apache.pekko.protobufv3.internal.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        system_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object hostname_ = "";
      /**
       * <code>required string hostname = 2;</code>
       * @return Whether the hostname field is set.
       */
      public boolean hasHostname() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <code>required string hostname = 2;</code>
       * @return The hostname.
       */
      public java.lang.String getHostname() {
        java.lang.Object ref = hostname_;
        if (!(ref instanceof java.lang.String)) {
          org.apache.pekko.protobufv3.internal.ByteString bs =
              (org.apache.pekko.protobufv3.internal.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            hostname_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>required string hostname = 2;</code>
       * @return The bytes for hostname.
       */
      public org.apache.pekko.protobufv3.internal.ByteString
          getHostnameBytes() {
        java.lang.Object ref = hostname_;
        if (ref instanceof String) {
          org.apache.pekko.protobufv3.internal.ByteString b = 
              org.apache.pekko.protobufv3.internal.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          hostname_ = b;
          return b;
        } else {
          return (org.apache.pekko.protobufv3.internal.ByteString) ref;
        }
      }
      /**
       * <code>required string hostname = 2;</code>
       * @param value The hostname to set.
       * @return This builder for chaining.
       */
      public Builder setHostname(
          java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        hostname_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <code>required string hostname = 2;</code>
       * @return This builder for chaining.
       */
      public Builder clearHostname() {
        hostname_ = getDefaultInstance().getHostname();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       * <code>required string hostname = 2;</code>
       * @param value The bytes for hostname to set.
       * @return This builder for chaining.
       */
      public Builder setHostnameBytes(
          org.apache.pekko.protobufv3.internal.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        hostname_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private int port_ ;
      /**
       * <code>required uint32 port = 3;</code>
       * @return Whether the port field is set.
       */
      @java.lang.Override
      public boolean hasPort() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       * <code>required uint32 port = 3;</code>
       * @return The port.
       */
      @java.lang.Override
      public int getPort() {
        return port_;
      }
      /**
       * <code>required uint32 port = 3;</code>
       * @param value The port to set.
       * @return This builder for chaining.
       */
      public Builder setPort(int value) {

        port_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       * <code>required uint32 port = 3;</code>
       * @return This builder for chaining.
       */
      public Builder clearPort() {
        bitField0_ = (bitField0_ & ~0x00000004);
        port_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object protocol_ = "";
      /**
       * <code>optional string protocol = 4;</code>
       * @return Whether the protocol field is set.
       */
      public boolean hasProtocol() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       * <code>optional string protocol = 4;</code>
       * @return The protocol.
       */
      public java.lang.String getProtocol() {
        java.lang.Object ref = protocol_;
        if (!(ref instanceof java.lang.String)) {
          org.apache.pekko.protobufv3.internal.ByteString bs =
              (org.apache.pekko.protobufv3.internal.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            protocol_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string protocol = 4;</code>
       * @return The bytes for protocol.
       */
      public org.apache.pekko.protobufv3.internal.ByteString
          getProtocolBytes() {
        java.lang.Object ref = protocol_;
        if (ref instanceof String) {
          org.apache.pekko.protobufv3.internal.ByteString b = 
              org.apache.pekko.protobufv3.internal.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          protocol_ = b;
          return b;
        } else {
          return (org.apache.pekko.protobufv3.internal.ByteString) ref;
        }
      }
      /**
       * <code>optional string protocol = 4;</code>
       * @param value The protocol to set.
       * @return This builder for chaining.
       */
      public Builder setProtocol(
          java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        protocol_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       * <code>optional string protocol = 4;</code>
       * @return This builder for chaining.
       */
      public Builder clearProtocol() {
        protocol_ = getDefaultInstance().getProtocol();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
        return this;
      }
      /**
       * <code>optional string protocol = 4;</code>
       * @param value The bytes for protocol to set.
       * @return This builder for chaining.
       */
      public Builder setProtocolBytes(
          org.apache.pekko.protobufv3.internal.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        protocol_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:AddressData)
    }

    // @@protoc_insertion_point(class_scope:AddressData)
    private static final org.apache.pekko.remote.WireFormats.AddressData DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.pekko.remote.WireFormats.AddressData();
    }

    public static org.apache.pekko.remote.WireFormats.AddressData getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final org.apache.pekko.protobufv3.internal.Parser<AddressData>
        PARSER = new org.apache.pekko.protobufv3.internal.AbstractParser<AddressData>() {
      @java.lang.Override
      public AddressData parsePartialFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (org.apache.pekko.protobufv3.internal.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static org.apache.pekko.protobufv3.internal.Parser<AddressData> parser() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.pekko.protobufv3.internal.Parser<AddressData> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.pekko.remote.WireFormats.AddressData getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface RemoteRouterConfigOrBuilder extends
      // @@protoc_insertion_point(interface_extends:RemoteRouterConfig)
      org.apache.pekko.protobufv3.internal.MessageOrBuilder {

    /**
     * <code>required .Payload local = 1;</code>
     * @return Whether the local field is set.
     */
    boolean hasLocal();
    /**
     * <code>required .Payload local = 1;</code>
     * @return The local.
     */
    org.apache.pekko.remote.ContainerFormats.Payload getLocal();
    /**
     * <code>required .Payload local = 1;</code>
     */
    org.apache.pekko.remote.ContainerFormats.PayloadOrBuilder getLocalOrBuilder();

    /**
     * <code>repeated .AddressData nodes = 2;</code>
     */
    java.util.List<org.apache.pekko.remote.WireFormats.AddressData> 
        getNodesList();
    /**
     * <code>repeated .AddressData nodes = 2;</code>
     */
    org.apache.pekko.remote.WireFormats.AddressData getNodes(int index);
    /**
     * <code>repeated .AddressData nodes = 2;</code>
     */
    int getNodesCount();
    /**
     * <code>repeated .AddressData nodes = 2;</code>
     */
    java.util.List<? extends org.apache.pekko.remote.WireFormats.AddressDataOrBuilder> 
        getNodesOrBuilderList();
    /**
     * <code>repeated .AddressData nodes = 2;</code>
     */
    org.apache.pekko.remote.WireFormats.AddressDataOrBuilder getNodesOrBuilder(
        int index);
  }
  /**
   * Protobuf type {@code RemoteRouterConfig}
   */
  public static final class RemoteRouterConfig extends
      org.apache.pekko.protobufv3.internal.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:RemoteRouterConfig)
      RemoteRouterConfigOrBuilder {
  private static final long serialVersionUID = 0L;
    static {
      org.apache.pekko.protobufv3.internal.RuntimeVersion.validateProtobufGencodeVersion(
        org.apache.pekko.protobufv3.internal.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 32,
        /* patch= */ 0,
        /* suffix= */ "",
        RemoteRouterConfig.class.getName());
    }
    // Use RemoteRouterConfig.newBuilder() to construct.
    private RemoteRouterConfig(org.apache.pekko.protobufv3.internal.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }
    private RemoteRouterConfig() {
      nodes_ = java.util.Collections.emptyList();
    }

    public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.pekko.remote.WireFormats.internal_static_RemoteRouterConfig_descriptor;
    }

    @java.lang.Override
    protected org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.pekko.remote.WireFormats.internal_static_RemoteRouterConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.pekko.remote.WireFormats.RemoteRouterConfig.class, org.apache.pekko.remote.WireFormats.RemoteRouterConfig.Builder.class);
    }

    private int bitField0_;
    public static final int LOCAL_FIELD_NUMBER = 1;
    private org.apache.pekko.remote.ContainerFormats.Payload local_;
    /**
     * <code>required .Payload local = 1;</code>
     * @return Whether the local field is set.
     */
    @java.lang.Override
    public boolean hasLocal() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <code>required .Payload local = 1;</code>
     * @return The local.
     */
    @java.lang.Override
    public org.apache.pekko.remote.ContainerFormats.Payload getLocal() {
      return local_ == null ? org.apache.pekko.remote.ContainerFormats.Payload.getDefaultInstance() : local_;
    }
    /**
     * <code>required .Payload local = 1;</code>
     */
    @java.lang.Override
    public org.apache.pekko.remote.ContainerFormats.PayloadOrBuilder getLocalOrBuilder() {
      return local_ == null ? org.apache.pekko.remote.ContainerFormats.Payload.getDefaultInstance() : local_;
    }

    public static final int NODES_FIELD_NUMBER = 2;
    @SuppressWarnings("serial")
    private java.util.List<org.apache.pekko.remote.WireFormats.AddressData> nodes_;
    /**
     * <code>repeated .AddressData nodes = 2;</code>
     */
    @java.lang.Override
    public java.util.List<org.apache.pekko.remote.WireFormats.AddressData> getNodesList() {
      return nodes_;
    }
    /**
     * <code>repeated .AddressData nodes = 2;</code>
     */
    @java.lang.Override
    public java.util.List<? extends org.apache.pekko.remote.WireFormats.AddressDataOrBuilder> 
        getNodesOrBuilderList() {
      return nodes_;
    }
    /**
     * <code>repeated .AddressData nodes = 2;</code>
     */
    @java.lang.Override
    public int getNodesCount() {
      return nodes_.size();
    }
    /**
     * <code>repeated .AddressData nodes = 2;</code>
     */
    @java.lang.Override
    public org.apache.pekko.remote.WireFormats.AddressData getNodes(int index) {
      return nodes_.get(index);
    }
    /**
     * <code>repeated .AddressData nodes = 2;</code>
     */
    @java.lang.Override
    public org.apache.pekko.remote.WireFormats.AddressDataOrBuilder getNodesOrBuilder(
        int index) {
      return nodes_.get(index);
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasLocal()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!getLocal().isInitialized()) {
        memoizedIsInitialized = 0;
        return false;
      }
      for (int i = 0; i < getNodesCount(); i++) {
        if (!getNodes(i).isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(org.apache.pekko.protobufv3.internal.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getLocal());
      }
      for (int i = 0; i < nodes_.size(); i++) {
        output.writeMessage(2, nodes_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeMessageSize(1, getLocal());
      }
      for (int i = 0; i < nodes_.size(); i++) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeMessageSize(2, nodes_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.pekko.remote.WireFormats.RemoteRouterConfig)) {
        return super.equals(obj);
      }
      org.apache.pekko.remote.WireFormats.RemoteRouterConfig other = (org.apache.pekko.remote.WireFormats.RemoteRouterConfig) obj;

      if (hasLocal() != other.hasLocal()) return false;
      if (hasLocal()) {
        if (!getLocal()
            .equals(other.getLocal())) return false;
      }
      if (!getNodesList()
          .equals(other.getNodesList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasLocal()) {
        hash = (37 * hash) + LOCAL_FIELD_NUMBER;
        hash = (53 * hash) + getLocal().hashCode();
      }
      if (getNodesCount() > 0) {
        hash = (37 * hash) + NODES_FIELD_NUMBER;
        hash = (53 * hash) + getNodesList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.pekko.remote.WireFormats.RemoteRouterConfig parseFrom(
        java.nio.ByteBuffer data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.remote.WireFormats.RemoteRouterConfig parseFrom(
        java.nio.ByteBuffer data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.RemoteRouterConfig parseFrom(
        org.apache.pekko.protobufv3.internal.ByteString data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.remote.WireFormats.RemoteRouterConfig parseFrom(
        org.apache.pekko.protobufv3.internal.ByteString data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.RemoteRouterConfig parseFrom(byte[] data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.remote.WireFormats.RemoteRouterConfig parseFrom(
        byte[] data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.RemoteRouterConfig parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.pekko.remote.WireFormats.RemoteRouterConfig parseFrom(
        java.io.InputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static org.apache.pekko.remote.WireFormats.RemoteRouterConfig parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static org.apache.pekko.remote.WireFormats.RemoteRouterConfig parseDelimitedFrom(
        java.io.InputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.pekko.remote.WireFormats.RemoteRouterConfig parseFrom(
        org.apache.pekko.protobufv3.internal.CodedInputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.pekko.remote.WireFormats.RemoteRouterConfig parseFrom(
        org.apache.pekko.protobufv3.internal.CodedInputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.pekko.remote.WireFormats.RemoteRouterConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        org.apache.pekko.protobufv3.internal.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code RemoteRouterConfig}
     */
    public static final class Builder extends
        org.apache.pekko.protobufv3.internal.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:RemoteRouterConfig)
        org.apache.pekko.remote.WireFormats.RemoteRouterConfigOrBuilder {
      public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.pekko.remote.WireFormats.internal_static_RemoteRouterConfig_descriptor;
      }

      @java.lang.Override
      protected org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.pekko.remote.WireFormats.internal_static_RemoteRouterConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.pekko.remote.WireFormats.RemoteRouterConfig.class, org.apache.pekko.remote.WireFormats.RemoteRouterConfig.Builder.class);
      }

      // Construct using org.apache.pekko.remote.WireFormats.RemoteRouterConfig.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          org.apache.pekko.protobufv3.internal.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (org.apache.pekko.protobufv3.internal.GeneratedMessage
                .alwaysUseFieldBuilders) {
          internalGetLocalFieldBuilder();
          internalGetNodesFieldBuilder();
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        local_ = null;
        if (localBuilder_ != null) {
          localBuilder_.dispose();
          localBuilder_ = null;
        }
        if (nodesBuilder_ == null) {
          nodes_ = java.util.Collections.emptyList();
        } else {
          nodes_ = null;
          nodesBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      @java.lang.Override
      public org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.pekko.remote.WireFormats.internal_static_RemoteRouterConfig_descriptor;
      }

      @java.lang.Override
      public org.apache.pekko.remote.WireFormats.RemoteRouterConfig getDefaultInstanceForType() {
        return org.apache.pekko.remote.WireFormats.RemoteRouterConfig.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.pekko.remote.WireFormats.RemoteRouterConfig build() {
        org.apache.pekko.remote.WireFormats.RemoteRouterConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.pekko.remote.WireFormats.RemoteRouterConfig buildPartial() {
        org.apache.pekko.remote.WireFormats.RemoteRouterConfig result = new org.apache.pekko.remote.WireFormats.RemoteRouterConfig(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(org.apache.pekko.remote.WireFormats.RemoteRouterConfig result) {
        if (nodesBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)) {
            nodes_ = java.util.Collections.unmodifiableList(nodes_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.nodes_ = nodes_;
        } else {
          result.nodes_ = nodesBuilder_.build();
        }
      }

      private void buildPartial0(org.apache.pekko.remote.WireFormats.RemoteRouterConfig result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.local_ = localBuilder_ == null
              ? local_
              : localBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder mergeFrom(org.apache.pekko.protobufv3.internal.Message other) {
        if (other instanceof org.apache.pekko.remote.WireFormats.RemoteRouterConfig) {
          return mergeFrom((org.apache.pekko.remote.WireFormats.RemoteRouterConfig)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.pekko.remote.WireFormats.RemoteRouterConfig other) {
        if (other == org.apache.pekko.remote.WireFormats.RemoteRouterConfig.getDefaultInstance()) return this;
        if (other.hasLocal()) {
          mergeLocal(other.getLocal());
        }
        if (nodesBuilder_ == null) {
          if (!other.nodes_.isEmpty()) {
            if (nodes_.isEmpty()) {
              nodes_ = other.nodes_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureNodesIsMutable();
              nodes_.addAll(other.nodes_);
            }
            onChanged();
          }
        } else {
          if (!other.nodes_.isEmpty()) {
            if (nodesBuilder_.isEmpty()) {
              nodesBuilder_.dispose();
              nodesBuilder_ = null;
              nodes_ = other.nodes_;
              bitField0_ = (bitField0_ & ~0x00000002);
              nodesBuilder_ = 
                org.apache.pekko.protobufv3.internal.GeneratedMessage.alwaysUseFieldBuilders ?
                   internalGetNodesFieldBuilder() : null;
            } else {
              nodesBuilder_.addAllMessages(other.nodes_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        if (!hasLocal()) {
          return false;
        }
        if (!getLocal().isInitialized()) {
          return false;
        }
        for (int i = 0; i < getNodesCount(); i++) {
          if (!getNodes(i).isInitialized()) {
            return false;
          }
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                input.readMessage(
                    internalGetLocalFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
              case 18: {
                org.apache.pekko.remote.WireFormats.AddressData m =
                    input.readMessage(
                        org.apache.pekko.remote.WireFormats.AddressData.parser(),
                        extensionRegistry);
                if (nodesBuilder_ == null) {
                  ensureNodesIsMutable();
                  nodes_.add(m);
                } else {
                  nodesBuilder_.addMessage(m);
                }
                break;
              } // case 18
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private org.apache.pekko.remote.ContainerFormats.Payload local_;
      private org.apache.pekko.protobufv3.internal.SingleFieldBuilder<
          org.apache.pekko.remote.ContainerFormats.Payload, org.apache.pekko.remote.ContainerFormats.Payload.Builder, org.apache.pekko.remote.ContainerFormats.PayloadOrBuilder> localBuilder_;
      /**
       * <code>required .Payload local = 1;</code>
       * @return Whether the local field is set.
       */
      public boolean hasLocal() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <code>required .Payload local = 1;</code>
       * @return The local.
       */
      public org.apache.pekko.remote.ContainerFormats.Payload getLocal() {
        if (localBuilder_ == null) {
          return local_ == null ? org.apache.pekko.remote.ContainerFormats.Payload.getDefaultInstance() : local_;
        } else {
          return localBuilder_.getMessage();
        }
      }
      /**
       * <code>required .Payload local = 1;</code>
       */
      public Builder setLocal(org.apache.pekko.remote.ContainerFormats.Payload value) {
        if (localBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          local_ = value;
        } else {
          localBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <code>required .Payload local = 1;</code>
       */
      public Builder setLocal(
          org.apache.pekko.remote.ContainerFormats.Payload.Builder builderForValue) {
        if (localBuilder_ == null) {
          local_ = builderForValue.build();
        } else {
          localBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <code>required .Payload local = 1;</code>
       */
      public Builder mergeLocal(org.apache.pekko.remote.ContainerFormats.Payload value) {
        if (localBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0) &&
            local_ != null &&
            local_ != org.apache.pekko.remote.ContainerFormats.Payload.getDefaultInstance()) {
            getLocalBuilder().mergeFrom(value);
          } else {
            local_ = value;
          }
        } else {
          localBuilder_.mergeFrom(value);
        }
        if (local_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }
      /**
       * <code>required .Payload local = 1;</code>
       */
      public Builder clearLocal() {
        bitField0_ = (bitField0_ & ~0x00000001);
        local_ = null;
        if (localBuilder_ != null) {
          localBuilder_.dispose();
          localBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <code>required .Payload local = 1;</code>
       */
      public org.apache.pekko.remote.ContainerFormats.Payload.Builder getLocalBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return internalGetLocalFieldBuilder().getBuilder();
      }
      /**
       * <code>required .Payload local = 1;</code>
       */
      public org.apache.pekko.remote.ContainerFormats.PayloadOrBuilder getLocalOrBuilder() {
        if (localBuilder_ != null) {
          return localBuilder_.getMessageOrBuilder();
        } else {
          return local_ == null ?
              org.apache.pekko.remote.ContainerFormats.Payload.getDefaultInstance() : local_;
        }
      }
      /**
       * <code>required .Payload local = 1;</code>
       */
      private org.apache.pekko.protobufv3.internal.SingleFieldBuilder<
          org.apache.pekko.remote.ContainerFormats.Payload, org.apache.pekko.remote.ContainerFormats.Payload.Builder, org.apache.pekko.remote.ContainerFormats.PayloadOrBuilder> 
          internalGetLocalFieldBuilder() {
        if (localBuilder_ == null) {
          localBuilder_ = new org.apache.pekko.protobufv3.internal.SingleFieldBuilder<
              org.apache.pekko.remote.ContainerFormats.Payload, org.apache.pekko.remote.ContainerFormats.Payload.Builder, org.apache.pekko.remote.ContainerFormats.PayloadOrBuilder>(
                  getLocal(),
                  getParentForChildren(),
                  isClean());
          local_ = null;
        }
        return localBuilder_;
      }

      private java.util.List<org.apache.pekko.remote.WireFormats.AddressData> nodes_ =
        java.util.Collections.emptyList();
      private void ensureNodesIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          nodes_ = new java.util.ArrayList<org.apache.pekko.remote.WireFormats.AddressData>(nodes_);
          bitField0_ |= 0x00000002;
         }
      }

      private org.apache.pekko.protobufv3.internal.RepeatedFieldBuilder<
          org.apache.pekko.remote.WireFormats.AddressData, org.apache.pekko.remote.WireFormats.AddressData.Builder, org.apache.pekko.remote.WireFormats.AddressDataOrBuilder> nodesBuilder_;

      /**
       * <code>repeated .AddressData nodes = 2;</code>
       */
      public java.util.List<org.apache.pekko.remote.WireFormats.AddressData> getNodesList() {
        if (nodesBuilder_ == null) {
          return java.util.Collections.unmodifiableList(nodes_);
        } else {
          return nodesBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .AddressData nodes = 2;</code>
       */
      public int getNodesCount() {
        if (nodesBuilder_ == null) {
          return nodes_.size();
        } else {
          return nodesBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .AddressData nodes = 2;</code>
       */
      public org.apache.pekko.remote.WireFormats.AddressData getNodes(int index) {
        if (nodesBuilder_ == null) {
          return nodes_.get(index);
        } else {
          return nodesBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .AddressData nodes = 2;</code>
       */
      public Builder setNodes(
          int index, org.apache.pekko.remote.WireFormats.AddressData value) {
        if (nodesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureNodesIsMutable();
          nodes_.set(index, value);
          onChanged();
        } else {
          nodesBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .AddressData nodes = 2;</code>
       */
      public Builder setNodes(
          int index, org.apache.pekko.remote.WireFormats.AddressData.Builder builderForValue) {
        if (nodesBuilder_ == null) {
          ensureNodesIsMutable();
          nodes_.set(index, builderForValue.build());
          onChanged();
        } else {
          nodesBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .AddressData nodes = 2;</code>
       */
      public Builder addNodes(org.apache.pekko.remote.WireFormats.AddressData value) {
        if (nodesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureNodesIsMutable();
          nodes_.add(value);
          onChanged();
        } else {
          nodesBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .AddressData nodes = 2;</code>
       */
      public Builder addNodes(
          int index, org.apache.pekko.remote.WireFormats.AddressData value) {
        if (nodesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureNodesIsMutable();
          nodes_.add(index, value);
          onChanged();
        } else {
          nodesBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .AddressData nodes = 2;</code>
       */
      public Builder addNodes(
          org.apache.pekko.remote.WireFormats.AddressData.Builder builderForValue) {
        if (nodesBuilder_ == null) {
          ensureNodesIsMutable();
          nodes_.add(builderForValue.build());
          onChanged();
        } else {
          nodesBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .AddressData nodes = 2;</code>
       */
      public Builder addNodes(
          int index, org.apache.pekko.remote.WireFormats.AddressData.Builder builderForValue) {
        if (nodesBuilder_ == null) {
          ensureNodesIsMutable();
          nodes_.add(index, builderForValue.build());
          onChanged();
        } else {
          nodesBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .AddressData nodes = 2;</code>
       */
      public Builder addAllNodes(
          java.lang.Iterable<? extends org.apache.pekko.remote.WireFormats.AddressData> values) {
        if (nodesBuilder_ == null) {
          ensureNodesIsMutable();
          org.apache.pekko.protobufv3.internal.AbstractMessageLite.Builder.addAll(
              values, nodes_);
          onChanged();
        } else {
          nodesBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .AddressData nodes = 2;</code>
       */
      public Builder clearNodes() {
        if (nodesBuilder_ == null) {
          nodes_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          nodesBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .AddressData nodes = 2;</code>
       */
      public Builder removeNodes(int index) {
        if (nodesBuilder_ == null) {
          ensureNodesIsMutable();
          nodes_.remove(index);
          onChanged();
        } else {
          nodesBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .AddressData nodes = 2;</code>
       */
      public org.apache.pekko.remote.WireFormats.AddressData.Builder getNodesBuilder(
          int index) {
        return internalGetNodesFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .AddressData nodes = 2;</code>
       */
      public org.apache.pekko.remote.WireFormats.AddressDataOrBuilder getNodesOrBuilder(
          int index) {
        if (nodesBuilder_ == null) {
          return nodes_.get(index);  } else {
          return nodesBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .AddressData nodes = 2;</code>
       */
      public java.util.List<? extends org.apache.pekko.remote.WireFormats.AddressDataOrBuilder> 
           getNodesOrBuilderList() {
        if (nodesBuilder_ != null) {
          return nodesBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(nodes_);
        }
      }
      /**
       * <code>repeated .AddressData nodes = 2;</code>
       */
      public org.apache.pekko.remote.WireFormats.AddressData.Builder addNodesBuilder() {
        return internalGetNodesFieldBuilder().addBuilder(
            org.apache.pekko.remote.WireFormats.AddressData.getDefaultInstance());
      }
      /**
       * <code>repeated .AddressData nodes = 2;</code>
       */
      public org.apache.pekko.remote.WireFormats.AddressData.Builder addNodesBuilder(
          int index) {
        return internalGetNodesFieldBuilder().addBuilder(
            index, org.apache.pekko.remote.WireFormats.AddressData.getDefaultInstance());
      }
      /**
       * <code>repeated .AddressData nodes = 2;</code>
       */
      public java.util.List<org.apache.pekko.remote.WireFormats.AddressData.Builder> 
           getNodesBuilderList() {
        return internalGetNodesFieldBuilder().getBuilderList();
      }
      private org.apache.pekko.protobufv3.internal.RepeatedFieldBuilder<
          org.apache.pekko.remote.WireFormats.AddressData, org.apache.pekko.remote.WireFormats.AddressData.Builder, org.apache.pekko.remote.WireFormats.AddressDataOrBuilder> 
          internalGetNodesFieldBuilder() {
        if (nodesBuilder_ == null) {
          nodesBuilder_ = new org.apache.pekko.protobufv3.internal.RepeatedFieldBuilder<
              org.apache.pekko.remote.WireFormats.AddressData, org.apache.pekko.remote.WireFormats.AddressData.Builder, org.apache.pekko.remote.WireFormats.AddressDataOrBuilder>(
                  nodes_,
                  ((bitField0_ & 0x00000002) != 0),
                  getParentForChildren(),
                  isClean());
          nodes_ = null;
        }
        return nodesBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:RemoteRouterConfig)
    }

    // @@protoc_insertion_point(class_scope:RemoteRouterConfig)
    private static final org.apache.pekko.remote.WireFormats.RemoteRouterConfig DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.pekko.remote.WireFormats.RemoteRouterConfig();
    }

    public static org.apache.pekko.remote.WireFormats.RemoteRouterConfig getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final org.apache.pekko.protobufv3.internal.Parser<RemoteRouterConfig>
        PARSER = new org.apache.pekko.protobufv3.internal.AbstractParser<RemoteRouterConfig>() {
      @java.lang.Override
      public RemoteRouterConfig parsePartialFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (org.apache.pekko.protobufv3.internal.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static org.apache.pekko.protobufv3.internal.Parser<RemoteRouterConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.pekko.protobufv3.internal.Parser<RemoteRouterConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.pekko.remote.WireFormats.RemoteRouterConfig getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  private static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
    internal_static_AckAndEnvelopeContainer_descriptor;
  private static final 
    org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable
      internal_static_AckAndEnvelopeContainer_fieldAccessorTable;
  private static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
    internal_static_RemoteEnvelope_descriptor;
  private static final 
    org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable
      internal_static_RemoteEnvelope_fieldAccessorTable;
  private static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
    internal_static_AcknowledgementInfo_descriptor;
  private static final 
    org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable
      internal_static_AcknowledgementInfo_fieldAccessorTable;
  private static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
    internal_static_ActorRefData_descriptor;
  private static final 
    org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable
      internal_static_ActorRefData_fieldAccessorTable;
  private static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
    internal_static_SerializedMessage_descriptor;
  private static final 
    org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable
      internal_static_SerializedMessage_fieldAccessorTable;
  private static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
    internal_static_DaemonMsgCreateData_descriptor;
  private static final 
    org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable
      internal_static_DaemonMsgCreateData_fieldAccessorTable;
  private static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
    internal_static_PropsData_descriptor;
  private static final 
    org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable
      internal_static_PropsData_fieldAccessorTable;
  private static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
    internal_static_DeployData_descriptor;
  private static final 
    org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable
      internal_static_DeployData_fieldAccessorTable;
  private static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
    internal_static_PekkoProtocolMessage_descriptor;
  private static final 
    org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable
      internal_static_PekkoProtocolMessage_fieldAccessorTable;
  private static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
    internal_static_PekkoControlMessage_descriptor;
  private static final 
    org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable
      internal_static_PekkoControlMessage_fieldAccessorTable;
  private static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
    internal_static_PekkoHandshakeInfo_descriptor;
  private static final 
    org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable
      internal_static_PekkoHandshakeInfo_fieldAccessorTable;
  private static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
    internal_static_FiniteDuration_descriptor;
  private static final 
    org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable
      internal_static_FiniteDuration_fieldAccessorTable;
  private static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
    internal_static_RemoteScope_descriptor;
  private static final 
    org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable
      internal_static_RemoteScope_fieldAccessorTable;
  private static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
    internal_static_DefaultResizer_descriptor;
  private static final 
    org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable
      internal_static_DefaultResizer_fieldAccessorTable;
  private static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
    internal_static_FromConfig_descriptor;
  private static final 
    org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable
      internal_static_FromConfig_fieldAccessorTable;
  private static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
    internal_static_GenericRoutingPool_descriptor;
  private static final 
    org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable
      internal_static_GenericRoutingPool_fieldAccessorTable;
  private static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
    internal_static_ScatterGatherPool_descriptor;
  private static final 
    org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable
      internal_static_ScatterGatherPool_fieldAccessorTable;
  private static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
    internal_static_TailChoppingPool_descriptor;
  private static final 
    org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable
      internal_static_TailChoppingPool_fieldAccessorTable;
  private static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
    internal_static_AddressData_descriptor;
  private static final 
    org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable
      internal_static_AddressData_fieldAccessorTable;
  private static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
    internal_static_RemoteRouterConfig_descriptor;
  private static final 
    org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable
      internal_static_RemoteRouterConfig_fieldAccessorTable;

  public static org.apache.pekko.protobufv3.internal.Descriptors.FileDescriptor
      getDescriptor() {
    return descriptor;
  }
  private static  org.apache.pekko.protobufv3.internal.Descriptors.FileDescriptor
      descriptor;
  static {
    java.lang.String[] descriptorData = {
      "\n\021WireFormats.proto\032\026ContainerFormats.pr" +
      "oto\"_\n\027AckAndEnvelopeContainer\022!\n\003ack\030\001 " +
      "\001(\0132\024.AcknowledgementInfo\022!\n\010envelope\030\002 " +
      "\001(\0132\017.RemoteEnvelope\"\203\001\n\016RemoteEnvelope\022" +
      " \n\trecipient\030\001 \002(\0132\r.ActorRefData\022#\n\007mes" +
      "sage\030\002 \002(\0132\022.SerializedMessage\022\035\n\006sender" +
      "\030\004 \001(\0132\r.ActorRefData\022\013\n\003seq\030\005 \001(\006\";\n\023Ac" +
      "knowledgementInfo\022\025\n\rcumulativeAck\030\001 \002(\006" +
      "\022\r\n\005nacks\030\002 \003(\006\"\034\n\014ActorRefData\022\014\n\004path\030" +
      "\001 \002(\t\"S\n\021SerializedMessage\022\017\n\007message\030\001 " +
      "\002(\014\022\024\n\014serializerId\030\002 \002(\005\022\027\n\017messageMani" +
      "fest\030\003 \001(\014\"~\n\023DaemonMsgCreateData\022\031\n\005pro" +
      "ps\030\001 \002(\0132\n.PropsData\022\033\n\006deploy\030\002 \002(\0132\013.D" +
      "eployData\022\014\n\004path\030\003 \002(\t\022!\n\nsupervisor\030\004 " +
      "\002(\0132\r.ActorRefData\"\204\001\n\tPropsData\022\033\n\006depl" +
      "oy\030\002 \002(\0132\013.DeployData\022\r\n\005clazz\030\003 \002(\t\022\014\n\004" +
      "args\030\004 \003(\014\022\021\n\tmanifests\030\005 \003(\t\022\025\n\rseriali" +
      "zerIds\030\006 \003(\005\022\023\n\013hasManifest\030\007 \003(\010\"\227\002\n\nDe" +
      "ployData\022\014\n\004path\030\001 \002(\t\022\016\n\006config\030\002 \001(\014\022\024" +
      "\n\014routerConfig\030\003 \001(\014\022\r\n\005scope\030\004 \001(\014\022\022\n\nd" +
      "ispatcher\030\005 \001(\t\022\031\n\021scopeSerializerId\030\006 \001" +
      "(\005\022\025\n\rscopeManifest\030\007 \001(\t\022\032\n\022configSeria" +
      "lizerId\030\010 \001(\005\022\026\n\016configManifest\030\t \001(\t\022 \n" +
      "\030routerConfigSerializerId\030\n \001(\005\022\034\n\024route" +
      "rConfigManifest\030\013 \001(\t\022\014\n\004tags\030\014 \003(\t\"R\n\024P" +
      "ekkoProtocolMessage\022\017\n\007payload\030\001 \001(\014\022)\n\013" +
      "instruction\030\002 \001(\0132\024.PekkoControlMessage\"" +
      "d\n\023PekkoControlMessage\022!\n\013commandType\030\001 " +
      "\002(\0162\014.CommandType\022*\n\rhandshakeInfo\030\002 \001(\013" +
      "2\023.PekkoHandshakeInfo\"O\n\022PekkoHandshakeI" +
      "nfo\022\034\n\006origin\030\001 \002(\0132\014.AddressData\022\013\n\003uid" +
      "\030\002 \002(\006\022\016\n\006cookie\030\003 \001(\t\"8\n\016FiniteDuration" +
      "\022\r\n\005value\030\001 \002(\003\022\027\n\004unit\030\002 \002(\0162\t.TimeUnit" +
      "\")\n\013RemoteScope\022\032\n\004node\030\001 \002(\0132\014.AddressD" +
      "ata\"\261\001\n\016DefaultResizer\022\022\n\nlowerBound\030\001 \002" +
      "(\r\022\022\n\nupperBound\030\002 \002(\r\022\031\n\021pressureThresh" +
      "old\030\003 \002(\r\022\022\n\nrampupRate\030\004 \002(\001\022\030\n\020backoff" +
      "Threshold\030\005 \002(\001\022\023\n\013backoffRate\030\006 \002(\001\022\031\n\021" +
      "messagesPerResize\030\007 \002(\r\"A\n\nFromConfig\022\031\n" +
      "\007resizer\030\001 \001(\0132\010.Payload\022\030\n\020routerDispat" +
      "cher\030\002 \001(\t\"{\n\022GenericRoutingPool\022\025\n\rnrOf" +
      "Instances\030\001 \002(\r\022\030\n\020routerDispatcher\030\002 \001(" +
      "\t\022\031\n\021usePoolDispatcher\030\003 \002(\010\022\031\n\007resizer\030" +
      "\004 \001(\0132\010.Payload\"Z\n\021ScatterGatherPool\022$\n\007" +
      "generic\030\001 \002(\0132\023.GenericRoutingPool\022\037\n\006wi" +
      "thin\030\002 \002(\0132\017.FiniteDuration\"|\n\020TailChopp" +
      "ingPool\022$\n\007generic\030\001 \002(\0132\023.GenericRoutin" +
      "gPool\022\037\n\006within\030\002 \002(\0132\017.FiniteDuration\022!" +
      "\n\010interval\030\003 \002(\0132\017.FiniteDuration\"O\n\013Add" +
      "ressData\022\016\n\006system\030\001 \002(\t\022\020\n\010hostname\030\002 \002" +
      "(\t\022\014\n\004port\030\003 \002(\r\022\020\n\010protocol\030\004 \001(\t\"J\n\022Re" +
      "moteRouterConfig\022\027\n\005local\030\001 \002(\0132\010.Payloa" +
      "d\022\033\n\005nodes\030\002 \003(\0132\014.AddressData*{\n\013Comman" +
      "dType\022\r\n\tASSOCIATE\020\001\022\020\n\014DISASSOCIATE\020\002\022\r" +
      "\n\tHEARTBEAT\020\003\022\036\n\032DISASSOCIATE_SHUTTING_D" +
      "OWN\020\004\022\034\n\030DISASSOCIATE_QUARANTINED\020\005*n\n\010T" +
      "imeUnit\022\017\n\013NANOSECONDS\020\001\022\020\n\014MICROSECONDS" +
      "\020\002\022\020\n\014MILLISECONDS\020\003\022\013\n\007SECONDS\020\004\022\013\n\007MIN" +
      "UTES\020\005\022\t\n\005HOURS\020\006\022\010\n\004DAYS\020\007B\033\n\027org.apach" +
      "e.pekko.remoteH\001"
    };
    descriptor = org.apache.pekko.protobufv3.internal.Descriptors.FileDescriptor
      .internalBuildGeneratedFileFrom(descriptorData,
        new org.apache.pekko.protobufv3.internal.Descriptors.FileDescriptor[] {
          org.apache.pekko.remote.ContainerFormats.getDescriptor(),
        });
    internal_static_AckAndEnvelopeContainer_descriptor =
      getDescriptor().getMessageTypes().get(0);
    internal_static_AckAndEnvelopeContainer_fieldAccessorTable = new
      org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable(
        internal_static_AckAndEnvelopeContainer_descriptor,
        new java.lang.String[] { "Ack", "Envelope", });
    internal_static_RemoteEnvelope_descriptor =
      getDescriptor().getMessageTypes().get(1);
    internal_static_RemoteEnvelope_fieldAccessorTable = new
      org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable(
        internal_static_RemoteEnvelope_descriptor,
        new java.lang.String[] { "Recipient", "Message", "Sender", "Seq", });
    internal_static_AcknowledgementInfo_descriptor =
      getDescriptor().getMessageTypes().get(2);
    internal_static_AcknowledgementInfo_fieldAccessorTable = new
      org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable(
        internal_static_AcknowledgementInfo_descriptor,
        new java.lang.String[] { "CumulativeAck", "Nacks", });
    internal_static_ActorRefData_descriptor =
      getDescriptor().getMessageTypes().get(3);
    internal_static_ActorRefData_fieldAccessorTable = new
      org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable(
        internal_static_ActorRefData_descriptor,
        new java.lang.String[] { "Path", });
    internal_static_SerializedMessage_descriptor =
      getDescriptor().getMessageTypes().get(4);
    internal_static_SerializedMessage_fieldAccessorTable = new
      org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable(
        internal_static_SerializedMessage_descriptor,
        new java.lang.String[] { "Message", "SerializerId", "MessageManifest", });
    internal_static_DaemonMsgCreateData_descriptor =
      getDescriptor().getMessageTypes().get(5);
    internal_static_DaemonMsgCreateData_fieldAccessorTable = new
      org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable(
        internal_static_DaemonMsgCreateData_descriptor,
        new java.lang.String[] { "Props", "Deploy", "Path", "Supervisor", });
    internal_static_PropsData_descriptor =
      getDescriptor().getMessageTypes().get(6);
    internal_static_PropsData_fieldAccessorTable = new
      org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable(
        internal_static_PropsData_descriptor,
        new java.lang.String[] { "Deploy", "Clazz", "Args", "Manifests", "SerializerIds", "HasManifest", });
    internal_static_DeployData_descriptor =
      getDescriptor().getMessageTypes().get(7);
    internal_static_DeployData_fieldAccessorTable = new
      org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable(
        internal_static_DeployData_descriptor,
        new java.lang.String[] { "Path", "Config", "RouterConfig", "Scope", "Dispatcher", "ScopeSerializerId", "ScopeManifest", "ConfigSerializerId", "ConfigManifest", "RouterConfigSerializerId", "RouterConfigManifest", "Tags", });
    internal_static_PekkoProtocolMessage_descriptor =
      getDescriptor().getMessageTypes().get(8);
    internal_static_PekkoProtocolMessage_fieldAccessorTable = new
      org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable(
        internal_static_PekkoProtocolMessage_descriptor,
        new java.lang.String[] { "Payload", "Instruction", });
    internal_static_PekkoControlMessage_descriptor =
      getDescriptor().getMessageTypes().get(9);
    internal_static_PekkoControlMessage_fieldAccessorTable = new
      org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable(
        internal_static_PekkoControlMessage_descriptor,
        new java.lang.String[] { "CommandType", "HandshakeInfo", });
    internal_static_PekkoHandshakeInfo_descriptor =
      getDescriptor().getMessageTypes().get(10);
    internal_static_PekkoHandshakeInfo_fieldAccessorTable = new
      org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable(
        internal_static_PekkoHandshakeInfo_descriptor,
        new java.lang.String[] { "Origin", "Uid", "Cookie", });
    internal_static_FiniteDuration_descriptor =
      getDescriptor().getMessageTypes().get(11);
    internal_static_FiniteDuration_fieldAccessorTable = new
      org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable(
        internal_static_FiniteDuration_descriptor,
        new java.lang.String[] { "Value", "Unit", });
    internal_static_RemoteScope_descriptor =
      getDescriptor().getMessageTypes().get(12);
    internal_static_RemoteScope_fieldAccessorTable = new
      org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable(
        internal_static_RemoteScope_descriptor,
        new java.lang.String[] { "Node", });
    internal_static_DefaultResizer_descriptor =
      getDescriptor().getMessageTypes().get(13);
    internal_static_DefaultResizer_fieldAccessorTable = new
      org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable(
        internal_static_DefaultResizer_descriptor,
        new java.lang.String[] { "LowerBound", "UpperBound", "PressureThreshold", "RampupRate", "BackoffThreshold", "BackoffRate", "MessagesPerResize", });
    internal_static_FromConfig_descriptor =
      getDescriptor().getMessageTypes().get(14);
    internal_static_FromConfig_fieldAccessorTable = new
      org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable(
        internal_static_FromConfig_descriptor,
        new java.lang.String[] { "Resizer", "RouterDispatcher", });
    internal_static_GenericRoutingPool_descriptor =
      getDescriptor().getMessageTypes().get(15);
    internal_static_GenericRoutingPool_fieldAccessorTable = new
      org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable(
        internal_static_GenericRoutingPool_descriptor,
        new java.lang.String[] { "NrOfInstances", "RouterDispatcher", "UsePoolDispatcher", "Resizer", });
    internal_static_ScatterGatherPool_descriptor =
      getDescriptor().getMessageTypes().get(16);
    internal_static_ScatterGatherPool_fieldAccessorTable = new
      org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable(
        internal_static_ScatterGatherPool_descriptor,
        new java.lang.String[] { "Generic", "Within", });
    internal_static_TailChoppingPool_descriptor =
      getDescriptor().getMessageTypes().get(17);
    internal_static_TailChoppingPool_fieldAccessorTable = new
      org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable(
        internal_static_TailChoppingPool_descriptor,
        new java.lang.String[] { "Generic", "Within", "Interval", });
    internal_static_AddressData_descriptor =
      getDescriptor().getMessageTypes().get(18);
    internal_static_AddressData_fieldAccessorTable = new
      org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable(
        internal_static_AddressData_descriptor,
        new java.lang.String[] { "System", "Hostname", "Port", "Protocol", });
    internal_static_RemoteRouterConfig_descriptor =
      getDescriptor().getMessageTypes().get(19);
    internal_static_RemoteRouterConfig_fieldAccessorTable = new
      org.apache.pekko.protobufv3.internal.GeneratedMessage.FieldAccessorTable(
        internal_static_RemoteRouterConfig_descriptor,
        new java.lang.String[] { "Local", "Nodes", });
    descriptor.resolveAllFeaturesImmutable();
    org.apache.pekko.remote.ContainerFormats.getDescriptor();
  }

  // @@protoc_insertion_point(outer_class_scope)
}
